/*
 * Decompiled with CFR 0.152.
 */
package com.bwsw.sj.engine.regular.task.engine;

import com.bwsw.common.JsonSerializer;
import com.bwsw.sj.common.DAL.model.module.RegularInstance;
import com.bwsw.sj.common.utils.SjTimer;
import com.bwsw.sj.engine.core.engine.PersistentBlockingQueue;
import com.bwsw.sj.engine.core.engine.input.TaskInputService;
import com.bwsw.sj.engine.core.entities.Envelope;
import com.bwsw.sj.engine.core.environment.RegularEnvironmentManager;
import com.bwsw.sj.engine.core.environment.RegularModuleOutput;
import com.bwsw.sj.engine.core.regular.RegularStreamingExecutor;
import com.bwsw.sj.engine.core.reporting.PerformanceMetrics;
import com.bwsw.sj.engine.regular.task.RegularTaskManager;
import com.bwsw.sj.engine.regular.task.engine.input.RegularTaskInputServiceFactory;
import com.bwsw.sj.engine.regular.task.engine.state.RegularTaskEngineService;
import com.bwsw.sj.engine.regular.task.engine.state.StatefulRegularTaskEngineService;
import com.bwsw.sj.engine.regular.task.engine.state.StatelessRegularTaskEngineService;
import com.bwsw.sj.engine.regular.task.reporting.RegularStreamingPerformanceMetrics;
import com.bwsw.tstreams.agents.group.CheckpointGroup;
import com.bwsw.tstreams.agents.group.CheckpointGroup$;
import com.bwsw.tstreams.agents.group.GroupParticipant;
import com.bwsw.tstreams.agents.producer.Producer;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u0001\u0003\u0003\u0003\u0001\"!\u0005*fOVd\u0017M\u001d+bg.,enZ5oK*\u00111\u0001B\u0001\u0007K:<\u0017N\\3\u000b\u0005\u00151\u0011\u0001\u0002;bg.T!a\u0002\u0005\u0002\u000fI,w-\u001e7be*\u00111!\u0003\u0006\u0003\u0015-\t!a\u001d6\u000b\u00051i\u0011\u0001\u00022xg^T\u0011AD\u0001\u0004G>l7\u0001A\n\u0004\u0001EI\u0002C\u0001\n\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\u0011a\u0017M\\4\u000b\u0003Y\tAA[1wC&\u0011\u0001d\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007iy\u0012%D\u0001\u001c\u0015\taR$\u0001\u0006d_:\u001cWO\u001d:f]RT!AH\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003Am\u0011\u0001bQ1mY\u0006\u0014G.\u001a\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000f\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0005*\u0003\u001di\u0017M\\1hKJ,\u0012A\u000b\t\u0003W1j\u0011\u0001B\u0005\u0003[\u0011\u0011!CU3hk2\f'\u000fV1tW6\u000bg.Y4fe\"Aq\u0006\u0001B\u0001B\u0003%!&\u0001\u0005nC:\fw-\u001a:!\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014A\u00059fe\u001a|'/\\1oG\u0016lU\r\u001e:jGN\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0003\u0002\u0013I,\u0007o\u001c:uS:<\u0017BA\u001c5\u0005\t\u0012VmZ;mCJ\u001cFO]3b[&tw\rU3sM>\u0014X.\u00198dK6+GO]5dg\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0007cY>\u001c7.\u001b8h#V,W/\u001a\t\u0003w}j\u0011\u0001\u0010\u0006\u0003\u0007uR!A\u0010\u0005\u0002\t\r|'/Z\u0005\u0003\u0001r\u0012q\u0003U3sg&\u001cH/\u001a8u\u00052|7m[5oOF+X-^3\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\u0011!ei\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\u0002\t\u000b!\n\u0005\u0019\u0001\u0016\t\u000bE\n\u0005\u0019\u0001\u001a\t\u000be\n\u0005\u0019\u0001\u001e\t\u000f)\u0003!\u0019!C\u0005\u0017\u0006i1-\u001e:sK:$H\u000b\u001b:fC\u0012,\u0012\u0001\u0014\t\u0003%5K!AT\n\u0003\rQC'/Z1e\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006q1-\u001e:sK:$H\u000b\u001b:fC\u0012\u0004\u0003b\u0002*\u0001\u0005\u0004%\tbU\u0001\u0007Y><w-\u001a:\u0016\u0003Q\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u000bMdg\r\u000e6\u000b\u0003e\u000b1a\u001c:h\u0013\tYfK\u0001\u0004M_\u001e<WM\u001d\u0005\u0007;\u0002\u0001\u000b\u0011\u0002+\u0002\u000f1|wmZ3sA!9q\f\u0001b\u0001\n#\u0001\u0017!\u00039s_\u0012,8-\u001a:t+\u0005\t\u0007\u0003\u00022fO:l\u0011a\u0019\u0006\u0003I\u000e\n!bY8mY\u0016\u001cG/[8o\u0013\t17MA\u0002NCB\u0004\"\u0001[6\u000f\u0005\tJ\u0017B\u00016$\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\u001c\u0003cA8wq6\t\u0001O\u0003\u0002re\u0006A\u0001O]8ek\u000e,'O\u0003\u0002ti\u00061\u0011mZ3oiNT!!^\u0006\u0002\u0011Q\u001cHO]3b[NL!a\u001e9\u0003\u0011A\u0013x\u000eZ;dKJ\u00042AI=|\u0013\tQ8EA\u0003BeJ\f\u0017\u0010\u0005\u0002#y&\u0011Qp\t\u0002\u0005\u0005f$X\r\u0003\u0004\u0000\u0001\u0001\u0006I!Y\u0001\u000baJ|G-^2feN\u0004\u0003\"CA\u0002\u0001\t\u0007I\u0011CA\u0003\u0003=\u0019\u0007.Z2la>Lg\u000e^$s_V\u0004XCAA\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007e\u0006)qM]8va&!\u0011\u0011CA\u0006\u0005=\u0019\u0005.Z2la>Lg\u000e^$s_V\u0004\b\u0002CA\u000b\u0001\u0001\u0006I!a\u0002\u0002!\rDWmY6q_&tGo\u0012:pkB\u0004\u0003\"CA\r\u0001\t\u0007I\u0011CA\u000e\u0003!Ign\u001d;b]\u000e,WCAA\u000f!\u0011\ty\"!\r\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\ta!\\8ek2,'\u0002BA\u0014\u0003S\tQ!\\8eK2TA!a\u000b\u0002.\u0005\u0019A)\u0011'\u000b\u0007\u0005=\u0012\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003g\t\tCA\bSK\u001e,H.\u0019:J]N$\u0018M\\2f\u0011!\t9\u0004\u0001Q\u0001\n\u0005u\u0011!C5ogR\fgnY3!\u0011%\tY\u0004\u0001b\u0001\n#\ti$\u0001\rsK\u001e,H.\u0019:UCN\\WI\\4j]\u0016\u001cVM\u001d<jG\u0016,\"!a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012\u0003\u0003\u0015\u0019H/\u0019;f\u0013\u0011\tI%a\u0011\u00031I+w-\u001e7beR\u000b7o[#oO&tWmU3sm&\u001cW\r\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA \u0003e\u0011XmZ;mCJ$\u0016m]6F]\u001eLg.Z*feZL7-\u001a\u0011\t\u0013\u0005E\u0003A1A\u0005\u0012\u0005M\u0013AE3om&\u0014xN\\7f]Rl\u0015M\\1hKJ,\"!!\u0016\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017>\u0003-)gN^5s_:lWM\u001c;\n\t\u0005}\u0013\u0011\f\u0002\u001a%\u0016<W\u000f\\1s\u000b:4\u0018N]8o[\u0016tG/T1oC\u001e,'\u000f\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA+\u0003M)gN^5s_:lWM\u001c;NC:\fw-\u001a:!\u0011%\t9\u0007\u0001b\u0001\n#\tI'\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\tY\u0007\u0005\u0003\u0002n\u0005ETBAA8\u0015\t9Q(\u0003\u0003\u0002t\u0005=$\u0001\u0007*fOVd\u0017M]*ue\u0016\fW.\u001b8h\u000bb,7-\u001e;pe\"A\u0011q\u000f\u0001!\u0002\u0013\tY'A\u0005fq\u0016\u001cW\u000f^8sA!I\u00111\u0010\u0001C\u0002\u0013%\u0011QP\u0001\f[>$W\u000f\\3US6,'/\u0006\u0002\u0002\u0000A!\u0011\u0011QAD\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u00065\u0012!B;uS2\u001c\u0018\u0002BAE\u0003\u0007\u0013qa\u00156US6,'\u000f\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BA@\u00031iw\u000eZ;mKRKW.\u001a:!\u0011%\t\t\n\u0001b\u0001\n#\t\u0019*\u0001\u0006pkR\u0004X\u000f\u001e+bON,\"!!&\u0011\u000f\u0005]\u0015QT4\u0002 6\u0011\u0011\u0011\u0014\u0006\u0004\u00037\u001b\u0017aB7vi\u0006\u0014G.Z\u0005\u0004M\u0006e\u0005C\u0002\u0012\u0002\"\u001e\f)+C\u0002\u0002$\u000e\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA,\u0003OKA!!+\u0002Z\t\u0019\"+Z4vY\u0006\u0014Xj\u001c3vY\u0016|U\u000f\u001e9vi\"A\u0011Q\u0016\u0001!\u0002\u0013\t)*A\u0006pkR\u0004X\u000f\u001e+bON\u0004\u0003\"CAY\u0001\t\u0007I\u0011BAZ\u0003y\u0011XmZ;mCJ$\u0016m]6J]B,HoU3sm&\u001cWMR1di>\u0014\u00180\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<\n\tQ!\u001b8qkRLA!a0\u0002:\nq\"+Z4vY\u0006\u0014H+Y:l\u0013:\u0004X\u000f^*feZL7-\u001a$bGR|'/\u001f\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u00026\u0006y\"/Z4vY\u0006\u0014H+Y:l\u0013:\u0004X\u000f^*feZL7-\u001a$bGR|'/\u001f\u0011\t\u0013\u0005\u001d\u0007A1A\u0005\u0002\u0005%\u0017\u0001\u0005;bg.Le\u000e];u'\u0016\u0014h/[2f+\t\tY\r\u0005\u0003\u0002N\u0006EWBAAh\u0015\r\tY\fP\u0005\u0005\u0003'\fyM\u0001\tUCN\\\u0017J\u001c9viN+'O^5dK\"A\u0011q\u001b\u0001!\u0002\u0013\tY-A\tuCN\\\u0017J\u001c9viN+'O^5dK\u0002B\u0011\"a7\u0001\u0005\u00045\t\"!8\u00023%\u001chj\u001c;P]2L8)^:u_6\u001c\u0005.Z2la>Lg\u000e^\u000b\u0003\u0003?\u00042AIAq\u0013\r\t\u0019o\t\u0002\b\u0005>|G.Z1o\u0011%\t9\u000f\u0001b\u0001\n#\tI/\u0001\nf]Z,Gn\u001c9f'\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAAv!\u0011\ti/!=\u000e\u0005\u0005=(bAA\u0018\u0017%!\u00111_Ax\u00059Q5o\u001c8TKJL\u0017\r\\5{KJD\u0001\"a>\u0001A\u0003%\u00111^\u0001\u0014K:4X\r\\8qKN+'/[1mSj,'\u000f\t\u0005\b\u0003w\u0004A\u0011CA\u007f\u0003y\u0019'/Z1uKJ+w-\u001e7beR\u000b7o[#oO&tWmU3sm&\u001cW\r\u0006\u0002\u0002@!9!\u0011\u0001\u0001\u0005\n\t\r\u0011!H1eIB\u0013x\u000eZ;dKJ\u001cHk\\\"iK\u000e\\\u0007o\\5oi\u001e\u0013x.\u001e9\u0015\u0003\u0005BqAa\u0002\u0001\t\u0003\u0012\u0019!\u0001\u0003dC2d\u0007b\u0002B\u0006\u0001\u0019E!1A\u0001\u0017C\u001a$XM\u001d*fG\u0016Lg/\u001b8h\u000b:4X\r\\8qK\"9!q\u0002\u0001\u0007\u0012\tE\u0011\u0001F5t\u0013R$\u0016.\\3U_\u000eCWmY6q_&tG\u000f\u0006\u0003\u0002`\nM\u0001\u0002\u0003B\u000b\u0005\u001b\u0001\r!a8\u0002+%\u001c8\t[3dWB|\u0017N\u001c;J]&$\u0018.\u0019;fI\"9!\u0011\u0004\u0001\u0005\u0012\t\r\u0011\u0001\u00043p\u0007\",7m\u001b9pS:$\bb\u0002B\u000f\u0001\u0019E!1A\u0001\u0019aJ,\u0007/\u0019:f\r>\u0014h*\u001a=u\u0007\",7m\u001b9pS:$\b")
public abstract class RegularTaskEngine
implements Callable<BoxedUnit> {
    private final RegularTaskManager manager;
    private final RegularStreamingPerformanceMetrics performanceMetrics;
    private final PersistentBlockingQueue blockingQueue;
    private final Thread currentThread;
    private final Logger logger;
    private final Map<String, Producer<byte[]>> producers;
    private final CheckpointGroup checkpointGroup;
    private final RegularInstance instance;
    private final RegularTaskEngineService regularTaskEngineService;
    private final RegularEnvironmentManager environmentManager;
    private final RegularStreamingExecutor executor;
    private final SjTimer moduleTimer;
    private final scala.collection.mutable.Map<String, Tuple2<String, RegularModuleOutput>> outputTags;
    private final RegularTaskInputServiceFactory regularTaskInputServiceFactory;
    private final TaskInputService taskInputService;
    private final JsonSerializer envelopeSerializer;

    public RegularTaskManager manager() {
        return this.manager;
    }

    private Thread currentThread() {
        return this.currentThread;
    }

    public Logger logger() {
        return this.logger;
    }

    public Map<String, Producer<byte[]>> producers() {
        return this.producers;
    }

    public CheckpointGroup checkpointGroup() {
        return this.checkpointGroup;
    }

    public RegularInstance instance() {
        return this.instance;
    }

    public RegularTaskEngineService regularTaskEngineService() {
        return this.regularTaskEngineService;
    }

    public RegularEnvironmentManager environmentManager() {
        return this.environmentManager;
    }

    public RegularStreamingExecutor executor() {
        return this.executor;
    }

    private SjTimer moduleTimer() {
        return this.moduleTimer;
    }

    public scala.collection.mutable.Map<String, Tuple2<String, RegularModuleOutput>> outputTags() {
        return this.outputTags;
    }

    private RegularTaskInputServiceFactory regularTaskInputServiceFactory() {
        return this.regularTaskInputServiceFactory;
    }

    public TaskInputService taskInputService() {
        return this.taskInputService;
    }

    public abstract boolean isNotOnlyCustomCheckpoint();

    public JsonSerializer envelopeSerializer() {
        return this.envelopeSerializer;
    }

    public RegularTaskEngineService createRegularTaskEngineService() {
        String string;
        block4: {
            RegularTaskEngineService regularTaskEngineService;
            block3: {
                block2: {
                    string = this.instance().stateManagement();
                    if (!"none".equals(string)) break block2;
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Start preparing of regular module without state\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
                    regularTaskEngineService = new StatelessRegularTaskEngineService(this.manager(), this.performanceMetrics);
                    break block3;
                }
                if (!"ram".equals(string)) break block4;
                regularTaskEngineService = new StatefulRegularTaskEngineService(this.manager(), this.checkpointGroup(), this.performanceMetrics);
            }
            return regularTaskEngineService;
        }
        throw new MatchError((Object)string);
    }

    private void addProducersToCheckpointGroup() {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Start adding t-stream producers to checkpoint group\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegularTaskEngine $outer;

            public final void apply(Tuple2<String, Producer<byte[]>> x) {
                this.$outer.checkpointGroup().add((GroupParticipant)x._2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". The t-stream producers are added to checkpoint group\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
    }

    @Override
    public void call() {
        Option option;
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task name: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Run regular task engine in a separate thread of execution service\\n"})).s((Seq)Nil$.MODULE$)).toString());
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Invoke onInit() handler\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.executor().onInit();
        while (true) {
            BoxedUnit boxedUnit;
            Option maybeEnvelope;
            if ((option = (maybeEnvelope = this.blockingQueue.get(this.instance().eventWaitTime()))) instanceof Some) {
                Some some = (Some)option;
                String serializedEnvelope = (String)some.x();
                Envelope envelope = (Envelope)this.envelopeSerializer().deserialize(serializedEnvelope, ManifestFactory$.MODULE$.classType(Envelope.class));
                this.afterReceivingEnvelope();
                this.taskInputService().registerEnvelope(envelope, (PerformanceMetrics)this.performanceMetrics);
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Invoke onMessage() handler\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
                this.executor().onMessage(envelope);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option)) break;
                this.performanceMetrics.increaseTotalIdleTime(this.instance().eventWaitTime());
                this.executor().onIdle();
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.isItTimeToCheckpoint(this.environmentManager().isCheckpointInitiated())) {
                this.doCheckpoint();
            }
            if (!this.moduleTimer().isTime()) continue;
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Invoke onTimer() handler\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
            this.executor().onTimer(System.currentTimeMillis() - this.moduleTimer().responseTime());
            this.moduleTimer().reset();
        }
        throw new MatchError((Object)option);
    }

    public abstract void afterReceivingEnvelope();

    public abstract boolean isItTimeToCheckpoint(boolean var1);

    public void doCheckpoint() {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". It's time to checkpoint\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Invoke onBeforeCheckpoint() handler\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.executor().onBeforeCheckpoint();
        this.regularTaskEngineService().doCheckpoint();
        this.taskInputService().doCheckpoint();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Do group checkpoint\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.checkpointGroup().checkpoint();
        this.outputTags().clear();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task: ", ". Invoke onAfterCheckpoint() handler\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manager().taskName()})));
        this.executor().onAfterCheckpoint();
        this.prepareForNextCheckpoint();
    }

    public abstract void prepareForNextCheckpoint();

    public RegularTaskEngine(RegularTaskManager manager, RegularStreamingPerformanceMetrics performanceMetrics, PersistentBlockingQueue blockingQueue) {
        this.manager = manager;
        this.performanceMetrics = performanceMetrics;
        this.blockingQueue = blockingQueue;
        this.currentThread = Thread.currentThread();
        this.currentThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regular-task-", "-engine"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manager.taskName()})));
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.producers = manager.outputProducers();
        this.checkpointGroup = new CheckpointGroup(CheckpointGroup$.MODULE$.$lessinit$greater$default$1());
        this.instance = (RegularInstance)manager.instance();
        this.regularTaskEngineService = this.createRegularTaskEngineService();
        this.environmentManager = this.regularTaskEngineService().regularEnvironmentManager();
        this.executor = this.regularTaskEngineService().executor();
        this.moduleTimer = this.regularTaskEngineService().moduleTimer();
        this.outputTags = this.regularTaskEngineService().outputTags();
        this.regularTaskInputServiceFactory = new RegularTaskInputServiceFactory(manager, blockingQueue, this.checkpointGroup());
        this.taskInputService = this.regularTaskInputServiceFactory().createRegularTaskInputService();
        this.envelopeSerializer = new JsonSerializer(true);
        this.addProducersToCheckpointGroup();
    }
}

