package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ApiSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MethodSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MixinSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableApi
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableMethod
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableMixin
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List

/**
 *  Api is a light-weight descriptor for an API Interface.
 *
 *  Interfaces are also described as "protocol buffer services" in some contexts,
 *  such as by the "service" keyword in a .proto file, but they are different
 *  from API Services, which represent a concrete implementation of an interface
 *  as opposed to simply a description of methods and bindings. They are also
 *  sometimes simply referred to as "APIs" in other contexts, such as the name of
 *  this message itself. See https://cloud.google.com/apis/design/glossary for
 *  detailed terminology.
 */
@ProtobufDefinition(".google.protobuf.Api")
public interface Api : Message<Api, MutableApi> {
  /**
   *  The fully qualified name of this interface, including package name
   *  followed by the interface's simple name.
   */
  public val name: String

  /**
   *  The methods of this interface, in unspecified order.
   */
  public val methods: List<Method>

  /**
   *  Any metadata attached to the interface.
   */
  public val options: List<Option>

  /**
   *  A version string for this interface. If specified, must have the form
   *  `major-version.minor-version`, as in `1.10`. If the minor version is
   *  omitted, it defaults to zero. If the entire version field is empty, the
   *  major version is derived from the package name, as outlined below. If the
   *  field is not empty, the version in the package name will be verified to be
   *  consistent with what is provided here.
   *
   *  The versioning schema uses [semantic
   *  versioning](http://semver.org) where the major version number
   *  indicates a breaking change and the minor version an additive,
   *  non-breaking change. Both version numbers are signals to users
   *  what to expect from different versions, and should be carefully
   *  chosen based on the product plan.
   *
   *  The major version is also reflected in the package name of the
   *  interface, which must end in `v<major-version>`, as in
   *  `google.feature.v1`. For major versions 0 and 1, the suffix can
   *  be omitted. Zero major versions must only be used for
   *  experimental, non-GA interfaces.
   */
  public val version: String

  /**
   *  Source context for the protocol buffer service represented by this
   *  message.
   */
  public val sourceContext: SourceContext?

  /**
   *  Included interfaces. See [Mixin][].
   */
  public val mixins: List<Mixin>

  /**
   *  The source syntax of the service.
   */
  public val syntax: Syntax

  public fun hasName(): Boolean

  public fun hasMethods(): Boolean

  public fun hasOptions(): Boolean

  public fun hasVersion(): Boolean

  public fun hasSourceContext(): Boolean

  public fun hasMixins(): Boolean

  public fun hasSyntax(): Boolean

  public companion object : ApiSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val METHODS_FIELD_NAME: String = "methods"

    public const val METHODS_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3

    public const val VERSION_FIELD_NAME: String = "version"

    public const val VERSION_FIELD_NUMBER: Int = 4

    public const val SOURCE_CONTEXT_FIELD_NAME: String = "source_context"

    public const val SOURCE_CONTEXT_FIELD_NUMBER: Int = 5

    public const val MIXINS_FIELD_NAME: String = "mixins"

    public const val MIXINS_FIELD_NUMBER: Int = 6

    public const val SYNTAX_FIELD_NAME: String = "syntax"

    public const val SYNTAX_FIELD_NUMBER: Int = 7
  }
}

/**
 *  Method represents a method of an API interface.
 */
@ProtobufDefinition(".google.protobuf.Method")
public interface Method : Message<Method, MutableMethod> {
  /**
   *  The simple name of this method.
   */
  public val name: String

  /**
   *  A URL of the input message type.
   */
  public val requestTypeUrl: String

  /**
   *  If true, the request is streamed.
   */
  public val requestStreaming: Boolean

  /**
   *  The URL of the output message type.
   */
  public val responseTypeUrl: String

  /**
   *  If true, the response is streamed.
   */
  public val responseStreaming: Boolean

  /**
   *  Any metadata attached to the method.
   */
  public val options: List<Option>

  /**
   *  The source syntax of this method.
   */
  public val syntax: Syntax

  public fun hasName(): Boolean

  public fun hasRequestTypeUrl(): Boolean

  public fun hasRequestStreaming(): Boolean

  public fun hasResponseTypeUrl(): Boolean

  public fun hasResponseStreaming(): Boolean

  public fun hasOptions(): Boolean

  public fun hasSyntax(): Boolean

  public companion object : MethodSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val REQUEST_TYPE_URL_FIELD_NAME: String = "request_type_url"

    public const val REQUEST_TYPE_URL_FIELD_NUMBER: Int = 2

    public const val REQUEST_STREAMING_FIELD_NAME: String = "request_streaming"

    public const val REQUEST_STREAMING_FIELD_NUMBER: Int = 3

    public const val RESPONSE_TYPE_URL_FIELD_NAME: String = "response_type_url"

    public const val RESPONSE_TYPE_URL_FIELD_NUMBER: Int = 4

    public const val RESPONSE_STREAMING_FIELD_NAME: String = "response_streaming"

    public const val RESPONSE_STREAMING_FIELD_NUMBER: Int = 5

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 6

    public const val SYNTAX_FIELD_NAME: String = "syntax"

    public const val SYNTAX_FIELD_NUMBER: Int = 7
  }
}

/**
 *  Declares an API Interface to be included in this interface. The including
 *  interface must redeclare all the methods from the included interface, but
 *  documentation and options are inherited as follows:
 *
 *  - If after comment and whitespace stripping, the documentation
 *    string of the redeclared method is empty, it will be inherited
 *    from the original method.
 *
 *  - Each annotation belonging to the service config (http,
 *    visibility) which is not set in the redeclared method will be
 *    inherited.
 *
 *  - If an http annotation is inherited, the path pattern will be
 *    modified as follows. Any version prefix will be replaced by the
 *    version of the including interface plus the [root][] path if
 *    specified.
 *
 *  Example of a simple mixin:
 *
 *      package google.acl.v1;
 *      service AccessControl {
 *        // Get the underlying ACL object.
 *        rpc GetAcl(GetAclRequest) returns (Acl) {
 *          option (google.api.http).get = "/v1/{resource=**}:getAcl";
 *        }
 *      }
 *
 *      package google.storage.v2;
 *      service Storage {
 *        rpc GetAcl(GetAclRequest) returns (Acl);
 *
 *        // Get a data record.
 *        rpc GetData(GetDataRequest) returns (Data) {
 *          option (google.api.http).get = "/v2/{resource=**}";
 *        }
 *      }
 *
 *  Example of a mixin configuration:
 *
 *      apis:
 *      - name: google.storage.v2.Storage
 *        mixins:
 *        - name: google.acl.v1.AccessControl
 *
 *  The mixin construct implies that all methods in `AccessControl` are
 *  also declared with same name and request/response types in
 *  `Storage`. A documentation generator or annotation processor will
 *  see the effective `Storage.GetAcl` method after inherting
 *  documentation and annotations as follows:
 *
 *      service Storage {
 *        // Get the underlying ACL object.
 *        rpc GetAcl(GetAclRequest) returns (Acl) {
 *          option (google.api.http).get = "/v2/{resource=**}:getAcl";
 *        }
 *        ...
 *      }
 *
 *  Note how the version in the path pattern changed from `v1` to `v2`.
 *
 *  If the `root` field in the mixin is specified, it should be a
 *  relative path under which inherited HTTP paths are placed. Example:
 *
 *      apis:
 *      - name: google.storage.v2.Storage
 *        mixins:
 *        - name: google.acl.v1.AccessControl
 *          root: acls
 *
 *  This implies the following inherited HTTP annotation:
 *
 *      service Storage {
 *        // Get the underlying ACL object.
 *        rpc GetAcl(GetAclRequest) returns (Acl) {
 *          option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";
 *        }
 *        ...
 *      }
 */
@ProtobufDefinition(".google.protobuf.Mixin")
public interface Mixin : Message<Mixin, MutableMixin> {
  /**
   *  The fully qualified name of the interface which is included.
   */
  public val name: String

  /**
   *  If non-empty specifies a path under which inherited HTTP paths
   *  are rooted.
   */
  public val root: String

  public fun hasName(): Boolean

  public fun hasRoot(): Boolean

  public companion object : MixinSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val ROOT_FIELD_NAME: String = "root"

    public const val ROOT_FIELD_NUMBER: Int = 2
  }
}
