package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.ProtoEnum
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.DescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumValueDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumValueOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ExtensionRangeOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FeatureSetSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FieldDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FieldOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FileDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FileDescriptorSetSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FileOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.GeneratedCodeInfoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MessageOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MethodDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MethodOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnumDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnumOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnumValueDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnumValueOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableExtensionRangeOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFeatureSet
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFieldDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFieldOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFileDescriptorSet
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFileOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableGeneratedCodeInfo
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableMessageOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableMethodDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableMethodOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableOneofDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableOneofOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableServiceDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableServiceOptions
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableSourceCodeInfo
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableUninterpretedOption
import com.bybutter.sisyphus.protobuf.primitives.`internal`.OneofDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.OneofOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ServiceDescriptorProtoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ServiceOptionsSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.SourceCodeInfoSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.UninterpretedOptionSupport
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.ULong
import kotlin.collections.List

/**
 *  The protocol compiler can output a FileDescriptorSet containing the .proto
 *  files it parses.
 */
@ProtobufDefinition(".google.protobuf.FileDescriptorSet")
public interface FileDescriptorSet : Message<FileDescriptorSet, MutableFileDescriptorSet> {
  public val `file`: List<FileDescriptorProto>

  public fun hasFile(): Boolean

  public companion object : FileDescriptorSetSupport() {
    public const val FILE_FIELD_NAME: String = "file"

    public const val FILE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Describes a complete .proto file.
 */
@ProtobufDefinition(".google.protobuf.FileDescriptorProto")
public interface FileDescriptorProto : Message<FileDescriptorProto, MutableFileDescriptorProto> {
  public val name: String

  public val `package`: String

  /**
   *  Names of files imported by this file.
   */
  public val dependency: List<String>

  /**
   *  Indexes of the public imported files in the dependency list above.
   */
  public val publicDependency: List<Int>

  /**
   *  Indexes of the weak imported files in the dependency list.
   *  For Google-internal migration only. Do not use.
   */
  public val weakDependency: List<Int>

  /**
   *  All top-level definitions in this file.
   */
  public val messageType: List<DescriptorProto>

  public val enumType: List<EnumDescriptorProto>

  public val service: List<ServiceDescriptorProto>

  public val extension: List<FieldDescriptorProto>

  public val options: FileOptions?

  /**
   *  This field contains optional information about the original source code.
   *  You may safely remove this entire field without harming runtime
   *  functionality of the descriptors -- the information is needed only by
   *  development tools.
   */
  public val sourceCodeInfo: SourceCodeInfo?

  /**
   *  The syntax of the proto file.
   *  The supported values are "proto2", "proto3", and "editions".
   *
   *  If `edition` is present, this value must be "editions".
   */
  public val syntax: String

  /**
   *  The edition of the proto file, which is an opaque string.
   */
  public val edition: String

  public fun hasName(): Boolean

  public fun hasPackage(): Boolean

  public fun hasDependency(): Boolean

  public fun hasPublicDependency(): Boolean

  public fun hasWeakDependency(): Boolean

  public fun hasMessageType(): Boolean

  public fun hasEnumType(): Boolean

  public fun hasService(): Boolean

  public fun hasExtension(): Boolean

  public fun hasOptions(): Boolean

  public fun hasSourceCodeInfo(): Boolean

  public fun hasSyntax(): Boolean

  public fun hasEdition(): Boolean

  public companion object : FileDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val PACKAGE_FIELD_NAME: String = "package"

    public const val PACKAGE_FIELD_NUMBER: Int = 2

    public const val DEPENDENCY_FIELD_NAME: String = "dependency"

    public const val DEPENDENCY_FIELD_NUMBER: Int = 3

    public const val PUBLIC_DEPENDENCY_FIELD_NAME: String = "public_dependency"

    public const val PUBLIC_DEPENDENCY_FIELD_NUMBER: Int = 10

    public const val WEAK_DEPENDENCY_FIELD_NAME: String = "weak_dependency"

    public const val WEAK_DEPENDENCY_FIELD_NUMBER: Int = 11

    public const val MESSAGE_TYPE_FIELD_NAME: String = "message_type"

    public const val MESSAGE_TYPE_FIELD_NUMBER: Int = 4

    public const val ENUM_TYPE_FIELD_NAME: String = "enum_type"

    public const val ENUM_TYPE_FIELD_NUMBER: Int = 5

    public const val SERVICE_FIELD_NAME: String = "service"

    public const val SERVICE_FIELD_NUMBER: Int = 6

    public const val EXTENSION_FIELD_NAME: String = "extension"

    public const val EXTENSION_FIELD_NUMBER: Int = 7

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 8

    public const val SOURCE_CODE_INFO_FIELD_NAME: String = "source_code_info"

    public const val SOURCE_CODE_INFO_FIELD_NUMBER: Int = 9

    public const val SYNTAX_FIELD_NAME: String = "syntax"

    public const val SYNTAX_FIELD_NUMBER: Int = 12

    public const val EDITION_FIELD_NAME: String = "edition"

    public const val EDITION_FIELD_NUMBER: Int = 13
  }
}

/**
 *  Describes a message type.
 */
@ProtobufDefinition(".google.protobuf.DescriptorProto")
public interface DescriptorProto : Message<DescriptorProto, MutableDescriptorProto> {
  public val name: String

  public val `field`: List<FieldDescriptorProto>

  public val extension: List<FieldDescriptorProto>

  public val nestedType: List<DescriptorProto>

  public val enumType: List<EnumDescriptorProto>

  public val extensionRange: List<ExtensionRange>

  public val oneofDecl: List<OneofDescriptorProto>

  public val options: MessageOptions?

  public val reservedRange: List<ReservedRange>

  /**
   *  Reserved field names, which may not be used by fields in the same message.
   *  A given name may only be reserved once.
   */
  public val reservedName: List<String>

  public fun hasName(): Boolean

  public fun hasField(): Boolean

  public fun hasExtension(): Boolean

  public fun hasNestedType(): Boolean

  public fun hasEnumType(): Boolean

  public fun hasExtensionRange(): Boolean

  public fun hasOneofDecl(): Boolean

  public fun hasOptions(): Boolean

  public fun hasReservedRange(): Boolean

  public fun hasReservedName(): Boolean

  @ProtobufDefinition(".google.protobuf.DescriptorProto.ExtensionRange")
  public interface ExtensionRange :
      Message<ExtensionRange, MutableDescriptorProto.MutableExtensionRange> {
    public val start: Int

    public val end: Int

    public val options: ExtensionRangeOptions?

    public fun hasStart(): Boolean

    public fun hasEnd(): Boolean

    public fun hasOptions(): Boolean

    public companion object : DescriptorProtoSupport.ExtensionRangeSupport() {
      public const val START_FIELD_NAME: String = "start"

      public const val START_FIELD_NUMBER: Int = 1

      public const val END_FIELD_NAME: String = "end"

      public const val END_FIELD_NUMBER: Int = 2

      public const val OPTIONS_FIELD_NAME: String = "options"

      public const val OPTIONS_FIELD_NUMBER: Int = 3
    }
  }

  @ProtobufDefinition(".google.protobuf.DescriptorProto.ReservedRange")
  public interface ReservedRange :
      Message<ReservedRange, MutableDescriptorProto.MutableReservedRange> {
    public val start: Int

    public val end: Int

    public fun hasStart(): Boolean

    public fun hasEnd(): Boolean

    public companion object : DescriptorProtoSupport.ReservedRangeSupport() {
      public const val START_FIELD_NAME: String = "start"

      public const val START_FIELD_NUMBER: Int = 1

      public const val END_FIELD_NAME: String = "end"

      public const val END_FIELD_NUMBER: Int = 2
    }
  }

  public companion object : DescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val FIELD_FIELD_NAME: String = "field"

    public const val FIELD_FIELD_NUMBER: Int = 2

    public const val EXTENSION_FIELD_NAME: String = "extension"

    public const val EXTENSION_FIELD_NUMBER: Int = 6

    public const val NESTED_TYPE_FIELD_NAME: String = "nested_type"

    public const val NESTED_TYPE_FIELD_NUMBER: Int = 3

    public const val ENUM_TYPE_FIELD_NAME: String = "enum_type"

    public const val ENUM_TYPE_FIELD_NUMBER: Int = 4

    public const val EXTENSION_RANGE_FIELD_NAME: String = "extension_range"

    public const val EXTENSION_RANGE_FIELD_NUMBER: Int = 5

    public const val ONEOF_DECL_FIELD_NAME: String = "oneof_decl"

    public const val ONEOF_DECL_FIELD_NUMBER: Int = 8

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 7

    public const val RESERVED_RANGE_FIELD_NAME: String = "reserved_range"

    public const val RESERVED_RANGE_FIELD_NUMBER: Int = 9

    public const val RESERVED_NAME_FIELD_NAME: String = "reserved_name"

    public const val RESERVED_NAME_FIELD_NUMBER: Int = 10
  }
}

@ProtobufDefinition(".google.protobuf.ExtensionRangeOptions")
public interface ExtensionRangeOptions :
    Message<ExtensionRangeOptions, MutableExtensionRangeOptions> {
  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  /**
   *  For external users: DO NOT USE. We are in the process of open sourcing
   *  extension declaration and executing internal cleanups before it can be
   *  used externally.
   */
  public val declaration: List<Declaration>

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The verification state of the range.
   *  TODO(b/278783756): flip the default to DECLARATION once all empty ranges
   *  are marked as UNVERIFIED.
   */
  public val verification: VerificationState

  public fun hasUninterpretedOption(): Boolean

  public fun hasDeclaration(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasVerification(): Boolean

  /**
   *  The verification state of the extension range.
   */
  @ProtobufDefinition(".google.protobuf.ExtensionRangeOptions.VerificationState")
  public enum class VerificationState(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<VerificationState> {
    /**
     *  All the extensions of the range must be declared.
     */
    DECLARATION(0, "DECLARATION"),
    UNVERIFIED(1, "UNVERIFIED"),
    ;

    public override fun support(): EnumSupport<VerificationState> = VerificationState

    public companion object : ExtensionRangeOptionsSupport.VerificationStateSupport()
  }

  @ProtobufDefinition(".google.protobuf.ExtensionRangeOptions.Declaration")
  public interface Declaration :
      Message<Declaration, MutableExtensionRangeOptions.MutableDeclaration> {
    public val number: Int

    public val fullName: String

    public val type: String

    public val reserved: Boolean

    public val repeated: Boolean

    public fun hasNumber(): Boolean

    public fun hasFullName(): Boolean

    public fun hasType(): Boolean

    public fun hasReserved(): Boolean

    public fun hasRepeated(): Boolean

    public companion object : ExtensionRangeOptionsSupport.DeclarationSupport() {
      public const val NUMBER_FIELD_NAME: String = "number"

      public const val NUMBER_FIELD_NUMBER: Int = 1

      public const val FULL_NAME_FIELD_NAME: String = "full_name"

      public const val FULL_NAME_FIELD_NUMBER: Int = 2

      public const val TYPE_FIELD_NAME: String = "type"

      public const val TYPE_FIELD_NUMBER: Int = 3

      public const val RESERVED_FIELD_NAME: String = "reserved"

      public const val RESERVED_FIELD_NUMBER: Int = 5

      public const val REPEATED_FIELD_NAME: String = "repeated"

      public const val REPEATED_FIELD_NUMBER: Int = 6
    }
  }

  public companion object : ExtensionRangeOptionsSupport() {
    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999

    public const val DECLARATION_FIELD_NAME: String = "declaration"

    public const val DECLARATION_FIELD_NUMBER: Int = 2

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 50

    public const val VERIFICATION_FIELD_NAME: String = "verification"

    public const val VERIFICATION_FIELD_NUMBER: Int = 3
  }
}

/**
 *  Describes a field within a message.
 */
@ProtobufDefinition(".google.protobuf.FieldDescriptorProto")
public interface FieldDescriptorProto : Message<FieldDescriptorProto, MutableFieldDescriptorProto> {
  public val name: String

  public val number: Int

  public val label: Label

  /**
   *  If type_name is set, this need not be set.  If both this and type_name
   *  are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.
   */
  public val type: Type

  /**
   *  For message and enum types, this is the name of the type.  If the name
   *  starts with a '.', it is fully-qualified.  Otherwise, C++-like scoping
   *  rules are used to find the type (i.e. first the nested types within this
   *  message are searched, then within the parent, on up to the root
   *  namespace).
   */
  public val typeName: String

  /**
   *  For extensions, this is the name of the type being extended.  It is
   *  resolved in the same manner as type_name.
   */
  public val extendee: String

  /**
   *  For numeric types, contains the original text representation of the value.
   *  For booleans, "true" or "false".
   *  For strings, contains the default text contents (not escaped in any way).
   *  For bytes, contains the C escaped value.  All bytes >= 128 are escaped.
   */
  public val defaultValue: String

  /**
   *  If set, gives the index of a oneof in the containing type's oneof_decl
   *  list.  This field is a member of that oneof.
   */
  public val oneofIndex: Int

  /**
   *  JSON name of this field. The value is set by protocol compiler. If the
   *  user has set a "json_name" option on this field, that option's value
   *  will be used. Otherwise, it's deduced from the field's name by converting
   *  it to camelCase.
   */
  public val jsonName: String

  public val options: FieldOptions?

  /**
   *  If true, this is a proto3 "optional". When a proto3 field is optional, it
   *  tracks presence regardless of field type.
   *
   *  When proto3_optional is true, this field must be belong to a oneof to
   *  signal to old proto3 clients that presence is tracked for this field. This
   *  oneof is known as a "synthetic" oneof, and this field must be its sole
   *  member (each proto3 optional field gets its own synthetic oneof). Synthetic
   *  oneofs exist in the descriptor only, and do not generate any API. Synthetic
   *  oneofs must be ordered after all "real" oneofs.
   *
   *  For message fields, proto3_optional doesn't create any semantic change,
   *  since non-repeated message fields always track presence. However it still
   *  indicates the semantic detail of whether the user wrote "optional" or not.
   *  This can be useful for round-tripping the .proto file. For consistency we
   *  give message fields a synthetic oneof also, even though it is not required
   *  to track presence. This is especially important because the parser can't
   *  tell if a field is a message or an enum, so it must always create a
   *  synthetic oneof.
   *
   *  Proto2 optional fields do not set this flag, because they already indicate
   *  optional with `LABEL_OPTIONAL`.
   */
  public val proto3Optional: Boolean

  public fun hasName(): Boolean

  public fun hasNumber(): Boolean

  public fun hasLabel(): Boolean

  public fun hasType(): Boolean

  public fun hasTypeName(): Boolean

  public fun hasExtendee(): Boolean

  public fun hasDefaultValue(): Boolean

  public fun hasOneofIndex(): Boolean

  public fun hasJsonName(): Boolean

  public fun hasOptions(): Boolean

  public fun hasProto3Optional(): Boolean

  @ProtobufDefinition(".google.protobuf.FieldDescriptorProto.Type")
  public enum class Type(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<Type> {
    /**
     *  0 is reserved for errors.
     *  Order is weird for historical reasons.
     */
    DOUBLE(1, "TYPE_DOUBLE"),
    FLOAT(2, "TYPE_FLOAT"),
    /**
     *  Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
     *  negative values are likely.
     */
    INT64(3, "TYPE_INT64"),
    UINT64(4, "TYPE_UINT64"),
    /**
     *  Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
     *  negative values are likely.
     */
    INT32(5, "TYPE_INT32"),
    FIXED64(6, "TYPE_FIXED64"),
    FIXED32(7, "TYPE_FIXED32"),
    BOOL(8, "TYPE_BOOL"),
    STRING(9, "TYPE_STRING"),
    /**
     *  Tag-delimited aggregate.
     *  Group type is deprecated and not supported in proto3. However, Proto3
     *  implementations should still be able to parse the group wire format and
     *  treat group fields as unknown fields.
     */
    GROUP(10, "TYPE_GROUP"),
    MESSAGE(11, "TYPE_MESSAGE"),
    /**
     *  New in version 2.
     */
    BYTES(12, "TYPE_BYTES"),
    UINT32(13, "TYPE_UINT32"),
    ENUM(14, "TYPE_ENUM"),
    SFIXED32(15, "TYPE_SFIXED32"),
    SFIXED64(16, "TYPE_SFIXED64"),
    SINT32(17, "TYPE_SINT32"),
    SINT64(18, "TYPE_SINT64"),
    ;

    public override fun support(): EnumSupport<Type> = Type

    public companion object : FieldDescriptorProtoSupport.TypeSupport()
  }

  @ProtobufDefinition(".google.protobuf.FieldDescriptorProto.Label")
  public enum class Label(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<Label> {
    /**
     *  0 is reserved for errors
     */
    OPTIONAL(1, "LABEL_OPTIONAL"),
    REQUIRED(2, "LABEL_REQUIRED"),
    REPEATED(3, "LABEL_REPEATED"),
    ;

    public override fun support(): EnumSupport<Label> = Label

    public companion object : FieldDescriptorProtoSupport.LabelSupport()
  }

  public companion object : FieldDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val NUMBER_FIELD_NAME: String = "number"

    public const val NUMBER_FIELD_NUMBER: Int = 3

    public const val LABEL_FIELD_NAME: String = "label"

    public const val LABEL_FIELD_NUMBER: Int = 4

    public const val TYPE_FIELD_NAME: String = "type"

    public const val TYPE_FIELD_NUMBER: Int = 5

    public const val TYPE_NAME_FIELD_NAME: String = "type_name"

    public const val TYPE_NAME_FIELD_NUMBER: Int = 6

    public const val EXTENDEE_FIELD_NAME: String = "extendee"

    public const val EXTENDEE_FIELD_NUMBER: Int = 2

    public const val DEFAULT_VALUE_FIELD_NAME: String = "default_value"

    public const val DEFAULT_VALUE_FIELD_NUMBER: Int = 7

    public const val ONEOF_INDEX_FIELD_NAME: String = "oneof_index"

    public const val ONEOF_INDEX_FIELD_NUMBER: Int = 9

    public const val JSON_NAME_FIELD_NAME: String = "json_name"

    public const val JSON_NAME_FIELD_NUMBER: Int = 10

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 8

    public const val PROTO3_OPTIONAL_FIELD_NAME: String = "proto3_optional"

    public const val PROTO3_OPTIONAL_FIELD_NUMBER: Int = 17
  }
}

/**
 *  Describes a oneof.
 */
@ProtobufDefinition(".google.protobuf.OneofDescriptorProto")
public interface OneofDescriptorProto : Message<OneofDescriptorProto, MutableOneofDescriptorProto> {
  public val name: String

  public val options: OneofOptions?

  public fun hasName(): Boolean

  public fun hasOptions(): Boolean

  public companion object : OneofDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 2
  }
}

/**
 *  Describes an enum type.
 */
@ProtobufDefinition(".google.protobuf.EnumDescriptorProto")
public interface EnumDescriptorProto : Message<EnumDescriptorProto, MutableEnumDescriptorProto> {
  public val name: String

  public val `value`: List<EnumValueDescriptorProto>

  public val options: EnumOptions?

  /**
   *  Range of reserved numeric values. Reserved numeric values may not be used
   *  by enum values in the same enum declaration. Reserved ranges may not
   *  overlap.
   */
  public val reservedRange: List<EnumReservedRange>

  /**
   *  Reserved enum value names, which may not be reused. A given name may only
   *  be reserved once.
   */
  public val reservedName: List<String>

  public fun hasName(): Boolean

  public fun hasValue(): Boolean

  public fun hasOptions(): Boolean

  public fun hasReservedRange(): Boolean

  public fun hasReservedName(): Boolean

  @ProtobufDefinition(".google.protobuf.EnumDescriptorProto.EnumReservedRange")
  public interface EnumReservedRange :
      Message<EnumReservedRange, MutableEnumDescriptorProto.MutableEnumReservedRange> {
    public val start: Int

    public val end: Int

    public fun hasStart(): Boolean

    public fun hasEnd(): Boolean

    public companion object : EnumDescriptorProtoSupport.EnumReservedRangeSupport() {
      public const val START_FIELD_NAME: String = "start"

      public const val START_FIELD_NUMBER: Int = 1

      public const val END_FIELD_NAME: String = "end"

      public const val END_FIELD_NUMBER: Int = 2
    }
  }

  public companion object : EnumDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3

    public const val RESERVED_RANGE_FIELD_NAME: String = "reserved_range"

    public const val RESERVED_RANGE_FIELD_NUMBER: Int = 4

    public const val RESERVED_NAME_FIELD_NAME: String = "reserved_name"

    public const val RESERVED_NAME_FIELD_NUMBER: Int = 5
  }
}

/**
 *  Describes a value within an enum.
 */
@ProtobufDefinition(".google.protobuf.EnumValueDescriptorProto")
public interface EnumValueDescriptorProto :
    Message<EnumValueDescriptorProto, MutableEnumValueDescriptorProto> {
  public val name: String

  public val number: Int

  public val options: EnumValueOptions?

  public fun hasName(): Boolean

  public fun hasNumber(): Boolean

  public fun hasOptions(): Boolean

  public companion object : EnumValueDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val NUMBER_FIELD_NAME: String = "number"

    public const val NUMBER_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3
  }
}

/**
 *  Describes a service.
 */
@ProtobufDefinition(".google.protobuf.ServiceDescriptorProto")
public interface ServiceDescriptorProto :
    Message<ServiceDescriptorProto, MutableServiceDescriptorProto> {
  public val name: String

  public val method: List<MethodDescriptorProto>

  public val options: ServiceOptions?

  public fun hasName(): Boolean

  public fun hasMethod(): Boolean

  public fun hasOptions(): Boolean

  public companion object : ServiceDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val METHOD_FIELD_NAME: String = "method"

    public const val METHOD_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3
  }
}

/**
 *  Describes a method of a service.
 */
@ProtobufDefinition(".google.protobuf.MethodDescriptorProto")
public interface MethodDescriptorProto :
    Message<MethodDescriptorProto, MutableMethodDescriptorProto> {
  public val name: String

  /**
   *  Input and output type names.  These are resolved in the same way as
   *  FieldDescriptorProto.type_name, but must refer to a message type.
   */
  public val inputType: String

  public val outputType: String

  public val options: MethodOptions?

  /**
   *  Identifies if client streams multiple client messages
   */
  public val clientStreaming: Boolean

  /**
   *  Identifies if server streams multiple server messages
   */
  public val serverStreaming: Boolean

  public fun hasName(): Boolean

  public fun hasInputType(): Boolean

  public fun hasOutputType(): Boolean

  public fun hasOptions(): Boolean

  public fun hasClientStreaming(): Boolean

  public fun hasServerStreaming(): Boolean

  public companion object : MethodDescriptorProtoSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val INPUT_TYPE_FIELD_NAME: String = "input_type"

    public const val INPUT_TYPE_FIELD_NUMBER: Int = 2

    public const val OUTPUT_TYPE_FIELD_NAME: String = "output_type"

    public const val OUTPUT_TYPE_FIELD_NUMBER: Int = 3

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 4

    public const val CLIENT_STREAMING_FIELD_NAME: String = "client_streaming"

    public const val CLIENT_STREAMING_FIELD_NUMBER: Int = 5

    public const val SERVER_STREAMING_FIELD_NAME: String = "server_streaming"

    public const val SERVER_STREAMING_FIELD_NUMBER: Int = 6
  }
}

@ProtobufDefinition(".google.protobuf.FileOptions")
public interface FileOptions : Message<FileOptions, MutableFileOptions> {
  /**
   *  Sets the Java package where classes generated from this .proto will be
   *  placed.  By default, the proto package is used, but this is often
   *  inappropriate because proto packages do not normally start with backwards
   *  domain names.
   */
  public val javaPackage: String

  /**
   *  Controls the name of the wrapper Java class generated for the .proto file.
   *  That class will always contain the .proto file's getDescriptor() method as
   *  well as any top-level extensions defined in the .proto file.
   *  If java_multiple_files is disabled, then all the other classes from the
   *  .proto file will be nested inside the single wrapper outer class.
   */
  public val javaOuterClassname: String

  /**
   *  If enabled, then the Java code generator will generate a separate .java
   *  file for each top-level message, enum, and service defined in the .proto
   *  file.  Thus, these types will *not* be nested inside the wrapper class
   *  named by java_outer_classname.  However, the wrapper class will still be
   *  generated to contain the file's getDescriptor() method as well as any
   *  top-level extensions defined in the file.
   */
  public val javaMultipleFiles: Boolean

  /**
   *  This option does nothing.
   */
  @Deprecated(message = "javaGenerateEqualsAndHash has been marked as deprecated")
  public val javaGenerateEqualsAndHash: Boolean

  /**
   *  If set true, then the Java2 code generator will generate code that
   *  throws an exception whenever an attempt is made to assign a non-UTF-8
   *  byte sequence to a string field.
   *  Message reflection will do the same.
   *  However, an extension field still accepts non-UTF-8 byte sequences.
   *  This option has no effect on when used with the lite runtime.
   */
  public val javaStringCheckUtf8: Boolean

  public val optimizeFor: OptimizeMode

  /**
   *  Sets the Go package where structs generated from this .proto will be
   *  placed. If omitted, the Go package will be derived from the following:
   *    - The basename of the package import path, if provided.
   *    - Otherwise, the package statement in the .proto file, if present.
   *    - Otherwise, the basename of the .proto file, without extension.
   */
  public val goPackage: String

  /**
   *  Should generic services be generated in each language?  "Generic" services
   *  are not specific to any particular RPC system.  They are generated by the
   *  main code generators in each language (without additional plugins).
   *  Generic services were the only kind of service generation supported by
   *  early versions of google.protobuf.
   *
   *  Generic services are now considered deprecated in favor of using plugins
   *  that generate code specific to your particular RPC system.  Therefore,
   *  these default to false.  Old code which depends on generic services should
   *  explicitly set them to true.
   */
  public val ccGenericServices: Boolean

  public val javaGenericServices: Boolean

  public val pyGenericServices: Boolean

  public val phpGenericServices: Boolean

  /**
   *  Is this file deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for everything in the file, or it will be completely ignored; in the very
   *  least, this is a formalization for deprecating files.
   */
  public val deprecated: Boolean

  /**
   *  Enables the use of arenas for the proto messages in this file. This applies
   *  only to generated classes for C++.
   */
  public val ccEnableArenas: Boolean

  /**
   *  Sets the objective c class prefix which is prepended to all objective c
   *  generated classes from this .proto. There is no default.
   */
  public val objcClassPrefix: String

  /**
   *  Namespace for generated classes; defaults to the package.
   */
  public val csharpNamespace: String

  /**
   *  By default Swift generators will take the proto package and CamelCase it
   *  replacing '.' with underscore and use that to prefix the types/symbols
   *  defined. When this options is provided, they will use this value instead
   *  to prefix the types/symbols defined.
   */
  public val swiftPrefix: String

  /**
   *  Sets the php class prefix which is prepended to all php generated classes
   *  from this .proto. Default is empty.
   */
  public val phpClassPrefix: String

  /**
   *  Use this option to change the namespace of php generated classes. Default
   *  is empty. When this option is empty, the package name will be used for
   *  determining the namespace.
   */
  public val phpNamespace: String

  /**
   *  Use this option to change the namespace of php generated metadata classes.
   *  Default is empty. When this option is empty, the proto file name will be
   *  used for determining the namespace.
   */
  public val phpMetadataNamespace: String

  /**
   *  Use this option to change the package of ruby generated classes. Default
   *  is empty. When this option is not set, the package name will be used for
   *  determining the ruby package.
   */
  public val rubyPackage: String

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here.
   *  See the documentation for the "Options" section above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasJavaPackage(): Boolean

  public fun hasJavaOuterClassname(): Boolean

  public fun hasJavaMultipleFiles(): Boolean

  public fun hasJavaGenerateEqualsAndHash(): Boolean

  public fun hasJavaStringCheckUtf8(): Boolean

  public fun hasOptimizeFor(): Boolean

  public fun hasGoPackage(): Boolean

  public fun hasCcGenericServices(): Boolean

  public fun hasJavaGenericServices(): Boolean

  public fun hasPyGenericServices(): Boolean

  public fun hasPhpGenericServices(): Boolean

  public fun hasDeprecated(): Boolean

  public fun hasCcEnableArenas(): Boolean

  public fun hasObjcClassPrefix(): Boolean

  public fun hasCsharpNamespace(): Boolean

  public fun hasSwiftPrefix(): Boolean

  public fun hasPhpClassPrefix(): Boolean

  public fun hasPhpNamespace(): Boolean

  public fun hasPhpMetadataNamespace(): Boolean

  public fun hasRubyPackage(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  /**
   *  Generated classes can be optimized for speed or code size.
   */
  @ProtobufDefinition(".google.protobuf.FileOptions.OptimizeMode")
  public enum class OptimizeMode(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<OptimizeMode> {
    SPEED(1, "SPEED"),
    /**
     *  etc.
     */
    CODE_SIZE(2, "CODE_SIZE"),
    LITE_RUNTIME(3, "LITE_RUNTIME"),
    ;

    public override fun support(): EnumSupport<OptimizeMode> = OptimizeMode

    public companion object : FileOptionsSupport.OptimizeModeSupport()
  }

  public companion object : FileOptionsSupport() {
    public const val JAVA_PACKAGE_FIELD_NAME: String = "java_package"

    public const val JAVA_PACKAGE_FIELD_NUMBER: Int = 1

    public const val JAVA_OUTER_CLASSNAME_FIELD_NAME: String = "java_outer_classname"

    public const val JAVA_OUTER_CLASSNAME_FIELD_NUMBER: Int = 8

    public const val JAVA_MULTIPLE_FILES_FIELD_NAME: String = "java_multiple_files"

    public const val JAVA_MULTIPLE_FILES_FIELD_NUMBER: Int = 10

    public const val JAVA_GENERATE_EQUALS_AND_HASH_FIELD_NAME: String =
        "java_generate_equals_and_hash"

    public const val JAVA_GENERATE_EQUALS_AND_HASH_FIELD_NUMBER: Int = 20

    public const val JAVA_STRING_CHECK_UTF8_FIELD_NAME: String = "java_string_check_utf8"

    public const val JAVA_STRING_CHECK_UTF8_FIELD_NUMBER: Int = 27

    public const val OPTIMIZE_FOR_FIELD_NAME: String = "optimize_for"

    public const val OPTIMIZE_FOR_FIELD_NUMBER: Int = 9

    public const val GO_PACKAGE_FIELD_NAME: String = "go_package"

    public const val GO_PACKAGE_FIELD_NUMBER: Int = 11

    public const val CC_GENERIC_SERVICES_FIELD_NAME: String = "cc_generic_services"

    public const val CC_GENERIC_SERVICES_FIELD_NUMBER: Int = 16

    public const val JAVA_GENERIC_SERVICES_FIELD_NAME: String = "java_generic_services"

    public const val JAVA_GENERIC_SERVICES_FIELD_NUMBER: Int = 17

    public const val PY_GENERIC_SERVICES_FIELD_NAME: String = "py_generic_services"

    public const val PY_GENERIC_SERVICES_FIELD_NUMBER: Int = 18

    public const val PHP_GENERIC_SERVICES_FIELD_NAME: String = "php_generic_services"

    public const val PHP_GENERIC_SERVICES_FIELD_NUMBER: Int = 42

    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 23

    public const val CC_ENABLE_ARENAS_FIELD_NAME: String = "cc_enable_arenas"

    public const val CC_ENABLE_ARENAS_FIELD_NUMBER: Int = 31

    public const val OBJC_CLASS_PREFIX_FIELD_NAME: String = "objc_class_prefix"

    public const val OBJC_CLASS_PREFIX_FIELD_NUMBER: Int = 36

    public const val CSHARP_NAMESPACE_FIELD_NAME: String = "csharp_namespace"

    public const val CSHARP_NAMESPACE_FIELD_NUMBER: Int = 37

    public const val SWIFT_PREFIX_FIELD_NAME: String = "swift_prefix"

    public const val SWIFT_PREFIX_FIELD_NUMBER: Int = 39

    public const val PHP_CLASS_PREFIX_FIELD_NAME: String = "php_class_prefix"

    public const val PHP_CLASS_PREFIX_FIELD_NUMBER: Int = 40

    public const val PHP_NAMESPACE_FIELD_NAME: String = "php_namespace"

    public const val PHP_NAMESPACE_FIELD_NUMBER: Int = 41

    public const val PHP_METADATA_NAMESPACE_FIELD_NAME: String = "php_metadata_namespace"

    public const val PHP_METADATA_NAMESPACE_FIELD_NUMBER: Int = 44

    public const val RUBY_PACKAGE_FIELD_NAME: String = "ruby_package"

    public const val RUBY_PACKAGE_FIELD_NUMBER: Int = 45

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 50

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.MessageOptions")
public interface MessageOptions : Message<MessageOptions, MutableMessageOptions> {
  /**
   *  Set true to use the old proto1 MessageSet wire format for extensions.
   *  This is provided for backwards-compatibility with the MessageSet wire
   *  format.  You should not use this for any other reason:  It's less
   *  efficient, has fewer features, and is more complicated.
   *
   *  The message must be defined exactly as follows:
   *    message Foo {
   *      option message_set_wire_format = true;
   *      extensions 4 to max;
   *    }
   *  Note that the message cannot have any defined fields; MessageSets only
   *  have extensions.
   *
   *  All extensions of your type must be singular messages; e.g. they cannot
   *  be int32s, enums, or repeated messages.
   *
   *  Because this is an option, the above two restrictions are not enforced by
   *  the protocol compiler.
   */
  public val messageSetWireFormat: Boolean

  /**
   *  Disables the generation of the standard "descriptor()" accessor, which can
   *  conflict with a field of the same name.  This is meant to make migration
   *  from proto1 easier; new code should avoid fields named "descriptor".
   */
  public val noStandardDescriptorAccessor: Boolean

  /**
   *  Is this message deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for the message, or it will be completely ignored; in the very least,
   *  this is a formalization for deprecating messages.
   */
  public val deprecated: Boolean

  /**
   *  NOTE: Do not set the option in .proto files. Always use the maps syntax
   *  instead. The option should only be implicitly set by the proto compiler
   *  parser.
   *
   *  Whether the message is an automatically generated map entry type for the
   *  maps field.
   *
   *  For maps fields:
   *      map<KeyType, ValueType> map_field = 1;
   *  The parsed descriptor looks like:
   *      message MapFieldEntry {
   *          option map_entry = true;
   *          optional KeyType key = 1;
   *          optional ValueType value = 2;
   *      }
   *      repeated MapFieldEntry map_field = 1;
   *
   *  Implementations may choose not to generate the map_entry=true message, but
   *  use a native map in the target language to hold the keys and values.
   *  The reflection APIs in such implementations still need to work as
   *  if the field is a repeated message field.
   */
  public val mapEntry: Boolean

  /**
   *  Enable the legacy handling of JSON field name conflicts.  This lowercases
   *  and strips underscored from the fields before comparison in proto3 only.
   *  The new behavior takes `json_name` into account and applies to proto2 as
   *  well.
   *
   *  This should only be used as a temporary measure against broken builds due
   *  to the change in behavior for JSON field name conflicts.
   *
   *  TODO(b/261750190) This is legacy behavior we plan to remove once downstream
   *  teams have had time to migrate.
   */
  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public val deprecatedLegacyJsonFieldConflicts: Boolean

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasMessageSetWireFormat(): Boolean

  public fun hasNoStandardDescriptorAccessor(): Boolean

  public fun hasDeprecated(): Boolean

  public fun hasMapEntry(): Boolean

  public fun hasDeprecatedLegacyJsonFieldConflicts(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  public companion object : MessageOptionsSupport() {
    public const val MESSAGE_SET_WIRE_FORMAT_FIELD_NAME: String = "message_set_wire_format"

    public const val MESSAGE_SET_WIRE_FORMAT_FIELD_NUMBER: Int = 1

    public const val NO_STANDARD_DESCRIPTOR_ACCESSOR_FIELD_NAME: String =
        "no_standard_descriptor_accessor"

    public const val NO_STANDARD_DESCRIPTOR_ACCESSOR_FIELD_NUMBER: Int = 2

    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 3

    public const val MAP_ENTRY_FIELD_NAME: String = "map_entry"

    public const val MAP_ENTRY_FIELD_NUMBER: Int = 7

    public const val DEPRECATED_LEGACY_JSON_FIELD_CONFLICTS_FIELD_NAME: String =
        "deprecated_legacy_json_field_conflicts"

    public const val DEPRECATED_LEGACY_JSON_FIELD_CONFLICTS_FIELD_NUMBER: Int = 11

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 12

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.FieldOptions")
public interface FieldOptions : Message<FieldOptions, MutableFieldOptions> {
  /**
   *  The ctype option instructs the C++ code generator to use a different
   *  representation of the field than it normally would.  See the specific
   *  options below.  This option is only implemented to support use of
   *  [ctype=CORD] and [ctype=STRING] (the default) on non-repeated fields of
   *  type "bytes" in the open source release -- sorry, we'll try to include
   *  other types in a future version!
   */
  public val ctype: CType

  /**
   *  The packed option can be enabled for repeated primitive fields to enable
   *  a more efficient representation on the wire. Rather than repeatedly
   *  writing the tag and type for each element, the entire array is encoded as
   *  a single length-delimited blob. In proto3, only explicit setting it to
   *  false will avoid using packed encoding.
   */
  public val packed: Boolean

  /**
   *  The jstype option determines the JavaScript type used for values of the
   *  field.  The option is permitted only for 64 bit integral and fixed types
   *  (int64, uint64, sint64, fixed64, sfixed64).  A field with jstype JS_STRING
   *  is represented as JavaScript string, which avoids loss of precision that
   *  can happen when a large value is converted to a floating point JavaScript.
   *  Specifying JS_NUMBER for the jstype causes the generated JavaScript code to
   *  use the JavaScript "number" type.  The behavior of the default option
   *  JS_NORMAL is implementation dependent.
   *
   *  This option is an enum to permit additional types to be added, e.g.
   *  goog.math.Integer.
   */
  public val jstype: JSType

  /**
   *  Should this field be parsed lazily?  Lazy applies only to message-type
   *  fields.  It means that when the outer message is initially parsed, the
   *  inner message's contents will not be parsed but instead stored in encoded
   *  form.  The inner message will actually be parsed when it is first accessed.
   *
   *  This is only a hint.  Implementations are free to choose whether to use
   *  eager or lazy parsing regardless of the value of this option.  However,
   *  setting this option true suggests that the protocol author believes that
   *  using lazy parsing on this field is worth the additional bookkeeping
   *  overhead typically needed to implement it.
   *
   *  This option does not affect the public interface of any generated code;
   *  all method signatures remain the same.  Furthermore, thread-safety of the
   *  interface is not affected by this option; const methods remain safe to
   *  call from multiple threads concurrently, while non-const methods continue
   *  to require exclusive access.
   *
   *  Note that implementations may choose not to check required fields within
   *  a lazy sub-message.  That is, calling IsInitialized() on the outer message
   *  may return true even if the inner message has missing required fields.
   *  This is necessary because otherwise the inner message would have to be
   *  parsed in order to perform the check, defeating the purpose of lazy
   *  parsing.  An implementation which chooses not to check required fields
   *  must be consistent about it.  That is, for any particular sub-message, the
   *  implementation must either *always* check its required fields, or *never*
   *  check its required fields, regardless of whether or not the message has
   *  been parsed.
   *
   *  As of May 2022, lazy verifies the contents of the byte stream during
   *  parsing.  An invalid byte stream will cause the overall parsing to fail.
   */
  public val lazy: Boolean

  /**
   *  unverified_lazy does no correctness checks on the byte stream. This should
   *  only be used where lazy with verification is prohibitive for performance
   *  reasons.
   */
  public val unverifiedLazy: Boolean

  /**
   *  Is this field deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for accessors, or it will be completely ignored; in the very least, this
   *  is a formalization for deprecating fields.
   */
  public val deprecated: Boolean

  /**
   *  For Google-internal migration only. Do not use.
   */
  public val weak: Boolean

  /**
   *  Indicate that the field value should not be printed out when using debug
   *  formats, e.g. when the field contains sensitive credentials.
   */
  public val debugRedact: Boolean

  public val retention: OptionRetention

  public val targets: List<OptionTargetType>

  public val editionDefaults: List<EditionDefault>

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasCtype(): Boolean

  public fun hasPacked(): Boolean

  public fun hasJstype(): Boolean

  public fun hasLazy(): Boolean

  public fun hasUnverifiedLazy(): Boolean

  public fun hasDeprecated(): Boolean

  public fun hasWeak(): Boolean

  public fun hasDebugRedact(): Boolean

  public fun hasRetention(): Boolean

  public fun hasTargets(): Boolean

  public fun hasEditionDefaults(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  @ProtobufDefinition(".google.protobuf.FieldOptions.CType")
  public enum class CType(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<CType> {
    /**
     *  Default mode.
     */
    STRING(0, "STRING"),
    /**
     *  The option [ctype=CORD] may be applied to a non-repeated field of type
     *  "bytes". It indicates that in C++, the data should be stored in a Cord
     *  instead of a string.  For very large strings, this may reduce memory
     *  fragmentation. It may also allow better performance when parsing from a
     *  Cord, or when parsing with aliasing enabled, as the parsed Cord may then
     *  alias the original buffer.
     */
    CORD(1, "CORD"),
    STRING_PIECE(2, "STRING_PIECE"),
    ;

    public override fun support(): EnumSupport<CType> = CType

    public companion object : FieldOptionsSupport.CTypeSupport()
  }

  @ProtobufDefinition(".google.protobuf.FieldOptions.JSType")
  public enum class JSType(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<JSType> {
    /**
     *  Use the default type.
     */
    JS_NORMAL(0, "JS_NORMAL"),
    /**
     *  Use JavaScript strings.
     */
    JS_STRING(1, "JS_STRING"),
    /**
     *  Use JavaScript numbers.
     */
    JS_NUMBER(2, "JS_NUMBER"),
    ;

    public override fun support(): EnumSupport<JSType> = JSType

    public companion object : FieldOptionsSupport.JSTypeSupport()
  }

  /**
   *  If set to RETENTION_SOURCE, the option will be omitted from the binary.
   *  Note: as of January 2023, support for this is in progress and does not yet
   *  have an effect (b/264593489).
   */
  @ProtobufDefinition(".google.protobuf.FieldOptions.OptionRetention")
  public enum class OptionRetention(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<OptionRetention> {
    RETENTION_UNKNOWN(0, "RETENTION_UNKNOWN"),
    RETENTION_RUNTIME(1, "RETENTION_RUNTIME"),
    RETENTION_SOURCE(2, "RETENTION_SOURCE"),
    ;

    public override fun support(): EnumSupport<OptionRetention> = OptionRetention

    public companion object : FieldOptionsSupport.OptionRetentionSupport()
  }

  /**
   *  This indicates the types of entities that the field may apply to when used
   *  as an option. If it is unset, then the field may be freely used as an
   *  option on any kind of entity. Note: as of January 2023, support for this is
   *  in progress and does not yet have an effect (b/264593489).
   */
  @ProtobufDefinition(".google.protobuf.FieldOptions.OptionTargetType")
  public enum class OptionTargetType(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<OptionTargetType> {
    TARGET_TYPE_UNKNOWN(0, "TARGET_TYPE_UNKNOWN"),
    TARGET_TYPE_FILE(1, "TARGET_TYPE_FILE"),
    TARGET_TYPE_EXTENSION_RANGE(2, "TARGET_TYPE_EXTENSION_RANGE"),
    TARGET_TYPE_MESSAGE(3, "TARGET_TYPE_MESSAGE"),
    TARGET_TYPE_FIELD(4, "TARGET_TYPE_FIELD"),
    TARGET_TYPE_ONEOF(5, "TARGET_TYPE_ONEOF"),
    TARGET_TYPE_ENUM(6, "TARGET_TYPE_ENUM"),
    TARGET_TYPE_ENUM_ENTRY(7, "TARGET_TYPE_ENUM_ENTRY"),
    TARGET_TYPE_SERVICE(8, "TARGET_TYPE_SERVICE"),
    TARGET_TYPE_METHOD(9, "TARGET_TYPE_METHOD"),
    ;

    public override fun support(): EnumSupport<OptionTargetType> = OptionTargetType

    public companion object : FieldOptionsSupport.OptionTargetTypeSupport()
  }

  @ProtobufDefinition(".google.protobuf.FieldOptions.EditionDefault")
  public interface EditionDefault :
      Message<EditionDefault, MutableFieldOptions.MutableEditionDefault> {
    public val edition: String

    public val `value`: String

    public fun hasEdition(): Boolean

    public fun hasValue(): Boolean

    public companion object : FieldOptionsSupport.EditionDefaultSupport() {
      public const val EDITION_FIELD_NAME: String = "edition"

      public const val EDITION_FIELD_NUMBER: Int = 1

      public const val VALUE_FIELD_NAME: String = "value"

      public const val VALUE_FIELD_NUMBER: Int = 2
    }
  }

  public companion object : FieldOptionsSupport() {
    public const val CTYPE_FIELD_NAME: String = "ctype"

    public const val CTYPE_FIELD_NUMBER: Int = 1

    public const val PACKED_FIELD_NAME: String = "packed"

    public const val PACKED_FIELD_NUMBER: Int = 2

    public const val JSTYPE_FIELD_NAME: String = "jstype"

    public const val JSTYPE_FIELD_NUMBER: Int = 6

    public const val LAZY_FIELD_NAME: String = "lazy"

    public const val LAZY_FIELD_NUMBER: Int = 5

    public const val UNVERIFIED_LAZY_FIELD_NAME: String = "unverified_lazy"

    public const val UNVERIFIED_LAZY_FIELD_NUMBER: Int = 15

    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 3

    public const val WEAK_FIELD_NAME: String = "weak"

    public const val WEAK_FIELD_NUMBER: Int = 10

    public const val DEBUG_REDACT_FIELD_NAME: String = "debug_redact"

    public const val DEBUG_REDACT_FIELD_NUMBER: Int = 16

    public const val RETENTION_FIELD_NAME: String = "retention"

    public const val RETENTION_FIELD_NUMBER: Int = 17

    public const val TARGETS_FIELD_NAME: String = "targets"

    public const val TARGETS_FIELD_NUMBER: Int = 19

    public const val EDITION_DEFAULTS_FIELD_NAME: String = "edition_defaults"

    public const val EDITION_DEFAULTS_FIELD_NUMBER: Int = 20

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 21

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.OneofOptions")
public interface OneofOptions : Message<OneofOptions, MutableOneofOptions> {
  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  public companion object : OneofOptionsSupport() {
    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 1

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.EnumOptions")
public interface EnumOptions : Message<EnumOptions, MutableEnumOptions> {
  /**
   *  Set this option to true to allow mapping different tag names to the same
   *  value.
   */
  public val allowAlias: Boolean

  /**
   *  Is this enum deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for the enum, or it will be completely ignored; in the very least, this
   *  is a formalization for deprecating enums.
   */
  public val deprecated: Boolean

  /**
   *  Enable the legacy handling of JSON field name conflicts.  This lowercases
   *  and strips underscored from the fields before comparison in proto3 only.
   *  The new behavior takes `json_name` into account and applies to proto2 as
   *  well.
   *  TODO(b/261750190) Remove this legacy behavior once downstream teams have
   *  had time to migrate.
   */
  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public val deprecatedLegacyJsonFieldConflicts: Boolean

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasAllowAlias(): Boolean

  public fun hasDeprecated(): Boolean

  public fun hasDeprecatedLegacyJsonFieldConflicts(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  public companion object : EnumOptionsSupport() {
    public const val ALLOW_ALIAS_FIELD_NAME: String = "allow_alias"

    public const val ALLOW_ALIAS_FIELD_NUMBER: Int = 2

    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 3

    public const val DEPRECATED_LEGACY_JSON_FIELD_CONFLICTS_FIELD_NAME: String =
        "deprecated_legacy_json_field_conflicts"

    public const val DEPRECATED_LEGACY_JSON_FIELD_CONFLICTS_FIELD_NUMBER: Int = 6

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 7

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.EnumValueOptions")
public interface EnumValueOptions : Message<EnumValueOptions, MutableEnumValueOptions> {
  /**
   *  Is this enum value deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for the enum value, or it will be completely ignored; in the very least,
   *  this is a formalization for deprecating enum values.
   */
  public val deprecated: Boolean

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  Indicate that fields annotated with this enum value should not be printed
   *  out when using debug formats, e.g. when the field contains sensitive
   *  credentials.
   */
  public val debugRedact: Boolean

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasDeprecated(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasDebugRedact(): Boolean

  public fun hasUninterpretedOption(): Boolean

  public companion object : EnumValueOptionsSupport() {
    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 1

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 2

    public const val DEBUG_REDACT_FIELD_NAME: String = "debug_redact"

    public const val DEBUG_REDACT_FIELD_NUMBER: Int = 3

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.ServiceOptions")
public interface ServiceOptions : Message<ServiceOptions, MutableServiceOptions> {
  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  Is this service deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for the service, or it will be completely ignored; in the very least,
   *  this is a formalization for deprecating services.
   */
  public val deprecated: Boolean

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasFeatures(): Boolean

  public fun hasDeprecated(): Boolean

  public fun hasUninterpretedOption(): Boolean

  public companion object : ServiceOptionsSupport() {
    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 34

    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 33

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

@ProtobufDefinition(".google.protobuf.MethodOptions")
public interface MethodOptions : Message<MethodOptions, MutableMethodOptions> {
  /**
   *  Is this method deprecated?
   *  Depending on the target platform, this can emit Deprecated annotations
   *  for the method, or it will be completely ignored; in the very least,
   *  this is a formalization for deprecating methods.
   */
  public val deprecated: Boolean

  public val idempotencyLevel: IdempotencyLevel

  /**
   *  Any features defined in the specific edition.
   */
  public val features: FeatureSet?

  /**
   *  The parser stores options it doesn't recognize here. See above.
   */
  public val uninterpretedOption: List<UninterpretedOption>

  public fun hasDeprecated(): Boolean

  public fun hasIdempotencyLevel(): Boolean

  public fun hasFeatures(): Boolean

  public fun hasUninterpretedOption(): Boolean

  /**
   *  Is this method side-effect-free (or safe in HTTP parlance), or idempotent,
   *  or neither? HTTP based RPC implementation may choose GET verb for safe
   *  methods, and PUT verb for idempotent methods instead of the default POST.
   */
  @ProtobufDefinition(".google.protobuf.MethodOptions.IdempotencyLevel")
  public enum class IdempotencyLevel(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<IdempotencyLevel> {
    IDEMPOTENCY_UNKNOWN(0, "IDEMPOTENCY_UNKNOWN"),
    NO_SIDE_EFFECTS(1, "NO_SIDE_EFFECTS"),
    IDEMPOTENT(2, "IDEMPOTENT"),
    ;

    public override fun support(): EnumSupport<IdempotencyLevel> = IdempotencyLevel

    public companion object : MethodOptionsSupport.IdempotencyLevelSupport()
  }

  public companion object : MethodOptionsSupport() {
    public const val DEPRECATED_FIELD_NAME: String = "deprecated"

    public const val DEPRECATED_FIELD_NUMBER: Int = 33

    public const val IDEMPOTENCY_LEVEL_FIELD_NAME: String = "idempotency_level"

    public const val IDEMPOTENCY_LEVEL_FIELD_NUMBER: Int = 34

    public const val FEATURES_FIELD_NAME: String = "features"

    public const val FEATURES_FIELD_NUMBER: Int = 35

    public const val UNINTERPRETED_OPTION_FIELD_NAME: String = "uninterpreted_option"

    public const val UNINTERPRETED_OPTION_FIELD_NUMBER: Int = 999
  }
}

/**
 *  A message representing a option the parser does not recognize. This only
 *  appears in options protos created by the compiler::Parser class.
 *  DescriptorPool resolves these when building Descriptor objects. Therefore,
 *  options protos in descriptor objects (e.g. returned by Descriptor::options(),
 *  or produced by Descriptor::CopyTo()) will never have UninterpretedOptions
 *  in them.
 */
@ProtobufDefinition(".google.protobuf.UninterpretedOption")
public interface UninterpretedOption : Message<UninterpretedOption, MutableUninterpretedOption> {
  public val name: List<NamePart>

  /**
   *  The value of the uninterpreted option, in whatever type the tokenizer
   *  identified it as during parsing. Exactly one of these should be set.
   */
  public val identifierValue: String

  public val positiveIntValue: ULong

  public val negativeIntValue: Long

  public val doubleValue: Double

  public val stringValue: ByteArray

  public val aggregateValue: String

  public fun hasName(): Boolean

  public fun hasIdentifierValue(): Boolean

  public fun hasPositiveIntValue(): Boolean

  public fun hasNegativeIntValue(): Boolean

  public fun hasDoubleValue(): Boolean

  public fun hasStringValue(): Boolean

  public fun hasAggregateValue(): Boolean

  @ProtobufDefinition(".google.protobuf.UninterpretedOption.NamePart")
  public interface NamePart : Message<NamePart, MutableUninterpretedOption.MutableNamePart> {
    public val namePart: String

    public val isExtension: Boolean

    public companion object : UninterpretedOptionSupport.NamePartSupport() {
      public const val NAME_PART_FIELD_NAME: String = "name_part"

      public const val NAME_PART_FIELD_NUMBER: Int = 1

      public const val IS_EXTENSION_FIELD_NAME: String = "is_extension"

      public const val IS_EXTENSION_FIELD_NUMBER: Int = 2
    }
  }

  public companion object : UninterpretedOptionSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 2

    public const val IDENTIFIER_VALUE_FIELD_NAME: String = "identifier_value"

    public const val IDENTIFIER_VALUE_FIELD_NUMBER: Int = 3

    public const val POSITIVE_INT_VALUE_FIELD_NAME: String = "positive_int_value"

    public const val POSITIVE_INT_VALUE_FIELD_NUMBER: Int = 4

    public const val NEGATIVE_INT_VALUE_FIELD_NAME: String = "negative_int_value"

    public const val NEGATIVE_INT_VALUE_FIELD_NUMBER: Int = 5

    public const val DOUBLE_VALUE_FIELD_NAME: String = "double_value"

    public const val DOUBLE_VALUE_FIELD_NUMBER: Int = 6

    public const val STRING_VALUE_FIELD_NAME: String = "string_value"

    public const val STRING_VALUE_FIELD_NUMBER: Int = 7

    public const val AGGREGATE_VALUE_FIELD_NAME: String = "aggregate_value"

    public const val AGGREGATE_VALUE_FIELD_NUMBER: Int = 8
  }
}

/**
 *  TODO(b/274655146) Enums in C++ gencode (and potentially other languages) are
 *  not well scoped.  This means that each of the feature enums below can clash
 *  with each other.  The short names we've chosen maximize call-site
 *  readability, but leave us very open to this scenario.  A future feature will
 *  be designed and implemented to handle this, hopefully before we ever hit a
 *  conflict here.
 */
@ProtobufDefinition(".google.protobuf.FeatureSet")
public interface FeatureSet : Message<FeatureSet, MutableFeatureSet> {
  public val fieldPresence: FieldPresence

  public val enumType: EnumType

  public val repeatedFieldEncoding: RepeatedFieldEncoding

  public val stringFieldValidation: StringFieldValidation

  public val messageEncoding: MessageEncoding

  public val jsonFormat: JsonFormat

  public val rawFeatures: FeatureSet?

  public fun hasFieldPresence(): Boolean

  public fun hasEnumType(): Boolean

  public fun hasRepeatedFieldEncoding(): Boolean

  public fun hasStringFieldValidation(): Boolean

  public fun hasMessageEncoding(): Boolean

  public fun hasJsonFormat(): Boolean

  public fun hasRawFeatures(): Boolean

  @ProtobufDefinition(".google.protobuf.FeatureSet.FieldPresence")
  public enum class FieldPresence(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<FieldPresence> {
    UNKNOWN(0, "FIELD_PRESENCE_UNKNOWN"),
    EXPLICIT(1, "EXPLICIT"),
    IMPLICIT(2, "IMPLICIT"),
    LEGACY_REQUIRED(3, "LEGACY_REQUIRED"),
    ;

    public override fun support(): EnumSupport<FieldPresence> = FieldPresence

    public companion object : FeatureSetSupport.FieldPresenceSupport()
  }

  @ProtobufDefinition(".google.protobuf.FeatureSet.EnumType")
  public enum class EnumType(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<EnumType> {
    UNKNOWN(0, "ENUM_TYPE_UNKNOWN"),
    OPEN(1, "OPEN"),
    CLOSED(2, "CLOSED"),
    ;

    public override fun support(): EnumSupport<EnumType> = EnumType

    public companion object : FeatureSetSupport.EnumTypeSupport()
  }

  @ProtobufDefinition(".google.protobuf.FeatureSet.RepeatedFieldEncoding")
  public enum class RepeatedFieldEncoding(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<RepeatedFieldEncoding> {
    UNKNOWN(0, "REPEATED_FIELD_ENCODING_UNKNOWN"),
    PACKED(1, "PACKED"),
    EXPANDED(2, "EXPANDED"),
    ;

    public override fun support(): EnumSupport<RepeatedFieldEncoding> = RepeatedFieldEncoding

    public companion object : FeatureSetSupport.RepeatedFieldEncodingSupport()
  }

  @ProtobufDefinition(".google.protobuf.FeatureSet.StringFieldValidation")
  public enum class StringFieldValidation(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<StringFieldValidation> {
    UNKNOWN(0, "STRING_FIELD_VALIDATION_UNKNOWN"),
    MANDATORY(1, "MANDATORY"),
    HINT(2, "HINT"),
    NONE(3, "NONE"),
    ;

    public override fun support(): EnumSupport<StringFieldValidation> = StringFieldValidation

    public companion object : FeatureSetSupport.StringFieldValidationSupport()
  }

  @ProtobufDefinition(".google.protobuf.FeatureSet.MessageEncoding")
  public enum class MessageEncoding(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<MessageEncoding> {
    UNKNOWN(0, "MESSAGE_ENCODING_UNKNOWN"),
    LENGTH_PREFIXED(1, "LENGTH_PREFIXED"),
    DELIMITED(2, "DELIMITED"),
    ;

    public override fun support(): EnumSupport<MessageEncoding> = MessageEncoding

    public companion object : FeatureSetSupport.MessageEncodingSupport()
  }

  @ProtobufDefinition(".google.protobuf.FeatureSet.JsonFormat")
  public enum class JsonFormat(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<JsonFormat> {
    UNKNOWN(0, "JSON_FORMAT_UNKNOWN"),
    ALLOW(1, "ALLOW"),
    LEGACY_BEST_EFFORT(2, "LEGACY_BEST_EFFORT"),
    ;

    public override fun support(): EnumSupport<JsonFormat> = JsonFormat

    public companion object : FeatureSetSupport.JsonFormatSupport()
  }

  public companion object : FeatureSetSupport() {
    public const val FIELD_PRESENCE_FIELD_NAME: String = "field_presence"

    public const val FIELD_PRESENCE_FIELD_NUMBER: Int = 1

    public const val ENUM_TYPE_FIELD_NAME: String = "enum_type"

    public const val ENUM_TYPE_FIELD_NUMBER: Int = 2

    public const val REPEATED_FIELD_ENCODING_FIELD_NAME: String = "repeated_field_encoding"

    public const val REPEATED_FIELD_ENCODING_FIELD_NUMBER: Int = 3

    public const val STRING_FIELD_VALIDATION_FIELD_NAME: String = "string_field_validation"

    public const val STRING_FIELD_VALIDATION_FIELD_NUMBER: Int = 4

    public const val MESSAGE_ENCODING_FIELD_NAME: String = "message_encoding"

    public const val MESSAGE_ENCODING_FIELD_NUMBER: Int = 5

    public const val JSON_FORMAT_FIELD_NAME: String = "json_format"

    public const val JSON_FORMAT_FIELD_NUMBER: Int = 6

    public const val RAW_FEATURES_FIELD_NAME: String = "raw_features"

    public const val RAW_FEATURES_FIELD_NUMBER: Int = 999
  }
}

/**
 *  Encapsulates information about the original source file from which a
 *  FileDescriptorProto was generated.
 */
@ProtobufDefinition(".google.protobuf.SourceCodeInfo")
public interface SourceCodeInfo : Message<SourceCodeInfo, MutableSourceCodeInfo> {
  /**
   *  A Location identifies a piece of source code in a .proto file which
   *  corresponds to a particular definition.  This information is intended
   *  to be useful to IDEs, code indexers, documentation generators, and similar
   *  tools.
   *
   *  For example, say we have a file like:
   *    message Foo {
   *      optional string foo = 1;
   *    }
   *  Let's look at just the field definition:
   *    optional string foo = 1;
   *    ^       ^^     ^^  ^  ^^^
   *    a       bc     de  f  ghi
   *  We have the following locations:
   *    span   path               represents
   *    [a,i)  [ 4, 0, 2, 0 ]     The whole field definition.
   *    [a,b)  [ 4, 0, 2, 0, 4 ]  The label (optional).
   *    [c,d)  [ 4, 0, 2, 0, 5 ]  The type (string).
   *    [e,f)  [ 4, 0, 2, 0, 1 ]  The name (foo).
   *    [g,h)  [ 4, 0, 2, 0, 3 ]  The number (1).
   *
   *  Notes:
   *  - A location may refer to a repeated field itself (i.e. not to any
   *    particular index within it).  This is used whenever a set of elements are
   *    logically enclosed in a single code segment.  For example, an entire
   *    extend block (possibly containing multiple extension definitions) will
   *    have an outer location whose path refers to the "extensions" repeated
   *    field without an index.
   *  - Multiple locations may have the same path.  This happens when a single
   *    logical declaration is spread out across multiple places.  The most
   *    obvious example is the "extend" block again -- there may be multiple
   *    extend blocks in the same scope, each of which will have the same path.
   *  - A location's span is not always a subset of its parent's span.  For
   *    example, the "extendee" of an extension declaration appears at the
   *    beginning of the "extend" block and is shared by all extensions within
   *    the block.
   *  - Just because a location's span is a subset of some other location's span
   *    does not mean that it is a descendant.  For example, a "group" defines
   *    both a type and a field in a single declaration.  Thus, the locations
   *    corresponding to the type and field and their components will overlap.
   *  - Code which tries to interpret locations should probably be designed to
   *    ignore those that it doesn't understand, as more types of locations could
   *    be recorded in the future.
   */
  public val location: List<Location>

  public fun hasLocation(): Boolean

  @ProtobufDefinition(".google.protobuf.SourceCodeInfo.Location")
  public interface Location : Message<Location, MutableSourceCodeInfo.MutableLocation> {
    public val path: List<Int>

    public val span: List<Int>

    public val leadingComments: String

    public val trailingComments: String

    public val leadingDetachedComments: List<String>

    public fun hasPath(): Boolean

    public fun hasSpan(): Boolean

    public fun hasLeadingComments(): Boolean

    public fun hasTrailingComments(): Boolean

    public fun hasLeadingDetachedComments(): Boolean

    public companion object : SourceCodeInfoSupport.LocationSupport() {
      public const val PATH_FIELD_NAME: String = "path"

      public const val PATH_FIELD_NUMBER: Int = 1

      public const val SPAN_FIELD_NAME: String = "span"

      public const val SPAN_FIELD_NUMBER: Int = 2

      public const val LEADING_COMMENTS_FIELD_NAME: String = "leading_comments"

      public const val LEADING_COMMENTS_FIELD_NUMBER: Int = 3

      public const val TRAILING_COMMENTS_FIELD_NAME: String = "trailing_comments"

      public const val TRAILING_COMMENTS_FIELD_NUMBER: Int = 4

      public const val LEADING_DETACHED_COMMENTS_FIELD_NAME: String = "leading_detached_comments"

      public const val LEADING_DETACHED_COMMENTS_FIELD_NUMBER: Int = 6
    }
  }

  public companion object : SourceCodeInfoSupport() {
    public const val LOCATION_FIELD_NAME: String = "location"

    public const val LOCATION_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Describes the relationship between generated code and its original source
 *  file. A GeneratedCodeInfo message is associated with only one generated
 *  source file, but may contain references to different source .proto files.
 */
@ProtobufDefinition(".google.protobuf.GeneratedCodeInfo")
public interface GeneratedCodeInfo : Message<GeneratedCodeInfo, MutableGeneratedCodeInfo> {
  /**
   *  An Annotation connects some span of text in generated code to an element
   *  of its generating .proto file.
   */
  public val `annotation`: List<Annotation>

  public fun hasAnnotation(): Boolean

  @ProtobufDefinition(".google.protobuf.GeneratedCodeInfo.Annotation")
  public interface Annotation : Message<Annotation, MutableGeneratedCodeInfo.MutableAnnotation> {
    public val path: List<Int>

    public val sourceFile: String

    public val begin: Int

    public val end: Int

    public val semantic: Semantic

    public fun hasPath(): Boolean

    public fun hasSourceFile(): Boolean

    public fun hasBegin(): Boolean

    public fun hasEnd(): Boolean

    public fun hasSemantic(): Boolean

    @ProtobufDefinition(".google.protobuf.GeneratedCodeInfo.Annotation.Semantic")
    public enum class Semantic(
      public override val number: Int,
      public override val proto: String,
    ) : ProtoEnum<Semantic> {
      NONE(0, "NONE"),
      SET(1, "SET"),
      ALIAS(2, "ALIAS"),
      ;

      public override fun support(): EnumSupport<Semantic> = Semantic

      public companion object : GeneratedCodeInfoSupport.AnnotationSupport.SemanticSupport()
    }

    public companion object : GeneratedCodeInfoSupport.AnnotationSupport() {
      public const val PATH_FIELD_NAME: String = "path"

      public const val PATH_FIELD_NUMBER: Int = 1

      public const val SOURCE_FILE_FIELD_NAME: String = "source_file"

      public const val SOURCE_FILE_FIELD_NUMBER: Int = 2

      public const val BEGIN_FIELD_NAME: String = "begin"

      public const val BEGIN_FIELD_NUMBER: Int = 3

      public const val END_FIELD_NAME: String = "end"

      public const val END_FIELD_NUMBER: Int = 4

      public const val SEMANTIC_FIELD_NAME: String = "semantic"

      public const val SEMANTIC_FIELD_NUMBER: Int = 5
    }
  }

  public companion object : GeneratedCodeInfoSupport() {
    public const val ANNOTATION_FIELD_NAME: String = "annotation"

    public const val ANNOTATION_FIELD_NUMBER: Int = 1
  }
}
