package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableSourceContext
import com.bybutter.sisyphus.protobuf.primitives.`internal`.SourceContextSupport
import kotlin.Boolean
import kotlin.Int
import kotlin.String

/**
 *  `SourceContext` represents information about the source of a
 *  protobuf element, like the file in which it is defined.
 */
@ProtobufDefinition(".google.protobuf.SourceContext")
public interface SourceContext : Message<SourceContext, MutableSourceContext> {
  /**
   *  The path-qualified name of the .proto file that contained the associated
   *  protobuf element.  For example: `"google/protobuf/source_context.proto"`.
   */
  public val fileName: String

  public fun hasFileName(): Boolean

  public companion object : SourceContextSupport() {
    public const val FILE_NAME_FIELD_NAME: String = "file_name"

    public const val FILE_NAME_FIELD_NUMBER: Int = 1
  }
}
