package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.OneOfValue
import com.bybutter.sisyphus.protobuf.ProtoEnum
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ListValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableListValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableStruct
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.NullValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.StructSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.ValueSupport
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map

/**
 *  `NullValue` is a singleton enumeration to represent the null value for the
 *  `Value` type union.
 *
 *  The JSON representation for `NullValue` is JSON `null`.
 */
@ProtobufDefinition(".google.protobuf.NullValue")
public enum class NullValue(
  public override val number: Int,
  public override val proto: String,
) : ProtoEnum<NullValue> {
  /**
   *  Null value.
   */
  NULL_VALUE(0, "NULL_VALUE"),
  ;

  public override fun support(): EnumSupport<NullValue> = NullValue

  public companion object : NullValueSupport()
}

/**
 *  `Struct` represents a structured data value, consisting of fields
 *  which map to dynamically typed values. In some languages, `Struct`
 *  might be supported by a native representation. For example, in
 *  scripting languages like JS a struct is represented as an
 *  object. The details of that representation are described together
 *  with the proto support for the language.
 *
 *  The JSON representation for `Struct` is JSON object.
 */
@ProtobufDefinition(".google.protobuf.Struct")
public interface Struct : Message<Struct, MutableStruct> {
  /**
   *  Unordered map of dynamically typed values.
   */
  public val fields: Map<String, Value>

  public fun hasFields(): Boolean

  public companion object : StructSupport() {
    public const val FIELDS_FIELD_NAME: String = "fields"

    public const val FIELDS_FIELD_NUMBER: Int = 1
  }
}

/**
 *  `Value` represents a dynamically typed value which can be either
 *  null, a number, a string, a boolean, a recursive struct value, or a
 *  list of values. A producer of value is expected to set one of these
 *  variants. Absence of any variant indicates an error.
 *
 *  The JSON representation for `Value` is JSON value.
 */
@ProtobufDefinition(".google.protobuf.Value")
public interface Value : Message<Value, MutableValue> {
  /**
   *  Represents a null value.
   */
  public val nullValue: NullValue

  /**
   *  Represents a double value.
   */
  public val numberValue: Double

  /**
   *  Represents a string value.
   */
  public val stringValue: String

  /**
   *  Represents a boolean value.
   */
  public val boolValue: Boolean

  /**
   *  Represents a structured value.
   */
  public val structValue: Struct?

  /**
   *  Represents a repeated `Value`.
   */
  public val listValue: ListValue?

  public val kind: Kind<*>?

  public fun hasNullValue(): Boolean

  public fun hasNumberValue(): Boolean

  public fun hasStringValue(): Boolean

  public fun hasBoolValue(): Boolean

  public fun hasStructValue(): Boolean

  public fun hasListValue(): Boolean

  public companion object : ValueSupport() {
    public const val NULL_VALUE_FIELD_NAME: String = "null_value"

    public const val NULL_VALUE_FIELD_NUMBER: Int = 1

    public const val NUMBER_VALUE_FIELD_NAME: String = "number_value"

    public const val NUMBER_VALUE_FIELD_NUMBER: Int = 2

    public const val STRING_VALUE_FIELD_NAME: String = "string_value"

    public const val STRING_VALUE_FIELD_NUMBER: Int = 3

    public const val BOOL_VALUE_FIELD_NAME: String = "bool_value"

    public const val BOOL_VALUE_FIELD_NUMBER: Int = 4

    public const val STRUCT_VALUE_FIELD_NAME: String = "struct_value"

    public const val STRUCT_VALUE_FIELD_NUMBER: Int = 5

    public const val LIST_VALUE_FIELD_NAME: String = "list_value"

    public const val LIST_VALUE_FIELD_NUMBER: Int = 6
  }

  public sealed interface Kind<T> : OneOfValue<T> {
    public data class NullValue(
      public override val `value`: com.bybutter.sisyphus.protobuf.primitives.NullValue,
    ) : Kind<com.bybutter.sisyphus.protobuf.primitives.NullValue>

    public data class NumberValue(
      public override val `value`: Double,
    ) : Kind<Double>

    public data class StringValue(
      public override val `value`: String,
    ) : Kind<String>

    public data class BoolValue(
      public override val `value`: Boolean,
    ) : Kind<Boolean>

    public data class StructValue(
      public override val `value`: Struct,
    ) : Kind<Struct>

    public data class ListValue(
      public override val `value`: com.bybutter.sisyphus.protobuf.primitives.ListValue,
    ) : Kind<com.bybutter.sisyphus.protobuf.primitives.ListValue>
  }
}

/**
 *  `ListValue` is a wrapper around a repeated field of values.
 *
 *  The JSON representation for `ListValue` is JSON array.
 */
@ProtobufDefinition(".google.protobuf.ListValue")
public interface ListValue : Message<ListValue, MutableListValue> {
  /**
   *  Repeated field of dynamically typed values.
   */
  public val values: List<Value>

  public fun hasValues(): Boolean

  public companion object : ListValueSupport() {
    public const val VALUES_FIELD_NAME: String = "values"

    public const val VALUES_FIELD_NUMBER: Int = 1
  }
}
