package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.ProtoEnum
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FieldSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnum
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableEnumValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableField
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableOption
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableType
import com.bybutter.sisyphus.protobuf.primitives.`internal`.OptionSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.SyntaxSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.TypeSupport
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List

/**
 *  The syntax in which a protocol buffer element is defined.
 */
@ProtobufDefinition(".google.protobuf.Syntax")
public enum class Syntax(
  public override val number: Int,
  public override val proto: String,
) : ProtoEnum<Syntax> {
  /**
   *  Syntax `proto2`.
   */
  PROTO2(0, "SYNTAX_PROTO2"),
  /**
   *  Syntax `proto3`.
   */
  PROTO3(1, "SYNTAX_PROTO3"),
  /**
   *  Syntax `editions`.
   */
  EDITIONS(2, "SYNTAX_EDITIONS"),
  ;

  public override fun support(): EnumSupport<Syntax> = Syntax

  public companion object : SyntaxSupport()
}

/**
 *  A protocol buffer message type.
 */
@ProtobufDefinition(".google.protobuf.Type")
public interface Type : Message<Type, MutableType> {
  /**
   *  The fully qualified message name.
   */
  public val name: String

  /**
   *  The list of fields.
   */
  public val fields: List<Field>

  /**
   *  The list of types appearing in `oneof` definitions in this type.
   */
  public val oneofs: List<String>

  /**
   *  The protocol buffer options.
   */
  public val options: List<Option>

  /**
   *  The source context.
   */
  public val sourceContext: SourceContext?

  /**
   *  The source syntax.
   */
  public val syntax: Syntax

  /**
   *  The source edition string, only valid when syntax is SYNTAX_EDITIONS.
   */
  public val edition: String

  public fun hasName(): Boolean

  public fun hasFields(): Boolean

  public fun hasOneofs(): Boolean

  public fun hasOptions(): Boolean

  public fun hasSourceContext(): Boolean

  public fun hasSyntax(): Boolean

  public fun hasEdition(): Boolean

  public companion object : TypeSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val FIELDS_FIELD_NAME: String = "fields"

    public const val FIELDS_FIELD_NUMBER: Int = 2

    public const val ONEOFS_FIELD_NAME: String = "oneofs"

    public const val ONEOFS_FIELD_NUMBER: Int = 3

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 4

    public const val SOURCE_CONTEXT_FIELD_NAME: String = "source_context"

    public const val SOURCE_CONTEXT_FIELD_NUMBER: Int = 5

    public const val SYNTAX_FIELD_NAME: String = "syntax"

    public const val SYNTAX_FIELD_NUMBER: Int = 6

    public const val EDITION_FIELD_NAME: String = "edition"

    public const val EDITION_FIELD_NUMBER: Int = 7
  }
}

/**
 *  A single field of a message type.
 */
@ProtobufDefinition(".google.protobuf.Field")
public interface Field : Message<Field, MutableField> {
  /**
   *  The field type.
   */
  public val kind: Kind

  /**
   *  The field cardinality.
   */
  public val cardinality: Cardinality

  /**
   *  The field number.
   */
  public val number: Int

  /**
   *  The field name.
   */
  public val name: String

  /**
   *  The field type URL, without the scheme, for message or enumeration
   *  types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
   */
  public val typeUrl: String

  /**
   *  The index of the field type in `Type.oneofs`, for message or enumeration
   *  types. The first type has index 1; zero means the type is not in the list.
   */
  public val oneofIndex: Int

  /**
   *  Whether to use alternative packed wire representation.
   */
  public val packed: Boolean

  /**
   *  The protocol buffer options.
   */
  public val options: List<Option>

  /**
   *  The field JSON name.
   */
  public val jsonName: String

  /**
   *  The string value of the default value of this field. Proto2 syntax only.
   */
  public val defaultValue: String

  public fun hasKind(): Boolean

  public fun hasCardinality(): Boolean

  public fun hasNumber(): Boolean

  public fun hasName(): Boolean

  public fun hasTypeUrl(): Boolean

  public fun hasOneofIndex(): Boolean

  public fun hasPacked(): Boolean

  public fun hasOptions(): Boolean

  public fun hasJsonName(): Boolean

  public fun hasDefaultValue(): Boolean

  /**
   *  Basic field types.
   */
  @ProtobufDefinition(".google.protobuf.Field.Kind")
  public enum class Kind(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<Kind> {
    /**
     *  Field type unknown.
     */
    TYPE_UNKNOWN(0, "TYPE_UNKNOWN"),
    /**
     *  Field type double.
     */
    TYPE_DOUBLE(1, "TYPE_DOUBLE"),
    /**
     *  Field type float.
     */
    TYPE_FLOAT(2, "TYPE_FLOAT"),
    /**
     *  Field type int64.
     */
    TYPE_INT64(3, "TYPE_INT64"),
    /**
     *  Field type uint64.
     */
    TYPE_UINT64(4, "TYPE_UINT64"),
    /**
     *  Field type int32.
     */
    TYPE_INT32(5, "TYPE_INT32"),
    /**
     *  Field type fixed64.
     */
    TYPE_FIXED64(6, "TYPE_FIXED64"),
    /**
     *  Field type fixed32.
     */
    TYPE_FIXED32(7, "TYPE_FIXED32"),
    /**
     *  Field type bool.
     */
    TYPE_BOOL(8, "TYPE_BOOL"),
    /**
     *  Field type string.
     */
    TYPE_STRING(9, "TYPE_STRING"),
    /**
     *  Field type group. Proto2 syntax only, and deprecated.
     */
    TYPE_GROUP(10, "TYPE_GROUP"),
    /**
     *  Field type message.
     */
    TYPE_MESSAGE(11, "TYPE_MESSAGE"),
    /**
     *  Field type bytes.
     */
    TYPE_BYTES(12, "TYPE_BYTES"),
    /**
     *  Field type uint32.
     */
    TYPE_UINT32(13, "TYPE_UINT32"),
    /**
     *  Field type enum.
     */
    TYPE_ENUM(14, "TYPE_ENUM"),
    /**
     *  Field type sfixed32.
     */
    TYPE_SFIXED32(15, "TYPE_SFIXED32"),
    /**
     *  Field type sfixed64.
     */
    TYPE_SFIXED64(16, "TYPE_SFIXED64"),
    /**
     *  Field type sint32.
     */
    TYPE_SINT32(17, "TYPE_SINT32"),
    /**
     *  Field type sint64.
     */
    TYPE_SINT64(18, "TYPE_SINT64"),
    ;

    public override fun support(): EnumSupport<Kind> = Kind

    public companion object : FieldSupport.KindSupport()
  }

  /**
   *  Whether a field is optional, required, or repeated.
   */
  @ProtobufDefinition(".google.protobuf.Field.Cardinality")
  public enum class Cardinality(
    public override val number: Int,
    public override val proto: String,
  ) : ProtoEnum<Cardinality> {
    /**
     *  For fields with unknown cardinality.
     */
    UNKNOWN(0, "CARDINALITY_UNKNOWN"),
    /**
     *  For optional fields.
     */
    OPTIONAL(1, "CARDINALITY_OPTIONAL"),
    /**
     *  For required fields. Proto2 syntax only.
     */
    REQUIRED(2, "CARDINALITY_REQUIRED"),
    /**
     *  For repeated fields.
     */
    REPEATED(3, "CARDINALITY_REPEATED"),
    ;

    public override fun support(): EnumSupport<Cardinality> = Cardinality

    public companion object : FieldSupport.CardinalitySupport()
  }

  public companion object : FieldSupport() {
    public const val KIND_FIELD_NAME: String = "kind"

    public const val KIND_FIELD_NUMBER: Int = 1

    public const val CARDINALITY_FIELD_NAME: String = "cardinality"

    public const val CARDINALITY_FIELD_NUMBER: Int = 2

    public const val NUMBER_FIELD_NAME: String = "number"

    public const val NUMBER_FIELD_NUMBER: Int = 3

    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 4

    public const val TYPE_URL_FIELD_NAME: String = "type_url"

    public const val TYPE_URL_FIELD_NUMBER: Int = 6

    public const val ONEOF_INDEX_FIELD_NAME: String = "oneof_index"

    public const val ONEOF_INDEX_FIELD_NUMBER: Int = 7

    public const val PACKED_FIELD_NAME: String = "packed"

    public const val PACKED_FIELD_NUMBER: Int = 8

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 9

    public const val JSON_NAME_FIELD_NAME: String = "json_name"

    public const val JSON_NAME_FIELD_NUMBER: Int = 10

    public const val DEFAULT_VALUE_FIELD_NAME: String = "default_value"

    public const val DEFAULT_VALUE_FIELD_NUMBER: Int = 11
  }
}

/**
 *  Enum type definition.
 */
@ProtobufDefinition(".google.protobuf.Enum")
public interface Enum : Message<Enum, MutableEnum> {
  /**
   *  Enum type name.
   */
  public val name: String

  /**
   *  Enum value definitions.
   */
  public val enumvalue: List<EnumValue>

  /**
   *  Protocol buffer options.
   */
  public val options: List<Option>

  /**
   *  The source context.
   */
  public val sourceContext: SourceContext?

  /**
   *  The source syntax.
   */
  public val syntax: Syntax

  /**
   *  The source edition string, only valid when syntax is SYNTAX_EDITIONS.
   */
  public val edition: String

  public fun hasName(): Boolean

  public fun hasEnumvalue(): Boolean

  public fun hasOptions(): Boolean

  public fun hasSourceContext(): Boolean

  public fun hasSyntax(): Boolean

  public fun hasEdition(): Boolean

  public companion object : com.bybutter.sisyphus.protobuf.primitives.`internal`.EnumSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val ENUMVALUE_FIELD_NAME: String = "enumvalue"

    public const val ENUMVALUE_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3

    public const val SOURCE_CONTEXT_FIELD_NAME: String = "source_context"

    public const val SOURCE_CONTEXT_FIELD_NUMBER: Int = 4

    public const val SYNTAX_FIELD_NAME: String = "syntax"

    public const val SYNTAX_FIELD_NUMBER: Int = 5

    public const val EDITION_FIELD_NAME: String = "edition"

    public const val EDITION_FIELD_NUMBER: Int = 6
  }
}

/**
 *  Enum value definition.
 */
@ProtobufDefinition(".google.protobuf.EnumValue")
public interface EnumValue : Message<EnumValue, MutableEnumValue> {
  /**
   *  Enum value name.
   */
  public val name: String

  /**
   *  Enum value number.
   */
  public val number: Int

  /**
   *  Protocol buffer options.
   */
  public val options: List<Option>

  public fun hasName(): Boolean

  public fun hasNumber(): Boolean

  public fun hasOptions(): Boolean

  public companion object : EnumValueSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val NUMBER_FIELD_NAME: String = "number"

    public const val NUMBER_FIELD_NUMBER: Int = 2

    public const val OPTIONS_FIELD_NAME: String = "options"

    public const val OPTIONS_FIELD_NUMBER: Int = 3
  }
}

/**
 *  A protocol buffer option, which can be attached to a message, field,
 *  enumeration, etc.
 */
@ProtobufDefinition(".google.protobuf.Option")
public interface Option : Message<Option, MutableOption> {
  /**
   *  The option's name. For protobuf built-in options (options defined in
   *  descriptor.proto), this is the short name. For example, `"map_entry"`.
   *  For custom options, it should be the fully-qualified name. For example,
   *  `"google.api.http"`.
   */
  public val name: String

  /**
   *  The option's value packed in an Any message. If the value is a primitive,
   *  the corresponding wrapper type defined in google/protobuf/wrappers.proto
   *  should be used. If the value is an enum, it should be stored as an int32
   *  value using the google.protobuf.Int32Value type.
   */
  public val `value`: Message<*, *>?

  public fun hasName(): Boolean

  public fun hasValue(): Boolean

  public companion object : OptionSupport() {
    public const val NAME_FIELD_NAME: String = "name"

    public const val NAME_FIELD_NUMBER: Int = 1

    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 2
  }
}
