package com.bybutter.sisyphus.protobuf.primitives

import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.ProtobufDefinition
import com.bybutter.sisyphus.protobuf.primitives.`internal`.BoolValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.BytesValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.DoubleValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.FloatValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.Int32ValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.Int64ValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableBoolValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableBytesValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableDoubleValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableFloatValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableInt32Value
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableInt64Value
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableStringValue
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableUInt32Value
import com.bybutter.sisyphus.protobuf.primitives.`internal`.MutableUInt64Value
import com.bybutter.sisyphus.protobuf.primitives.`internal`.StringValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.UInt32ValueSupport
import com.bybutter.sisyphus.protobuf.primitives.`internal`.UInt64ValueSupport
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Double
import kotlin.Float
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.UInt
import kotlin.ULong

/**
 *  Wrapper message for `double`.
 *
 *  The JSON representation for `DoubleValue` is JSON number.
 */
@ProtobufDefinition(".google.protobuf.DoubleValue")
public interface DoubleValue : Message<DoubleValue, MutableDoubleValue> {
  /**
   *  The double value.
   */
  public val `value`: Double

  public fun hasValue(): Boolean

  public companion object : DoubleValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `float`.
 *
 *  The JSON representation for `FloatValue` is JSON number.
 */
@ProtobufDefinition(".google.protobuf.FloatValue")
public interface FloatValue : Message<FloatValue, MutableFloatValue> {
  /**
   *  The float value.
   */
  public val `value`: Float

  public fun hasValue(): Boolean

  public companion object : FloatValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `int64`.
 *
 *  The JSON representation for `Int64Value` is JSON string.
 */
@ProtobufDefinition(".google.protobuf.Int64Value")
public interface Int64Value : Message<Int64Value, MutableInt64Value> {
  /**
   *  The int64 value.
   */
  public val `value`: Long

  public fun hasValue(): Boolean

  public companion object : Int64ValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `uint64`.
 *
 *  The JSON representation for `UInt64Value` is JSON string.
 */
@ProtobufDefinition(".google.protobuf.UInt64Value")
public interface UInt64Value : Message<UInt64Value, MutableUInt64Value> {
  /**
   *  The uint64 value.
   */
  public val `value`: ULong

  public fun hasValue(): Boolean

  public companion object : UInt64ValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `int32`.
 *
 *  The JSON representation for `Int32Value` is JSON number.
 */
@ProtobufDefinition(".google.protobuf.Int32Value")
public interface Int32Value : Message<Int32Value, MutableInt32Value> {
  /**
   *  The int32 value.
   */
  public val `value`: Int

  public fun hasValue(): Boolean

  public companion object : Int32ValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `uint32`.
 *
 *  The JSON representation for `UInt32Value` is JSON number.
 */
@ProtobufDefinition(".google.protobuf.UInt32Value")
public interface UInt32Value : Message<UInt32Value, MutableUInt32Value> {
  /**
   *  The uint32 value.
   */
  public val `value`: UInt

  public fun hasValue(): Boolean

  public companion object : UInt32ValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `bool`.
 *
 *  The JSON representation for `BoolValue` is JSON `true` and `false`.
 */
@ProtobufDefinition(".google.protobuf.BoolValue")
public interface BoolValue : Message<BoolValue, MutableBoolValue> {
  /**
   *  The bool value.
   */
  public val `value`: Boolean

  public fun hasValue(): Boolean

  public companion object : BoolValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `string`.
 *
 *  The JSON representation for `StringValue` is JSON string.
 */
@ProtobufDefinition(".google.protobuf.StringValue")
public interface StringValue : Message<StringValue, MutableStringValue> {
  /**
   *  The string value.
   */
  public val `value`: String

  public fun hasValue(): Boolean

  public companion object : StringValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}

/**
 *  Wrapper message for `bytes`.
 *
 *  The JSON representation for `BytesValue` is JSON string.
 */
@ProtobufDefinition(".google.protobuf.BytesValue")
public interface BytesValue : Message<BytesValue, MutableBytesValue> {
  /**
   *  The bytes value.
   */
  public val `value`: ByteArray

  public fun hasValue(): Boolean

  public companion object : BytesValueSupport() {
    public const val VALUE_FIELD_NAME: String = "value"

    public const val VALUE_FIELD_NUMBER: Int = 1
  }
}
