package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.Any
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Array
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.lazy

public object AnyMetadata : FileSupport() {
  public override val name: String = "google/protobuf/any.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/any.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Any)
}

public interface MutableAny : MutableMessage<Any, MutableAny>, Any {
  public override var typeUrl: String

  public override var `value`: ByteArray

  public fun clearTypeUrl(): String?

  public fun clearValue(): ByteArray?
}

@InternalProtoApi
internal class AnyImpl : AbstractMutableMessage<Any, MutableAny>(), MutableAny {
  private var _hasTypeUrl: Boolean = false

  public override var typeUrl: String = ""
    get() = if(_hasTypeUrl) field else ""
    set(`value`) {
      field = value
      _hasTypeUrl = true
    }

  private var _hasValue: Boolean = false

  public override var `value`: ByteArray = byteArrayOf()
    get() = if(_hasValue) field else byteArrayOf()
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasTypeUrl(): Boolean = _hasTypeUrl

  public override fun clearTypeUrl(): String? {
    if (!hasTypeUrl()) return null
    return typeUrl.also {
      typeUrl = ""
      _hasTypeUrl = false
    }
  }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): ByteArray? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = byteArrayOf()
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<Any, MutableAny> = Any

  public override fun mergeWith(other: Any?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableAny = AnyImpl().apply {
    mergeWith(this@AnyImpl)
  }

  public override fun clear(): Unit {
    this.clearTypeUrl()
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): kotlin.Any? = when(fieldName) {
    "type_url", "typeUrl" -> this.clearTypeUrl()
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): kotlin.Any? = when(fieldNumber) {
    1 -> this.clearTypeUrl()
    2 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "type_url", "typeUrl" -> this.typeUrl.uncheckedCast()
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.typeUrl.uncheckedCast()
    2 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "type_url", "typeUrl" -> this.typeUrl = value.uncheckedCast()
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.typeUrl = value.uncheckedCast()
      2 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "type_url", "typeUrl" -> this.hasTypeUrl()
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasTypeUrl()
    2 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Any): Boolean {
    if (typeUrl != other.typeUrl) return false
    if (!`value`.contentEquals(other.`value`)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasTypeUrl()) {
      result = result * 37 + 1
      result = result * 31 + this.typeUrl.hashCode()
    }
    if (hasValue()) {
      result = result * 37 + 2
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasTypeUrl()) {
      writer.tag(10).string(this.typeUrl)
    }
    if (hasValue()) {
      writer.tag(18).bytes(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.typeUrl = reader.string()
      2 -> this.`value` = reader.bytes()
      else -> return false
    }
    return true
  }
}

public open class AnySupport internal constructor() : MessageSupport<Any, MutableAny>() {
  public override val name: String
    get() = ".google.protobuf.Any"

  public override val parent: FileSupport
    get() = AnyMetadata

  public override val descriptor: DescriptorProto by lazy {
    AnyMetadata.descriptor.messageType.first{ it.name == "Any" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableAny = AnyImpl()
}
