package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.collection.contentEquals
import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.Api
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.Method
import com.bybutter.sisyphus.protobuf.primitives.Mixin
import com.bybutter.sisyphus.protobuf.primitives.Option
import com.bybutter.sisyphus.protobuf.primitives.SourceContext
import com.bybutter.sisyphus.protobuf.primitives.Syntax
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.lazy

public object ApiMetadata : FileSupport() {
  public override val name: String = "google/protobuf/api.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/api.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Api, Method, Mixin)
}

public interface MutableApi : MutableMessage<Api, MutableApi>, Api {
  public override var name: String

  public override val methods: MutableList<Method>

  public override val options: MutableList<Option>

  public override var version: String

  public override var sourceContext: SourceContext?

  public override val mixins: MutableList<Mixin>

  public override var syntax: Syntax

  public fun clearName(): String?

  public fun clearMethods(): List<Method>

  public fun clearOptions(): List<Option>

  public fun clearVersion(): String?

  public fun clearSourceContext(): SourceContext?

  public fun clearMixins(): List<Mixin>

  public fun clearSyntax(): Syntax?
}

@InternalProtoApi
internal class ApiImpl : AbstractMutableMessage<Api, MutableApi>(), MutableApi {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val methods: MutableList<Method> = mutableListOf()

  public override val options: MutableList<Option> = mutableListOf()

  private var _hasVersion: Boolean = false

  public override var version: String = ""
    get() = if(_hasVersion) field else ""
    set(`value`) {
      field = value
      _hasVersion = true
    }

  public override var sourceContext: SourceContext? = null
    set(`value`) {
      field = value
    }

  public override val mixins: MutableList<Mixin> = mutableListOf()

  private var _hasSyntax: Boolean = false

  public override var syntax: Syntax = Syntax()
    get() = if(_hasSyntax) field else Syntax()
    set(`value`) {
      field = value
      _hasSyntax = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasMethods(): Boolean = methods.isNotEmpty()

  public override fun clearMethods(): List<Method> = methods.toList().also {
    methods.clear()
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun hasVersion(): Boolean = _hasVersion

  public override fun clearVersion(): String? {
    if (!hasVersion()) return null
    return version.also {
      version = ""
      _hasVersion = false
    }
  }

  public override fun hasSourceContext(): Boolean = sourceContext != null

  public override fun clearSourceContext(): SourceContext? {
    if (!hasSourceContext()) return null
    return sourceContext.also {
      sourceContext = null
    }
  }

  public override fun hasMixins(): Boolean = mixins.isNotEmpty()

  public override fun clearMixins(): List<Mixin> = mixins.toList().also {
    mixins.clear()
  }

  public override fun hasSyntax(): Boolean = _hasSyntax

  public override fun clearSyntax(): Syntax? {
    if (!hasSyntax()) return null
    return syntax.also {
      syntax = Syntax()
      _hasSyntax = false
    }
  }

  public override fun support(): MessageSupport<Api, MutableApi> = Api

  public override fun mergeWith(other: Api?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableApi = ApiImpl().apply {
    mergeWith(this@ApiImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearMethods()
    this.clearOptions()
    this.clearVersion()
    this.clearSourceContext()
    this.clearMixins()
    this.clearSyntax()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "methods" -> this.clearMethods()
    "options" -> this.clearOptions()
    "version" -> this.clearVersion()
    "source_context", "sourceContext" -> this.clearSourceContext()
    "mixins" -> this.clearMixins()
    "syntax" -> this.clearSyntax()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearMethods()
    3 -> this.clearOptions()
    4 -> this.clearVersion()
    5 -> this.clearSourceContext()
    6 -> this.clearMixins()
    7 -> this.clearSyntax()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "methods" -> this.methods.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "version" -> this.version.uncheckedCast()
    "source_context", "sourceContext" -> this.sourceContext.uncheckedCast()
    "mixins" -> this.mixins.uncheckedCast()
    "syntax" -> this.syntax.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.methods.uncheckedCast()
    3 -> this.options.uncheckedCast()
    4 -> this.version.uncheckedCast()
    5 -> this.sourceContext.uncheckedCast()
    6 -> this.mixins.uncheckedCast()
    7 -> this.syntax.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "methods" -> {
        this.methods.clear()
        this.methods.addAll(value.uncheckedCast())
      }
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      "version" -> this.version = value.uncheckedCast()
      "source_context", "sourceContext" -> this.sourceContext = value.uncheckedCast()
      "mixins" -> {
        this.mixins.clear()
        this.mixins.addAll(value.uncheckedCast())
      }
      "syntax" -> this.syntax = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.methods.clear()
        this.methods.addAll(value.uncheckedCast())
      }
      3 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      4 -> this.version = value.uncheckedCast()
      5 -> this.sourceContext = value.uncheckedCast()
      6 -> {
        this.mixins.clear()
        this.mixins.addAll(value.uncheckedCast())
      }
      7 -> this.syntax = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "methods" -> this.hasMethods()
    "options" -> this.hasOptions()
    "version" -> this.hasVersion()
    "source_context", "sourceContext" -> this.hasSourceContext()
    "mixins" -> this.hasMixins()
    "syntax" -> this.hasSyntax()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasMethods()
    3 -> this.hasOptions()
    4 -> this.hasVersion()
    5 -> this.hasSourceContext()
    6 -> this.hasMixins()
    7 -> this.hasSyntax()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Api): Boolean {
    if (name != other.name) return false
    if (!methods.contentEquals(other.methods)) return false
    if (!options.contentEquals(other.options)) return false
    if (version != other.version) return false
    if (sourceContext != other.sourceContext) return false
    if (!mixins.contentEquals(other.mixins)) return false
    if (syntax != other.syntax) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.methods) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    if (hasVersion()) {
      result = result * 37 + 4
      result = result * 31 + this.version.hashCode()
    }
    if (hasSourceContext()) {
      result = result * 37 + 5
      result = result * 31 + this.sourceContext!!.hashCode()
    }
    for (value in this.mixins) {
      result = result * 37 + 6
      result = result * 31 + value.hashCode()
    }
    if (hasSyntax()) {
      result = result * 37 + 7
      result = result * 31 + this.syntax.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.methods.forEach { writer.tag(18).message(it) }
    this.options.forEach { writer.tag(26).message(it) }
    if (hasVersion()) {
      writer.tag(34).string(this.version)
    }
    if (hasSourceContext()) {
      writer.tag(42).message(this.sourceContext)
    }
    this.mixins.forEach { writer.tag(50).message(it) }
    if (hasSyntax()) {
      writer.tag(56).enum(this.syntax)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.methods += Method.newMutable().apply { readFrom(reader) }
      3 -> this.options += Option.newMutable().apply { readFrom(reader) }
      4 -> this.version = reader.string()
      5 -> this.sourceContext = SourceContext.newMutable().apply { readFrom(reader) }
      6 -> this.mixins += Mixin.newMutable().apply { readFrom(reader) }
      7 -> this.syntax = Syntax(reader.int32())
      else -> return false
    }
    return true
  }
}

public open class ApiSupport internal constructor() : MessageSupport<Api, MutableApi>() {
  public override val name: String
    get() = ".google.protobuf.Api"

  public override val parent: FileSupport
    get() = ApiMetadata

  public override val descriptor: DescriptorProto by lazy {
    ApiMetadata.descriptor.messageType.first{ it.name == "Api" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableApi = ApiImpl()
}

public interface MutableMethod : MutableMessage<Method, MutableMethod>, Method {
  public override var name: String

  public override var requestTypeUrl: String

  public override var requestStreaming: Boolean

  public override var responseTypeUrl: String

  public override var responseStreaming: Boolean

  public override val options: MutableList<Option>

  public override var syntax: Syntax

  public fun clearName(): String?

  public fun clearRequestTypeUrl(): String?

  public fun clearRequestStreaming(): Boolean?

  public fun clearResponseTypeUrl(): String?

  public fun clearResponseStreaming(): Boolean?

  public fun clearOptions(): List<Option>

  public fun clearSyntax(): Syntax?
}

@InternalProtoApi
internal class MethodImpl : AbstractMutableMessage<Method, MutableMethod>(), MutableMethod {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasRequestTypeUrl: Boolean = false

  public override var requestTypeUrl: String = ""
    get() = if(_hasRequestTypeUrl) field else ""
    set(`value`) {
      field = value
      _hasRequestTypeUrl = true
    }

  private var _hasRequestStreaming: Boolean = false

  public override var requestStreaming: Boolean = false
    get() = if(_hasRequestStreaming) field else false
    set(`value`) {
      field = value
      _hasRequestStreaming = true
    }

  private var _hasResponseTypeUrl: Boolean = false

  public override var responseTypeUrl: String = ""
    get() = if(_hasResponseTypeUrl) field else ""
    set(`value`) {
      field = value
      _hasResponseTypeUrl = true
    }

  private var _hasResponseStreaming: Boolean = false

  public override var responseStreaming: Boolean = false
    get() = if(_hasResponseStreaming) field else false
    set(`value`) {
      field = value
      _hasResponseStreaming = true
    }

  public override val options: MutableList<Option> = mutableListOf()

  private var _hasSyntax: Boolean = false

  public override var syntax: Syntax = Syntax()
    get() = if(_hasSyntax) field else Syntax()
    set(`value`) {
      field = value
      _hasSyntax = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasRequestTypeUrl(): Boolean = _hasRequestTypeUrl

  public override fun clearRequestTypeUrl(): String? {
    if (!hasRequestTypeUrl()) return null
    return requestTypeUrl.also {
      requestTypeUrl = ""
      _hasRequestTypeUrl = false
    }
  }

  public override fun hasRequestStreaming(): Boolean = _hasRequestStreaming

  public override fun clearRequestStreaming(): Boolean? {
    if (!hasRequestStreaming()) return null
    return requestStreaming.also {
      requestStreaming = false
      _hasRequestStreaming = false
    }
  }

  public override fun hasResponseTypeUrl(): Boolean = _hasResponseTypeUrl

  public override fun clearResponseTypeUrl(): String? {
    if (!hasResponseTypeUrl()) return null
    return responseTypeUrl.also {
      responseTypeUrl = ""
      _hasResponseTypeUrl = false
    }
  }

  public override fun hasResponseStreaming(): Boolean = _hasResponseStreaming

  public override fun clearResponseStreaming(): Boolean? {
    if (!hasResponseStreaming()) return null
    return responseStreaming.also {
      responseStreaming = false
      _hasResponseStreaming = false
    }
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun hasSyntax(): Boolean = _hasSyntax

  public override fun clearSyntax(): Syntax? {
    if (!hasSyntax()) return null
    return syntax.also {
      syntax = Syntax()
      _hasSyntax = false
    }
  }

  public override fun support(): MessageSupport<Method, MutableMethod> = Method

  public override fun mergeWith(other: Method?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableMethod = MethodImpl().apply {
    mergeWith(this@MethodImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearRequestTypeUrl()
    this.clearRequestStreaming()
    this.clearResponseTypeUrl()
    this.clearResponseStreaming()
    this.clearOptions()
    this.clearSyntax()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "request_type_url", "requestTypeUrl" -> this.clearRequestTypeUrl()
    "request_streaming", "requestStreaming" -> this.clearRequestStreaming()
    "response_type_url", "responseTypeUrl" -> this.clearResponseTypeUrl()
    "response_streaming", "responseStreaming" -> this.clearResponseStreaming()
    "options" -> this.clearOptions()
    "syntax" -> this.clearSyntax()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearRequestTypeUrl()
    3 -> this.clearRequestStreaming()
    4 -> this.clearResponseTypeUrl()
    5 -> this.clearResponseStreaming()
    6 -> this.clearOptions()
    7 -> this.clearSyntax()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "request_type_url", "requestTypeUrl" -> this.requestTypeUrl.uncheckedCast()
    "request_streaming", "requestStreaming" -> this.requestStreaming.uncheckedCast()
    "response_type_url", "responseTypeUrl" -> this.responseTypeUrl.uncheckedCast()
    "response_streaming", "responseStreaming" -> this.responseStreaming.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "syntax" -> this.syntax.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.requestTypeUrl.uncheckedCast()
    3 -> this.requestStreaming.uncheckedCast()
    4 -> this.responseTypeUrl.uncheckedCast()
    5 -> this.responseStreaming.uncheckedCast()
    6 -> this.options.uncheckedCast()
    7 -> this.syntax.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "request_type_url", "requestTypeUrl" -> this.requestTypeUrl = value.uncheckedCast()
      "request_streaming", "requestStreaming" -> this.requestStreaming = value.uncheckedCast()
      "response_type_url", "responseTypeUrl" -> this.responseTypeUrl = value.uncheckedCast()
      "response_streaming", "responseStreaming" -> this.responseStreaming = value.uncheckedCast()
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      "syntax" -> this.syntax = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.requestTypeUrl = value.uncheckedCast()
      3 -> this.requestStreaming = value.uncheckedCast()
      4 -> this.responseTypeUrl = value.uncheckedCast()
      5 -> this.responseStreaming = value.uncheckedCast()
      6 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      7 -> this.syntax = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "request_type_url", "requestTypeUrl" -> this.hasRequestTypeUrl()
    "request_streaming", "requestStreaming" -> this.hasRequestStreaming()
    "response_type_url", "responseTypeUrl" -> this.hasResponseTypeUrl()
    "response_streaming", "responseStreaming" -> this.hasResponseStreaming()
    "options" -> this.hasOptions()
    "syntax" -> this.hasSyntax()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasRequestTypeUrl()
    3 -> this.hasRequestStreaming()
    4 -> this.hasResponseTypeUrl()
    5 -> this.hasResponseStreaming()
    6 -> this.hasOptions()
    7 -> this.hasSyntax()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Method): Boolean {
    if (name != other.name) return false
    if (requestTypeUrl != other.requestTypeUrl) return false
    if (requestStreaming != other.requestStreaming) return false
    if (responseTypeUrl != other.responseTypeUrl) return false
    if (responseStreaming != other.responseStreaming) return false
    if (!options.contentEquals(other.options)) return false
    if (syntax != other.syntax) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasRequestTypeUrl()) {
      result = result * 37 + 2
      result = result * 31 + this.requestTypeUrl.hashCode()
    }
    if (hasRequestStreaming()) {
      result = result * 37 + 3
      result = result * 31 + this.requestStreaming.hashCode()
    }
    if (hasResponseTypeUrl()) {
      result = result * 37 + 4
      result = result * 31 + this.responseTypeUrl.hashCode()
    }
    if (hasResponseStreaming()) {
      result = result * 37 + 5
      result = result * 31 + this.responseStreaming.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 6
      result = result * 31 + value.hashCode()
    }
    if (hasSyntax()) {
      result = result * 37 + 7
      result = result * 31 + this.syntax.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasRequestTypeUrl()) {
      writer.tag(18).string(this.requestTypeUrl)
    }
    if (hasRequestStreaming()) {
      writer.tag(24).bool(this.requestStreaming)
    }
    if (hasResponseTypeUrl()) {
      writer.tag(34).string(this.responseTypeUrl)
    }
    if (hasResponseStreaming()) {
      writer.tag(40).bool(this.responseStreaming)
    }
    this.options.forEach { writer.tag(50).message(it) }
    if (hasSyntax()) {
      writer.tag(56).enum(this.syntax)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.requestTypeUrl = reader.string()
      3 -> this.requestStreaming = reader.bool()
      4 -> this.responseTypeUrl = reader.string()
      5 -> this.responseStreaming = reader.bool()
      6 -> this.options += Option.newMutable().apply { readFrom(reader) }
      7 -> this.syntax = Syntax(reader.int32())
      else -> return false
    }
    return true
  }
}

public open class MethodSupport internal constructor() : MessageSupport<Method, MutableMethod>() {
  public override val name: String
    get() = ".google.protobuf.Method"

  public override val parent: FileSupport
    get() = ApiMetadata

  public override val descriptor: DescriptorProto by lazy {
    ApiMetadata.descriptor.messageType.first{ it.name == "Method" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableMethod = MethodImpl()
}

public interface MutableMixin : MutableMessage<Mixin, MutableMixin>, Mixin {
  public override var name: String

  public override var root: String

  public fun clearName(): String?

  public fun clearRoot(): String?
}

@InternalProtoApi
internal class MixinImpl : AbstractMutableMessage<Mixin, MutableMixin>(), MutableMixin {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasRoot: Boolean = false

  public override var root: String = ""
    get() = if(_hasRoot) field else ""
    set(`value`) {
      field = value
      _hasRoot = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasRoot(): Boolean = _hasRoot

  public override fun clearRoot(): String? {
    if (!hasRoot()) return null
    return root.also {
      root = ""
      _hasRoot = false
    }
  }

  public override fun support(): MessageSupport<Mixin, MutableMixin> = Mixin

  public override fun mergeWith(other: Mixin?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableMixin = MixinImpl().apply {
    mergeWith(this@MixinImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearRoot()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "root" -> this.clearRoot()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearRoot()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "root" -> this.root.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.root.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "root" -> this.root = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.root = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "root" -> this.hasRoot()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasRoot()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Mixin): Boolean {
    if (name != other.name) return false
    if (root != other.root) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasRoot()) {
      result = result * 37 + 2
      result = result * 31 + this.root.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasRoot()) {
      writer.tag(18).string(this.root)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.root = reader.string()
      else -> return false
    }
    return true
  }
}

public open class MixinSupport internal constructor() : MessageSupport<Mixin, MutableMixin>() {
  public override val name: String
    get() = ".google.protobuf.Mixin"

  public override val parent: FileSupport
    get() = ApiMetadata

  public override val descriptor: DescriptorProto by lazy {
    ApiMetadata.descriptor.messageType.first{ it.name == "Mixin" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableMixin = MixinImpl()
}
