package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.collection.contentEquals
import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.EnumDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.EnumOptions
import com.bybutter.sisyphus.protobuf.primitives.EnumValueDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.EnumValueOptions
import com.bybutter.sisyphus.protobuf.primitives.ExtensionRangeOptions
import com.bybutter.sisyphus.protobuf.primitives.FeatureSet
import com.bybutter.sisyphus.protobuf.primitives.FieldDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FieldOptions
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorSet
import com.bybutter.sisyphus.protobuf.primitives.FileOptions
import com.bybutter.sisyphus.protobuf.primitives.GeneratedCodeInfo
import com.bybutter.sisyphus.protobuf.primitives.MessageOptions
import com.bybutter.sisyphus.protobuf.primitives.MethodDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.MethodOptions
import com.bybutter.sisyphus.protobuf.primitives.OneofDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.OneofOptions
import com.bybutter.sisyphus.protobuf.primitives.ServiceDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.ServiceOptions
import com.bybutter.sisyphus.protobuf.primitives.SourceCodeInfo
import com.bybutter.sisyphus.protobuf.primitives.UninterpretedOption
import com.bybutter.sisyphus.reflect.uncheckedCast
import java.lang.IllegalArgumentException
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.ULong
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.lazy

public object DescriptorMetadata : FileSupport() {
  public override val name: String = "google/protobuf/descriptor.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/descriptor.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FileDescriptorSet,
      FileDescriptorProto, DescriptorProto, ExtensionRangeOptions, FieldDescriptorProto,
      OneofDescriptorProto, EnumDescriptorProto, EnumValueDescriptorProto, ServiceDescriptorProto,
      MethodDescriptorProto, FileOptions, MessageOptions, FieldOptions, OneofOptions, EnumOptions,
      EnumValueOptions, ServiceOptions, MethodOptions, UninterpretedOption, FeatureSet,
      SourceCodeInfo, GeneratedCodeInfo)
}

public interface MutableFileDescriptorSet :
    MutableMessage<FileDescriptorSet, MutableFileDescriptorSet>, FileDescriptorSet {
  public override val `file`: MutableList<FileDescriptorProto>

  public fun clearFile(): List<FileDescriptorProto>
}

@InternalProtoApi
internal class FileDescriptorSetImpl :
    AbstractMutableMessage<FileDescriptorSet, MutableFileDescriptorSet>(), MutableFileDescriptorSet
    {
  public override val `file`: MutableList<FileDescriptorProto> = mutableListOf()

  public override fun hasFile(): Boolean = `file`.isNotEmpty()

  public override fun clearFile(): List<FileDescriptorProto> = `file`.toList().also {
    `file`.clear()
  }

  public override fun support(): MessageSupport<FileDescriptorSet, MutableFileDescriptorSet> =
      FileDescriptorSet

  public override fun mergeWith(other: FileDescriptorSet?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFileDescriptorSet = FileDescriptorSetImpl().apply {
    mergeWith(this@FileDescriptorSetImpl)
  }

  public override fun clear(): Unit {
    this.clearFile()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "file" -> this.clearFile()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearFile()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "file" -> this.`file`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`file`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "file" -> {
        this.`file`.clear()
        this.`file`.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.`file`.clear()
        this.`file`.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "file" -> this.hasFile()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasFile()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FileDescriptorSet): Boolean {
    if (!`file`.contentEquals(other.`file`)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.`file`) {
      result = result * 37 + 1
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.`file`.forEach { writer.tag(10).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`file` += FileDescriptorProto.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class FileDescriptorSetSupport internal constructor() :
    MessageSupport<FileDescriptorSet, MutableFileDescriptorSet>() {
  public override val name: String
    get() = ".google.protobuf.FileDescriptorSet"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FileDescriptorSet" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFileDescriptorSet = FileDescriptorSetImpl()
}

public interface MutableFileDescriptorProto :
    MutableMessage<FileDescriptorProto, MutableFileDescriptorProto>, FileDescriptorProto {
  public override var name: String

  public override var `package`: String

  public override val dependency: MutableList<String>

  public override val publicDependency: MutableList<Int>

  public override val weakDependency: MutableList<Int>

  public override val messageType: MutableList<DescriptorProto>

  public override val enumType: MutableList<EnumDescriptorProto>

  public override val service: MutableList<ServiceDescriptorProto>

  public override val extension: MutableList<FieldDescriptorProto>

  public override var options: FileOptions?

  public override var sourceCodeInfo: SourceCodeInfo?

  public override var syntax: String

  public override var edition: String

  public fun clearName(): String?

  public fun clearPackage(): String?

  public fun clearDependency(): List<String>

  public fun clearPublicDependency(): List<Int>

  public fun clearWeakDependency(): List<Int>

  public fun clearMessageType(): List<DescriptorProto>

  public fun clearEnumType(): List<EnumDescriptorProto>

  public fun clearService(): List<ServiceDescriptorProto>

  public fun clearExtension(): List<FieldDescriptorProto>

  public fun clearOptions(): FileOptions?

  public fun clearSourceCodeInfo(): SourceCodeInfo?

  public fun clearSyntax(): String?

  public fun clearEdition(): String?
}

@InternalProtoApi
internal class FileDescriptorProtoImpl :
    AbstractMutableMessage<FileDescriptorProto, MutableFileDescriptorProto>(),
    MutableFileDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasPackage: Boolean = false

  public override var `package`: String = ""
    get() = if(_hasPackage) field else ""
    set(`value`) {
      field = value
      _hasPackage = true
    }

  public override val dependency: MutableList<String> = mutableListOf()

  public override val publicDependency: MutableList<Int> = mutableListOf()

  public override val weakDependency: MutableList<Int> = mutableListOf()

  public override val messageType: MutableList<DescriptorProto> = mutableListOf()

  public override val enumType: MutableList<EnumDescriptorProto> = mutableListOf()

  public override val service: MutableList<ServiceDescriptorProto> = mutableListOf()

  public override val extension: MutableList<FieldDescriptorProto> = mutableListOf()

  public override var options: FileOptions? = null
    set(`value`) {
      field = value
    }

  public override var sourceCodeInfo: SourceCodeInfo? = null
    set(`value`) {
      field = value
    }

  private var _hasSyntax: Boolean = false

  public override var syntax: String = ""
    get() = if(_hasSyntax) field else ""
    set(`value`) {
      field = value
      _hasSyntax = true
    }

  private var _hasEdition: Boolean = false

  public override var edition: String = ""
    get() = if(_hasEdition) field else ""
    set(`value`) {
      field = value
      _hasEdition = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasPackage(): Boolean = _hasPackage

  public override fun clearPackage(): String? {
    if (!hasPackage()) return null
    return `package`.also {
      `package` = ""
      _hasPackage = false
    }
  }

  public override fun hasDependency(): Boolean = dependency.isNotEmpty()

  public override fun clearDependency(): List<String> = dependency.toList().also {
    dependency.clear()
  }

  public override fun hasPublicDependency(): Boolean = publicDependency.isNotEmpty()

  public override fun clearPublicDependency(): List<Int> = publicDependency.toList().also {
    publicDependency.clear()
  }

  public override fun hasWeakDependency(): Boolean = weakDependency.isNotEmpty()

  public override fun clearWeakDependency(): List<Int> = weakDependency.toList().also {
    weakDependency.clear()
  }

  public override fun hasMessageType(): Boolean = messageType.isNotEmpty()

  public override fun clearMessageType(): List<DescriptorProto> = messageType.toList().also {
    messageType.clear()
  }

  public override fun hasEnumType(): Boolean = enumType.isNotEmpty()

  public override fun clearEnumType(): List<EnumDescriptorProto> = enumType.toList().also {
    enumType.clear()
  }

  public override fun hasService(): Boolean = service.isNotEmpty()

  public override fun clearService(): List<ServiceDescriptorProto> = service.toList().also {
    service.clear()
  }

  public override fun hasExtension(): Boolean = extension.isNotEmpty()

  public override fun clearExtension(): List<FieldDescriptorProto> = extension.toList().also {
    extension.clear()
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): FileOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun hasSourceCodeInfo(): Boolean = sourceCodeInfo != null

  public override fun clearSourceCodeInfo(): SourceCodeInfo? {
    if (!hasSourceCodeInfo()) return null
    return sourceCodeInfo.also {
      sourceCodeInfo = null
    }
  }

  public override fun hasSyntax(): Boolean = _hasSyntax

  public override fun clearSyntax(): String? {
    if (!hasSyntax()) return null
    return syntax.also {
      syntax = ""
      _hasSyntax = false
    }
  }

  public override fun hasEdition(): Boolean = _hasEdition

  public override fun clearEdition(): String? {
    if (!hasEdition()) return null
    return edition.also {
      edition = ""
      _hasEdition = false
    }
  }

  public override fun support(): MessageSupport<FileDescriptorProto, MutableFileDescriptorProto> =
      FileDescriptorProto

  public override fun mergeWith(other: FileDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFileDescriptorProto = FileDescriptorProtoImpl().apply {
    mergeWith(this@FileDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearPackage()
    this.clearDependency()
    this.clearPublicDependency()
    this.clearWeakDependency()
    this.clearMessageType()
    this.clearEnumType()
    this.clearService()
    this.clearExtension()
    this.clearOptions()
    this.clearSourceCodeInfo()
    this.clearSyntax()
    this.clearEdition()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "package" -> this.clearPackage()
    "dependency" -> this.clearDependency()
    "public_dependency", "publicDependency" -> this.clearPublicDependency()
    "weak_dependency", "weakDependency" -> this.clearWeakDependency()
    "message_type", "messageType" -> this.clearMessageType()
    "enum_type", "enumType" -> this.clearEnumType()
    "service" -> this.clearService()
    "extension" -> this.clearExtension()
    "options" -> this.clearOptions()
    "source_code_info", "sourceCodeInfo" -> this.clearSourceCodeInfo()
    "syntax" -> this.clearSyntax()
    "edition" -> this.clearEdition()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearPackage()
    3 -> this.clearDependency()
    10 -> this.clearPublicDependency()
    11 -> this.clearWeakDependency()
    4 -> this.clearMessageType()
    5 -> this.clearEnumType()
    6 -> this.clearService()
    7 -> this.clearExtension()
    8 -> this.clearOptions()
    9 -> this.clearSourceCodeInfo()
    12 -> this.clearSyntax()
    13 -> this.clearEdition()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "package" -> this.`package`.uncheckedCast()
    "dependency" -> this.dependency.uncheckedCast()
    "public_dependency", "publicDependency" -> this.publicDependency.uncheckedCast()
    "weak_dependency", "weakDependency" -> this.weakDependency.uncheckedCast()
    "message_type", "messageType" -> this.messageType.uncheckedCast()
    "enum_type", "enumType" -> this.enumType.uncheckedCast()
    "service" -> this.service.uncheckedCast()
    "extension" -> this.extension.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "source_code_info", "sourceCodeInfo" -> this.sourceCodeInfo.uncheckedCast()
    "syntax" -> this.syntax.uncheckedCast()
    "edition" -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.`package`.uncheckedCast()
    3 -> this.dependency.uncheckedCast()
    10 -> this.publicDependency.uncheckedCast()
    11 -> this.weakDependency.uncheckedCast()
    4 -> this.messageType.uncheckedCast()
    5 -> this.enumType.uncheckedCast()
    6 -> this.service.uncheckedCast()
    7 -> this.extension.uncheckedCast()
    8 -> this.options.uncheckedCast()
    9 -> this.sourceCodeInfo.uncheckedCast()
    12 -> this.syntax.uncheckedCast()
    13 -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "package" -> this.`package` = value.uncheckedCast()
      "dependency" -> {
        this.dependency.clear()
        this.dependency.addAll(value.uncheckedCast())
      }
      "public_dependency", "publicDependency" -> {
        this.publicDependency.clear()
        this.publicDependency.addAll(value.uncheckedCast())
      }
      "weak_dependency", "weakDependency" -> {
        this.weakDependency.clear()
        this.weakDependency.addAll(value.uncheckedCast())
      }
      "message_type", "messageType" -> {
        this.messageType.clear()
        this.messageType.addAll(value.uncheckedCast())
      }
      "enum_type", "enumType" -> {
        this.enumType.clear()
        this.enumType.addAll(value.uncheckedCast())
      }
      "service" -> {
        this.service.clear()
        this.service.addAll(value.uncheckedCast())
      }
      "extension" -> {
        this.extension.clear()
        this.extension.addAll(value.uncheckedCast())
      }
      "options" -> this.options = value.uncheckedCast()
      "source_code_info", "sourceCodeInfo" -> this.sourceCodeInfo = value.uncheckedCast()
      "syntax" -> this.syntax = value.uncheckedCast()
      "edition" -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.`package` = value.uncheckedCast()
      3 -> {
        this.dependency.clear()
        this.dependency.addAll(value.uncheckedCast())
      }
      10 -> {
        this.publicDependency.clear()
        this.publicDependency.addAll(value.uncheckedCast())
      }
      11 -> {
        this.weakDependency.clear()
        this.weakDependency.addAll(value.uncheckedCast())
      }
      4 -> {
        this.messageType.clear()
        this.messageType.addAll(value.uncheckedCast())
      }
      5 -> {
        this.enumType.clear()
        this.enumType.addAll(value.uncheckedCast())
      }
      6 -> {
        this.service.clear()
        this.service.addAll(value.uncheckedCast())
      }
      7 -> {
        this.extension.clear()
        this.extension.addAll(value.uncheckedCast())
      }
      8 -> this.options = value.uncheckedCast()
      9 -> this.sourceCodeInfo = value.uncheckedCast()
      12 -> this.syntax = value.uncheckedCast()
      13 -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "package" -> this.hasPackage()
    "dependency" -> this.hasDependency()
    "public_dependency", "publicDependency" -> this.hasPublicDependency()
    "weak_dependency", "weakDependency" -> this.hasWeakDependency()
    "message_type", "messageType" -> this.hasMessageType()
    "enum_type", "enumType" -> this.hasEnumType()
    "service" -> this.hasService()
    "extension" -> this.hasExtension()
    "options" -> this.hasOptions()
    "source_code_info", "sourceCodeInfo" -> this.hasSourceCodeInfo()
    "syntax" -> this.hasSyntax()
    "edition" -> this.hasEdition()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasPackage()
    3 -> this.hasDependency()
    10 -> this.hasPublicDependency()
    11 -> this.hasWeakDependency()
    4 -> this.hasMessageType()
    5 -> this.hasEnumType()
    6 -> this.hasService()
    7 -> this.hasExtension()
    8 -> this.hasOptions()
    9 -> this.hasSourceCodeInfo()
    12 -> this.hasSyntax()
    13 -> this.hasEdition()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FileDescriptorProto): Boolean {
    if (name != other.name) return false
    if (`package` != other.`package`) return false
    if (!dependency.contentEquals(other.dependency)) return false
    if (!publicDependency.contentEquals(other.publicDependency)) return false
    if (!weakDependency.contentEquals(other.weakDependency)) return false
    if (!messageType.contentEquals(other.messageType)) return false
    if (!enumType.contentEquals(other.enumType)) return false
    if (!service.contentEquals(other.service)) return false
    if (!extension.contentEquals(other.extension)) return false
    if (options != other.options) return false
    if (sourceCodeInfo != other.sourceCodeInfo) return false
    if (syntax != other.syntax) return false
    if (edition != other.edition) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasPackage()) {
      result = result * 37 + 2
      result = result * 31 + this.`package`.hashCode()
    }
    for (value in this.dependency) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    for (value in this.publicDependency) {
      result = result * 37 + 10
      result = result * 31 + value.hashCode()
    }
    for (value in this.weakDependency) {
      result = result * 37 + 11
      result = result * 31 + value.hashCode()
    }
    for (value in this.messageType) {
      result = result * 37 + 4
      result = result * 31 + value.hashCode()
    }
    for (value in this.enumType) {
      result = result * 37 + 5
      result = result * 31 + value.hashCode()
    }
    for (value in this.service) {
      result = result * 37 + 6
      result = result * 31 + value.hashCode()
    }
    for (value in this.extension) {
      result = result * 37 + 7
      result = result * 31 + value.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 8
      result = result * 31 + this.options!!.hashCode()
    }
    if (hasSourceCodeInfo()) {
      result = result * 37 + 9
      result = result * 31 + this.sourceCodeInfo!!.hashCode()
    }
    if (hasSyntax()) {
      result = result * 37 + 12
      result = result * 31 + this.syntax.hashCode()
    }
    if (hasEdition()) {
      result = result * 37 + 13
      result = result * 31 + this.edition.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasPackage()) {
      writer.tag(18).string(this.`package`)
    }
    this.dependency.forEach { writer.tag(26).string(it) }
    writer.tag(82).beginLd().apply{ this@FileDescriptorProtoImpl.publicDependency.forEach {
        int32(it) } }.endLd()
    writer.tag(90).beginLd().apply{ this@FileDescriptorProtoImpl.weakDependency.forEach { int32(it)
        } }.endLd()
    this.messageType.forEach { writer.tag(34).message(it) }
    this.enumType.forEach { writer.tag(42).message(it) }
    this.service.forEach { writer.tag(50).message(it) }
    this.extension.forEach { writer.tag(58).message(it) }
    if (hasOptions()) {
      writer.tag(66).message(this.options)
    }
    if (hasSourceCodeInfo()) {
      writer.tag(74).message(this.sourceCodeInfo)
    }
    if (hasSyntax()) {
      writer.tag(98).string(this.syntax)
    }
    if (hasEdition()) {
      writer.tag(106).string(this.edition)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.`package` = reader.string()
      3 -> this.dependency += reader.string()
      10 -> reader.packed(wire) { this.publicDependency += it.int32() }
      11 -> reader.packed(wire) { this.weakDependency += it.int32() }
      4 -> this.messageType += DescriptorProto.newMutable().apply { readFrom(reader) }
      5 -> this.enumType += EnumDescriptorProto.newMutable().apply { readFrom(reader) }
      6 -> this.service += ServiceDescriptorProto.newMutable().apply { readFrom(reader) }
      7 -> this.extension += FieldDescriptorProto.newMutable().apply { readFrom(reader) }
      8 -> this.options = FileOptions.newMutable().apply { readFrom(reader) }
      9 -> this.sourceCodeInfo = SourceCodeInfo.newMutable().apply { readFrom(reader) }
      12 -> this.syntax = reader.string()
      13 -> this.edition = reader.string()
      else -> return false
    }
    return true
  }
}

public open class FileDescriptorProtoSupport internal constructor() :
    MessageSupport<FileDescriptorProto, MutableFileDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.FileDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FileDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFileDescriptorProto = FileDescriptorProtoImpl()
}

public interface MutableDescriptorProto : MutableMessage<DescriptorProto, MutableDescriptorProto>,
    DescriptorProto {
  public override var name: String

  public override val `field`: MutableList<FieldDescriptorProto>

  public override val extension: MutableList<FieldDescriptorProto>

  public override val nestedType: MutableList<DescriptorProto>

  public override val enumType: MutableList<EnumDescriptorProto>

  public override val extensionRange: MutableList<DescriptorProto.ExtensionRange>

  public override val oneofDecl: MutableList<OneofDescriptorProto>

  public override var options: MessageOptions?

  public override val reservedRange: MutableList<DescriptorProto.ReservedRange>

  public override val reservedName: MutableList<String>

  public fun clearName(): String?

  public fun clearField(): List<FieldDescriptorProto>

  public fun clearExtension(): List<FieldDescriptorProto>

  public fun clearNestedType(): List<DescriptorProto>

  public fun clearEnumType(): List<EnumDescriptorProto>

  public fun clearExtensionRange(): List<DescriptorProto.ExtensionRange>

  public fun clearOneofDecl(): List<OneofDescriptorProto>

  public fun clearOptions(): MessageOptions?

  public fun clearReservedRange(): List<DescriptorProto.ReservedRange>

  public fun clearReservedName(): List<String>

  public interface MutableExtensionRange :
      MutableMessage<DescriptorProto.ExtensionRange, MutableExtensionRange>,
      DescriptorProto.ExtensionRange {
    public override var start: Int

    public override var end: Int

    public override var options: ExtensionRangeOptions?

    public fun clearStart(): Int?

    public fun clearEnd(): Int?

    public fun clearOptions(): ExtensionRangeOptions?
  }

  public interface MutableReservedRange :
      MutableMessage<DescriptorProto.ReservedRange, MutableReservedRange>,
      DescriptorProto.ReservedRange {
    public override var start: Int

    public override var end: Int

    public fun clearStart(): Int?

    public fun clearEnd(): Int?
  }
}

@InternalProtoApi
internal class DescriptorProtoImpl :
    AbstractMutableMessage<DescriptorProto, MutableDescriptorProto>(), MutableDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val `field`: MutableList<FieldDescriptorProto> = mutableListOf()

  public override val extension: MutableList<FieldDescriptorProto> = mutableListOf()

  public override val nestedType: MutableList<DescriptorProto> = mutableListOf()

  public override val enumType: MutableList<EnumDescriptorProto> = mutableListOf()

  public override val extensionRange: MutableList<DescriptorProto.ExtensionRange> = mutableListOf()

  public override val oneofDecl: MutableList<OneofDescriptorProto> = mutableListOf()

  public override var options: MessageOptions? = null
    set(`value`) {
      field = value
    }

  public override val reservedRange: MutableList<DescriptorProto.ReservedRange> = mutableListOf()

  public override val reservedName: MutableList<String> = mutableListOf()

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasField(): Boolean = `field`.isNotEmpty()

  public override fun clearField(): List<FieldDescriptorProto> = `field`.toList().also {
    `field`.clear()
  }

  public override fun hasExtension(): Boolean = extension.isNotEmpty()

  public override fun clearExtension(): List<FieldDescriptorProto> = extension.toList().also {
    extension.clear()
  }

  public override fun hasNestedType(): Boolean = nestedType.isNotEmpty()

  public override fun clearNestedType(): List<DescriptorProto> = nestedType.toList().also {
    nestedType.clear()
  }

  public override fun hasEnumType(): Boolean = enumType.isNotEmpty()

  public override fun clearEnumType(): List<EnumDescriptorProto> = enumType.toList().also {
    enumType.clear()
  }

  public override fun hasExtensionRange(): Boolean = extensionRange.isNotEmpty()

  public override fun clearExtensionRange(): List<DescriptorProto.ExtensionRange> =
      extensionRange.toList().also {
    extensionRange.clear()
  }

  public override fun hasOneofDecl(): Boolean = oneofDecl.isNotEmpty()

  public override fun clearOneofDecl(): List<OneofDescriptorProto> = oneofDecl.toList().also {
    oneofDecl.clear()
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): MessageOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun hasReservedRange(): Boolean = reservedRange.isNotEmpty()

  public override fun clearReservedRange(): List<DescriptorProto.ReservedRange> =
      reservedRange.toList().also {
    reservedRange.clear()
  }

  public override fun hasReservedName(): Boolean = reservedName.isNotEmpty()

  public override fun clearReservedName(): List<String> = reservedName.toList().also {
    reservedName.clear()
  }

  public override fun support(): MessageSupport<DescriptorProto, MutableDescriptorProto> =
      DescriptorProto

  public override fun mergeWith(other: DescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableDescriptorProto = DescriptorProtoImpl().apply {
    mergeWith(this@DescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearField()
    this.clearExtension()
    this.clearNestedType()
    this.clearEnumType()
    this.clearExtensionRange()
    this.clearOneofDecl()
    this.clearOptions()
    this.clearReservedRange()
    this.clearReservedName()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "field" -> this.clearField()
    "extension" -> this.clearExtension()
    "nested_type", "nestedType" -> this.clearNestedType()
    "enum_type", "enumType" -> this.clearEnumType()
    "extension_range", "extensionRange" -> this.clearExtensionRange()
    "oneof_decl", "oneofDecl" -> this.clearOneofDecl()
    "options" -> this.clearOptions()
    "reserved_range", "reservedRange" -> this.clearReservedRange()
    "reserved_name", "reservedName" -> this.clearReservedName()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearField()
    6 -> this.clearExtension()
    3 -> this.clearNestedType()
    4 -> this.clearEnumType()
    5 -> this.clearExtensionRange()
    8 -> this.clearOneofDecl()
    7 -> this.clearOptions()
    9 -> this.clearReservedRange()
    10 -> this.clearReservedName()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "field" -> this.`field`.uncheckedCast()
    "extension" -> this.extension.uncheckedCast()
    "nested_type", "nestedType" -> this.nestedType.uncheckedCast()
    "enum_type", "enumType" -> this.enumType.uncheckedCast()
    "extension_range", "extensionRange" -> this.extensionRange.uncheckedCast()
    "oneof_decl", "oneofDecl" -> this.oneofDecl.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "reserved_range", "reservedRange" -> this.reservedRange.uncheckedCast()
    "reserved_name", "reservedName" -> this.reservedName.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.`field`.uncheckedCast()
    6 -> this.extension.uncheckedCast()
    3 -> this.nestedType.uncheckedCast()
    4 -> this.enumType.uncheckedCast()
    5 -> this.extensionRange.uncheckedCast()
    8 -> this.oneofDecl.uncheckedCast()
    7 -> this.options.uncheckedCast()
    9 -> this.reservedRange.uncheckedCast()
    10 -> this.reservedName.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "field" -> {
        this.`field`.clear()
        this.`field`.addAll(value.uncheckedCast())
      }
      "extension" -> {
        this.extension.clear()
        this.extension.addAll(value.uncheckedCast())
      }
      "nested_type", "nestedType" -> {
        this.nestedType.clear()
        this.nestedType.addAll(value.uncheckedCast())
      }
      "enum_type", "enumType" -> {
        this.enumType.clear()
        this.enumType.addAll(value.uncheckedCast())
      }
      "extension_range", "extensionRange" -> {
        this.extensionRange.clear()
        this.extensionRange.addAll(value.uncheckedCast())
      }
      "oneof_decl", "oneofDecl" -> {
        this.oneofDecl.clear()
        this.oneofDecl.addAll(value.uncheckedCast())
      }
      "options" -> this.options = value.uncheckedCast()
      "reserved_range", "reservedRange" -> {
        this.reservedRange.clear()
        this.reservedRange.addAll(value.uncheckedCast())
      }
      "reserved_name", "reservedName" -> {
        this.reservedName.clear()
        this.reservedName.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.`field`.clear()
        this.`field`.addAll(value.uncheckedCast())
      }
      6 -> {
        this.extension.clear()
        this.extension.addAll(value.uncheckedCast())
      }
      3 -> {
        this.nestedType.clear()
        this.nestedType.addAll(value.uncheckedCast())
      }
      4 -> {
        this.enumType.clear()
        this.enumType.addAll(value.uncheckedCast())
      }
      5 -> {
        this.extensionRange.clear()
        this.extensionRange.addAll(value.uncheckedCast())
      }
      8 -> {
        this.oneofDecl.clear()
        this.oneofDecl.addAll(value.uncheckedCast())
      }
      7 -> this.options = value.uncheckedCast()
      9 -> {
        this.reservedRange.clear()
        this.reservedRange.addAll(value.uncheckedCast())
      }
      10 -> {
        this.reservedName.clear()
        this.reservedName.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "field" -> this.hasField()
    "extension" -> this.hasExtension()
    "nested_type", "nestedType" -> this.hasNestedType()
    "enum_type", "enumType" -> this.hasEnumType()
    "extension_range", "extensionRange" -> this.hasExtensionRange()
    "oneof_decl", "oneofDecl" -> this.hasOneofDecl()
    "options" -> this.hasOptions()
    "reserved_range", "reservedRange" -> this.hasReservedRange()
    "reserved_name", "reservedName" -> this.hasReservedName()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasField()
    6 -> this.hasExtension()
    3 -> this.hasNestedType()
    4 -> this.hasEnumType()
    5 -> this.hasExtensionRange()
    8 -> this.hasOneofDecl()
    7 -> this.hasOptions()
    9 -> this.hasReservedRange()
    10 -> this.hasReservedName()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: DescriptorProto): Boolean {
    if (name != other.name) return false
    if (!`field`.contentEquals(other.`field`)) return false
    if (!extension.contentEquals(other.extension)) return false
    if (!nestedType.contentEquals(other.nestedType)) return false
    if (!enumType.contentEquals(other.enumType)) return false
    if (!extensionRange.contentEquals(other.extensionRange)) return false
    if (!oneofDecl.contentEquals(other.oneofDecl)) return false
    if (options != other.options) return false
    if (!reservedRange.contentEquals(other.reservedRange)) return false
    if (!reservedName.contentEquals(other.reservedName)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.`field`) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    for (value in this.extension) {
      result = result * 37 + 6
      result = result * 31 + value.hashCode()
    }
    for (value in this.nestedType) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    for (value in this.enumType) {
      result = result * 37 + 4
      result = result * 31 + value.hashCode()
    }
    for (value in this.extensionRange) {
      result = result * 37 + 5
      result = result * 31 + value.hashCode()
    }
    for (value in this.oneofDecl) {
      result = result * 37 + 8
      result = result * 31 + value.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 7
      result = result * 31 + this.options!!.hashCode()
    }
    for (value in this.reservedRange) {
      result = result * 37 + 9
      result = result * 31 + value.hashCode()
    }
    for (value in this.reservedName) {
      result = result * 37 + 10
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.`field`.forEach { writer.tag(18).message(it) }
    this.extension.forEach { writer.tag(50).message(it) }
    this.nestedType.forEach { writer.tag(26).message(it) }
    this.enumType.forEach { writer.tag(34).message(it) }
    this.extensionRange.forEach { writer.tag(42).message(it) }
    this.oneofDecl.forEach { writer.tag(66).message(it) }
    if (hasOptions()) {
      writer.tag(58).message(this.options)
    }
    this.reservedRange.forEach { writer.tag(74).message(it) }
    this.reservedName.forEach { writer.tag(82).string(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.`field` += FieldDescriptorProto.newMutable().apply { readFrom(reader) }
      6 -> this.extension += FieldDescriptorProto.newMutable().apply { readFrom(reader) }
      3 -> this.nestedType += DescriptorProto.newMutable().apply { readFrom(reader) }
      4 -> this.enumType += EnumDescriptorProto.newMutable().apply { readFrom(reader) }
      5 -> this.extensionRange += DescriptorProto.ExtensionRange.newMutable().apply {
          readFrom(reader) }
      8 -> this.oneofDecl += OneofDescriptorProto.newMutable().apply { readFrom(reader) }
      7 -> this.options = MessageOptions.newMutable().apply { readFrom(reader) }
      9 -> this.reservedRange += DescriptorProto.ReservedRange.newMutable().apply { readFrom(reader)
          }
      10 -> this.reservedName += reader.string()
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class ExtensionRangeImpl :
      AbstractMutableMessage<DescriptorProto.ExtensionRange, MutableDescriptorProto.MutableExtensionRange>(),
      MutableDescriptorProto.MutableExtensionRange {
    private var _hasStart: Boolean = false

    public override var start: Int = 0
      get() = if(_hasStart) field else 0
      set(`value`) {
        field = value
        _hasStart = true
      }

    private var _hasEnd: Boolean = false

    public override var end: Int = 0
      get() = if(_hasEnd) field else 0
      set(`value`) {
        field = value
        _hasEnd = true
      }

    public override var options: ExtensionRangeOptions? = null
      set(`value`) {
        field = value
      }

    public override fun hasStart(): Boolean = _hasStart

    public override fun clearStart(): Int? {
      if (!hasStart()) return null
      return start.also {
        start = 0
        _hasStart = false
      }
    }

    public override fun hasEnd(): Boolean = _hasEnd

    public override fun clearEnd(): Int? {
      if (!hasEnd()) return null
      return end.also {
        end = 0
        _hasEnd = false
      }
    }

    public override fun hasOptions(): Boolean = options != null

    public override fun clearOptions(): ExtensionRangeOptions? {
      if (!hasOptions()) return null
      return options.also {
        options = null
      }
    }

    public override fun support():
        MessageSupport<DescriptorProto.ExtensionRange, MutableDescriptorProto.MutableExtensionRange>
        = DescriptorProto.ExtensionRange

    public override fun mergeWith(other: DescriptorProto.ExtensionRange?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableDescriptorProto.MutableExtensionRange =
        ExtensionRangeImpl().apply {
      mergeWith(this@ExtensionRangeImpl)
    }

    public override fun clear(): Unit {
      this.clearStart()
      this.clearEnd()
      this.clearOptions()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "start" -> this.clearStart()
      "end" -> this.clearEnd()
      "options" -> this.clearOptions()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearStart()
      2 -> this.clearEnd()
      3 -> this.clearOptions()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "start" -> this.start.uncheckedCast()
      "end" -> this.end.uncheckedCast()
      "options" -> this.options.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.start.uncheckedCast()
      2 -> this.end.uncheckedCast()
      3 -> this.options.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "start" -> this.start = value.uncheckedCast()
        "end" -> this.end = value.uncheckedCast()
        "options" -> this.options = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.start = value.uncheckedCast()
        2 -> this.end = value.uncheckedCast()
        3 -> this.options = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "start" -> this.hasStart()
      "end" -> this.hasEnd()
      "options" -> this.hasOptions()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasStart()
      2 -> this.hasEnd()
      3 -> this.hasOptions()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: DescriptorProto.ExtensionRange): Boolean {
      if (start != other.start) return false
      if (end != other.end) return false
      if (options != other.options) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      if (hasStart()) {
        result = result * 37 + 1
        result = result * 31 + this.start.hashCode()
      }
      if (hasEnd()) {
        result = result * 37 + 2
        result = result * 31 + this.end.hashCode()
      }
      if (hasOptions()) {
        result = result * 37 + 3
        result = result * 31 + this.options!!.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      if (hasStart()) {
        writer.tag(8).int32(this.start)
      }
      if (hasEnd()) {
        writer.tag(16).int32(this.end)
      }
      if (hasOptions()) {
        writer.tag(26).message(this.options)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.start = reader.int32()
        2 -> this.end = reader.int32()
        3 -> this.options = ExtensionRangeOptions.newMutable().apply { readFrom(reader) }
        else -> return false
      }
      return true
    }
  }

  @InternalProtoApi
  internal class ReservedRangeImpl :
      AbstractMutableMessage<DescriptorProto.ReservedRange, MutableDescriptorProto.MutableReservedRange>(),
      MutableDescriptorProto.MutableReservedRange {
    private var _hasStart: Boolean = false

    public override var start: Int = 0
      get() = if(_hasStart) field else 0
      set(`value`) {
        field = value
        _hasStart = true
      }

    private var _hasEnd: Boolean = false

    public override var end: Int = 0
      get() = if(_hasEnd) field else 0
      set(`value`) {
        field = value
        _hasEnd = true
      }

    public override fun hasStart(): Boolean = _hasStart

    public override fun clearStart(): Int? {
      if (!hasStart()) return null
      return start.also {
        start = 0
        _hasStart = false
      }
    }

    public override fun hasEnd(): Boolean = _hasEnd

    public override fun clearEnd(): Int? {
      if (!hasEnd()) return null
      return end.also {
        end = 0
        _hasEnd = false
      }
    }

    public override fun support():
        MessageSupport<DescriptorProto.ReservedRange, MutableDescriptorProto.MutableReservedRange> =
        DescriptorProto.ReservedRange

    public override fun mergeWith(other: DescriptorProto.ReservedRange?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableDescriptorProto.MutableReservedRange =
        ReservedRangeImpl().apply {
      mergeWith(this@ReservedRangeImpl)
    }

    public override fun clear(): Unit {
      this.clearStart()
      this.clearEnd()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "start" -> this.clearStart()
      "end" -> this.clearEnd()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearStart()
      2 -> this.clearEnd()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "start" -> this.start.uncheckedCast()
      "end" -> this.end.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.start.uncheckedCast()
      2 -> this.end.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "start" -> this.start = value.uncheckedCast()
        "end" -> this.end = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.start = value.uncheckedCast()
        2 -> this.end = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "start" -> this.hasStart()
      "end" -> this.hasEnd()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasStart()
      2 -> this.hasEnd()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: DescriptorProto.ReservedRange): Boolean {
      if (start != other.start) return false
      if (end != other.end) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      if (hasStart()) {
        result = result * 37 + 1
        result = result * 31 + this.start.hashCode()
      }
      if (hasEnd()) {
        result = result * 37 + 2
        result = result * 31 + this.end.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      if (hasStart()) {
        writer.tag(8).int32(this.start)
      }
      if (hasEnd()) {
        writer.tag(16).int32(this.end)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.start = reader.int32()
        2 -> this.end = reader.int32()
        else -> return false
      }
      return true
    }
  }
}

public open class DescriptorProtoSupport internal constructor() :
    MessageSupport<DescriptorProto, MutableDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.DescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "DescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableDescriptorProto = DescriptorProtoImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(DescriptorProto.ExtensionRange,
      DescriptorProto.ReservedRange)

  public open class ExtensionRangeSupport internal constructor() :
      MessageSupport<DescriptorProto.ExtensionRange, MutableDescriptorProto.MutableExtensionRange>()
      {
    public override val name: String
      get() = ".google.protobuf.DescriptorProto.ExtensionRange"

    public override val parent: DescriptorProto.Companion
      get() = DescriptorProto

    public override val descriptor: DescriptorProto by lazy {
      DescriptorProto.descriptor.nestedType.first{ it.name == "ExtensionRange" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableDescriptorProto.MutableExtensionRange =
        DescriptorProtoImpl.ExtensionRangeImpl()
  }

  public open class ReservedRangeSupport internal constructor() :
      MessageSupport<DescriptorProto.ReservedRange, MutableDescriptorProto.MutableReservedRange>() {
    public override val name: String
      get() = ".google.protobuf.DescriptorProto.ReservedRange"

    public override val parent: DescriptorProto.Companion
      get() = DescriptorProto

    public override val descriptor: DescriptorProto by lazy {
      DescriptorProto.descriptor.nestedType.first{ it.name == "ReservedRange" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableDescriptorProto.MutableReservedRange =
        DescriptorProtoImpl.ReservedRangeImpl()
  }
}

public interface MutableExtensionRangeOptions :
    MutableMessage<ExtensionRangeOptions, MutableExtensionRangeOptions>, ExtensionRangeOptions {
  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public override val declaration: MutableList<ExtensionRangeOptions.Declaration>

  public override var features: FeatureSet?

  public override var verification: ExtensionRangeOptions.VerificationState

  public fun clearUninterpretedOption(): List<UninterpretedOption>

  public fun clearDeclaration(): List<ExtensionRangeOptions.Declaration>

  public fun clearFeatures(): FeatureSet?

  public fun clearVerification(): ExtensionRangeOptions.VerificationState?

  public interface MutableDeclaration :
      MutableMessage<ExtensionRangeOptions.Declaration, MutableDeclaration>,
      ExtensionRangeOptions.Declaration {
    public override var number: Int

    public override var fullName: String

    public override var type: String

    public override var reserved: Boolean

    public override var repeated: Boolean

    public fun clearNumber(): Int?

    public fun clearFullName(): String?

    public fun clearType(): String?

    public fun clearReserved(): Boolean?

    public fun clearRepeated(): Boolean?
  }
}

@InternalProtoApi
internal class ExtensionRangeOptionsImpl :
    AbstractMutableMessage<ExtensionRangeOptions, MutableExtensionRangeOptions>(),
    MutableExtensionRangeOptions {
  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override val declaration: MutableList<ExtensionRangeOptions.Declaration> = mutableListOf()

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  private var _hasVerification: Boolean = false

  public override var verification: ExtensionRangeOptions.VerificationState =
      ExtensionRangeOptions.VerificationState()
    get() = if(_hasVerification) field else ExtensionRangeOptions.VerificationState()
    set(`value`) {
      field = value
      _hasVerification = true
    }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun hasDeclaration(): Boolean = declaration.isNotEmpty()

  public override fun clearDeclaration(): List<ExtensionRangeOptions.Declaration> =
      declaration.toList().also {
    declaration.clear()
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasVerification(): Boolean = _hasVerification

  public override fun clearVerification(): ExtensionRangeOptions.VerificationState? {
    if (!hasVerification()) return null
    return verification.also {
      verification = ExtensionRangeOptions.VerificationState()
      _hasVerification = false
    }
  }

  public override fun support(): MessageSupport<ExtensionRangeOptions, MutableExtensionRangeOptions>
      = ExtensionRangeOptions

  public override fun mergeWith(other: ExtensionRangeOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableExtensionRangeOptions =
      ExtensionRangeOptionsImpl().apply {
    mergeWith(this@ExtensionRangeOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearUninterpretedOption()
    this.clearDeclaration()
    this.clearFeatures()
    this.clearVerification()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    "declaration" -> this.clearDeclaration()
    "features" -> this.clearFeatures()
    "verification" -> this.clearVerification()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    999 -> this.clearUninterpretedOption()
    2 -> this.clearDeclaration()
    50 -> this.clearFeatures()
    3 -> this.clearVerification()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    "declaration" -> this.declaration.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "verification" -> this.verification.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    999 -> this.uninterpretedOption.uncheckedCast()
    2 -> this.declaration.uncheckedCast()
    50 -> this.features.uncheckedCast()
    3 -> this.verification.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      "declaration" -> {
        this.declaration.clear()
        this.declaration.addAll(value.uncheckedCast())
      }
      "features" -> this.features = value.uncheckedCast()
      "verification" -> this.verification = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      2 -> {
        this.declaration.clear()
        this.declaration.addAll(value.uncheckedCast())
      }
      50 -> this.features = value.uncheckedCast()
      3 -> this.verification = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    "declaration" -> this.hasDeclaration()
    "features" -> this.hasFeatures()
    "verification" -> this.hasVerification()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    999 -> this.hasUninterpretedOption()
    2 -> this.hasDeclaration()
    50 -> this.hasFeatures()
    3 -> this.hasVerification()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: ExtensionRangeOptions): Boolean {
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    if (!declaration.contentEquals(other.declaration)) return false
    if (features != other.features) return false
    if (verification != other.verification) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    for (value in this.declaration) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 50
      result = result * 31 + this.features!!.hashCode()
    }
    if (hasVerification()) {
      result = result * 37 + 3
      result = result * 31 + this.verification.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
    this.declaration.forEach { writer.tag(18).message(it) }
    if (hasFeatures()) {
      writer.tag(402).message(this.features)
    }
    if (hasVerification()) {
      writer.tag(24).enum(this.verification)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      2 -> this.declaration += ExtensionRangeOptions.Declaration.newMutable().apply {
          readFrom(reader) }
      50 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      3 -> this.verification = ExtensionRangeOptions.VerificationState(reader.int32())
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class DeclarationImpl :
      AbstractMutableMessage<ExtensionRangeOptions.Declaration, MutableExtensionRangeOptions.MutableDeclaration>(),
      MutableExtensionRangeOptions.MutableDeclaration {
    private var _hasNumber: Boolean = false

    public override var number: Int = 0
      get() = if(_hasNumber) field else 0
      set(`value`) {
        field = value
        _hasNumber = true
      }

    private var _hasFullName: Boolean = false

    public override var fullName: String = ""
      get() = if(_hasFullName) field else ""
      set(`value`) {
        field = value
        _hasFullName = true
      }

    private var _hasType: Boolean = false

    public override var type: String = ""
      get() = if(_hasType) field else ""
      set(`value`) {
        field = value
        _hasType = true
      }

    private var _hasReserved: Boolean = false

    public override var reserved: Boolean = false
      get() = if(_hasReserved) field else false
      set(`value`) {
        field = value
        _hasReserved = true
      }

    private var _hasRepeated: Boolean = false

    public override var repeated: Boolean = false
      get() = if(_hasRepeated) field else false
      set(`value`) {
        field = value
        _hasRepeated = true
      }

    public override fun hasNumber(): Boolean = _hasNumber

    public override fun clearNumber(): Int? {
      if (!hasNumber()) return null
      return number.also {
        number = 0
        _hasNumber = false
      }
    }

    public override fun hasFullName(): Boolean = _hasFullName

    public override fun clearFullName(): String? {
      if (!hasFullName()) return null
      return fullName.also {
        fullName = ""
        _hasFullName = false
      }
    }

    public override fun hasType(): Boolean = _hasType

    public override fun clearType(): String? {
      if (!hasType()) return null
      return type.also {
        type = ""
        _hasType = false
      }
    }

    public override fun hasReserved(): Boolean = _hasReserved

    public override fun clearReserved(): Boolean? {
      if (!hasReserved()) return null
      return reserved.also {
        reserved = false
        _hasReserved = false
      }
    }

    public override fun hasRepeated(): Boolean = _hasRepeated

    public override fun clearRepeated(): Boolean? {
      if (!hasRepeated()) return null
      return repeated.also {
        repeated = false
        _hasRepeated = false
      }
    }

    public override fun support():
        MessageSupport<ExtensionRangeOptions.Declaration, MutableExtensionRangeOptions.MutableDeclaration>
        = ExtensionRangeOptions.Declaration

    public override fun mergeWith(other: ExtensionRangeOptions.Declaration?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableExtensionRangeOptions.MutableDeclaration =
        DeclarationImpl().apply {
      mergeWith(this@DeclarationImpl)
    }

    public override fun clear(): Unit {
      this.clearNumber()
      this.clearFullName()
      this.clearType()
      this.clearReserved()
      this.clearRepeated()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "number" -> this.clearNumber()
      "full_name", "fullName" -> this.clearFullName()
      "type" -> this.clearType()
      "reserved" -> this.clearReserved()
      "repeated" -> this.clearRepeated()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearNumber()
      2 -> this.clearFullName()
      3 -> this.clearType()
      5 -> this.clearReserved()
      6 -> this.clearRepeated()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "number" -> this.number.uncheckedCast()
      "full_name", "fullName" -> this.fullName.uncheckedCast()
      "type" -> this.type.uncheckedCast()
      "reserved" -> this.reserved.uncheckedCast()
      "repeated" -> this.repeated.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.number.uncheckedCast()
      2 -> this.fullName.uncheckedCast()
      3 -> this.type.uncheckedCast()
      5 -> this.reserved.uncheckedCast()
      6 -> this.repeated.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "number" -> this.number = value.uncheckedCast()
        "full_name", "fullName" -> this.fullName = value.uncheckedCast()
        "type" -> this.type = value.uncheckedCast()
        "reserved" -> this.reserved = value.uncheckedCast()
        "repeated" -> this.repeated = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.number = value.uncheckedCast()
        2 -> this.fullName = value.uncheckedCast()
        3 -> this.type = value.uncheckedCast()
        5 -> this.reserved = value.uncheckedCast()
        6 -> this.repeated = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "number" -> this.hasNumber()
      "full_name", "fullName" -> this.hasFullName()
      "type" -> this.hasType()
      "reserved" -> this.hasReserved()
      "repeated" -> this.hasRepeated()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasNumber()
      2 -> this.hasFullName()
      3 -> this.hasType()
      5 -> this.hasReserved()
      6 -> this.hasRepeated()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: ExtensionRangeOptions.Declaration): Boolean {
      if (number != other.number) return false
      if (fullName != other.fullName) return false
      if (type != other.type) return false
      if (reserved != other.reserved) return false
      if (repeated != other.repeated) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      if (hasNumber()) {
        result = result * 37 + 1
        result = result * 31 + this.number.hashCode()
      }
      if (hasFullName()) {
        result = result * 37 + 2
        result = result * 31 + this.fullName.hashCode()
      }
      if (hasType()) {
        result = result * 37 + 3
        result = result * 31 + this.type.hashCode()
      }
      if (hasReserved()) {
        result = result * 37 + 5
        result = result * 31 + this.reserved.hashCode()
      }
      if (hasRepeated()) {
        result = result * 37 + 6
        result = result * 31 + this.repeated.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      if (hasNumber()) {
        writer.tag(8).int32(this.number)
      }
      if (hasFullName()) {
        writer.tag(18).string(this.fullName)
      }
      if (hasType()) {
        writer.tag(26).string(this.type)
      }
      if (hasReserved()) {
        writer.tag(40).bool(this.reserved)
      }
      if (hasRepeated()) {
        writer.tag(48).bool(this.repeated)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.number = reader.int32()
        2 -> this.fullName = reader.string()
        3 -> this.type = reader.string()
        5 -> this.reserved = reader.bool()
        6 -> this.repeated = reader.bool()
        else -> return false
      }
      return true
    }
  }
}

public open class ExtensionRangeOptionsSupport internal constructor() :
    MessageSupport<ExtensionRangeOptions, MutableExtensionRangeOptions>() {
  public override val name: String
    get() = ".google.protobuf.ExtensionRangeOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "ExtensionRangeOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableExtensionRangeOptions = ExtensionRangeOptionsImpl()

  public override fun children(): Array<ProtoSupport<*>> =
      arrayOf(ExtensionRangeOptions.Declaration, ExtensionRangeOptions.VerificationState)

  public abstract class VerificationStateSupport internal constructor() :
      EnumSupport<ExtensionRangeOptions.VerificationState>() {
    public override val name: String
      get() = ".google.protobuf.ExtensionRangeOptions.VerificationState"

    public override val parent: ExtensionRangeOptions.Companion
      get() = ExtensionRangeOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      ExtensionRangeOptions.descriptor.enumType.first{ it.name == "VerificationState" }
    }


    public override fun values(): Array<ExtensionRangeOptions.VerificationState> =
        ExtensionRangeOptions.VerificationState.values()
  }

  public open class DeclarationSupport internal constructor() :
      MessageSupport<ExtensionRangeOptions.Declaration, MutableExtensionRangeOptions.MutableDeclaration>()
      {
    public override val name: String
      get() = ".google.protobuf.ExtensionRangeOptions.Declaration"

    public override val parent: ExtensionRangeOptions.Companion
      get() = ExtensionRangeOptions

    public override val descriptor: DescriptorProto by lazy {
      ExtensionRangeOptions.descriptor.nestedType.first{ it.name == "Declaration" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableExtensionRangeOptions.MutableDeclaration =
        ExtensionRangeOptionsImpl.DeclarationImpl()
  }
}

public interface MutableFieldDescriptorProto :
    MutableMessage<FieldDescriptorProto, MutableFieldDescriptorProto>, FieldDescriptorProto {
  public override var name: String

  public override var number: Int

  public override var label: FieldDescriptorProto.Label

  public override var type: FieldDescriptorProto.Type

  public override var typeName: String

  public override var extendee: String

  public override var defaultValue: String

  public override var oneofIndex: Int

  public override var jsonName: String

  public override var options: FieldOptions?

  public override var proto3Optional: Boolean

  public fun clearName(): String?

  public fun clearNumber(): Int?

  public fun clearLabel(): FieldDescriptorProto.Label?

  public fun clearType(): FieldDescriptorProto.Type?

  public fun clearTypeName(): String?

  public fun clearExtendee(): String?

  public fun clearDefaultValue(): String?

  public fun clearOneofIndex(): Int?

  public fun clearJsonName(): String?

  public fun clearOptions(): FieldOptions?

  public fun clearProto3Optional(): Boolean?
}

@InternalProtoApi
internal class FieldDescriptorProtoImpl :
    AbstractMutableMessage<FieldDescriptorProto, MutableFieldDescriptorProto>(),
    MutableFieldDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasNumber: Boolean = false

  public override var number: Int = 0
    get() = if(_hasNumber) field else 0
    set(`value`) {
      field = value
      _hasNumber = true
    }

  private var _hasLabel: Boolean = false

  public override var label: FieldDescriptorProto.Label = FieldDescriptorProto.Label()
    get() = if(_hasLabel) field else FieldDescriptorProto.Label()
    set(`value`) {
      field = value
      _hasLabel = true
    }

  private var _hasType: Boolean = false

  public override var type: FieldDescriptorProto.Type = FieldDescriptorProto.Type()
    get() = if(_hasType) field else FieldDescriptorProto.Type()
    set(`value`) {
      field = value
      _hasType = true
    }

  private var _hasTypeName: Boolean = false

  public override var typeName: String = ""
    get() = if(_hasTypeName) field else ""
    set(`value`) {
      field = value
      _hasTypeName = true
    }

  private var _hasExtendee: Boolean = false

  public override var extendee: String = ""
    get() = if(_hasExtendee) field else ""
    set(`value`) {
      field = value
      _hasExtendee = true
    }

  private var _hasDefaultValue: Boolean = false

  public override var defaultValue: String = ""
    get() = if(_hasDefaultValue) field else ""
    set(`value`) {
      field = value
      _hasDefaultValue = true
    }

  private var _hasOneofIndex: Boolean = false

  public override var oneofIndex: Int = 0
    get() = if(_hasOneofIndex) field else 0
    set(`value`) {
      field = value
      _hasOneofIndex = true
    }

  private var _hasJsonName: Boolean = false

  public override var jsonName: String = ""
    get() = if(_hasJsonName) field else ""
    set(`value`) {
      field = value
      _hasJsonName = true
    }

  public override var options: FieldOptions? = null
    set(`value`) {
      field = value
    }

  private var _hasProto3Optional: Boolean = false

  public override var proto3Optional: Boolean = false
    get() = if(_hasProto3Optional) field else false
    set(`value`) {
      field = value
      _hasProto3Optional = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasNumber(): Boolean = _hasNumber

  public override fun clearNumber(): Int? {
    if (!hasNumber()) return null
    return number.also {
      number = 0
      _hasNumber = false
    }
  }

  public override fun hasLabel(): Boolean = _hasLabel

  public override fun clearLabel(): FieldDescriptorProto.Label? {
    if (!hasLabel()) return null
    return label.also {
      label = FieldDescriptorProto.Label()
      _hasLabel = false
    }
  }

  public override fun hasType(): Boolean = _hasType

  public override fun clearType(): FieldDescriptorProto.Type? {
    if (!hasType()) return null
    return type.also {
      type = FieldDescriptorProto.Type()
      _hasType = false
    }
  }

  public override fun hasTypeName(): Boolean = _hasTypeName

  public override fun clearTypeName(): String? {
    if (!hasTypeName()) return null
    return typeName.also {
      typeName = ""
      _hasTypeName = false
    }
  }

  public override fun hasExtendee(): Boolean = _hasExtendee

  public override fun clearExtendee(): String? {
    if (!hasExtendee()) return null
    return extendee.also {
      extendee = ""
      _hasExtendee = false
    }
  }

  public override fun hasDefaultValue(): Boolean = _hasDefaultValue

  public override fun clearDefaultValue(): String? {
    if (!hasDefaultValue()) return null
    return defaultValue.also {
      defaultValue = ""
      _hasDefaultValue = false
    }
  }

  public override fun hasOneofIndex(): Boolean = _hasOneofIndex

  public override fun clearOneofIndex(): Int? {
    if (!hasOneofIndex()) return null
    return oneofIndex.also {
      oneofIndex = 0
      _hasOneofIndex = false
    }
  }

  public override fun hasJsonName(): Boolean = _hasJsonName

  public override fun clearJsonName(): String? {
    if (!hasJsonName()) return null
    return jsonName.also {
      jsonName = ""
      _hasJsonName = false
    }
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): FieldOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun hasProto3Optional(): Boolean = _hasProto3Optional

  public override fun clearProto3Optional(): Boolean? {
    if (!hasProto3Optional()) return null
    return proto3Optional.also {
      proto3Optional = false
      _hasProto3Optional = false
    }
  }

  public override fun support(): MessageSupport<FieldDescriptorProto, MutableFieldDescriptorProto> =
      FieldDescriptorProto

  public override fun mergeWith(other: FieldDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFieldDescriptorProto =
      FieldDescriptorProtoImpl().apply {
    mergeWith(this@FieldDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearNumber()
    this.clearLabel()
    this.clearType()
    this.clearTypeName()
    this.clearExtendee()
    this.clearDefaultValue()
    this.clearOneofIndex()
    this.clearJsonName()
    this.clearOptions()
    this.clearProto3Optional()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "number" -> this.clearNumber()
    "label" -> this.clearLabel()
    "type" -> this.clearType()
    "type_name", "typeName" -> this.clearTypeName()
    "extendee" -> this.clearExtendee()
    "default_value", "defaultValue" -> this.clearDefaultValue()
    "oneof_index", "oneofIndex" -> this.clearOneofIndex()
    "json_name", "jsonName" -> this.clearJsonName()
    "options" -> this.clearOptions()
    "proto3_optional", "proto3Optional" -> this.clearProto3Optional()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    3 -> this.clearNumber()
    4 -> this.clearLabel()
    5 -> this.clearType()
    6 -> this.clearTypeName()
    2 -> this.clearExtendee()
    7 -> this.clearDefaultValue()
    9 -> this.clearOneofIndex()
    10 -> this.clearJsonName()
    8 -> this.clearOptions()
    17 -> this.clearProto3Optional()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "number" -> this.number.uncheckedCast()
    "label" -> this.label.uncheckedCast()
    "type" -> this.type.uncheckedCast()
    "type_name", "typeName" -> this.typeName.uncheckedCast()
    "extendee" -> this.extendee.uncheckedCast()
    "default_value", "defaultValue" -> this.defaultValue.uncheckedCast()
    "oneof_index", "oneofIndex" -> this.oneofIndex.uncheckedCast()
    "json_name", "jsonName" -> this.jsonName.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "proto3_optional", "proto3Optional" -> this.proto3Optional.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    3 -> this.number.uncheckedCast()
    4 -> this.label.uncheckedCast()
    5 -> this.type.uncheckedCast()
    6 -> this.typeName.uncheckedCast()
    2 -> this.extendee.uncheckedCast()
    7 -> this.defaultValue.uncheckedCast()
    9 -> this.oneofIndex.uncheckedCast()
    10 -> this.jsonName.uncheckedCast()
    8 -> this.options.uncheckedCast()
    17 -> this.proto3Optional.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "number" -> this.number = value.uncheckedCast()
      "label" -> this.label = value.uncheckedCast()
      "type" -> this.type = value.uncheckedCast()
      "type_name", "typeName" -> this.typeName = value.uncheckedCast()
      "extendee" -> this.extendee = value.uncheckedCast()
      "default_value", "defaultValue" -> this.defaultValue = value.uncheckedCast()
      "oneof_index", "oneofIndex" -> this.oneofIndex = value.uncheckedCast()
      "json_name", "jsonName" -> this.jsonName = value.uncheckedCast()
      "options" -> this.options = value.uncheckedCast()
      "proto3_optional", "proto3Optional" -> this.proto3Optional = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      3 -> this.number = value.uncheckedCast()
      4 -> this.label = value.uncheckedCast()
      5 -> this.type = value.uncheckedCast()
      6 -> this.typeName = value.uncheckedCast()
      2 -> this.extendee = value.uncheckedCast()
      7 -> this.defaultValue = value.uncheckedCast()
      9 -> this.oneofIndex = value.uncheckedCast()
      10 -> this.jsonName = value.uncheckedCast()
      8 -> this.options = value.uncheckedCast()
      17 -> this.proto3Optional = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "number" -> this.hasNumber()
    "label" -> this.hasLabel()
    "type" -> this.hasType()
    "type_name", "typeName" -> this.hasTypeName()
    "extendee" -> this.hasExtendee()
    "default_value", "defaultValue" -> this.hasDefaultValue()
    "oneof_index", "oneofIndex" -> this.hasOneofIndex()
    "json_name", "jsonName" -> this.hasJsonName()
    "options" -> this.hasOptions()
    "proto3_optional", "proto3Optional" -> this.hasProto3Optional()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    3 -> this.hasNumber()
    4 -> this.hasLabel()
    5 -> this.hasType()
    6 -> this.hasTypeName()
    2 -> this.hasExtendee()
    7 -> this.hasDefaultValue()
    9 -> this.hasOneofIndex()
    10 -> this.hasJsonName()
    8 -> this.hasOptions()
    17 -> this.hasProto3Optional()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FieldDescriptorProto): Boolean {
    if (name != other.name) return false
    if (number != other.number) return false
    if (label != other.label) return false
    if (type != other.type) return false
    if (typeName != other.typeName) return false
    if (extendee != other.extendee) return false
    if (defaultValue != other.defaultValue) return false
    if (oneofIndex != other.oneofIndex) return false
    if (jsonName != other.jsonName) return false
    if (options != other.options) return false
    if (proto3Optional != other.proto3Optional) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasNumber()) {
      result = result * 37 + 3
      result = result * 31 + this.number.hashCode()
    }
    if (hasLabel()) {
      result = result * 37 + 4
      result = result * 31 + this.label.hashCode()
    }
    if (hasType()) {
      result = result * 37 + 5
      result = result * 31 + this.type.hashCode()
    }
    if (hasTypeName()) {
      result = result * 37 + 6
      result = result * 31 + this.typeName.hashCode()
    }
    if (hasExtendee()) {
      result = result * 37 + 2
      result = result * 31 + this.extendee.hashCode()
    }
    if (hasDefaultValue()) {
      result = result * 37 + 7
      result = result * 31 + this.defaultValue.hashCode()
    }
    if (hasOneofIndex()) {
      result = result * 37 + 9
      result = result * 31 + this.oneofIndex.hashCode()
    }
    if (hasJsonName()) {
      result = result * 37 + 10
      result = result * 31 + this.jsonName.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 8
      result = result * 31 + this.options!!.hashCode()
    }
    if (hasProto3Optional()) {
      result = result * 37 + 17
      result = result * 31 + this.proto3Optional.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasNumber()) {
      writer.tag(24).int32(this.number)
    }
    if (hasLabel()) {
      writer.tag(32).enum(this.label)
    }
    if (hasType()) {
      writer.tag(40).enum(this.type)
    }
    if (hasTypeName()) {
      writer.tag(50).string(this.typeName)
    }
    if (hasExtendee()) {
      writer.tag(18).string(this.extendee)
    }
    if (hasDefaultValue()) {
      writer.tag(58).string(this.defaultValue)
    }
    if (hasOneofIndex()) {
      writer.tag(72).int32(this.oneofIndex)
    }
    if (hasJsonName()) {
      writer.tag(82).string(this.jsonName)
    }
    if (hasOptions()) {
      writer.tag(66).message(this.options)
    }
    if (hasProto3Optional()) {
      writer.tag(136).bool(this.proto3Optional)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      3 -> this.number = reader.int32()
      4 -> this.label = FieldDescriptorProto.Label(reader.int32())
      5 -> this.type = FieldDescriptorProto.Type(reader.int32())
      6 -> this.typeName = reader.string()
      2 -> this.extendee = reader.string()
      7 -> this.defaultValue = reader.string()
      9 -> this.oneofIndex = reader.int32()
      10 -> this.jsonName = reader.string()
      8 -> this.options = FieldOptions.newMutable().apply { readFrom(reader) }
      17 -> this.proto3Optional = reader.bool()
      else -> return false
    }
    return true
  }
}

public open class FieldDescriptorProtoSupport internal constructor() :
    MessageSupport<FieldDescriptorProto, MutableFieldDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.FieldDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FieldDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFieldDescriptorProto = FieldDescriptorProtoImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FieldDescriptorProto.Type,
      FieldDescriptorProto.Label)

  public abstract class TypeSupport internal constructor() :
      EnumSupport<FieldDescriptorProto.Type>() {
    public override val name: String
      get() = ".google.protobuf.FieldDescriptorProto.Type"

    public override val parent: FieldDescriptorProto.Companion
      get() = FieldDescriptorProto

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldDescriptorProto.descriptor.enumType.first{ it.name == "Type" }
    }


    public override fun values(): Array<FieldDescriptorProto.Type> =
        FieldDescriptorProto.Type.values()
  }

  public abstract class LabelSupport internal constructor() :
      EnumSupport<FieldDescriptorProto.Label>() {
    public override val name: String
      get() = ".google.protobuf.FieldDescriptorProto.Label"

    public override val parent: FieldDescriptorProto.Companion
      get() = FieldDescriptorProto

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldDescriptorProto.descriptor.enumType.first{ it.name == "Label" }
    }


    public override fun values(): Array<FieldDescriptorProto.Label> =
        FieldDescriptorProto.Label.values()
  }
}

public interface MutableOneofDescriptorProto :
    MutableMessage<OneofDescriptorProto, MutableOneofDescriptorProto>, OneofDescriptorProto {
  public override var name: String

  public override var options: OneofOptions?

  public fun clearName(): String?

  public fun clearOptions(): OneofOptions?
}

@InternalProtoApi
internal class OneofDescriptorProtoImpl :
    AbstractMutableMessage<OneofDescriptorProto, MutableOneofDescriptorProto>(),
    MutableOneofDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override var options: OneofOptions? = null
    set(`value`) {
      field = value
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): OneofOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun support(): MessageSupport<OneofDescriptorProto, MutableOneofDescriptorProto> =
      OneofDescriptorProto

  public override fun mergeWith(other: OneofDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableOneofDescriptorProto =
      OneofDescriptorProtoImpl().apply {
    mergeWith(this@OneofDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearOptions()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "options" -> this.clearOptions()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearOptions()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "options" -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "options" -> this.hasOptions()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasOptions()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: OneofDescriptorProto): Boolean {
    if (name != other.name) return false
    if (options != other.options) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 2
      result = result * 31 + this.options!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasOptions()) {
      writer.tag(18).message(this.options)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.options = OneofOptions.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class OneofDescriptorProtoSupport internal constructor() :
    MessageSupport<OneofDescriptorProto, MutableOneofDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.OneofDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "OneofDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableOneofDescriptorProto = OneofDescriptorProtoImpl()
}

public interface MutableEnumDescriptorProto :
    MutableMessage<EnumDescriptorProto, MutableEnumDescriptorProto>, EnumDescriptorProto {
  public override var name: String

  public override val `value`: MutableList<EnumValueDescriptorProto>

  public override var options: EnumOptions?

  public override val reservedRange: MutableList<EnumDescriptorProto.EnumReservedRange>

  public override val reservedName: MutableList<String>

  public fun clearName(): String?

  public fun clearValue(): List<EnumValueDescriptorProto>

  public fun clearOptions(): EnumOptions?

  public fun clearReservedRange(): List<EnumDescriptorProto.EnumReservedRange>

  public fun clearReservedName(): List<String>

  public interface MutableEnumReservedRange :
      MutableMessage<EnumDescriptorProto.EnumReservedRange, MutableEnumReservedRange>,
      EnumDescriptorProto.EnumReservedRange {
    public override var start: Int

    public override var end: Int

    public fun clearStart(): Int?

    public fun clearEnd(): Int?
  }
}

@InternalProtoApi
internal class EnumDescriptorProtoImpl :
    AbstractMutableMessage<EnumDescriptorProto, MutableEnumDescriptorProto>(),
    MutableEnumDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val `value`: MutableList<EnumValueDescriptorProto> = mutableListOf()

  public override var options: EnumOptions? = null
    set(`value`) {
      field = value
    }

  public override val reservedRange: MutableList<EnumDescriptorProto.EnumReservedRange> =
      mutableListOf()

  public override val reservedName: MutableList<String> = mutableListOf()

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasValue(): Boolean = `value`.isNotEmpty()

  public override fun clearValue(): List<EnumValueDescriptorProto> = `value`.toList().also {
    `value`.clear()
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): EnumOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun hasReservedRange(): Boolean = reservedRange.isNotEmpty()

  public override fun clearReservedRange(): List<EnumDescriptorProto.EnumReservedRange> =
      reservedRange.toList().also {
    reservedRange.clear()
  }

  public override fun hasReservedName(): Boolean = reservedName.isNotEmpty()

  public override fun clearReservedName(): List<String> = reservedName.toList().also {
    reservedName.clear()
  }

  public override fun support(): MessageSupport<EnumDescriptorProto, MutableEnumDescriptorProto> =
      EnumDescriptorProto

  public override fun mergeWith(other: EnumDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnumDescriptorProto = EnumDescriptorProtoImpl().apply {
    mergeWith(this@EnumDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearValue()
    this.clearOptions()
    this.clearReservedRange()
    this.clearReservedName()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "value" -> this.clearValue()
    "options" -> this.clearOptions()
    "reserved_range", "reservedRange" -> this.clearReservedRange()
    "reserved_name", "reservedName" -> this.clearReservedName()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearValue()
    3 -> this.clearOptions()
    4 -> this.clearReservedRange()
    5 -> this.clearReservedName()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "value" -> this.`value`.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "reserved_range", "reservedRange" -> this.reservedRange.uncheckedCast()
    "reserved_name", "reservedName" -> this.reservedName.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.`value`.uncheckedCast()
    3 -> this.options.uncheckedCast()
    4 -> this.reservedRange.uncheckedCast()
    5 -> this.reservedName.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "value" -> {
        this.`value`.clear()
        this.`value`.addAll(value.uncheckedCast())
      }
      "options" -> this.options = value.uncheckedCast()
      "reserved_range", "reservedRange" -> {
        this.reservedRange.clear()
        this.reservedRange.addAll(value.uncheckedCast())
      }
      "reserved_name", "reservedName" -> {
        this.reservedName.clear()
        this.reservedName.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.`value`.clear()
        this.`value`.addAll(value.uncheckedCast())
      }
      3 -> this.options = value.uncheckedCast()
      4 -> {
        this.reservedRange.clear()
        this.reservedRange.addAll(value.uncheckedCast())
      }
      5 -> {
        this.reservedName.clear()
        this.reservedName.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "value" -> this.hasValue()
    "options" -> this.hasOptions()
    "reserved_range", "reservedRange" -> this.hasReservedRange()
    "reserved_name", "reservedName" -> this.hasReservedName()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasValue()
    3 -> this.hasOptions()
    4 -> this.hasReservedRange()
    5 -> this.hasReservedName()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: EnumDescriptorProto): Boolean {
    if (name != other.name) return false
    if (!`value`.contentEquals(other.`value`)) return false
    if (options != other.options) return false
    if (!reservedRange.contentEquals(other.reservedRange)) return false
    if (!reservedName.contentEquals(other.reservedName)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.`value`) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 3
      result = result * 31 + this.options!!.hashCode()
    }
    for (value in this.reservedRange) {
      result = result * 37 + 4
      result = result * 31 + value.hashCode()
    }
    for (value in this.reservedName) {
      result = result * 37 + 5
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.`value`.forEach { writer.tag(18).message(it) }
    if (hasOptions()) {
      writer.tag(26).message(this.options)
    }
    this.reservedRange.forEach { writer.tag(34).message(it) }
    this.reservedName.forEach { writer.tag(42).string(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.`value` += EnumValueDescriptorProto.newMutable().apply { readFrom(reader) }
      3 -> this.options = EnumOptions.newMutable().apply { readFrom(reader) }
      4 -> this.reservedRange += EnumDescriptorProto.EnumReservedRange.newMutable().apply {
          readFrom(reader) }
      5 -> this.reservedName += reader.string()
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class EnumReservedRangeImpl :
      AbstractMutableMessage<EnumDescriptorProto.EnumReservedRange, MutableEnumDescriptorProto.MutableEnumReservedRange>(),
      MutableEnumDescriptorProto.MutableEnumReservedRange {
    private var _hasStart: Boolean = false

    public override var start: Int = 0
      get() = if(_hasStart) field else 0
      set(`value`) {
        field = value
        _hasStart = true
      }

    private var _hasEnd: Boolean = false

    public override var end: Int = 0
      get() = if(_hasEnd) field else 0
      set(`value`) {
        field = value
        _hasEnd = true
      }

    public override fun hasStart(): Boolean = _hasStart

    public override fun clearStart(): Int? {
      if (!hasStart()) return null
      return start.also {
        start = 0
        _hasStart = false
      }
    }

    public override fun hasEnd(): Boolean = _hasEnd

    public override fun clearEnd(): Int? {
      if (!hasEnd()) return null
      return end.also {
        end = 0
        _hasEnd = false
      }
    }

    public override fun support():
        MessageSupport<EnumDescriptorProto.EnumReservedRange, MutableEnumDescriptorProto.MutableEnumReservedRange>
        = EnumDescriptorProto.EnumReservedRange

    public override fun mergeWith(other: EnumDescriptorProto.EnumReservedRange?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableEnumDescriptorProto.MutableEnumReservedRange =
        EnumReservedRangeImpl().apply {
      mergeWith(this@EnumReservedRangeImpl)
    }

    public override fun clear(): Unit {
      this.clearStart()
      this.clearEnd()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "start" -> this.clearStart()
      "end" -> this.clearEnd()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearStart()
      2 -> this.clearEnd()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "start" -> this.start.uncheckedCast()
      "end" -> this.end.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.start.uncheckedCast()
      2 -> this.end.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "start" -> this.start = value.uncheckedCast()
        "end" -> this.end = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.start = value.uncheckedCast()
        2 -> this.end = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "start" -> this.hasStart()
      "end" -> this.hasEnd()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasStart()
      2 -> this.hasEnd()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: EnumDescriptorProto.EnumReservedRange): Boolean {
      if (start != other.start) return false
      if (end != other.end) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      if (hasStart()) {
        result = result * 37 + 1
        result = result * 31 + this.start.hashCode()
      }
      if (hasEnd()) {
        result = result * 37 + 2
        result = result * 31 + this.end.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      if (hasStart()) {
        writer.tag(8).int32(this.start)
      }
      if (hasEnd()) {
        writer.tag(16).int32(this.end)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.start = reader.int32()
        2 -> this.end = reader.int32()
        else -> return false
      }
      return true
    }
  }
}

public open class EnumDescriptorProtoSupport internal constructor() :
    MessageSupport<EnumDescriptorProto, MutableEnumDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.EnumDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "EnumDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnumDescriptorProto = EnumDescriptorProtoImpl()

  public override fun children(): Array<ProtoSupport<*>> =
      arrayOf(EnumDescriptorProto.EnumReservedRange)

  public open class EnumReservedRangeSupport internal constructor() :
      MessageSupport<EnumDescriptorProto.EnumReservedRange, MutableEnumDescriptorProto.MutableEnumReservedRange>()
      {
    public override val name: String
      get() = ".google.protobuf.EnumDescriptorProto.EnumReservedRange"

    public override val parent: EnumDescriptorProto.Companion
      get() = EnumDescriptorProto

    public override val descriptor: DescriptorProto by lazy {
      EnumDescriptorProto.descriptor.nestedType.first{ it.name == "EnumReservedRange" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableEnumDescriptorProto.MutableEnumReservedRange =
        EnumDescriptorProtoImpl.EnumReservedRangeImpl()
  }
}

public interface MutableEnumValueDescriptorProto :
    MutableMessage<EnumValueDescriptorProto, MutableEnumValueDescriptorProto>,
    EnumValueDescriptorProto {
  public override var name: String

  public override var number: Int

  public override var options: EnumValueOptions?

  public fun clearName(): String?

  public fun clearNumber(): Int?

  public fun clearOptions(): EnumValueOptions?
}

@InternalProtoApi
internal class EnumValueDescriptorProtoImpl :
    AbstractMutableMessage<EnumValueDescriptorProto, MutableEnumValueDescriptorProto>(),
    MutableEnumValueDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasNumber: Boolean = false

  public override var number: Int = 0
    get() = if(_hasNumber) field else 0
    set(`value`) {
      field = value
      _hasNumber = true
    }

  public override var options: EnumValueOptions? = null
    set(`value`) {
      field = value
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasNumber(): Boolean = _hasNumber

  public override fun clearNumber(): Int? {
    if (!hasNumber()) return null
    return number.also {
      number = 0
      _hasNumber = false
    }
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): EnumValueOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun support():
      MessageSupport<EnumValueDescriptorProto, MutableEnumValueDescriptorProto> =
      EnumValueDescriptorProto

  public override fun mergeWith(other: EnumValueDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnumValueDescriptorProto =
      EnumValueDescriptorProtoImpl().apply {
    mergeWith(this@EnumValueDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearNumber()
    this.clearOptions()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "number" -> this.clearNumber()
    "options" -> this.clearOptions()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearNumber()
    3 -> this.clearOptions()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "number" -> this.number.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.number.uncheckedCast()
    3 -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "number" -> this.number = value.uncheckedCast()
      "options" -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.number = value.uncheckedCast()
      3 -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "number" -> this.hasNumber()
    "options" -> this.hasOptions()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasNumber()
    3 -> this.hasOptions()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: EnumValueDescriptorProto): Boolean {
    if (name != other.name) return false
    if (number != other.number) return false
    if (options != other.options) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasNumber()) {
      result = result * 37 + 2
      result = result * 31 + this.number.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 3
      result = result * 31 + this.options!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasNumber()) {
      writer.tag(16).int32(this.number)
    }
    if (hasOptions()) {
      writer.tag(26).message(this.options)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.number = reader.int32()
      3 -> this.options = EnumValueOptions.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class EnumValueDescriptorProtoSupport internal constructor() :
    MessageSupport<EnumValueDescriptorProto, MutableEnumValueDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.EnumValueDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "EnumValueDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnumValueDescriptorProto = EnumValueDescriptorProtoImpl()
}

public interface MutableServiceDescriptorProto :
    MutableMessage<ServiceDescriptorProto, MutableServiceDescriptorProto>, ServiceDescriptorProto {
  public override var name: String

  public override val method: MutableList<MethodDescriptorProto>

  public override var options: ServiceOptions?

  public fun clearName(): String?

  public fun clearMethod(): List<MethodDescriptorProto>

  public fun clearOptions(): ServiceOptions?
}

@InternalProtoApi
internal class ServiceDescriptorProtoImpl :
    AbstractMutableMessage<ServiceDescriptorProto, MutableServiceDescriptorProto>(),
    MutableServiceDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val method: MutableList<MethodDescriptorProto> = mutableListOf()

  public override var options: ServiceOptions? = null
    set(`value`) {
      field = value
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasMethod(): Boolean = method.isNotEmpty()

  public override fun clearMethod(): List<MethodDescriptorProto> = method.toList().also {
    method.clear()
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): ServiceOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun support():
      MessageSupport<ServiceDescriptorProto, MutableServiceDescriptorProto> = ServiceDescriptorProto

  public override fun mergeWith(other: ServiceDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableServiceDescriptorProto =
      ServiceDescriptorProtoImpl().apply {
    mergeWith(this@ServiceDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearMethod()
    this.clearOptions()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "method" -> this.clearMethod()
    "options" -> this.clearOptions()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearMethod()
    3 -> this.clearOptions()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "method" -> this.method.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.method.uncheckedCast()
    3 -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "method" -> {
        this.method.clear()
        this.method.addAll(value.uncheckedCast())
      }
      "options" -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.method.clear()
        this.method.addAll(value.uncheckedCast())
      }
      3 -> this.options = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "method" -> this.hasMethod()
    "options" -> this.hasOptions()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasMethod()
    3 -> this.hasOptions()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: ServiceDescriptorProto): Boolean {
    if (name != other.name) return false
    if (!method.contentEquals(other.method)) return false
    if (options != other.options) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.method) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 3
      result = result * 31 + this.options!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.method.forEach { writer.tag(18).message(it) }
    if (hasOptions()) {
      writer.tag(26).message(this.options)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.method += MethodDescriptorProto.newMutable().apply { readFrom(reader) }
      3 -> this.options = ServiceOptions.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class ServiceDescriptorProtoSupport internal constructor() :
    MessageSupport<ServiceDescriptorProto, MutableServiceDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.ServiceDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "ServiceDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableServiceDescriptorProto = ServiceDescriptorProtoImpl()
}

public interface MutableMethodDescriptorProto :
    MutableMessage<MethodDescriptorProto, MutableMethodDescriptorProto>, MethodDescriptorProto {
  public override var name: String

  public override var inputType: String

  public override var outputType: String

  public override var options: MethodOptions?

  public override var clientStreaming: Boolean

  public override var serverStreaming: Boolean

  public fun clearName(): String?

  public fun clearInputType(): String?

  public fun clearOutputType(): String?

  public fun clearOptions(): MethodOptions?

  public fun clearClientStreaming(): Boolean?

  public fun clearServerStreaming(): Boolean?
}

@InternalProtoApi
internal class MethodDescriptorProtoImpl :
    AbstractMutableMessage<MethodDescriptorProto, MutableMethodDescriptorProto>(),
    MutableMethodDescriptorProto {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasInputType: Boolean = false

  public override var inputType: String = ""
    get() = if(_hasInputType) field else ""
    set(`value`) {
      field = value
      _hasInputType = true
    }

  private var _hasOutputType: Boolean = false

  public override var outputType: String = ""
    get() = if(_hasOutputType) field else ""
    set(`value`) {
      field = value
      _hasOutputType = true
    }

  public override var options: MethodOptions? = null
    set(`value`) {
      field = value
    }

  private var _hasClientStreaming: Boolean = false

  public override var clientStreaming: Boolean = false
    get() = if(_hasClientStreaming) field else false
    set(`value`) {
      field = value
      _hasClientStreaming = true
    }

  private var _hasServerStreaming: Boolean = false

  public override var serverStreaming: Boolean = false
    get() = if(_hasServerStreaming) field else false
    set(`value`) {
      field = value
      _hasServerStreaming = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasInputType(): Boolean = _hasInputType

  public override fun clearInputType(): String? {
    if (!hasInputType()) return null
    return inputType.also {
      inputType = ""
      _hasInputType = false
    }
  }

  public override fun hasOutputType(): Boolean = _hasOutputType

  public override fun clearOutputType(): String? {
    if (!hasOutputType()) return null
    return outputType.also {
      outputType = ""
      _hasOutputType = false
    }
  }

  public override fun hasOptions(): Boolean = options != null

  public override fun clearOptions(): MethodOptions? {
    if (!hasOptions()) return null
    return options.also {
      options = null
    }
  }

  public override fun hasClientStreaming(): Boolean = _hasClientStreaming

  public override fun clearClientStreaming(): Boolean? {
    if (!hasClientStreaming()) return null
    return clientStreaming.also {
      clientStreaming = false
      _hasClientStreaming = false
    }
  }

  public override fun hasServerStreaming(): Boolean = _hasServerStreaming

  public override fun clearServerStreaming(): Boolean? {
    if (!hasServerStreaming()) return null
    return serverStreaming.also {
      serverStreaming = false
      _hasServerStreaming = false
    }
  }

  public override fun support(): MessageSupport<MethodDescriptorProto, MutableMethodDescriptorProto>
      = MethodDescriptorProto

  public override fun mergeWith(other: MethodDescriptorProto?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableMethodDescriptorProto =
      MethodDescriptorProtoImpl().apply {
    mergeWith(this@MethodDescriptorProtoImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearInputType()
    this.clearOutputType()
    this.clearOptions()
    this.clearClientStreaming()
    this.clearServerStreaming()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "input_type", "inputType" -> this.clearInputType()
    "output_type", "outputType" -> this.clearOutputType()
    "options" -> this.clearOptions()
    "client_streaming", "clientStreaming" -> this.clearClientStreaming()
    "server_streaming", "serverStreaming" -> this.clearServerStreaming()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearInputType()
    3 -> this.clearOutputType()
    4 -> this.clearOptions()
    5 -> this.clearClientStreaming()
    6 -> this.clearServerStreaming()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "input_type", "inputType" -> this.inputType.uncheckedCast()
    "output_type", "outputType" -> this.outputType.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "client_streaming", "clientStreaming" -> this.clientStreaming.uncheckedCast()
    "server_streaming", "serverStreaming" -> this.serverStreaming.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.inputType.uncheckedCast()
    3 -> this.outputType.uncheckedCast()
    4 -> this.options.uncheckedCast()
    5 -> this.clientStreaming.uncheckedCast()
    6 -> this.serverStreaming.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "input_type", "inputType" -> this.inputType = value.uncheckedCast()
      "output_type", "outputType" -> this.outputType = value.uncheckedCast()
      "options" -> this.options = value.uncheckedCast()
      "client_streaming", "clientStreaming" -> this.clientStreaming = value.uncheckedCast()
      "server_streaming", "serverStreaming" -> this.serverStreaming = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.inputType = value.uncheckedCast()
      3 -> this.outputType = value.uncheckedCast()
      4 -> this.options = value.uncheckedCast()
      5 -> this.clientStreaming = value.uncheckedCast()
      6 -> this.serverStreaming = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "input_type", "inputType" -> this.hasInputType()
    "output_type", "outputType" -> this.hasOutputType()
    "options" -> this.hasOptions()
    "client_streaming", "clientStreaming" -> this.hasClientStreaming()
    "server_streaming", "serverStreaming" -> this.hasServerStreaming()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasInputType()
    3 -> this.hasOutputType()
    4 -> this.hasOptions()
    5 -> this.hasClientStreaming()
    6 -> this.hasServerStreaming()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: MethodDescriptorProto): Boolean {
    if (name != other.name) return false
    if (inputType != other.inputType) return false
    if (outputType != other.outputType) return false
    if (options != other.options) return false
    if (clientStreaming != other.clientStreaming) return false
    if (serverStreaming != other.serverStreaming) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasInputType()) {
      result = result * 37 + 2
      result = result * 31 + this.inputType.hashCode()
    }
    if (hasOutputType()) {
      result = result * 37 + 3
      result = result * 31 + this.outputType.hashCode()
    }
    if (hasOptions()) {
      result = result * 37 + 4
      result = result * 31 + this.options!!.hashCode()
    }
    if (hasClientStreaming()) {
      result = result * 37 + 5
      result = result * 31 + this.clientStreaming.hashCode()
    }
    if (hasServerStreaming()) {
      result = result * 37 + 6
      result = result * 31 + this.serverStreaming.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasInputType()) {
      writer.tag(18).string(this.inputType)
    }
    if (hasOutputType()) {
      writer.tag(26).string(this.outputType)
    }
    if (hasOptions()) {
      writer.tag(34).message(this.options)
    }
    if (hasClientStreaming()) {
      writer.tag(40).bool(this.clientStreaming)
    }
    if (hasServerStreaming()) {
      writer.tag(48).bool(this.serverStreaming)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.inputType = reader.string()
      3 -> this.outputType = reader.string()
      4 -> this.options = MethodOptions.newMutable().apply { readFrom(reader) }
      5 -> this.clientStreaming = reader.bool()
      6 -> this.serverStreaming = reader.bool()
      else -> return false
    }
    return true
  }
}

public open class MethodDescriptorProtoSupport internal constructor() :
    MessageSupport<MethodDescriptorProto, MutableMethodDescriptorProto>() {
  public override val name: String
    get() = ".google.protobuf.MethodDescriptorProto"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "MethodDescriptorProto" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableMethodDescriptorProto = MethodDescriptorProtoImpl()
}

public interface MutableFileOptions : MutableMessage<FileOptions, MutableFileOptions>, FileOptions {
  public override var javaPackage: String

  public override var javaOuterClassname: String

  public override var javaMultipleFiles: Boolean

  @Deprecated(message = "javaGenerateEqualsAndHash has been marked as deprecated")
  public override var javaGenerateEqualsAndHash: Boolean

  public override var javaStringCheckUtf8: Boolean

  public override var optimizeFor: FileOptions.OptimizeMode

  public override var goPackage: String

  public override var ccGenericServices: Boolean

  public override var javaGenericServices: Boolean

  public override var pyGenericServices: Boolean

  public override var phpGenericServices: Boolean

  public override var deprecated: Boolean

  public override var ccEnableArenas: Boolean

  public override var objcClassPrefix: String

  public override var csharpNamespace: String

  public override var swiftPrefix: String

  public override var phpClassPrefix: String

  public override var phpNamespace: String

  public override var phpMetadataNamespace: String

  public override var rubyPackage: String

  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearJavaPackage(): String?

  public fun clearJavaOuterClassname(): String?

  public fun clearJavaMultipleFiles(): Boolean?

  public fun clearJavaGenerateEqualsAndHash(): Boolean?

  public fun clearJavaStringCheckUtf8(): Boolean?

  public fun clearOptimizeFor(): FileOptions.OptimizeMode?

  public fun clearGoPackage(): String?

  public fun clearCcGenericServices(): Boolean?

  public fun clearJavaGenericServices(): Boolean?

  public fun clearPyGenericServices(): Boolean?

  public fun clearPhpGenericServices(): Boolean?

  public fun clearDeprecated(): Boolean?

  public fun clearCcEnableArenas(): Boolean?

  public fun clearObjcClassPrefix(): String?

  public fun clearCsharpNamespace(): String?

  public fun clearSwiftPrefix(): String?

  public fun clearPhpClassPrefix(): String?

  public fun clearPhpNamespace(): String?

  public fun clearPhpMetadataNamespace(): String?

  public fun clearRubyPackage(): String?

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class FileOptionsImpl : AbstractMutableMessage<FileOptions, MutableFileOptions>(),
    MutableFileOptions {
  private var _hasJavaPackage: Boolean = false

  public override var javaPackage: String = ""
    get() = if(_hasJavaPackage) field else ""
    set(`value`) {
      field = value
      _hasJavaPackage = true
    }

  private var _hasJavaOuterClassname: Boolean = false

  public override var javaOuterClassname: String = ""
    get() = if(_hasJavaOuterClassname) field else ""
    set(`value`) {
      field = value
      _hasJavaOuterClassname = true
    }

  private var _hasJavaMultipleFiles: Boolean = false

  public override var javaMultipleFiles: Boolean = false
    get() = if(_hasJavaMultipleFiles) field else false
    set(`value`) {
      field = value
      _hasJavaMultipleFiles = true
    }

  private var _hasJavaGenerateEqualsAndHash: Boolean = false

  @Deprecated(message = "javaGenerateEqualsAndHash has been marked as deprecated")
  public override var javaGenerateEqualsAndHash: Boolean = false
    get() = if(_hasJavaGenerateEqualsAndHash) field else false
    set(`value`) {
      field = value
      _hasJavaGenerateEqualsAndHash = true
    }

  private var _hasJavaStringCheckUtf8: Boolean = false

  public override var javaStringCheckUtf8: Boolean = false
    get() = if(_hasJavaStringCheckUtf8) field else false
    set(`value`) {
      field = value
      _hasJavaStringCheckUtf8 = true
    }

  private var _hasOptimizeFor: Boolean = false

  public override var optimizeFor: FileOptions.OptimizeMode = FileOptions.OptimizeMode()
    get() = if(_hasOptimizeFor) field else FileOptions.OptimizeMode()
    set(`value`) {
      field = value
      _hasOptimizeFor = true
    }

  private var _hasGoPackage: Boolean = false

  public override var goPackage: String = ""
    get() = if(_hasGoPackage) field else ""
    set(`value`) {
      field = value
      _hasGoPackage = true
    }

  private var _hasCcGenericServices: Boolean = false

  public override var ccGenericServices: Boolean = false
    get() = if(_hasCcGenericServices) field else false
    set(`value`) {
      field = value
      _hasCcGenericServices = true
    }

  private var _hasJavaGenericServices: Boolean = false

  public override var javaGenericServices: Boolean = false
    get() = if(_hasJavaGenericServices) field else false
    set(`value`) {
      field = value
      _hasJavaGenericServices = true
    }

  private var _hasPyGenericServices: Boolean = false

  public override var pyGenericServices: Boolean = false
    get() = if(_hasPyGenericServices) field else false
    set(`value`) {
      field = value
      _hasPyGenericServices = true
    }

  private var _hasPhpGenericServices: Boolean = false

  public override var phpGenericServices: Boolean = false
    get() = if(_hasPhpGenericServices) field else false
    set(`value`) {
      field = value
      _hasPhpGenericServices = true
    }

  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  private var _hasCcEnableArenas: Boolean = false

  public override var ccEnableArenas: Boolean = false
    get() = if(_hasCcEnableArenas) field else false
    set(`value`) {
      field = value
      _hasCcEnableArenas = true
    }

  private var _hasObjcClassPrefix: Boolean = false

  public override var objcClassPrefix: String = ""
    get() = if(_hasObjcClassPrefix) field else ""
    set(`value`) {
      field = value
      _hasObjcClassPrefix = true
    }

  private var _hasCsharpNamespace: Boolean = false

  public override var csharpNamespace: String = ""
    get() = if(_hasCsharpNamespace) field else ""
    set(`value`) {
      field = value
      _hasCsharpNamespace = true
    }

  private var _hasSwiftPrefix: Boolean = false

  public override var swiftPrefix: String = ""
    get() = if(_hasSwiftPrefix) field else ""
    set(`value`) {
      field = value
      _hasSwiftPrefix = true
    }

  private var _hasPhpClassPrefix: Boolean = false

  public override var phpClassPrefix: String = ""
    get() = if(_hasPhpClassPrefix) field else ""
    set(`value`) {
      field = value
      _hasPhpClassPrefix = true
    }

  private var _hasPhpNamespace: Boolean = false

  public override var phpNamespace: String = ""
    get() = if(_hasPhpNamespace) field else ""
    set(`value`) {
      field = value
      _hasPhpNamespace = true
    }

  private var _hasPhpMetadataNamespace: Boolean = false

  public override var phpMetadataNamespace: String = ""
    get() = if(_hasPhpMetadataNamespace) field else ""
    set(`value`) {
      field = value
      _hasPhpMetadataNamespace = true
    }

  private var _hasRubyPackage: Boolean = false

  public override var rubyPackage: String = ""
    get() = if(_hasRubyPackage) field else ""
    set(`value`) {
      field = value
      _hasRubyPackage = true
    }

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasJavaPackage(): Boolean = _hasJavaPackage

  public override fun clearJavaPackage(): String? {
    if (!hasJavaPackage()) return null
    return javaPackage.also {
      javaPackage = ""
      _hasJavaPackage = false
    }
  }

  public override fun hasJavaOuterClassname(): Boolean = _hasJavaOuterClassname

  public override fun clearJavaOuterClassname(): String? {
    if (!hasJavaOuterClassname()) return null
    return javaOuterClassname.also {
      javaOuterClassname = ""
      _hasJavaOuterClassname = false
    }
  }

  public override fun hasJavaMultipleFiles(): Boolean = _hasJavaMultipleFiles

  public override fun clearJavaMultipleFiles(): Boolean? {
    if (!hasJavaMultipleFiles()) return null
    return javaMultipleFiles.also {
      javaMultipleFiles = false
      _hasJavaMultipleFiles = false
    }
  }

  public override fun hasJavaGenerateEqualsAndHash(): Boolean = _hasJavaGenerateEqualsAndHash

  public override fun clearJavaGenerateEqualsAndHash(): Boolean? {
    if (!hasJavaGenerateEqualsAndHash()) return null
    return javaGenerateEqualsAndHash.also {
      javaGenerateEqualsAndHash = false
      _hasJavaGenerateEqualsAndHash = false
    }
  }

  public override fun hasJavaStringCheckUtf8(): Boolean = _hasJavaStringCheckUtf8

  public override fun clearJavaStringCheckUtf8(): Boolean? {
    if (!hasJavaStringCheckUtf8()) return null
    return javaStringCheckUtf8.also {
      javaStringCheckUtf8 = false
      _hasJavaStringCheckUtf8 = false
    }
  }

  public override fun hasOptimizeFor(): Boolean = _hasOptimizeFor

  public override fun clearOptimizeFor(): FileOptions.OptimizeMode? {
    if (!hasOptimizeFor()) return null
    return optimizeFor.also {
      optimizeFor = FileOptions.OptimizeMode()
      _hasOptimizeFor = false
    }
  }

  public override fun hasGoPackage(): Boolean = _hasGoPackage

  public override fun clearGoPackage(): String? {
    if (!hasGoPackage()) return null
    return goPackage.also {
      goPackage = ""
      _hasGoPackage = false
    }
  }

  public override fun hasCcGenericServices(): Boolean = _hasCcGenericServices

  public override fun clearCcGenericServices(): Boolean? {
    if (!hasCcGenericServices()) return null
    return ccGenericServices.also {
      ccGenericServices = false
      _hasCcGenericServices = false
    }
  }

  public override fun hasJavaGenericServices(): Boolean = _hasJavaGenericServices

  public override fun clearJavaGenericServices(): Boolean? {
    if (!hasJavaGenericServices()) return null
    return javaGenericServices.also {
      javaGenericServices = false
      _hasJavaGenericServices = false
    }
  }

  public override fun hasPyGenericServices(): Boolean = _hasPyGenericServices

  public override fun clearPyGenericServices(): Boolean? {
    if (!hasPyGenericServices()) return null
    return pyGenericServices.also {
      pyGenericServices = false
      _hasPyGenericServices = false
    }
  }

  public override fun hasPhpGenericServices(): Boolean = _hasPhpGenericServices

  public override fun clearPhpGenericServices(): Boolean? {
    if (!hasPhpGenericServices()) return null
    return phpGenericServices.also {
      phpGenericServices = false
      _hasPhpGenericServices = false
    }
  }

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasCcEnableArenas(): Boolean = _hasCcEnableArenas

  public override fun clearCcEnableArenas(): Boolean? {
    if (!hasCcEnableArenas()) return null
    return ccEnableArenas.also {
      ccEnableArenas = false
      _hasCcEnableArenas = false
    }
  }

  public override fun hasObjcClassPrefix(): Boolean = _hasObjcClassPrefix

  public override fun clearObjcClassPrefix(): String? {
    if (!hasObjcClassPrefix()) return null
    return objcClassPrefix.also {
      objcClassPrefix = ""
      _hasObjcClassPrefix = false
    }
  }

  public override fun hasCsharpNamespace(): Boolean = _hasCsharpNamespace

  public override fun clearCsharpNamespace(): String? {
    if (!hasCsharpNamespace()) return null
    return csharpNamespace.also {
      csharpNamespace = ""
      _hasCsharpNamespace = false
    }
  }

  public override fun hasSwiftPrefix(): Boolean = _hasSwiftPrefix

  public override fun clearSwiftPrefix(): String? {
    if (!hasSwiftPrefix()) return null
    return swiftPrefix.also {
      swiftPrefix = ""
      _hasSwiftPrefix = false
    }
  }

  public override fun hasPhpClassPrefix(): Boolean = _hasPhpClassPrefix

  public override fun clearPhpClassPrefix(): String? {
    if (!hasPhpClassPrefix()) return null
    return phpClassPrefix.also {
      phpClassPrefix = ""
      _hasPhpClassPrefix = false
    }
  }

  public override fun hasPhpNamespace(): Boolean = _hasPhpNamespace

  public override fun clearPhpNamespace(): String? {
    if (!hasPhpNamespace()) return null
    return phpNamespace.also {
      phpNamespace = ""
      _hasPhpNamespace = false
    }
  }

  public override fun hasPhpMetadataNamespace(): Boolean = _hasPhpMetadataNamespace

  public override fun clearPhpMetadataNamespace(): String? {
    if (!hasPhpMetadataNamespace()) return null
    return phpMetadataNamespace.also {
      phpMetadataNamespace = ""
      _hasPhpMetadataNamespace = false
    }
  }

  public override fun hasRubyPackage(): Boolean = _hasRubyPackage

  public override fun clearRubyPackage(): String? {
    if (!hasRubyPackage()) return null
    return rubyPackage.also {
      rubyPackage = ""
      _hasRubyPackage = false
    }
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<FileOptions, MutableFileOptions> = FileOptions

  public override fun mergeWith(other: FileOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFileOptions = FileOptionsImpl().apply {
    mergeWith(this@FileOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearJavaPackage()
    this.clearJavaOuterClassname()
    this.clearJavaMultipleFiles()
    this.clearJavaGenerateEqualsAndHash()
    this.clearJavaStringCheckUtf8()
    this.clearOptimizeFor()
    this.clearGoPackage()
    this.clearCcGenericServices()
    this.clearJavaGenericServices()
    this.clearPyGenericServices()
    this.clearPhpGenericServices()
    this.clearDeprecated()
    this.clearCcEnableArenas()
    this.clearObjcClassPrefix()
    this.clearCsharpNamespace()
    this.clearSwiftPrefix()
    this.clearPhpClassPrefix()
    this.clearPhpNamespace()
    this.clearPhpMetadataNamespace()
    this.clearRubyPackage()
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "java_package", "javaPackage" -> this.clearJavaPackage()
    "java_outer_classname", "javaOuterClassname" -> this.clearJavaOuterClassname()
    "java_multiple_files", "javaMultipleFiles" -> this.clearJavaMultipleFiles()
    "java_generate_equals_and_hash", "javaGenerateEqualsAndHash" ->
        this.clearJavaGenerateEqualsAndHash()
    "java_string_check_utf8", "javaStringCheckUtf8" -> this.clearJavaStringCheckUtf8()
    "optimize_for", "optimizeFor" -> this.clearOptimizeFor()
    "go_package", "goPackage" -> this.clearGoPackage()
    "cc_generic_services", "ccGenericServices" -> this.clearCcGenericServices()
    "java_generic_services", "javaGenericServices" -> this.clearJavaGenericServices()
    "py_generic_services", "pyGenericServices" -> this.clearPyGenericServices()
    "php_generic_services", "phpGenericServices" -> this.clearPhpGenericServices()
    "deprecated" -> this.clearDeprecated()
    "cc_enable_arenas", "ccEnableArenas" -> this.clearCcEnableArenas()
    "objc_class_prefix", "objcClassPrefix" -> this.clearObjcClassPrefix()
    "csharp_namespace", "csharpNamespace" -> this.clearCsharpNamespace()
    "swift_prefix", "swiftPrefix" -> this.clearSwiftPrefix()
    "php_class_prefix", "phpClassPrefix" -> this.clearPhpClassPrefix()
    "php_namespace", "phpNamespace" -> this.clearPhpNamespace()
    "php_metadata_namespace", "phpMetadataNamespace" -> this.clearPhpMetadataNamespace()
    "ruby_package", "rubyPackage" -> this.clearRubyPackage()
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearJavaPackage()
    8 -> this.clearJavaOuterClassname()
    10 -> this.clearJavaMultipleFiles()
    20 -> this.clearJavaGenerateEqualsAndHash()
    27 -> this.clearJavaStringCheckUtf8()
    9 -> this.clearOptimizeFor()
    11 -> this.clearGoPackage()
    16 -> this.clearCcGenericServices()
    17 -> this.clearJavaGenericServices()
    18 -> this.clearPyGenericServices()
    42 -> this.clearPhpGenericServices()
    23 -> this.clearDeprecated()
    31 -> this.clearCcEnableArenas()
    36 -> this.clearObjcClassPrefix()
    37 -> this.clearCsharpNamespace()
    39 -> this.clearSwiftPrefix()
    40 -> this.clearPhpClassPrefix()
    41 -> this.clearPhpNamespace()
    44 -> this.clearPhpMetadataNamespace()
    45 -> this.clearRubyPackage()
    50 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "java_package", "javaPackage" -> this.javaPackage.uncheckedCast()
    "java_outer_classname", "javaOuterClassname" -> this.javaOuterClassname.uncheckedCast()
    "java_multiple_files", "javaMultipleFiles" -> this.javaMultipleFiles.uncheckedCast()
    "java_generate_equals_and_hash", "javaGenerateEqualsAndHash" ->
        this.javaGenerateEqualsAndHash.uncheckedCast()
    "java_string_check_utf8", "javaStringCheckUtf8" -> this.javaStringCheckUtf8.uncheckedCast()
    "optimize_for", "optimizeFor" -> this.optimizeFor.uncheckedCast()
    "go_package", "goPackage" -> this.goPackage.uncheckedCast()
    "cc_generic_services", "ccGenericServices" -> this.ccGenericServices.uncheckedCast()
    "java_generic_services", "javaGenericServices" -> this.javaGenericServices.uncheckedCast()
    "py_generic_services", "pyGenericServices" -> this.pyGenericServices.uncheckedCast()
    "php_generic_services", "phpGenericServices" -> this.phpGenericServices.uncheckedCast()
    "deprecated" -> this.deprecated.uncheckedCast()
    "cc_enable_arenas", "ccEnableArenas" -> this.ccEnableArenas.uncheckedCast()
    "objc_class_prefix", "objcClassPrefix" -> this.objcClassPrefix.uncheckedCast()
    "csharp_namespace", "csharpNamespace" -> this.csharpNamespace.uncheckedCast()
    "swift_prefix", "swiftPrefix" -> this.swiftPrefix.uncheckedCast()
    "php_class_prefix", "phpClassPrefix" -> this.phpClassPrefix.uncheckedCast()
    "php_namespace", "phpNamespace" -> this.phpNamespace.uncheckedCast()
    "php_metadata_namespace", "phpMetadataNamespace" -> this.phpMetadataNamespace.uncheckedCast()
    "ruby_package", "rubyPackage" -> this.rubyPackage.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.javaPackage.uncheckedCast()
    8 -> this.javaOuterClassname.uncheckedCast()
    10 -> this.javaMultipleFiles.uncheckedCast()
    20 -> this.javaGenerateEqualsAndHash.uncheckedCast()
    27 -> this.javaStringCheckUtf8.uncheckedCast()
    9 -> this.optimizeFor.uncheckedCast()
    11 -> this.goPackage.uncheckedCast()
    16 -> this.ccGenericServices.uncheckedCast()
    17 -> this.javaGenericServices.uncheckedCast()
    18 -> this.pyGenericServices.uncheckedCast()
    42 -> this.phpGenericServices.uncheckedCast()
    23 -> this.deprecated.uncheckedCast()
    31 -> this.ccEnableArenas.uncheckedCast()
    36 -> this.objcClassPrefix.uncheckedCast()
    37 -> this.csharpNamespace.uncheckedCast()
    39 -> this.swiftPrefix.uncheckedCast()
    40 -> this.phpClassPrefix.uncheckedCast()
    41 -> this.phpNamespace.uncheckedCast()
    44 -> this.phpMetadataNamespace.uncheckedCast()
    45 -> this.rubyPackage.uncheckedCast()
    50 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "java_package", "javaPackage" -> this.javaPackage = value.uncheckedCast()
      "java_outer_classname", "javaOuterClassname" ->
          this.javaOuterClassname = value.uncheckedCast()
      "java_multiple_files", "javaMultipleFiles" -> this.javaMultipleFiles = value.uncheckedCast()
      "java_generate_equals_and_hash", "javaGenerateEqualsAndHash" ->
          this.javaGenerateEqualsAndHash = value.uncheckedCast()
      "java_string_check_utf8", "javaStringCheckUtf8" ->
          this.javaStringCheckUtf8 = value.uncheckedCast()
      "optimize_for", "optimizeFor" -> this.optimizeFor = value.uncheckedCast()
      "go_package", "goPackage" -> this.goPackage = value.uncheckedCast()
      "cc_generic_services", "ccGenericServices" -> this.ccGenericServices = value.uncheckedCast()
      "java_generic_services", "javaGenericServices" ->
          this.javaGenericServices = value.uncheckedCast()
      "py_generic_services", "pyGenericServices" -> this.pyGenericServices = value.uncheckedCast()
      "php_generic_services", "phpGenericServices" ->
          this.phpGenericServices = value.uncheckedCast()
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "cc_enable_arenas", "ccEnableArenas" -> this.ccEnableArenas = value.uncheckedCast()
      "objc_class_prefix", "objcClassPrefix" -> this.objcClassPrefix = value.uncheckedCast()
      "csharp_namespace", "csharpNamespace" -> this.csharpNamespace = value.uncheckedCast()
      "swift_prefix", "swiftPrefix" -> this.swiftPrefix = value.uncheckedCast()
      "php_class_prefix", "phpClassPrefix" -> this.phpClassPrefix = value.uncheckedCast()
      "php_namespace", "phpNamespace" -> this.phpNamespace = value.uncheckedCast()
      "php_metadata_namespace", "phpMetadataNamespace" ->
          this.phpMetadataNamespace = value.uncheckedCast()
      "ruby_package", "rubyPackage" -> this.rubyPackage = value.uncheckedCast()
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.javaPackage = value.uncheckedCast()
      8 -> this.javaOuterClassname = value.uncheckedCast()
      10 -> this.javaMultipleFiles = value.uncheckedCast()
      20 -> this.javaGenerateEqualsAndHash = value.uncheckedCast()
      27 -> this.javaStringCheckUtf8 = value.uncheckedCast()
      9 -> this.optimizeFor = value.uncheckedCast()
      11 -> this.goPackage = value.uncheckedCast()
      16 -> this.ccGenericServices = value.uncheckedCast()
      17 -> this.javaGenericServices = value.uncheckedCast()
      18 -> this.pyGenericServices = value.uncheckedCast()
      42 -> this.phpGenericServices = value.uncheckedCast()
      23 -> this.deprecated = value.uncheckedCast()
      31 -> this.ccEnableArenas = value.uncheckedCast()
      36 -> this.objcClassPrefix = value.uncheckedCast()
      37 -> this.csharpNamespace = value.uncheckedCast()
      39 -> this.swiftPrefix = value.uncheckedCast()
      40 -> this.phpClassPrefix = value.uncheckedCast()
      41 -> this.phpNamespace = value.uncheckedCast()
      44 -> this.phpMetadataNamespace = value.uncheckedCast()
      45 -> this.rubyPackage = value.uncheckedCast()
      50 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "java_package", "javaPackage" -> this.hasJavaPackage()
    "java_outer_classname", "javaOuterClassname" -> this.hasJavaOuterClassname()
    "java_multiple_files", "javaMultipleFiles" -> this.hasJavaMultipleFiles()
    "java_generate_equals_and_hash", "javaGenerateEqualsAndHash" ->
        this.hasJavaGenerateEqualsAndHash()
    "java_string_check_utf8", "javaStringCheckUtf8" -> this.hasJavaStringCheckUtf8()
    "optimize_for", "optimizeFor" -> this.hasOptimizeFor()
    "go_package", "goPackage" -> this.hasGoPackage()
    "cc_generic_services", "ccGenericServices" -> this.hasCcGenericServices()
    "java_generic_services", "javaGenericServices" -> this.hasJavaGenericServices()
    "py_generic_services", "pyGenericServices" -> this.hasPyGenericServices()
    "php_generic_services", "phpGenericServices" -> this.hasPhpGenericServices()
    "deprecated" -> this.hasDeprecated()
    "cc_enable_arenas", "ccEnableArenas" -> this.hasCcEnableArenas()
    "objc_class_prefix", "objcClassPrefix" -> this.hasObjcClassPrefix()
    "csharp_namespace", "csharpNamespace" -> this.hasCsharpNamespace()
    "swift_prefix", "swiftPrefix" -> this.hasSwiftPrefix()
    "php_class_prefix", "phpClassPrefix" -> this.hasPhpClassPrefix()
    "php_namespace", "phpNamespace" -> this.hasPhpNamespace()
    "php_metadata_namespace", "phpMetadataNamespace" -> this.hasPhpMetadataNamespace()
    "ruby_package", "rubyPackage" -> this.hasRubyPackage()
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasJavaPackage()
    8 -> this.hasJavaOuterClassname()
    10 -> this.hasJavaMultipleFiles()
    20 -> this.hasJavaGenerateEqualsAndHash()
    27 -> this.hasJavaStringCheckUtf8()
    9 -> this.hasOptimizeFor()
    11 -> this.hasGoPackage()
    16 -> this.hasCcGenericServices()
    17 -> this.hasJavaGenericServices()
    18 -> this.hasPyGenericServices()
    42 -> this.hasPhpGenericServices()
    23 -> this.hasDeprecated()
    31 -> this.hasCcEnableArenas()
    36 -> this.hasObjcClassPrefix()
    37 -> this.hasCsharpNamespace()
    39 -> this.hasSwiftPrefix()
    40 -> this.hasPhpClassPrefix()
    41 -> this.hasPhpNamespace()
    44 -> this.hasPhpMetadataNamespace()
    45 -> this.hasRubyPackage()
    50 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FileOptions): Boolean {
    if (javaPackage != other.javaPackage) return false
    if (javaOuterClassname != other.javaOuterClassname) return false
    if (javaMultipleFiles != other.javaMultipleFiles) return false
    if (javaGenerateEqualsAndHash != other.javaGenerateEqualsAndHash) return false
    if (javaStringCheckUtf8 != other.javaStringCheckUtf8) return false
    if (optimizeFor != other.optimizeFor) return false
    if (goPackage != other.goPackage) return false
    if (ccGenericServices != other.ccGenericServices) return false
    if (javaGenericServices != other.javaGenericServices) return false
    if (pyGenericServices != other.pyGenericServices) return false
    if (phpGenericServices != other.phpGenericServices) return false
    if (deprecated != other.deprecated) return false
    if (ccEnableArenas != other.ccEnableArenas) return false
    if (objcClassPrefix != other.objcClassPrefix) return false
    if (csharpNamespace != other.csharpNamespace) return false
    if (swiftPrefix != other.swiftPrefix) return false
    if (phpClassPrefix != other.phpClassPrefix) return false
    if (phpNamespace != other.phpNamespace) return false
    if (phpMetadataNamespace != other.phpMetadataNamespace) return false
    if (rubyPackage != other.rubyPackage) return false
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasJavaPackage()) {
      result = result * 37 + 1
      result = result * 31 + this.javaPackage.hashCode()
    }
    if (hasJavaOuterClassname()) {
      result = result * 37 + 8
      result = result * 31 + this.javaOuterClassname.hashCode()
    }
    if (hasJavaMultipleFiles()) {
      result = result * 37 + 10
      result = result * 31 + this.javaMultipleFiles.hashCode()
    }
    if (hasJavaGenerateEqualsAndHash()) {
      result = result * 37 + 20
      result = result * 31 + this.javaGenerateEqualsAndHash.hashCode()
    }
    if (hasJavaStringCheckUtf8()) {
      result = result * 37 + 27
      result = result * 31 + this.javaStringCheckUtf8.hashCode()
    }
    if (hasOptimizeFor()) {
      result = result * 37 + 9
      result = result * 31 + this.optimizeFor.hashCode()
    }
    if (hasGoPackage()) {
      result = result * 37 + 11
      result = result * 31 + this.goPackage.hashCode()
    }
    if (hasCcGenericServices()) {
      result = result * 37 + 16
      result = result * 31 + this.ccGenericServices.hashCode()
    }
    if (hasJavaGenericServices()) {
      result = result * 37 + 17
      result = result * 31 + this.javaGenericServices.hashCode()
    }
    if (hasPyGenericServices()) {
      result = result * 37 + 18
      result = result * 31 + this.pyGenericServices.hashCode()
    }
    if (hasPhpGenericServices()) {
      result = result * 37 + 42
      result = result * 31 + this.phpGenericServices.hashCode()
    }
    if (hasDeprecated()) {
      result = result * 37 + 23
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasCcEnableArenas()) {
      result = result * 37 + 31
      result = result * 31 + this.ccEnableArenas.hashCode()
    }
    if (hasObjcClassPrefix()) {
      result = result * 37 + 36
      result = result * 31 + this.objcClassPrefix.hashCode()
    }
    if (hasCsharpNamespace()) {
      result = result * 37 + 37
      result = result * 31 + this.csharpNamespace.hashCode()
    }
    if (hasSwiftPrefix()) {
      result = result * 37 + 39
      result = result * 31 + this.swiftPrefix.hashCode()
    }
    if (hasPhpClassPrefix()) {
      result = result * 37 + 40
      result = result * 31 + this.phpClassPrefix.hashCode()
    }
    if (hasPhpNamespace()) {
      result = result * 37 + 41
      result = result * 31 + this.phpNamespace.hashCode()
    }
    if (hasPhpMetadataNamespace()) {
      result = result * 37 + 44
      result = result * 31 + this.phpMetadataNamespace.hashCode()
    }
    if (hasRubyPackage()) {
      result = result * 37 + 45
      result = result * 31 + this.rubyPackage.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 50
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasJavaPackage()) {
      writer.tag(10).string(this.javaPackage)
    }
    if (hasJavaOuterClassname()) {
      writer.tag(66).string(this.javaOuterClassname)
    }
    if (hasJavaMultipleFiles()) {
      writer.tag(80).bool(this.javaMultipleFiles)
    }
    if (hasJavaGenerateEqualsAndHash()) {
      writer.tag(160).bool(this.javaGenerateEqualsAndHash)
    }
    if (hasJavaStringCheckUtf8()) {
      writer.tag(216).bool(this.javaStringCheckUtf8)
    }
    if (hasOptimizeFor()) {
      writer.tag(72).enum(this.optimizeFor)
    }
    if (hasGoPackage()) {
      writer.tag(90).string(this.goPackage)
    }
    if (hasCcGenericServices()) {
      writer.tag(128).bool(this.ccGenericServices)
    }
    if (hasJavaGenericServices()) {
      writer.tag(136).bool(this.javaGenericServices)
    }
    if (hasPyGenericServices()) {
      writer.tag(144).bool(this.pyGenericServices)
    }
    if (hasPhpGenericServices()) {
      writer.tag(336).bool(this.phpGenericServices)
    }
    if (hasDeprecated()) {
      writer.tag(184).bool(this.deprecated)
    }
    if (hasCcEnableArenas()) {
      writer.tag(248).bool(this.ccEnableArenas)
    }
    if (hasObjcClassPrefix()) {
      writer.tag(290).string(this.objcClassPrefix)
    }
    if (hasCsharpNamespace()) {
      writer.tag(298).string(this.csharpNamespace)
    }
    if (hasSwiftPrefix()) {
      writer.tag(314).string(this.swiftPrefix)
    }
    if (hasPhpClassPrefix()) {
      writer.tag(322).string(this.phpClassPrefix)
    }
    if (hasPhpNamespace()) {
      writer.tag(330).string(this.phpNamespace)
    }
    if (hasPhpMetadataNamespace()) {
      writer.tag(354).string(this.phpMetadataNamespace)
    }
    if (hasRubyPackage()) {
      writer.tag(362).string(this.rubyPackage)
    }
    if (hasFeatures()) {
      writer.tag(402).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.javaPackage = reader.string()
      8 -> this.javaOuterClassname = reader.string()
      10 -> this.javaMultipleFiles = reader.bool()
      20 -> this.javaGenerateEqualsAndHash = reader.bool()
      27 -> this.javaStringCheckUtf8 = reader.bool()
      9 -> this.optimizeFor = FileOptions.OptimizeMode(reader.int32())
      11 -> this.goPackage = reader.string()
      16 -> this.ccGenericServices = reader.bool()
      17 -> this.javaGenericServices = reader.bool()
      18 -> this.pyGenericServices = reader.bool()
      42 -> this.phpGenericServices = reader.bool()
      23 -> this.deprecated = reader.bool()
      31 -> this.ccEnableArenas = reader.bool()
      36 -> this.objcClassPrefix = reader.string()
      37 -> this.csharpNamespace = reader.string()
      39 -> this.swiftPrefix = reader.string()
      40 -> this.phpClassPrefix = reader.string()
      41 -> this.phpNamespace = reader.string()
      44 -> this.phpMetadataNamespace = reader.string()
      45 -> this.rubyPackage = reader.string()
      50 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class FileOptionsSupport internal constructor() :
    MessageSupport<FileOptions, MutableFileOptions>() {
  public override val name: String
    get() = ".google.protobuf.FileOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FileOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFileOptions = FileOptionsImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FileOptions.OptimizeMode)

  public abstract class OptimizeModeSupport internal constructor() :
      EnumSupport<FileOptions.OptimizeMode>() {
    public override val name: String
      get() = ".google.protobuf.FileOptions.OptimizeMode"

    public override val parent: FileOptions.Companion
      get() = FileOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      FileOptions.descriptor.enumType.first{ it.name == "OptimizeMode" }
    }


    public override fun values(): Array<FileOptions.OptimizeMode> =
        FileOptions.OptimizeMode.values()
  }
}

public interface MutableMessageOptions : MutableMessage<MessageOptions, MutableMessageOptions>,
    MessageOptions {
  public override var messageSetWireFormat: Boolean

  public override var noStandardDescriptorAccessor: Boolean

  public override var deprecated: Boolean

  public override var mapEntry: Boolean

  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public override var deprecatedLegacyJsonFieldConflicts: Boolean

  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearMessageSetWireFormat(): Boolean?

  public fun clearNoStandardDescriptorAccessor(): Boolean?

  public fun clearDeprecated(): Boolean?

  public fun clearMapEntry(): Boolean?

  public fun clearDeprecatedLegacyJsonFieldConflicts(): Boolean?

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class MessageOptionsImpl : AbstractMutableMessage<MessageOptions, MutableMessageOptions>(),
    MutableMessageOptions {
  private var _hasMessageSetWireFormat: Boolean = false

  public override var messageSetWireFormat: Boolean = false
    get() = if(_hasMessageSetWireFormat) field else false
    set(`value`) {
      field = value
      _hasMessageSetWireFormat = true
    }

  private var _hasNoStandardDescriptorAccessor: Boolean = false

  public override var noStandardDescriptorAccessor: Boolean = false
    get() = if(_hasNoStandardDescriptorAccessor) field else false
    set(`value`) {
      field = value
      _hasNoStandardDescriptorAccessor = true
    }

  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  private var _hasMapEntry: Boolean = false

  public override var mapEntry: Boolean = false
    get() = if(_hasMapEntry) field else false
    set(`value`) {
      field = value
      _hasMapEntry = true
    }

  private var _hasDeprecatedLegacyJsonFieldConflicts: Boolean = false

  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public override var deprecatedLegacyJsonFieldConflicts: Boolean = false
    get() = if(_hasDeprecatedLegacyJsonFieldConflicts) field else false
    set(`value`) {
      field = value
      _hasDeprecatedLegacyJsonFieldConflicts = true
    }

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasMessageSetWireFormat(): Boolean = _hasMessageSetWireFormat

  public override fun clearMessageSetWireFormat(): Boolean? {
    if (!hasMessageSetWireFormat()) return null
    return messageSetWireFormat.also {
      messageSetWireFormat = false
      _hasMessageSetWireFormat = false
    }
  }

  public override fun hasNoStandardDescriptorAccessor(): Boolean = _hasNoStandardDescriptorAccessor

  public override fun clearNoStandardDescriptorAccessor(): Boolean? {
    if (!hasNoStandardDescriptorAccessor()) return null
    return noStandardDescriptorAccessor.also {
      noStandardDescriptorAccessor = false
      _hasNoStandardDescriptorAccessor = false
    }
  }

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasMapEntry(): Boolean = _hasMapEntry

  public override fun clearMapEntry(): Boolean? {
    if (!hasMapEntry()) return null
    return mapEntry.also {
      mapEntry = false
      _hasMapEntry = false
    }
  }

  public override fun hasDeprecatedLegacyJsonFieldConflicts(): Boolean =
      _hasDeprecatedLegacyJsonFieldConflicts

  public override fun clearDeprecatedLegacyJsonFieldConflicts(): Boolean? {
    if (!hasDeprecatedLegacyJsonFieldConflicts()) return null
    return deprecatedLegacyJsonFieldConflicts.also {
      deprecatedLegacyJsonFieldConflicts = false
      _hasDeprecatedLegacyJsonFieldConflicts = false
    }
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<MessageOptions, MutableMessageOptions> =
      MessageOptions

  public override fun mergeWith(other: MessageOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableMessageOptions = MessageOptionsImpl().apply {
    mergeWith(this@MessageOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearMessageSetWireFormat()
    this.clearNoStandardDescriptorAccessor()
    this.clearDeprecated()
    this.clearMapEntry()
    this.clearDeprecatedLegacyJsonFieldConflicts()
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "message_set_wire_format", "messageSetWireFormat" -> this.clearMessageSetWireFormat()
    "no_standard_descriptor_accessor", "noStandardDescriptorAccessor" ->
        this.clearNoStandardDescriptorAccessor()
    "deprecated" -> this.clearDeprecated()
    "map_entry", "mapEntry" -> this.clearMapEntry()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.clearDeprecatedLegacyJsonFieldConflicts()
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearMessageSetWireFormat()
    2 -> this.clearNoStandardDescriptorAccessor()
    3 -> this.clearDeprecated()
    7 -> this.clearMapEntry()
    11 -> this.clearDeprecatedLegacyJsonFieldConflicts()
    12 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "message_set_wire_format", "messageSetWireFormat" -> this.messageSetWireFormat.uncheckedCast()
    "no_standard_descriptor_accessor", "noStandardDescriptorAccessor" ->
        this.noStandardDescriptorAccessor.uncheckedCast()
    "deprecated" -> this.deprecated.uncheckedCast()
    "map_entry", "mapEntry" -> this.mapEntry.uncheckedCast()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.deprecatedLegacyJsonFieldConflicts.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.messageSetWireFormat.uncheckedCast()
    2 -> this.noStandardDescriptorAccessor.uncheckedCast()
    3 -> this.deprecated.uncheckedCast()
    7 -> this.mapEntry.uncheckedCast()
    11 -> this.deprecatedLegacyJsonFieldConflicts.uncheckedCast()
    12 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "message_set_wire_format", "messageSetWireFormat" ->
          this.messageSetWireFormat = value.uncheckedCast()
      "no_standard_descriptor_accessor", "noStandardDescriptorAccessor" ->
          this.noStandardDescriptorAccessor = value.uncheckedCast()
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "map_entry", "mapEntry" -> this.mapEntry = value.uncheckedCast()
      "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
          this.deprecatedLegacyJsonFieldConflicts = value.uncheckedCast()
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.messageSetWireFormat = value.uncheckedCast()
      2 -> this.noStandardDescriptorAccessor = value.uncheckedCast()
      3 -> this.deprecated = value.uncheckedCast()
      7 -> this.mapEntry = value.uncheckedCast()
      11 -> this.deprecatedLegacyJsonFieldConflicts = value.uncheckedCast()
      12 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "message_set_wire_format", "messageSetWireFormat" -> this.hasMessageSetWireFormat()
    "no_standard_descriptor_accessor", "noStandardDescriptorAccessor" ->
        this.hasNoStandardDescriptorAccessor()
    "deprecated" -> this.hasDeprecated()
    "map_entry", "mapEntry" -> this.hasMapEntry()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.hasDeprecatedLegacyJsonFieldConflicts()
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasMessageSetWireFormat()
    2 -> this.hasNoStandardDescriptorAccessor()
    3 -> this.hasDeprecated()
    7 -> this.hasMapEntry()
    11 -> this.hasDeprecatedLegacyJsonFieldConflicts()
    12 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: MessageOptions): Boolean {
    if (messageSetWireFormat != other.messageSetWireFormat) return false
    if (noStandardDescriptorAccessor != other.noStandardDescriptorAccessor) return false
    if (deprecated != other.deprecated) return false
    if (mapEntry != other.mapEntry) return false
    if (deprecatedLegacyJsonFieldConflicts != other.deprecatedLegacyJsonFieldConflicts) return false
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasMessageSetWireFormat()) {
      result = result * 37 + 1
      result = result * 31 + this.messageSetWireFormat.hashCode()
    }
    if (hasNoStandardDescriptorAccessor()) {
      result = result * 37 + 2
      result = result * 31 + this.noStandardDescriptorAccessor.hashCode()
    }
    if (hasDeprecated()) {
      result = result * 37 + 3
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasMapEntry()) {
      result = result * 37 + 7
      result = result * 31 + this.mapEntry.hashCode()
    }
    if (hasDeprecatedLegacyJsonFieldConflicts()) {
      result = result * 37 + 11
      result = result * 31 + this.deprecatedLegacyJsonFieldConflicts.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 12
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasMessageSetWireFormat()) {
      writer.tag(8).bool(this.messageSetWireFormat)
    }
    if (hasNoStandardDescriptorAccessor()) {
      writer.tag(16).bool(this.noStandardDescriptorAccessor)
    }
    if (hasDeprecated()) {
      writer.tag(24).bool(this.deprecated)
    }
    if (hasMapEntry()) {
      writer.tag(56).bool(this.mapEntry)
    }
    if (hasDeprecatedLegacyJsonFieldConflicts()) {
      writer.tag(88).bool(this.deprecatedLegacyJsonFieldConflicts)
    }
    if (hasFeatures()) {
      writer.tag(98).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.messageSetWireFormat = reader.bool()
      2 -> this.noStandardDescriptorAccessor = reader.bool()
      3 -> this.deprecated = reader.bool()
      7 -> this.mapEntry = reader.bool()
      11 -> this.deprecatedLegacyJsonFieldConflicts = reader.bool()
      12 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class MessageOptionsSupport internal constructor() :
    MessageSupport<MessageOptions, MutableMessageOptions>() {
  public override val name: String
    get() = ".google.protobuf.MessageOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "MessageOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableMessageOptions = MessageOptionsImpl()
}

public interface MutableFieldOptions : MutableMessage<FieldOptions, MutableFieldOptions>,
    FieldOptions {
  public override var ctype: FieldOptions.CType

  public override var packed: Boolean

  public override var jstype: FieldOptions.JSType

  public override var lazy: Boolean

  public override var unverifiedLazy: Boolean

  public override var deprecated: Boolean

  public override var weak: Boolean

  public override var debugRedact: Boolean

  public override var retention: FieldOptions.OptionRetention

  public override val targets: MutableList<FieldOptions.OptionTargetType>

  public override val editionDefaults: MutableList<FieldOptions.EditionDefault>

  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearCtype(): FieldOptions.CType?

  public fun clearPacked(): Boolean?

  public fun clearJstype(): FieldOptions.JSType?

  public fun clearLazy(): Boolean?

  public fun clearUnverifiedLazy(): Boolean?

  public fun clearDeprecated(): Boolean?

  public fun clearWeak(): Boolean?

  public fun clearDebugRedact(): Boolean?

  public fun clearRetention(): FieldOptions.OptionRetention?

  public fun clearTargets(): List<FieldOptions.OptionTargetType>

  public fun clearEditionDefaults(): List<FieldOptions.EditionDefault>

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>

  public interface MutableEditionDefault :
      MutableMessage<FieldOptions.EditionDefault, MutableEditionDefault>,
      FieldOptions.EditionDefault {
    public override var edition: String

    public override var `value`: String

    public fun clearEdition(): String?

    public fun clearValue(): String?
  }
}

@InternalProtoApi
internal class FieldOptionsImpl : AbstractMutableMessage<FieldOptions, MutableFieldOptions>(),
    MutableFieldOptions {
  private var _hasCtype: Boolean = false

  public override var ctype: FieldOptions.CType = FieldOptions.CType()
    get() = if(_hasCtype) field else FieldOptions.CType()
    set(`value`) {
      field = value
      _hasCtype = true
    }

  private var _hasPacked: Boolean = false

  public override var packed: Boolean = false
    get() = if(_hasPacked) field else false
    set(`value`) {
      field = value
      _hasPacked = true
    }

  private var _hasJstype: Boolean = false

  public override var jstype: FieldOptions.JSType = FieldOptions.JSType()
    get() = if(_hasJstype) field else FieldOptions.JSType()
    set(`value`) {
      field = value
      _hasJstype = true
    }

  private var _hasLazy: Boolean = false

  public override var lazy: Boolean = false
    get() = if(_hasLazy) field else false
    set(`value`) {
      field = value
      _hasLazy = true
    }

  private var _hasUnverifiedLazy: Boolean = false

  public override var unverifiedLazy: Boolean = false
    get() = if(_hasUnverifiedLazy) field else false
    set(`value`) {
      field = value
      _hasUnverifiedLazy = true
    }

  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  private var _hasWeak: Boolean = false

  public override var weak: Boolean = false
    get() = if(_hasWeak) field else false
    set(`value`) {
      field = value
      _hasWeak = true
    }

  private var _hasDebugRedact: Boolean = false

  public override var debugRedact: Boolean = false
    get() = if(_hasDebugRedact) field else false
    set(`value`) {
      field = value
      _hasDebugRedact = true
    }

  private var _hasRetention: Boolean = false

  public override var retention: FieldOptions.OptionRetention = FieldOptions.OptionRetention()
    get() = if(_hasRetention) field else FieldOptions.OptionRetention()
    set(`value`) {
      field = value
      _hasRetention = true
    }

  public override val targets: MutableList<FieldOptions.OptionTargetType> = mutableListOf()

  public override val editionDefaults: MutableList<FieldOptions.EditionDefault> = mutableListOf()

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasCtype(): Boolean = _hasCtype

  public override fun clearCtype(): FieldOptions.CType? {
    if (!hasCtype()) return null
    return ctype.also {
      ctype = FieldOptions.CType()
      _hasCtype = false
    }
  }

  public override fun hasPacked(): Boolean = _hasPacked

  public override fun clearPacked(): Boolean? {
    if (!hasPacked()) return null
    return packed.also {
      packed = false
      _hasPacked = false
    }
  }

  public override fun hasJstype(): Boolean = _hasJstype

  public override fun clearJstype(): FieldOptions.JSType? {
    if (!hasJstype()) return null
    return jstype.also {
      jstype = FieldOptions.JSType()
      _hasJstype = false
    }
  }

  public override fun hasLazy(): Boolean = _hasLazy

  public override fun clearLazy(): Boolean? {
    if (!hasLazy()) return null
    return lazy.also {
      lazy = false
      _hasLazy = false
    }
  }

  public override fun hasUnverifiedLazy(): Boolean = _hasUnverifiedLazy

  public override fun clearUnverifiedLazy(): Boolean? {
    if (!hasUnverifiedLazy()) return null
    return unverifiedLazy.also {
      unverifiedLazy = false
      _hasUnverifiedLazy = false
    }
  }

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasWeak(): Boolean = _hasWeak

  public override fun clearWeak(): Boolean? {
    if (!hasWeak()) return null
    return weak.also {
      weak = false
      _hasWeak = false
    }
  }

  public override fun hasDebugRedact(): Boolean = _hasDebugRedact

  public override fun clearDebugRedact(): Boolean? {
    if (!hasDebugRedact()) return null
    return debugRedact.also {
      debugRedact = false
      _hasDebugRedact = false
    }
  }

  public override fun hasRetention(): Boolean = _hasRetention

  public override fun clearRetention(): FieldOptions.OptionRetention? {
    if (!hasRetention()) return null
    return retention.also {
      retention = FieldOptions.OptionRetention()
      _hasRetention = false
    }
  }

  public override fun hasTargets(): Boolean = targets.isNotEmpty()

  public override fun clearTargets(): List<FieldOptions.OptionTargetType> = targets.toList().also {
    targets.clear()
  }

  public override fun hasEditionDefaults(): Boolean = editionDefaults.isNotEmpty()

  public override fun clearEditionDefaults(): List<FieldOptions.EditionDefault> =
      editionDefaults.toList().also {
    editionDefaults.clear()
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<FieldOptions, MutableFieldOptions> = FieldOptions

  public override fun mergeWith(other: FieldOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFieldOptions = FieldOptionsImpl().apply {
    mergeWith(this@FieldOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearCtype()
    this.clearPacked()
    this.clearJstype()
    this.clearLazy()
    this.clearUnverifiedLazy()
    this.clearDeprecated()
    this.clearWeak()
    this.clearDebugRedact()
    this.clearRetention()
    this.clearTargets()
    this.clearEditionDefaults()
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "ctype" -> this.clearCtype()
    "packed" -> this.clearPacked()
    "jstype" -> this.clearJstype()
    "lazy" -> this.clearLazy()
    "unverified_lazy", "unverifiedLazy" -> this.clearUnverifiedLazy()
    "deprecated" -> this.clearDeprecated()
    "weak" -> this.clearWeak()
    "debug_redact", "debugRedact" -> this.clearDebugRedact()
    "retention" -> this.clearRetention()
    "targets" -> this.clearTargets()
    "edition_defaults", "editionDefaults" -> this.clearEditionDefaults()
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearCtype()
    2 -> this.clearPacked()
    6 -> this.clearJstype()
    5 -> this.clearLazy()
    15 -> this.clearUnverifiedLazy()
    3 -> this.clearDeprecated()
    10 -> this.clearWeak()
    16 -> this.clearDebugRedact()
    17 -> this.clearRetention()
    19 -> this.clearTargets()
    20 -> this.clearEditionDefaults()
    21 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "ctype" -> this.ctype.uncheckedCast()
    "packed" -> this.packed.uncheckedCast()
    "jstype" -> this.jstype.uncheckedCast()
    "lazy" -> this.lazy.uncheckedCast()
    "unverified_lazy", "unverifiedLazy" -> this.unverifiedLazy.uncheckedCast()
    "deprecated" -> this.deprecated.uncheckedCast()
    "weak" -> this.weak.uncheckedCast()
    "debug_redact", "debugRedact" -> this.debugRedact.uncheckedCast()
    "retention" -> this.retention.uncheckedCast()
    "targets" -> this.targets.uncheckedCast()
    "edition_defaults", "editionDefaults" -> this.editionDefaults.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.ctype.uncheckedCast()
    2 -> this.packed.uncheckedCast()
    6 -> this.jstype.uncheckedCast()
    5 -> this.lazy.uncheckedCast()
    15 -> this.unverifiedLazy.uncheckedCast()
    3 -> this.deprecated.uncheckedCast()
    10 -> this.weak.uncheckedCast()
    16 -> this.debugRedact.uncheckedCast()
    17 -> this.retention.uncheckedCast()
    19 -> this.targets.uncheckedCast()
    20 -> this.editionDefaults.uncheckedCast()
    21 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "ctype" -> this.ctype = value.uncheckedCast()
      "packed" -> this.packed = value.uncheckedCast()
      "jstype" -> this.jstype = value.uncheckedCast()
      "lazy" -> this.lazy = value.uncheckedCast()
      "unverified_lazy", "unverifiedLazy" -> this.unverifiedLazy = value.uncheckedCast()
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "weak" -> this.weak = value.uncheckedCast()
      "debug_redact", "debugRedact" -> this.debugRedact = value.uncheckedCast()
      "retention" -> this.retention = value.uncheckedCast()
      "targets" -> {
        this.targets.clear()
        this.targets.addAll(value.uncheckedCast())
      }
      "edition_defaults", "editionDefaults" -> {
        this.editionDefaults.clear()
        this.editionDefaults.addAll(value.uncheckedCast())
      }
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.ctype = value.uncheckedCast()
      2 -> this.packed = value.uncheckedCast()
      6 -> this.jstype = value.uncheckedCast()
      5 -> this.lazy = value.uncheckedCast()
      15 -> this.unverifiedLazy = value.uncheckedCast()
      3 -> this.deprecated = value.uncheckedCast()
      10 -> this.weak = value.uncheckedCast()
      16 -> this.debugRedact = value.uncheckedCast()
      17 -> this.retention = value.uncheckedCast()
      19 -> {
        this.targets.clear()
        this.targets.addAll(value.uncheckedCast())
      }
      20 -> {
        this.editionDefaults.clear()
        this.editionDefaults.addAll(value.uncheckedCast())
      }
      21 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "ctype" -> this.hasCtype()
    "packed" -> this.hasPacked()
    "jstype" -> this.hasJstype()
    "lazy" -> this.hasLazy()
    "unverified_lazy", "unverifiedLazy" -> this.hasUnverifiedLazy()
    "deprecated" -> this.hasDeprecated()
    "weak" -> this.hasWeak()
    "debug_redact", "debugRedact" -> this.hasDebugRedact()
    "retention" -> this.hasRetention()
    "targets" -> this.hasTargets()
    "edition_defaults", "editionDefaults" -> this.hasEditionDefaults()
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasCtype()
    2 -> this.hasPacked()
    6 -> this.hasJstype()
    5 -> this.hasLazy()
    15 -> this.hasUnverifiedLazy()
    3 -> this.hasDeprecated()
    10 -> this.hasWeak()
    16 -> this.hasDebugRedact()
    17 -> this.hasRetention()
    19 -> this.hasTargets()
    20 -> this.hasEditionDefaults()
    21 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FieldOptions): Boolean {
    if (ctype != other.ctype) return false
    if (packed != other.packed) return false
    if (jstype != other.jstype) return false
    if (lazy != other.lazy) return false
    if (unverifiedLazy != other.unverifiedLazy) return false
    if (deprecated != other.deprecated) return false
    if (weak != other.weak) return false
    if (debugRedact != other.debugRedact) return false
    if (retention != other.retention) return false
    if (!targets.contentEquals(other.targets)) return false
    if (!editionDefaults.contentEquals(other.editionDefaults)) return false
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasCtype()) {
      result = result * 37 + 1
      result = result * 31 + this.ctype.hashCode()
    }
    if (hasPacked()) {
      result = result * 37 + 2
      result = result * 31 + this.packed.hashCode()
    }
    if (hasJstype()) {
      result = result * 37 + 6
      result = result * 31 + this.jstype.hashCode()
    }
    if (hasLazy()) {
      result = result * 37 + 5
      result = result * 31 + this.lazy.hashCode()
    }
    if (hasUnverifiedLazy()) {
      result = result * 37 + 15
      result = result * 31 + this.unverifiedLazy.hashCode()
    }
    if (hasDeprecated()) {
      result = result * 37 + 3
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasWeak()) {
      result = result * 37 + 10
      result = result * 31 + this.weak.hashCode()
    }
    if (hasDebugRedact()) {
      result = result * 37 + 16
      result = result * 31 + this.debugRedact.hashCode()
    }
    if (hasRetention()) {
      result = result * 37 + 17
      result = result * 31 + this.retention.hashCode()
    }
    for (value in this.targets) {
      result = result * 37 + 19
      result = result * 31 + value.hashCode()
    }
    for (value in this.editionDefaults) {
      result = result * 37 + 20
      result = result * 31 + value.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 21
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasCtype()) {
      writer.tag(8).enum(this.ctype)
    }
    if (hasPacked()) {
      writer.tag(16).bool(this.packed)
    }
    if (hasJstype()) {
      writer.tag(48).enum(this.jstype)
    }
    if (hasLazy()) {
      writer.tag(40).bool(this.lazy)
    }
    if (hasUnverifiedLazy()) {
      writer.tag(120).bool(this.unverifiedLazy)
    }
    if (hasDeprecated()) {
      writer.tag(24).bool(this.deprecated)
    }
    if (hasWeak()) {
      writer.tag(80).bool(this.weak)
    }
    if (hasDebugRedact()) {
      writer.tag(128).bool(this.debugRedact)
    }
    if (hasRetention()) {
      writer.tag(136).enum(this.retention)
    }
    writer.tag(154).beginLd().apply{ this@FieldOptionsImpl.targets.forEach { enum(it) } }.endLd()
    this.editionDefaults.forEach { writer.tag(162).message(it) }
    if (hasFeatures()) {
      writer.tag(170).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.ctype = FieldOptions.CType(reader.int32())
      2 -> this.packed = reader.bool()
      6 -> this.jstype = FieldOptions.JSType(reader.int32())
      5 -> this.lazy = reader.bool()
      15 -> this.unverifiedLazy = reader.bool()
      3 -> this.deprecated = reader.bool()
      10 -> this.weak = reader.bool()
      16 -> this.debugRedact = reader.bool()
      17 -> this.retention = FieldOptions.OptionRetention(reader.int32())
      19 -> reader.packed(wire) { this.targets += FieldOptions.OptionTargetType(it.int32()) }
      20 -> this.editionDefaults += FieldOptions.EditionDefault.newMutable().apply {
          readFrom(reader) }
      21 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class EditionDefaultImpl :
      AbstractMutableMessage<FieldOptions.EditionDefault, MutableFieldOptions.MutableEditionDefault>(),
      MutableFieldOptions.MutableEditionDefault {
    private var _hasEdition: Boolean = false

    public override var edition: String = ""
      get() = if(_hasEdition) field else ""
      set(`value`) {
        field = value
        _hasEdition = true
      }

    private var _hasValue: Boolean = false

    public override var `value`: String = ""
      get() = if(_hasValue) field else ""
      set(`value`) {
        field = value
        _hasValue = true
      }

    public override fun hasEdition(): Boolean = _hasEdition

    public override fun clearEdition(): String? {
      if (!hasEdition()) return null
      return edition.also {
        edition = ""
        _hasEdition = false
      }
    }

    public override fun hasValue(): Boolean = _hasValue

    public override fun clearValue(): String? {
      if (!hasValue()) return null
      return `value`.also {
        `value` = ""
        _hasValue = false
      }
    }

    public override fun support():
        MessageSupport<FieldOptions.EditionDefault, MutableFieldOptions.MutableEditionDefault> =
        FieldOptions.EditionDefault

    public override fun mergeWith(other: FieldOptions.EditionDefault?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableFieldOptions.MutableEditionDefault =
        EditionDefaultImpl().apply {
      mergeWith(this@EditionDefaultImpl)
    }

    public override fun clear(): Unit {
      this.clearEdition()
      this.clearValue()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "edition" -> this.clearEdition()
      "value" -> this.clearValue()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearEdition()
      2 -> this.clearValue()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "edition" -> this.edition.uncheckedCast()
      "value" -> this.`value`.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.edition.uncheckedCast()
      2 -> this.`value`.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "edition" -> this.edition = value.uncheckedCast()
        "value" -> this.`value` = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.edition = value.uncheckedCast()
        2 -> this.`value` = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "edition" -> this.hasEdition()
      "value" -> this.hasValue()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasEdition()
      2 -> this.hasValue()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: FieldOptions.EditionDefault): Boolean {
      if (edition != other.edition) return false
      if (`value` != other.`value`) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      if (hasEdition()) {
        result = result * 37 + 1
        result = result * 31 + this.edition.hashCode()
      }
      if (hasValue()) {
        result = result * 37 + 2
        result = result * 31 + this.`value`.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      if (hasEdition()) {
        writer.tag(10).string(this.edition)
      }
      if (hasValue()) {
        writer.tag(18).string(this.`value`)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.edition = reader.string()
        2 -> this.`value` = reader.string()
        else -> return false
      }
      return true
    }
  }
}

public open class FieldOptionsSupport internal constructor() :
    MessageSupport<FieldOptions, MutableFieldOptions>() {
  public override val name: String
    get() = ".google.protobuf.FieldOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FieldOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFieldOptions = FieldOptionsImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FieldOptions.EditionDefault,
      FieldOptions.CType, FieldOptions.JSType, FieldOptions.OptionRetention,
      FieldOptions.OptionTargetType)

  public abstract class CTypeSupport internal constructor() : EnumSupport<FieldOptions.CType>() {
    public override val name: String
      get() = ".google.protobuf.FieldOptions.CType"

    public override val parent: FieldOptions.Companion
      get() = FieldOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldOptions.descriptor.enumType.first{ it.name == "CType" }
    }


    public override fun values(): Array<FieldOptions.CType> = FieldOptions.CType.values()
  }

  public abstract class JSTypeSupport internal constructor() : EnumSupport<FieldOptions.JSType>() {
    public override val name: String
      get() = ".google.protobuf.FieldOptions.JSType"

    public override val parent: FieldOptions.Companion
      get() = FieldOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldOptions.descriptor.enumType.first{ it.name == "JSType" }
    }


    public override fun values(): Array<FieldOptions.JSType> = FieldOptions.JSType.values()
  }

  public abstract class OptionRetentionSupport internal constructor() :
      EnumSupport<FieldOptions.OptionRetention>() {
    public override val name: String
      get() = ".google.protobuf.FieldOptions.OptionRetention"

    public override val parent: FieldOptions.Companion
      get() = FieldOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldOptions.descriptor.enumType.first{ it.name == "OptionRetention" }
    }


    public override fun values(): Array<FieldOptions.OptionRetention> =
        FieldOptions.OptionRetention.values()
  }

  public abstract class OptionTargetTypeSupport internal constructor() :
      EnumSupport<FieldOptions.OptionTargetType>() {
    public override val name: String
      get() = ".google.protobuf.FieldOptions.OptionTargetType"

    public override val parent: FieldOptions.Companion
      get() = FieldOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      FieldOptions.descriptor.enumType.first{ it.name == "OptionTargetType" }
    }


    public override fun values(): Array<FieldOptions.OptionTargetType> =
        FieldOptions.OptionTargetType.values()
  }

  public open class EditionDefaultSupport internal constructor() :
      MessageSupport<FieldOptions.EditionDefault, MutableFieldOptions.MutableEditionDefault>() {
    public override val name: String
      get() = ".google.protobuf.FieldOptions.EditionDefault"

    public override val parent: FieldOptions.Companion
      get() = FieldOptions

    public override val descriptor: DescriptorProto by lazy {
      FieldOptions.descriptor.nestedType.first{ it.name == "EditionDefault" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableFieldOptions.MutableEditionDefault =
        FieldOptionsImpl.EditionDefaultImpl()
  }
}

public interface MutableOneofOptions : MutableMessage<OneofOptions, MutableOneofOptions>,
    OneofOptions {
  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class OneofOptionsImpl : AbstractMutableMessage<OneofOptions, MutableOneofOptions>(),
    MutableOneofOptions {
  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<OneofOptions, MutableOneofOptions> = OneofOptions

  public override fun mergeWith(other: OneofOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableOneofOptions = OneofOptionsImpl().apply {
    mergeWith(this@OneofOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: OneofOptions): Boolean {
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasFeatures()) {
      result = result * 37 + 1
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasFeatures()) {
      writer.tag(10).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class OneofOptionsSupport internal constructor() :
    MessageSupport<OneofOptions, MutableOneofOptions>() {
  public override val name: String
    get() = ".google.protobuf.OneofOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "OneofOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableOneofOptions = OneofOptionsImpl()
}

public interface MutableEnumOptions : MutableMessage<EnumOptions, MutableEnumOptions>, EnumOptions {
  public override var allowAlias: Boolean

  public override var deprecated: Boolean

  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public override var deprecatedLegacyJsonFieldConflicts: Boolean

  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearAllowAlias(): Boolean?

  public fun clearDeprecated(): Boolean?

  public fun clearDeprecatedLegacyJsonFieldConflicts(): Boolean?

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class EnumOptionsImpl : AbstractMutableMessage<EnumOptions, MutableEnumOptions>(),
    MutableEnumOptions {
  private var _hasAllowAlias: Boolean = false

  public override var allowAlias: Boolean = false
    get() = if(_hasAllowAlias) field else false
    set(`value`) {
      field = value
      _hasAllowAlias = true
    }

  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  private var _hasDeprecatedLegacyJsonFieldConflicts: Boolean = false

  @Deprecated(message = "deprecatedLegacyJsonFieldConflicts has been marked as deprecated")
  public override var deprecatedLegacyJsonFieldConflicts: Boolean = false
    get() = if(_hasDeprecatedLegacyJsonFieldConflicts) field else false
    set(`value`) {
      field = value
      _hasDeprecatedLegacyJsonFieldConflicts = true
    }

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasAllowAlias(): Boolean = _hasAllowAlias

  public override fun clearAllowAlias(): Boolean? {
    if (!hasAllowAlias()) return null
    return allowAlias.also {
      allowAlias = false
      _hasAllowAlias = false
    }
  }

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasDeprecatedLegacyJsonFieldConflicts(): Boolean =
      _hasDeprecatedLegacyJsonFieldConflicts

  public override fun clearDeprecatedLegacyJsonFieldConflicts(): Boolean? {
    if (!hasDeprecatedLegacyJsonFieldConflicts()) return null
    return deprecatedLegacyJsonFieldConflicts.also {
      deprecatedLegacyJsonFieldConflicts = false
      _hasDeprecatedLegacyJsonFieldConflicts = false
    }
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<EnumOptions, MutableEnumOptions> = EnumOptions

  public override fun mergeWith(other: EnumOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnumOptions = EnumOptionsImpl().apply {
    mergeWith(this@EnumOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearAllowAlias()
    this.clearDeprecated()
    this.clearDeprecatedLegacyJsonFieldConflicts()
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "allow_alias", "allowAlias" -> this.clearAllowAlias()
    "deprecated" -> this.clearDeprecated()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.clearDeprecatedLegacyJsonFieldConflicts()
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    2 -> this.clearAllowAlias()
    3 -> this.clearDeprecated()
    6 -> this.clearDeprecatedLegacyJsonFieldConflicts()
    7 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "allow_alias", "allowAlias" -> this.allowAlias.uncheckedCast()
    "deprecated" -> this.deprecated.uncheckedCast()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.deprecatedLegacyJsonFieldConflicts.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    2 -> this.allowAlias.uncheckedCast()
    3 -> this.deprecated.uncheckedCast()
    6 -> this.deprecatedLegacyJsonFieldConflicts.uncheckedCast()
    7 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "allow_alias", "allowAlias" -> this.allowAlias = value.uncheckedCast()
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
          this.deprecatedLegacyJsonFieldConflicts = value.uncheckedCast()
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      2 -> this.allowAlias = value.uncheckedCast()
      3 -> this.deprecated = value.uncheckedCast()
      6 -> this.deprecatedLegacyJsonFieldConflicts = value.uncheckedCast()
      7 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "allow_alias", "allowAlias" -> this.hasAllowAlias()
    "deprecated" -> this.hasDeprecated()
    "deprecated_legacy_json_field_conflicts", "deprecatedLegacyJsonFieldConflicts" ->
        this.hasDeprecatedLegacyJsonFieldConflicts()
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    2 -> this.hasAllowAlias()
    3 -> this.hasDeprecated()
    6 -> this.hasDeprecatedLegacyJsonFieldConflicts()
    7 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: EnumOptions): Boolean {
    if (allowAlias != other.allowAlias) return false
    if (deprecated != other.deprecated) return false
    if (deprecatedLegacyJsonFieldConflicts != other.deprecatedLegacyJsonFieldConflicts) return false
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasAllowAlias()) {
      result = result * 37 + 2
      result = result * 31 + this.allowAlias.hashCode()
    }
    if (hasDeprecated()) {
      result = result * 37 + 3
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasDeprecatedLegacyJsonFieldConflicts()) {
      result = result * 37 + 6
      result = result * 31 + this.deprecatedLegacyJsonFieldConflicts.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 7
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasAllowAlias()) {
      writer.tag(16).bool(this.allowAlias)
    }
    if (hasDeprecated()) {
      writer.tag(24).bool(this.deprecated)
    }
    if (hasDeprecatedLegacyJsonFieldConflicts()) {
      writer.tag(48).bool(this.deprecatedLegacyJsonFieldConflicts)
    }
    if (hasFeatures()) {
      writer.tag(58).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      2 -> this.allowAlias = reader.bool()
      3 -> this.deprecated = reader.bool()
      6 -> this.deprecatedLegacyJsonFieldConflicts = reader.bool()
      7 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class EnumOptionsSupport internal constructor() :
    MessageSupport<EnumOptions, MutableEnumOptions>() {
  public override val name: String
    get() = ".google.protobuf.EnumOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "EnumOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnumOptions = EnumOptionsImpl()
}

public interface MutableEnumValueOptions :
    MutableMessage<EnumValueOptions, MutableEnumValueOptions>, EnumValueOptions {
  public override var deprecated: Boolean

  public override var features: FeatureSet?

  public override var debugRedact: Boolean

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearDeprecated(): Boolean?

  public fun clearFeatures(): FeatureSet?

  public fun clearDebugRedact(): Boolean?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class EnumValueOptionsImpl :
    AbstractMutableMessage<EnumValueOptions, MutableEnumValueOptions>(), MutableEnumValueOptions {
  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  private var _hasDebugRedact: Boolean = false

  public override var debugRedact: Boolean = false
    get() = if(_hasDebugRedact) field else false
    set(`value`) {
      field = value
      _hasDebugRedact = true
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasDebugRedact(): Boolean = _hasDebugRedact

  public override fun clearDebugRedact(): Boolean? {
    if (!hasDebugRedact()) return null
    return debugRedact.also {
      debugRedact = false
      _hasDebugRedact = false
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<EnumValueOptions, MutableEnumValueOptions> =
      EnumValueOptions

  public override fun mergeWith(other: EnumValueOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnumValueOptions = EnumValueOptionsImpl().apply {
    mergeWith(this@EnumValueOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearDeprecated()
    this.clearFeatures()
    this.clearDebugRedact()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "deprecated" -> this.clearDeprecated()
    "features" -> this.clearFeatures()
    "debug_redact", "debugRedact" -> this.clearDebugRedact()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearDeprecated()
    2 -> this.clearFeatures()
    3 -> this.clearDebugRedact()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "deprecated" -> this.deprecated.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "debug_redact", "debugRedact" -> this.debugRedact.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.deprecated.uncheckedCast()
    2 -> this.features.uncheckedCast()
    3 -> this.debugRedact.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "features" -> this.features = value.uncheckedCast()
      "debug_redact", "debugRedact" -> this.debugRedact = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.deprecated = value.uncheckedCast()
      2 -> this.features = value.uncheckedCast()
      3 -> this.debugRedact = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "deprecated" -> this.hasDeprecated()
    "features" -> this.hasFeatures()
    "debug_redact", "debugRedact" -> this.hasDebugRedact()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasDeprecated()
    2 -> this.hasFeatures()
    3 -> this.hasDebugRedact()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: EnumValueOptions): Boolean {
    if (deprecated != other.deprecated) return false
    if (features != other.features) return false
    if (debugRedact != other.debugRedact) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasDeprecated()) {
      result = result * 37 + 1
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 2
      result = result * 31 + this.features!!.hashCode()
    }
    if (hasDebugRedact()) {
      result = result * 37 + 3
      result = result * 31 + this.debugRedact.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasDeprecated()) {
      writer.tag(8).bool(this.deprecated)
    }
    if (hasFeatures()) {
      writer.tag(18).message(this.features)
    }
    if (hasDebugRedact()) {
      writer.tag(24).bool(this.debugRedact)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.deprecated = reader.bool()
      2 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      3 -> this.debugRedact = reader.bool()
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class EnumValueOptionsSupport internal constructor() :
    MessageSupport<EnumValueOptions, MutableEnumValueOptions>() {
  public override val name: String
    get() = ".google.protobuf.EnumValueOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "EnumValueOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnumValueOptions = EnumValueOptionsImpl()
}

public interface MutableServiceOptions : MutableMessage<ServiceOptions, MutableServiceOptions>,
    ServiceOptions {
  public override var features: FeatureSet?

  public override var deprecated: Boolean

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearFeatures(): FeatureSet?

  public fun clearDeprecated(): Boolean?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class ServiceOptionsImpl : AbstractMutableMessage<ServiceOptions, MutableServiceOptions>(),
    MutableServiceOptions {
  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<ServiceOptions, MutableServiceOptions> =
      ServiceOptions

  public override fun mergeWith(other: ServiceOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableServiceOptions = ServiceOptionsImpl().apply {
    mergeWith(this@ServiceOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearFeatures()
    this.clearDeprecated()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "features" -> this.clearFeatures()
    "deprecated" -> this.clearDeprecated()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    34 -> this.clearFeatures()
    33 -> this.clearDeprecated()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "features" -> this.features.uncheckedCast()
    "deprecated" -> this.deprecated.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    34 -> this.features.uncheckedCast()
    33 -> this.deprecated.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "features" -> this.features = value.uncheckedCast()
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      34 -> this.features = value.uncheckedCast()
      33 -> this.deprecated = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "features" -> this.hasFeatures()
    "deprecated" -> this.hasDeprecated()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    34 -> this.hasFeatures()
    33 -> this.hasDeprecated()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: ServiceOptions): Boolean {
    if (features != other.features) return false
    if (deprecated != other.deprecated) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasFeatures()) {
      result = result * 37 + 34
      result = result * 31 + this.features!!.hashCode()
    }
    if (hasDeprecated()) {
      result = result * 37 + 33
      result = result * 31 + this.deprecated.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasFeatures()) {
      writer.tag(274).message(this.features)
    }
    if (hasDeprecated()) {
      writer.tag(264).bool(this.deprecated)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      34 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      33 -> this.deprecated = reader.bool()
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class ServiceOptionsSupport internal constructor() :
    MessageSupport<ServiceOptions, MutableServiceOptions>() {
  public override val name: String
    get() = ".google.protobuf.ServiceOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "ServiceOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableServiceOptions = ServiceOptionsImpl()
}

public interface MutableMethodOptions : MutableMessage<MethodOptions, MutableMethodOptions>,
    MethodOptions {
  public override var deprecated: Boolean

  public override var idempotencyLevel: MethodOptions.IdempotencyLevel

  public override var features: FeatureSet?

  public override val uninterpretedOption: MutableList<UninterpretedOption>

  public fun clearDeprecated(): Boolean?

  public fun clearIdempotencyLevel(): MethodOptions.IdempotencyLevel?

  public fun clearFeatures(): FeatureSet?

  public fun clearUninterpretedOption(): List<UninterpretedOption>
}

@InternalProtoApi
internal class MethodOptionsImpl : AbstractMutableMessage<MethodOptions, MutableMethodOptions>(),
    MutableMethodOptions {
  private var _hasDeprecated: Boolean = false

  public override var deprecated: Boolean = false
    get() = if(_hasDeprecated) field else false
    set(`value`) {
      field = value
      _hasDeprecated = true
    }

  private var _hasIdempotencyLevel: Boolean = false

  public override var idempotencyLevel: MethodOptions.IdempotencyLevel =
      MethodOptions.IdempotencyLevel()
    get() = if(_hasIdempotencyLevel) field else MethodOptions.IdempotencyLevel()
    set(`value`) {
      field = value
      _hasIdempotencyLevel = true
    }

  public override var features: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override val uninterpretedOption: MutableList<UninterpretedOption> = mutableListOf()

  public override fun hasDeprecated(): Boolean = _hasDeprecated

  public override fun clearDeprecated(): Boolean? {
    if (!hasDeprecated()) return null
    return deprecated.also {
      deprecated = false
      _hasDeprecated = false
    }
  }

  public override fun hasIdempotencyLevel(): Boolean = _hasIdempotencyLevel

  public override fun clearIdempotencyLevel(): MethodOptions.IdempotencyLevel? {
    if (!hasIdempotencyLevel()) return null
    return idempotencyLevel.also {
      idempotencyLevel = MethodOptions.IdempotencyLevel()
      _hasIdempotencyLevel = false
    }
  }

  public override fun hasFeatures(): Boolean = features != null

  public override fun clearFeatures(): FeatureSet? {
    if (!hasFeatures()) return null
    return features.also {
      features = null
    }
  }

  public override fun hasUninterpretedOption(): Boolean = uninterpretedOption.isNotEmpty()

  public override fun clearUninterpretedOption(): List<UninterpretedOption> =
      uninterpretedOption.toList().also {
    uninterpretedOption.clear()
  }

  public override fun support(): MessageSupport<MethodOptions, MutableMethodOptions> = MethodOptions

  public override fun mergeWith(other: MethodOptions?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableMethodOptions = MethodOptionsImpl().apply {
    mergeWith(this@MethodOptionsImpl)
  }

  public override fun clear(): Unit {
    this.clearDeprecated()
    this.clearIdempotencyLevel()
    this.clearFeatures()
    this.clearUninterpretedOption()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "deprecated" -> this.clearDeprecated()
    "idempotency_level", "idempotencyLevel" -> this.clearIdempotencyLevel()
    "features" -> this.clearFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    33 -> this.clearDeprecated()
    34 -> this.clearIdempotencyLevel()
    35 -> this.clearFeatures()
    999 -> this.clearUninterpretedOption()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "deprecated" -> this.deprecated.uncheckedCast()
    "idempotency_level", "idempotencyLevel" -> this.idempotencyLevel.uncheckedCast()
    "features" -> this.features.uncheckedCast()
    "uninterpreted_option", "uninterpretedOption" -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    33 -> this.deprecated.uncheckedCast()
    34 -> this.idempotencyLevel.uncheckedCast()
    35 -> this.features.uncheckedCast()
    999 -> this.uninterpretedOption.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "deprecated" -> this.deprecated = value.uncheckedCast()
      "idempotency_level", "idempotencyLevel" -> this.idempotencyLevel = value.uncheckedCast()
      "features" -> this.features = value.uncheckedCast()
      "uninterpreted_option", "uninterpretedOption" -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      33 -> this.deprecated = value.uncheckedCast()
      34 -> this.idempotencyLevel = value.uncheckedCast()
      35 -> this.features = value.uncheckedCast()
      999 -> {
        this.uninterpretedOption.clear()
        this.uninterpretedOption.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "deprecated" -> this.hasDeprecated()
    "idempotency_level", "idempotencyLevel" -> this.hasIdempotencyLevel()
    "features" -> this.hasFeatures()
    "uninterpreted_option", "uninterpretedOption" -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    33 -> this.hasDeprecated()
    34 -> this.hasIdempotencyLevel()
    35 -> this.hasFeatures()
    999 -> this.hasUninterpretedOption()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: MethodOptions): Boolean {
    if (deprecated != other.deprecated) return false
    if (idempotencyLevel != other.idempotencyLevel) return false
    if (features != other.features) return false
    if (!uninterpretedOption.contentEquals(other.uninterpretedOption)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasDeprecated()) {
      result = result * 37 + 33
      result = result * 31 + this.deprecated.hashCode()
    }
    if (hasIdempotencyLevel()) {
      result = result * 37 + 34
      result = result * 31 + this.idempotencyLevel.hashCode()
    }
    if (hasFeatures()) {
      result = result * 37 + 35
      result = result * 31 + this.features!!.hashCode()
    }
    for (value in this.uninterpretedOption) {
      result = result * 37 + 999
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasDeprecated()) {
      writer.tag(264).bool(this.deprecated)
    }
    if (hasIdempotencyLevel()) {
      writer.tag(272).enum(this.idempotencyLevel)
    }
    if (hasFeatures()) {
      writer.tag(282).message(this.features)
    }
    this.uninterpretedOption.forEach { writer.tag(7994).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      33 -> this.deprecated = reader.bool()
      34 -> this.idempotencyLevel = MethodOptions.IdempotencyLevel(reader.int32())
      35 -> this.features = FeatureSet.newMutable().apply { readFrom(reader) }
      999 -> this.uninterpretedOption += UninterpretedOption.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class MethodOptionsSupport internal constructor() :
    MessageSupport<MethodOptions, MutableMethodOptions>() {
  public override val name: String
    get() = ".google.protobuf.MethodOptions"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "MethodOptions" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableMethodOptions = MethodOptionsImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(MethodOptions.IdempotencyLevel)

  public abstract class IdempotencyLevelSupport internal constructor() :
      EnumSupport<MethodOptions.IdempotencyLevel>() {
    public override val name: String
      get() = ".google.protobuf.MethodOptions.IdempotencyLevel"

    public override val parent: MethodOptions.Companion
      get() = MethodOptions

    public override val descriptor: EnumDescriptorProto by lazy {
      MethodOptions.descriptor.enumType.first{ it.name == "IdempotencyLevel" }
    }


    public override fun values(): Array<MethodOptions.IdempotencyLevel> =
        MethodOptions.IdempotencyLevel.values()
  }
}

public interface MutableUninterpretedOption :
    MutableMessage<UninterpretedOption, MutableUninterpretedOption>, UninterpretedOption {
  public override val name: MutableList<UninterpretedOption.NamePart>

  public override var identifierValue: String

  public override var positiveIntValue: ULong

  public override var negativeIntValue: Long

  public override var doubleValue: Double

  public override var stringValue: ByteArray

  public override var aggregateValue: String

  public fun clearName(): List<UninterpretedOption.NamePart>

  public fun clearIdentifierValue(): String?

  public fun clearPositiveIntValue(): ULong?

  public fun clearNegativeIntValue(): Long?

  public fun clearDoubleValue(): Double?

  public fun clearStringValue(): ByteArray?

  public fun clearAggregateValue(): String?

  public interface MutableNamePart : MutableMessage<UninterpretedOption.NamePart, MutableNamePart>,
      UninterpretedOption.NamePart {
    public override var namePart: String

    public override var isExtension: Boolean
  }
}

@InternalProtoApi
internal class UninterpretedOptionImpl :
    AbstractMutableMessage<UninterpretedOption, MutableUninterpretedOption>(),
    MutableUninterpretedOption {
  public override val name: MutableList<UninterpretedOption.NamePart> = mutableListOf()

  private var _hasIdentifierValue: Boolean = false

  public override var identifierValue: String = ""
    get() = if(_hasIdentifierValue) field else ""
    set(`value`) {
      field = value
      _hasIdentifierValue = true
    }

  private var _hasPositiveIntValue: Boolean = false

  public override var positiveIntValue: ULong = 0UL
    get() = if(_hasPositiveIntValue) field else 0UL
    set(`value`) {
      field = value
      _hasPositiveIntValue = true
    }

  private var _hasNegativeIntValue: Boolean = false

  public override var negativeIntValue: Long = 0L
    get() = if(_hasNegativeIntValue) field else 0L
    set(`value`) {
      field = value
      _hasNegativeIntValue = true
    }

  private var _hasDoubleValue: Boolean = false

  public override var doubleValue: Double = 0.0
    get() = if(_hasDoubleValue) field else 0.0
    set(`value`) {
      field = value
      _hasDoubleValue = true
    }

  private var _hasStringValue: Boolean = false

  public override var stringValue: ByteArray = byteArrayOf()
    get() = if(_hasStringValue) field else byteArrayOf()
    set(`value`) {
      field = value
      _hasStringValue = true
    }

  private var _hasAggregateValue: Boolean = false

  public override var aggregateValue: String = ""
    get() = if(_hasAggregateValue) field else ""
    set(`value`) {
      field = value
      _hasAggregateValue = true
    }

  public override fun hasName(): Boolean = name.isNotEmpty()

  public override fun clearName(): List<UninterpretedOption.NamePart> = name.toList().also {
    name.clear()
  }

  public override fun hasIdentifierValue(): Boolean = _hasIdentifierValue

  public override fun clearIdentifierValue(): String? {
    if (!hasIdentifierValue()) return null
    return identifierValue.also {
      identifierValue = ""
      _hasIdentifierValue = false
    }
  }

  public override fun hasPositiveIntValue(): Boolean = _hasPositiveIntValue

  public override fun clearPositiveIntValue(): ULong? {
    if (!hasPositiveIntValue()) return null
    return positiveIntValue.also {
      positiveIntValue = 0UL
      _hasPositiveIntValue = false
    }
  }

  public override fun hasNegativeIntValue(): Boolean = _hasNegativeIntValue

  public override fun clearNegativeIntValue(): Long? {
    if (!hasNegativeIntValue()) return null
    return negativeIntValue.also {
      negativeIntValue = 0L
      _hasNegativeIntValue = false
    }
  }

  public override fun hasDoubleValue(): Boolean = _hasDoubleValue

  public override fun clearDoubleValue(): Double? {
    if (!hasDoubleValue()) return null
    return doubleValue.also {
      doubleValue = 0.0
      _hasDoubleValue = false
    }
  }

  public override fun hasStringValue(): Boolean = _hasStringValue

  public override fun clearStringValue(): ByteArray? {
    if (!hasStringValue()) return null
    return stringValue.also {
      stringValue = byteArrayOf()
      _hasStringValue = false
    }
  }

  public override fun hasAggregateValue(): Boolean = _hasAggregateValue

  public override fun clearAggregateValue(): String? {
    if (!hasAggregateValue()) return null
    return aggregateValue.also {
      aggregateValue = ""
      _hasAggregateValue = false
    }
  }

  public override fun support(): MessageSupport<UninterpretedOption, MutableUninterpretedOption> =
      UninterpretedOption

  public override fun mergeWith(other: UninterpretedOption?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableUninterpretedOption = UninterpretedOptionImpl().apply {
    mergeWith(this@UninterpretedOptionImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearIdentifierValue()
    this.clearPositiveIntValue()
    this.clearNegativeIntValue()
    this.clearDoubleValue()
    this.clearStringValue()
    this.clearAggregateValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "identifier_value", "identifierValue" -> this.clearIdentifierValue()
    "positive_int_value", "positiveIntValue" -> this.clearPositiveIntValue()
    "negative_int_value", "negativeIntValue" -> this.clearNegativeIntValue()
    "double_value", "doubleValue" -> this.clearDoubleValue()
    "string_value", "stringValue" -> this.clearStringValue()
    "aggregate_value", "aggregateValue" -> this.clearAggregateValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    2 -> this.clearName()
    3 -> this.clearIdentifierValue()
    4 -> this.clearPositiveIntValue()
    5 -> this.clearNegativeIntValue()
    6 -> this.clearDoubleValue()
    7 -> this.clearStringValue()
    8 -> this.clearAggregateValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "identifier_value", "identifierValue" -> this.identifierValue.uncheckedCast()
    "positive_int_value", "positiveIntValue" -> this.positiveIntValue.uncheckedCast()
    "negative_int_value", "negativeIntValue" -> this.negativeIntValue.uncheckedCast()
    "double_value", "doubleValue" -> this.doubleValue.uncheckedCast()
    "string_value", "stringValue" -> this.stringValue.uncheckedCast()
    "aggregate_value", "aggregateValue" -> this.aggregateValue.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    2 -> this.name.uncheckedCast()
    3 -> this.identifierValue.uncheckedCast()
    4 -> this.positiveIntValue.uncheckedCast()
    5 -> this.negativeIntValue.uncheckedCast()
    6 -> this.doubleValue.uncheckedCast()
    7 -> this.stringValue.uncheckedCast()
    8 -> this.aggregateValue.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> {
        this.name.clear()
        this.name.addAll(value.uncheckedCast())
      }
      "identifier_value", "identifierValue" -> this.identifierValue = value.uncheckedCast()
      "positive_int_value", "positiveIntValue" -> this.positiveIntValue = value.uncheckedCast()
      "negative_int_value", "negativeIntValue" -> this.negativeIntValue = value.uncheckedCast()
      "double_value", "doubleValue" -> this.doubleValue = value.uncheckedCast()
      "string_value", "stringValue" -> this.stringValue = value.uncheckedCast()
      "aggregate_value", "aggregateValue" -> this.aggregateValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      2 -> {
        this.name.clear()
        this.name.addAll(value.uncheckedCast())
      }
      3 -> this.identifierValue = value.uncheckedCast()
      4 -> this.positiveIntValue = value.uncheckedCast()
      5 -> this.negativeIntValue = value.uncheckedCast()
      6 -> this.doubleValue = value.uncheckedCast()
      7 -> this.stringValue = value.uncheckedCast()
      8 -> this.aggregateValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "identifier_value", "identifierValue" -> this.hasIdentifierValue()
    "positive_int_value", "positiveIntValue" -> this.hasPositiveIntValue()
    "negative_int_value", "negativeIntValue" -> this.hasNegativeIntValue()
    "double_value", "doubleValue" -> this.hasDoubleValue()
    "string_value", "stringValue" -> this.hasStringValue()
    "aggregate_value", "aggregateValue" -> this.hasAggregateValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    2 -> this.hasName()
    3 -> this.hasIdentifierValue()
    4 -> this.hasPositiveIntValue()
    5 -> this.hasNegativeIntValue()
    6 -> this.hasDoubleValue()
    7 -> this.hasStringValue()
    8 -> this.hasAggregateValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: UninterpretedOption): Boolean {
    if (!name.contentEquals(other.name)) return false
    if (identifierValue != other.identifierValue) return false
    if (positiveIntValue != other.positiveIntValue) return false
    if (negativeIntValue != other.negativeIntValue) return false
    if (doubleValue != other.doubleValue) return false
    if (!stringValue.contentEquals(other.stringValue)) return false
    if (aggregateValue != other.aggregateValue) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.name) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    if (hasIdentifierValue()) {
      result = result * 37 + 3
      result = result * 31 + this.identifierValue.hashCode()
    }
    if (hasPositiveIntValue()) {
      result = result * 37 + 4
      result = result * 31 + this.positiveIntValue.hashCode()
    }
    if (hasNegativeIntValue()) {
      result = result * 37 + 5
      result = result * 31 + this.negativeIntValue.hashCode()
    }
    if (hasDoubleValue()) {
      result = result * 37 + 6
      result = result * 31 + this.doubleValue.hashCode()
    }
    if (hasStringValue()) {
      result = result * 37 + 7
      result = result * 31 + this.stringValue.hashCode()
    }
    if (hasAggregateValue()) {
      result = result * 37 + 8
      result = result * 31 + this.aggregateValue.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.name.forEach { writer.tag(18).message(it) }
    if (hasIdentifierValue()) {
      writer.tag(26).string(this.identifierValue)
    }
    if (hasPositiveIntValue()) {
      writer.tag(32).uint64(this.positiveIntValue)
    }
    if (hasNegativeIntValue()) {
      writer.tag(40).int64(this.negativeIntValue)
    }
    if (hasDoubleValue()) {
      writer.tag(49).double(this.doubleValue)
    }
    if (hasStringValue()) {
      writer.tag(58).bytes(this.stringValue)
    }
    if (hasAggregateValue()) {
      writer.tag(66).string(this.aggregateValue)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      2 -> this.name += UninterpretedOption.NamePart.newMutable().apply { readFrom(reader) }
      3 -> this.identifierValue = reader.string()
      4 -> this.positiveIntValue = reader.uint64()
      5 -> this.negativeIntValue = reader.int64()
      6 -> this.doubleValue = reader.double()
      7 -> this.stringValue = reader.bytes()
      8 -> this.aggregateValue = reader.string()
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class NamePartImpl :
      AbstractMutableMessage<UninterpretedOption.NamePart, MutableUninterpretedOption.MutableNamePart>(),
      MutableUninterpretedOption.MutableNamePart {
    public override lateinit var namePart: String

    public override var isExtension: Boolean = false

    public override fun support():
        MessageSupport<UninterpretedOption.NamePart, MutableUninterpretedOption.MutableNamePart> =
        UninterpretedOption.NamePart

    public override fun mergeWith(other: UninterpretedOption.NamePart?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableUninterpretedOption.MutableNamePart =
        NamePartImpl().apply {
      mergeWith(this@NamePartImpl)
    }

    public override fun clear(): Unit {
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "name_part", "namePart" -> throw
          IllegalArgumentException("Field 'name_part' is required field can't be clear.")
      "is_extension", "isExtension" -> throw
          IllegalArgumentException("Field 'is_extension' is required field can't be clear.")
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> throw IllegalArgumentException("Field 'name_part' is required field can't be clear.")
      2 -> throw IllegalArgumentException("Field 'is_extension' is required field can't be clear.")
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "name_part", "namePart" -> this.namePart.uncheckedCast()
      "is_extension", "isExtension" -> this.isExtension.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.namePart.uncheckedCast()
      2 -> this.isExtension.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "name_part", "namePart" -> this.namePart = value.uncheckedCast()
        "is_extension", "isExtension" -> this.isExtension = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> this.namePart = value.uncheckedCast()
        2 -> this.isExtension = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "name_part", "namePart" -> true
      "is_extension", "isExtension" -> true
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> true
      2 -> true
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: UninterpretedOption.NamePart): Boolean {
      if (namePart != other.namePart) return false
      if (isExtension != other.isExtension) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      result = result * 37 + 1
      result = result * 31 + this.namePart.hashCode()
      result = result * 37 + 2
      result = result * 31 + this.isExtension.hashCode()
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      writer.tag(10).string(this.namePart)
      writer.tag(16).bool(this.isExtension)
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> this.namePart = reader.string()
        2 -> this.isExtension = reader.bool()
        else -> return false
      }
      return true
    }
  }
}

public open class UninterpretedOptionSupport internal constructor() :
    MessageSupport<UninterpretedOption, MutableUninterpretedOption>() {
  public override val name: String
    get() = ".google.protobuf.UninterpretedOption"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "UninterpretedOption" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableUninterpretedOption = UninterpretedOptionImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(UninterpretedOption.NamePart)

  public open class NamePartSupport internal constructor() :
      MessageSupport<UninterpretedOption.NamePart, MutableUninterpretedOption.MutableNamePart>() {
    public override val name: String
      get() = ".google.protobuf.UninterpretedOption.NamePart"

    public override val parent: UninterpretedOption.Companion
      get() = UninterpretedOption

    public override val descriptor: DescriptorProto by lazy {
      UninterpretedOption.descriptor.nestedType.first{ it.name == "NamePart" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableUninterpretedOption.MutableNamePart =
        UninterpretedOptionImpl.NamePartImpl()
  }
}

public interface MutableFeatureSet : MutableMessage<FeatureSet, MutableFeatureSet>, FeatureSet {
  public override var fieldPresence: FeatureSet.FieldPresence

  public override var enumType: FeatureSet.EnumType

  public override var repeatedFieldEncoding: FeatureSet.RepeatedFieldEncoding

  public override var stringFieldValidation: FeatureSet.StringFieldValidation

  public override var messageEncoding: FeatureSet.MessageEncoding

  public override var jsonFormat: FeatureSet.JsonFormat

  public override var rawFeatures: FeatureSet?

  public fun clearFieldPresence(): FeatureSet.FieldPresence?

  public fun clearEnumType(): FeatureSet.EnumType?

  public fun clearRepeatedFieldEncoding(): FeatureSet.RepeatedFieldEncoding?

  public fun clearStringFieldValidation(): FeatureSet.StringFieldValidation?

  public fun clearMessageEncoding(): FeatureSet.MessageEncoding?

  public fun clearJsonFormat(): FeatureSet.JsonFormat?

  public fun clearRawFeatures(): FeatureSet?
}

@InternalProtoApi
internal class FeatureSetImpl : AbstractMutableMessage<FeatureSet, MutableFeatureSet>(),
    MutableFeatureSet {
  private var _hasFieldPresence: Boolean = false

  public override var fieldPresence: FeatureSet.FieldPresence = FeatureSet.FieldPresence()
    get() = if(_hasFieldPresence) field else FeatureSet.FieldPresence()
    set(`value`) {
      field = value
      _hasFieldPresence = true
    }

  private var _hasEnumType: Boolean = false

  public override var enumType: FeatureSet.EnumType = FeatureSet.EnumType()
    get() = if(_hasEnumType) field else FeatureSet.EnumType()
    set(`value`) {
      field = value
      _hasEnumType = true
    }

  private var _hasRepeatedFieldEncoding: Boolean = false

  public override var repeatedFieldEncoding: FeatureSet.RepeatedFieldEncoding =
      FeatureSet.RepeatedFieldEncoding()
    get() = if(_hasRepeatedFieldEncoding) field else FeatureSet.RepeatedFieldEncoding()
    set(`value`) {
      field = value
      _hasRepeatedFieldEncoding = true
    }

  private var _hasStringFieldValidation: Boolean = false

  public override var stringFieldValidation: FeatureSet.StringFieldValidation =
      FeatureSet.StringFieldValidation()
    get() = if(_hasStringFieldValidation) field else FeatureSet.StringFieldValidation()
    set(`value`) {
      field = value
      _hasStringFieldValidation = true
    }

  private var _hasMessageEncoding: Boolean = false

  public override var messageEncoding: FeatureSet.MessageEncoding = FeatureSet.MessageEncoding()
    get() = if(_hasMessageEncoding) field else FeatureSet.MessageEncoding()
    set(`value`) {
      field = value
      _hasMessageEncoding = true
    }

  private var _hasJsonFormat: Boolean = false

  public override var jsonFormat: FeatureSet.JsonFormat = FeatureSet.JsonFormat()
    get() = if(_hasJsonFormat) field else FeatureSet.JsonFormat()
    set(`value`) {
      field = value
      _hasJsonFormat = true
    }

  public override var rawFeatures: FeatureSet? = null
    set(`value`) {
      field = value
    }

  public override fun hasFieldPresence(): Boolean = _hasFieldPresence

  public override fun clearFieldPresence(): FeatureSet.FieldPresence? {
    if (!hasFieldPresence()) return null
    return fieldPresence.also {
      fieldPresence = FeatureSet.FieldPresence()
      _hasFieldPresence = false
    }
  }

  public override fun hasEnumType(): Boolean = _hasEnumType

  public override fun clearEnumType(): FeatureSet.EnumType? {
    if (!hasEnumType()) return null
    return enumType.also {
      enumType = FeatureSet.EnumType()
      _hasEnumType = false
    }
  }

  public override fun hasRepeatedFieldEncoding(): Boolean = _hasRepeatedFieldEncoding

  public override fun clearRepeatedFieldEncoding(): FeatureSet.RepeatedFieldEncoding? {
    if (!hasRepeatedFieldEncoding()) return null
    return repeatedFieldEncoding.also {
      repeatedFieldEncoding = FeatureSet.RepeatedFieldEncoding()
      _hasRepeatedFieldEncoding = false
    }
  }

  public override fun hasStringFieldValidation(): Boolean = _hasStringFieldValidation

  public override fun clearStringFieldValidation(): FeatureSet.StringFieldValidation? {
    if (!hasStringFieldValidation()) return null
    return stringFieldValidation.also {
      stringFieldValidation = FeatureSet.StringFieldValidation()
      _hasStringFieldValidation = false
    }
  }

  public override fun hasMessageEncoding(): Boolean = _hasMessageEncoding

  public override fun clearMessageEncoding(): FeatureSet.MessageEncoding? {
    if (!hasMessageEncoding()) return null
    return messageEncoding.also {
      messageEncoding = FeatureSet.MessageEncoding()
      _hasMessageEncoding = false
    }
  }

  public override fun hasJsonFormat(): Boolean = _hasJsonFormat

  public override fun clearJsonFormat(): FeatureSet.JsonFormat? {
    if (!hasJsonFormat()) return null
    return jsonFormat.also {
      jsonFormat = FeatureSet.JsonFormat()
      _hasJsonFormat = false
    }
  }

  public override fun hasRawFeatures(): Boolean = rawFeatures != null

  public override fun clearRawFeatures(): FeatureSet? {
    if (!hasRawFeatures()) return null
    return rawFeatures.also {
      rawFeatures = null
    }
  }

  public override fun support(): MessageSupport<FeatureSet, MutableFeatureSet> = FeatureSet

  public override fun mergeWith(other: FeatureSet?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFeatureSet = FeatureSetImpl().apply {
    mergeWith(this@FeatureSetImpl)
  }

  public override fun clear(): Unit {
    this.clearFieldPresence()
    this.clearEnumType()
    this.clearRepeatedFieldEncoding()
    this.clearStringFieldValidation()
    this.clearMessageEncoding()
    this.clearJsonFormat()
    this.clearRawFeatures()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "field_presence", "fieldPresence" -> this.clearFieldPresence()
    "enum_type", "enumType" -> this.clearEnumType()
    "repeated_field_encoding", "repeatedFieldEncoding" -> this.clearRepeatedFieldEncoding()
    "string_field_validation", "stringFieldValidation" -> this.clearStringFieldValidation()
    "message_encoding", "messageEncoding" -> this.clearMessageEncoding()
    "json_format", "jsonFormat" -> this.clearJsonFormat()
    "raw_features", "rawFeatures" -> this.clearRawFeatures()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearFieldPresence()
    2 -> this.clearEnumType()
    3 -> this.clearRepeatedFieldEncoding()
    4 -> this.clearStringFieldValidation()
    5 -> this.clearMessageEncoding()
    6 -> this.clearJsonFormat()
    999 -> this.clearRawFeatures()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "field_presence", "fieldPresence" -> this.fieldPresence.uncheckedCast()
    "enum_type", "enumType" -> this.enumType.uncheckedCast()
    "repeated_field_encoding", "repeatedFieldEncoding" -> this.repeatedFieldEncoding.uncheckedCast()
    "string_field_validation", "stringFieldValidation" -> this.stringFieldValidation.uncheckedCast()
    "message_encoding", "messageEncoding" -> this.messageEncoding.uncheckedCast()
    "json_format", "jsonFormat" -> this.jsonFormat.uncheckedCast()
    "raw_features", "rawFeatures" -> this.rawFeatures.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.fieldPresence.uncheckedCast()
    2 -> this.enumType.uncheckedCast()
    3 -> this.repeatedFieldEncoding.uncheckedCast()
    4 -> this.stringFieldValidation.uncheckedCast()
    5 -> this.messageEncoding.uncheckedCast()
    6 -> this.jsonFormat.uncheckedCast()
    999 -> this.rawFeatures.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "field_presence", "fieldPresence" -> this.fieldPresence = value.uncheckedCast()
      "enum_type", "enumType" -> this.enumType = value.uncheckedCast()
      "repeated_field_encoding", "repeatedFieldEncoding" ->
          this.repeatedFieldEncoding = value.uncheckedCast()
      "string_field_validation", "stringFieldValidation" ->
          this.stringFieldValidation = value.uncheckedCast()
      "message_encoding", "messageEncoding" -> this.messageEncoding = value.uncheckedCast()
      "json_format", "jsonFormat" -> this.jsonFormat = value.uncheckedCast()
      "raw_features", "rawFeatures" -> this.rawFeatures = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.fieldPresence = value.uncheckedCast()
      2 -> this.enumType = value.uncheckedCast()
      3 -> this.repeatedFieldEncoding = value.uncheckedCast()
      4 -> this.stringFieldValidation = value.uncheckedCast()
      5 -> this.messageEncoding = value.uncheckedCast()
      6 -> this.jsonFormat = value.uncheckedCast()
      999 -> this.rawFeatures = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "field_presence", "fieldPresence" -> this.hasFieldPresence()
    "enum_type", "enumType" -> this.hasEnumType()
    "repeated_field_encoding", "repeatedFieldEncoding" -> this.hasRepeatedFieldEncoding()
    "string_field_validation", "stringFieldValidation" -> this.hasStringFieldValidation()
    "message_encoding", "messageEncoding" -> this.hasMessageEncoding()
    "json_format", "jsonFormat" -> this.hasJsonFormat()
    "raw_features", "rawFeatures" -> this.hasRawFeatures()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasFieldPresence()
    2 -> this.hasEnumType()
    3 -> this.hasRepeatedFieldEncoding()
    4 -> this.hasStringFieldValidation()
    5 -> this.hasMessageEncoding()
    6 -> this.hasJsonFormat()
    999 -> this.hasRawFeatures()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FeatureSet): Boolean {
    if (fieldPresence != other.fieldPresence) return false
    if (enumType != other.enumType) return false
    if (repeatedFieldEncoding != other.repeatedFieldEncoding) return false
    if (stringFieldValidation != other.stringFieldValidation) return false
    if (messageEncoding != other.messageEncoding) return false
    if (jsonFormat != other.jsonFormat) return false
    if (rawFeatures != other.rawFeatures) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasFieldPresence()) {
      result = result * 37 + 1
      result = result * 31 + this.fieldPresence.hashCode()
    }
    if (hasEnumType()) {
      result = result * 37 + 2
      result = result * 31 + this.enumType.hashCode()
    }
    if (hasRepeatedFieldEncoding()) {
      result = result * 37 + 3
      result = result * 31 + this.repeatedFieldEncoding.hashCode()
    }
    if (hasStringFieldValidation()) {
      result = result * 37 + 4
      result = result * 31 + this.stringFieldValidation.hashCode()
    }
    if (hasMessageEncoding()) {
      result = result * 37 + 5
      result = result * 31 + this.messageEncoding.hashCode()
    }
    if (hasJsonFormat()) {
      result = result * 37 + 6
      result = result * 31 + this.jsonFormat.hashCode()
    }
    if (hasRawFeatures()) {
      result = result * 37 + 999
      result = result * 31 + this.rawFeatures!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasFieldPresence()) {
      writer.tag(8).enum(this.fieldPresence)
    }
    if (hasEnumType()) {
      writer.tag(16).enum(this.enumType)
    }
    if (hasRepeatedFieldEncoding()) {
      writer.tag(24).enum(this.repeatedFieldEncoding)
    }
    if (hasStringFieldValidation()) {
      writer.tag(32).enum(this.stringFieldValidation)
    }
    if (hasMessageEncoding()) {
      writer.tag(40).enum(this.messageEncoding)
    }
    if (hasJsonFormat()) {
      writer.tag(48).enum(this.jsonFormat)
    }
    if (hasRawFeatures()) {
      writer.tag(7994).message(this.rawFeatures)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.fieldPresence = FeatureSet.FieldPresence(reader.int32())
      2 -> this.enumType = FeatureSet.EnumType(reader.int32())
      3 -> this.repeatedFieldEncoding = FeatureSet.RepeatedFieldEncoding(reader.int32())
      4 -> this.stringFieldValidation = FeatureSet.StringFieldValidation(reader.int32())
      5 -> this.messageEncoding = FeatureSet.MessageEncoding(reader.int32())
      6 -> this.jsonFormat = FeatureSet.JsonFormat(reader.int32())
      999 -> this.rawFeatures = FeatureSet.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class FeatureSetSupport internal constructor() :
    MessageSupport<FeatureSet, MutableFeatureSet>() {
  public override val name: String
    get() = ".google.protobuf.FeatureSet"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "FeatureSet" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFeatureSet = FeatureSetImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FeatureSet.FieldPresence,
      FeatureSet.EnumType, FeatureSet.RepeatedFieldEncoding, FeatureSet.StringFieldValidation,
      FeatureSet.MessageEncoding, FeatureSet.JsonFormat)

  public abstract class FieldPresenceSupport internal constructor() :
      EnumSupport<FeatureSet.FieldPresence>() {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.FieldPresence"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "FieldPresence" }
    }


    public override fun values(): Array<FeatureSet.FieldPresence> =
        FeatureSet.FieldPresence.values()
  }

  public abstract class EnumTypeSupport internal constructor() : EnumSupport<FeatureSet.EnumType>()
      {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.EnumType"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "EnumType" }
    }


    public override fun values(): Array<FeatureSet.EnumType> = FeatureSet.EnumType.values()
  }

  public abstract class RepeatedFieldEncodingSupport internal constructor() :
      EnumSupport<FeatureSet.RepeatedFieldEncoding>() {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.RepeatedFieldEncoding"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "RepeatedFieldEncoding" }
    }


    public override fun values(): Array<FeatureSet.RepeatedFieldEncoding> =
        FeatureSet.RepeatedFieldEncoding.values()
  }

  public abstract class StringFieldValidationSupport internal constructor() :
      EnumSupport<FeatureSet.StringFieldValidation>() {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.StringFieldValidation"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "StringFieldValidation" }
    }


    public override fun values(): Array<FeatureSet.StringFieldValidation> =
        FeatureSet.StringFieldValidation.values()
  }

  public abstract class MessageEncodingSupport internal constructor() :
      EnumSupport<FeatureSet.MessageEncoding>() {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.MessageEncoding"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "MessageEncoding" }
    }


    public override fun values(): Array<FeatureSet.MessageEncoding> =
        FeatureSet.MessageEncoding.values()
  }

  public abstract class JsonFormatSupport internal constructor() :
      EnumSupport<FeatureSet.JsonFormat>() {
    public override val name: String
      get() = ".google.protobuf.FeatureSet.JsonFormat"

    public override val parent: FeatureSet.Companion
      get() = FeatureSet

    public override val descriptor: EnumDescriptorProto by lazy {
      FeatureSet.descriptor.enumType.first{ it.name == "JsonFormat" }
    }


    public override fun values(): Array<FeatureSet.JsonFormat> = FeatureSet.JsonFormat.values()
  }
}

public interface MutableSourceCodeInfo : MutableMessage<SourceCodeInfo, MutableSourceCodeInfo>,
    SourceCodeInfo {
  public override val location: MutableList<SourceCodeInfo.Location>

  public fun clearLocation(): List<SourceCodeInfo.Location>

  public interface MutableLocation : MutableMessage<SourceCodeInfo.Location, MutableLocation>,
      SourceCodeInfo.Location {
    public override val path: MutableList<Int>

    public override val span: MutableList<Int>

    public override var leadingComments: String

    public override var trailingComments: String

    public override val leadingDetachedComments: MutableList<String>

    public fun clearPath(): List<Int>

    public fun clearSpan(): List<Int>

    public fun clearLeadingComments(): String?

    public fun clearTrailingComments(): String?

    public fun clearLeadingDetachedComments(): List<String>
  }
}

@InternalProtoApi
internal class SourceCodeInfoImpl : AbstractMutableMessage<SourceCodeInfo, MutableSourceCodeInfo>(),
    MutableSourceCodeInfo {
  public override val location: MutableList<SourceCodeInfo.Location> = mutableListOf()

  public override fun hasLocation(): Boolean = location.isNotEmpty()

  public override fun clearLocation(): List<SourceCodeInfo.Location> = location.toList().also {
    location.clear()
  }

  public override fun support(): MessageSupport<SourceCodeInfo, MutableSourceCodeInfo> =
      SourceCodeInfo

  public override fun mergeWith(other: SourceCodeInfo?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableSourceCodeInfo = SourceCodeInfoImpl().apply {
    mergeWith(this@SourceCodeInfoImpl)
  }

  public override fun clear(): Unit {
    this.clearLocation()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "location" -> this.clearLocation()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearLocation()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "location" -> this.location.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.location.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "location" -> {
        this.location.clear()
        this.location.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.location.clear()
        this.location.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "location" -> this.hasLocation()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasLocation()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: SourceCodeInfo): Boolean {
    if (!location.contentEquals(other.location)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.location) {
      result = result * 37 + 1
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.location.forEach { writer.tag(10).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.location += SourceCodeInfo.Location.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class LocationImpl :
      AbstractMutableMessage<SourceCodeInfo.Location, MutableSourceCodeInfo.MutableLocation>(),
      MutableSourceCodeInfo.MutableLocation {
    public override val path: MutableList<Int> = mutableListOf()

    public override val span: MutableList<Int> = mutableListOf()

    private var _hasLeadingComments: Boolean = false

    public override var leadingComments: String = ""
      get() = if(_hasLeadingComments) field else ""
      set(`value`) {
        field = value
        _hasLeadingComments = true
      }

    private var _hasTrailingComments: Boolean = false

    public override var trailingComments: String = ""
      get() = if(_hasTrailingComments) field else ""
      set(`value`) {
        field = value
        _hasTrailingComments = true
      }

    public override val leadingDetachedComments: MutableList<String> = mutableListOf()

    public override fun hasPath(): Boolean = path.isNotEmpty()

    public override fun clearPath(): List<Int> = path.toList().also {
      path.clear()
    }

    public override fun hasSpan(): Boolean = span.isNotEmpty()

    public override fun clearSpan(): List<Int> = span.toList().also {
      span.clear()
    }

    public override fun hasLeadingComments(): Boolean = _hasLeadingComments

    public override fun clearLeadingComments(): String? {
      if (!hasLeadingComments()) return null
      return leadingComments.also {
        leadingComments = ""
        _hasLeadingComments = false
      }
    }

    public override fun hasTrailingComments(): Boolean = _hasTrailingComments

    public override fun clearTrailingComments(): String? {
      if (!hasTrailingComments()) return null
      return trailingComments.also {
        trailingComments = ""
        _hasTrailingComments = false
      }
    }

    public override fun hasLeadingDetachedComments(): Boolean = leadingDetachedComments.isNotEmpty()

    public override fun clearLeadingDetachedComments(): List<String> =
        leadingDetachedComments.toList().also {
      leadingDetachedComments.clear()
    }

    public override fun support():
        MessageSupport<SourceCodeInfo.Location, MutableSourceCodeInfo.MutableLocation> =
        SourceCodeInfo.Location

    public override fun mergeWith(other: SourceCodeInfo.Location?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableSourceCodeInfo.MutableLocation =
        LocationImpl().apply {
      mergeWith(this@LocationImpl)
    }

    public override fun clear(): Unit {
      this.clearPath()
      this.clearSpan()
      this.clearLeadingComments()
      this.clearTrailingComments()
      this.clearLeadingDetachedComments()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "path" -> this.clearPath()
      "span" -> this.clearSpan()
      "leading_comments", "leadingComments" -> this.clearLeadingComments()
      "trailing_comments", "trailingComments" -> this.clearTrailingComments()
      "leading_detached_comments", "leadingDetachedComments" -> this.clearLeadingDetachedComments()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearPath()
      2 -> this.clearSpan()
      3 -> this.clearLeadingComments()
      4 -> this.clearTrailingComments()
      6 -> this.clearLeadingDetachedComments()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "path" -> this.path.uncheckedCast()
      "span" -> this.span.uncheckedCast()
      "leading_comments", "leadingComments" -> this.leadingComments.uncheckedCast()
      "trailing_comments", "trailingComments" -> this.trailingComments.uncheckedCast()
      "leading_detached_comments", "leadingDetachedComments" ->
          this.leadingDetachedComments.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.path.uncheckedCast()
      2 -> this.span.uncheckedCast()
      3 -> this.leadingComments.uncheckedCast()
      4 -> this.trailingComments.uncheckedCast()
      6 -> this.leadingDetachedComments.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "path" -> {
          this.path.clear()
          this.path.addAll(value.uncheckedCast())
        }
        "span" -> {
          this.span.clear()
          this.span.addAll(value.uncheckedCast())
        }
        "leading_comments", "leadingComments" -> this.leadingComments = value.uncheckedCast()
        "trailing_comments", "trailingComments" -> this.trailingComments = value.uncheckedCast()
        "leading_detached_comments", "leadingDetachedComments" -> {
          this.leadingDetachedComments.clear()
          this.leadingDetachedComments.addAll(value.uncheckedCast())
        }
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> {
          this.path.clear()
          this.path.addAll(value.uncheckedCast())
        }
        2 -> {
          this.span.clear()
          this.span.addAll(value.uncheckedCast())
        }
        3 -> this.leadingComments = value.uncheckedCast()
        4 -> this.trailingComments = value.uncheckedCast()
        6 -> {
          this.leadingDetachedComments.clear()
          this.leadingDetachedComments.addAll(value.uncheckedCast())
        }
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "path" -> this.hasPath()
      "span" -> this.hasSpan()
      "leading_comments", "leadingComments" -> this.hasLeadingComments()
      "trailing_comments", "trailingComments" -> this.hasTrailingComments()
      "leading_detached_comments", "leadingDetachedComments" -> this.hasLeadingDetachedComments()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasPath()
      2 -> this.hasSpan()
      3 -> this.hasLeadingComments()
      4 -> this.hasTrailingComments()
      6 -> this.hasLeadingDetachedComments()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: SourceCodeInfo.Location): Boolean {
      if (!path.contentEquals(other.path)) return false
      if (!span.contentEquals(other.span)) return false
      if (leadingComments != other.leadingComments) return false
      if (trailingComments != other.trailingComments) return false
      if (!leadingDetachedComments.contentEquals(other.leadingDetachedComments)) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      for (value in this.path) {
        result = result * 37 + 1
        result = result * 31 + value.hashCode()
      }
      for (value in this.span) {
        result = result * 37 + 2
        result = result * 31 + value.hashCode()
      }
      if (hasLeadingComments()) {
        result = result * 37 + 3
        result = result * 31 + this.leadingComments.hashCode()
      }
      if (hasTrailingComments()) {
        result = result * 37 + 4
        result = result * 31 + this.trailingComments.hashCode()
      }
      for (value in this.leadingDetachedComments) {
        result = result * 37 + 6
        result = result * 31 + value.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      writer.tag(10).beginLd().apply{ this@LocationImpl.path.forEach { int32(it) } }.endLd()
      writer.tag(18).beginLd().apply{ this@LocationImpl.span.forEach { int32(it) } }.endLd()
      if (hasLeadingComments()) {
        writer.tag(26).string(this.leadingComments)
      }
      if (hasTrailingComments()) {
        writer.tag(34).string(this.trailingComments)
      }
      this.leadingDetachedComments.forEach { writer.tag(50).string(it) }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> reader.packed(wire) { this.path += it.int32() }
        2 -> reader.packed(wire) { this.span += it.int32() }
        3 -> this.leadingComments = reader.string()
        4 -> this.trailingComments = reader.string()
        6 -> this.leadingDetachedComments += reader.string()
        else -> return false
      }
      return true
    }
  }
}

public open class SourceCodeInfoSupport internal constructor() :
    MessageSupport<SourceCodeInfo, MutableSourceCodeInfo>() {
  public override val name: String
    get() = ".google.protobuf.SourceCodeInfo"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "SourceCodeInfo" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableSourceCodeInfo = SourceCodeInfoImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(SourceCodeInfo.Location)

  public open class LocationSupport internal constructor() :
      MessageSupport<SourceCodeInfo.Location, MutableSourceCodeInfo.MutableLocation>() {
    public override val name: String
      get() = ".google.protobuf.SourceCodeInfo.Location"

    public override val parent: SourceCodeInfo.Companion
      get() = SourceCodeInfo

    public override val descriptor: DescriptorProto by lazy {
      SourceCodeInfo.descriptor.nestedType.first{ it.name == "Location" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableSourceCodeInfo.MutableLocation =
        SourceCodeInfoImpl.LocationImpl()
  }
}

public interface MutableGeneratedCodeInfo :
    MutableMessage<GeneratedCodeInfo, MutableGeneratedCodeInfo>, GeneratedCodeInfo {
  public override val `annotation`: MutableList<GeneratedCodeInfo.Annotation>

  public fun clearAnnotation(): List<GeneratedCodeInfo.Annotation>

  public interface MutableAnnotation :
      MutableMessage<GeneratedCodeInfo.Annotation, MutableAnnotation>, GeneratedCodeInfo.Annotation
      {
    public override val path: MutableList<Int>

    public override var sourceFile: String

    public override var begin: Int

    public override var end: Int

    public override var semantic: GeneratedCodeInfo.Annotation.Semantic

    public fun clearPath(): List<Int>

    public fun clearSourceFile(): String?

    public fun clearBegin(): Int?

    public fun clearEnd(): Int?

    public fun clearSemantic(): GeneratedCodeInfo.Annotation.Semantic?
  }
}

@InternalProtoApi
internal class GeneratedCodeInfoImpl :
    AbstractMutableMessage<GeneratedCodeInfo, MutableGeneratedCodeInfo>(), MutableGeneratedCodeInfo
    {
  public override val `annotation`: MutableList<GeneratedCodeInfo.Annotation> = mutableListOf()

  public override fun hasAnnotation(): Boolean = `annotation`.isNotEmpty()

  public override fun clearAnnotation(): List<GeneratedCodeInfo.Annotation> =
      `annotation`.toList().also {
    `annotation`.clear()
  }

  public override fun support(): MessageSupport<GeneratedCodeInfo, MutableGeneratedCodeInfo> =
      GeneratedCodeInfo

  public override fun mergeWith(other: GeneratedCodeInfo?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableGeneratedCodeInfo = GeneratedCodeInfoImpl().apply {
    mergeWith(this@GeneratedCodeInfoImpl)
  }

  public override fun clear(): Unit {
    this.clearAnnotation()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "annotation" -> this.clearAnnotation()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearAnnotation()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "annotation" -> this.`annotation`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`annotation`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "annotation" -> {
        this.`annotation`.clear()
        this.`annotation`.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.`annotation`.clear()
        this.`annotation`.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "annotation" -> this.hasAnnotation()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasAnnotation()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: GeneratedCodeInfo): Boolean {
    if (!`annotation`.contentEquals(other.`annotation`)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.`annotation`) {
      result = result * 37 + 1
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.`annotation`.forEach { writer.tag(10).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`annotation` += GeneratedCodeInfo.Annotation.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }

  @InternalProtoApi
  internal class AnnotationImpl :
      AbstractMutableMessage<GeneratedCodeInfo.Annotation, MutableGeneratedCodeInfo.MutableAnnotation>(),
      MutableGeneratedCodeInfo.MutableAnnotation {
    public override val path: MutableList<Int> = mutableListOf()

    private var _hasSourceFile: Boolean = false

    public override var sourceFile: String = ""
      get() = if(_hasSourceFile) field else ""
      set(`value`) {
        field = value
        _hasSourceFile = true
      }

    private var _hasBegin: Boolean = false

    public override var begin: Int = 0
      get() = if(_hasBegin) field else 0
      set(`value`) {
        field = value
        _hasBegin = true
      }

    private var _hasEnd: Boolean = false

    public override var end: Int = 0
      get() = if(_hasEnd) field else 0
      set(`value`) {
        field = value
        _hasEnd = true
      }

    private var _hasSemantic: Boolean = false

    public override var semantic: GeneratedCodeInfo.Annotation.Semantic =
        GeneratedCodeInfo.Annotation.Semantic()
      get() = if(_hasSemantic) field else GeneratedCodeInfo.Annotation.Semantic()
      set(`value`) {
        field = value
        _hasSemantic = true
      }

    public override fun hasPath(): Boolean = path.isNotEmpty()

    public override fun clearPath(): List<Int> = path.toList().also {
      path.clear()
    }

    public override fun hasSourceFile(): Boolean = _hasSourceFile

    public override fun clearSourceFile(): String? {
      if (!hasSourceFile()) return null
      return sourceFile.also {
        sourceFile = ""
        _hasSourceFile = false
      }
    }

    public override fun hasBegin(): Boolean = _hasBegin

    public override fun clearBegin(): Int? {
      if (!hasBegin()) return null
      return begin.also {
        begin = 0
        _hasBegin = false
      }
    }

    public override fun hasEnd(): Boolean = _hasEnd

    public override fun clearEnd(): Int? {
      if (!hasEnd()) return null
      return end.also {
        end = 0
        _hasEnd = false
      }
    }

    public override fun hasSemantic(): Boolean = _hasSemantic

    public override fun clearSemantic(): GeneratedCodeInfo.Annotation.Semantic? {
      if (!hasSemantic()) return null
      return semantic.also {
        semantic = GeneratedCodeInfo.Annotation.Semantic()
        _hasSemantic = false
      }
    }

    public override fun support():
        MessageSupport<GeneratedCodeInfo.Annotation, MutableGeneratedCodeInfo.MutableAnnotation> =
        GeneratedCodeInfo.Annotation

    public override fun mergeWith(other: GeneratedCodeInfo.Annotation?): Unit {
      other ?: return
      val proto = other.toProto()
      readFrom(Reader(proto.inputStream()), proto.size)
    }

    @InternalProtoApi
    public override fun cloneMutable(): MutableGeneratedCodeInfo.MutableAnnotation =
        AnnotationImpl().apply {
      mergeWith(this@AnnotationImpl)
    }

    public override fun clear(): Unit {
      this.clearPath()
      this.clearSourceFile()
      this.clearBegin()
      this.clearEnd()
      this.clearSemantic()
    }

    public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
      "path" -> this.clearPath()
      "source_file", "sourceFile" -> this.clearSourceFile()
      "begin" -> this.clearBegin()
      "end" -> this.clearEnd()
      "semantic" -> this.clearSemantic()
      else -> clearFieldInExtensions(fieldName)
    }

    public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
      1 -> this.clearPath()
      2 -> this.clearSourceFile()
      3 -> this.clearBegin()
      4 -> this.clearEnd()
      5 -> this.clearSemantic()
      else -> clearFieldInExtensions(fieldNumber)
    }

    public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
      "path" -> this.path.uncheckedCast()
      "source_file", "sourceFile" -> this.sourceFile.uncheckedCast()
      "begin" -> this.begin.uncheckedCast()
      "end" -> this.end.uncheckedCast()
      "semantic" -> this.semantic.uncheckedCast()
      else -> getFieldInExtensions(fieldName)
    }

    public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
      1 -> this.path.uncheckedCast()
      2 -> this.sourceFile.uncheckedCast()
      3 -> this.begin.uncheckedCast()
      4 -> this.end.uncheckedCast()
      5 -> this.semantic.uncheckedCast()
      else -> getFieldInExtensions(fieldNumber)
    }

    public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
      when(fieldName) {
        "path" -> {
          this.path.clear()
          this.path.addAll(value.uncheckedCast())
        }
        "source_file", "sourceFile" -> this.sourceFile = value.uncheckedCast()
        "begin" -> this.begin = value.uncheckedCast()
        "end" -> this.end = value.uncheckedCast()
        "semantic" -> this.semantic = value.uncheckedCast()
        else -> setFieldInExtensions(fieldName, value)
      }
    }

    public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
      when(fieldNumber) {
        1 -> {
          this.path.clear()
          this.path.addAll(value.uncheckedCast())
        }
        2 -> this.sourceFile = value.uncheckedCast()
        3 -> this.begin = value.uncheckedCast()
        4 -> this.end = value.uncheckedCast()
        5 -> this.semantic = value.uncheckedCast()
        else -> setFieldInExtensions(fieldNumber, value)
      }
    }

    public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
      "path" -> this.hasPath()
      "source_file", "sourceFile" -> this.hasSourceFile()
      "begin" -> this.hasBegin()
      "end" -> this.hasEnd()
      "semantic" -> this.hasSemantic()
      else -> hasFieldInExtensions(fieldName)
    }

    public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
      1 -> this.hasPath()
      2 -> this.hasSourceFile()
      3 -> this.hasBegin()
      4 -> this.hasEnd()
      5 -> this.hasSemantic()
      else -> hasFieldInExtensions(fieldNumber)
    }

    public override fun equalsMessage(other: GeneratedCodeInfo.Annotation): Boolean {
      if (!path.contentEquals(other.path)) return false
      if (sourceFile != other.sourceFile) return false
      if (begin != other.begin) return false
      if (end != other.end) return false
      if (semantic != other.semantic) return false
      return true
    }

    public override fun computeHashCode(): Int {
      var result = this.javaClass.hashCode()
      for (value in this.path) {
        result = result * 37 + 1
        result = result * 31 + value.hashCode()
      }
      if (hasSourceFile()) {
        result = result * 37 + 2
        result = result * 31 + this.sourceFile.hashCode()
      }
      if (hasBegin()) {
        result = result * 37 + 3
        result = result * 31 + this.begin.hashCode()
      }
      if (hasEnd()) {
        result = result * 37 + 4
        result = result * 31 + this.end.hashCode()
      }
      if (hasSemantic()) {
        result = result * 37 + 5
        result = result * 31 + this.semantic.hashCode()
      }
      return result
    }

    public override fun writeFields(writer: Writer): Unit {
      writer.tag(10).beginLd().apply{ this@AnnotationImpl.path.forEach { int32(it) } }.endLd()
      if (hasSourceFile()) {
        writer.tag(18).string(this.sourceFile)
      }
      if (hasBegin()) {
        writer.tag(24).int32(this.begin)
      }
      if (hasEnd()) {
        writer.tag(32).int32(this.end)
      }
      if (hasSemantic()) {
        writer.tag(40).enum(this.semantic)
      }
    }

    @InternalProtoApi
    public override fun readField(
      reader: Reader,
      `field`: Int,
      wire: Int,
    ): Boolean {
      when(field) {
        1 -> reader.packed(wire) { this.path += it.int32() }
        2 -> this.sourceFile = reader.string()
        3 -> this.begin = reader.int32()
        4 -> this.end = reader.int32()
        5 -> this.semantic = GeneratedCodeInfo.Annotation.Semantic(reader.int32())
        else -> return false
      }
      return true
    }
  }
}

public open class GeneratedCodeInfoSupport internal constructor() :
    MessageSupport<GeneratedCodeInfo, MutableGeneratedCodeInfo>() {
  public override val name: String
    get() = ".google.protobuf.GeneratedCodeInfo"

  public override val parent: FileSupport
    get() = DescriptorMetadata

  public override val descriptor: DescriptorProto by lazy {
    DescriptorMetadata.descriptor.messageType.first{ it.name == "GeneratedCodeInfo" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableGeneratedCodeInfo = GeneratedCodeInfoImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(GeneratedCodeInfo.Annotation)

  public open class AnnotationSupport internal constructor() :
      MessageSupport<GeneratedCodeInfo.Annotation, MutableGeneratedCodeInfo.MutableAnnotation>() {
    public override val name: String
      get() = ".google.protobuf.GeneratedCodeInfo.Annotation"

    public override val parent: GeneratedCodeInfo.Companion
      get() = GeneratedCodeInfo

    public override val descriptor: DescriptorProto by lazy {
      GeneratedCodeInfo.descriptor.nestedType.first{ it.name == "Annotation" }
    }


    @InternalProtoApi
    public override fun newMutable(): MutableGeneratedCodeInfo.MutableAnnotation =
        GeneratedCodeInfoImpl.AnnotationImpl()

    public override fun children(): Array<ProtoSupport<*>> =
        arrayOf(GeneratedCodeInfo.Annotation.Semantic)

    public abstract class SemanticSupport internal constructor() :
        EnumSupport<GeneratedCodeInfo.Annotation.Semantic>() {
      public override val name: String
        get() = ".google.protobuf.GeneratedCodeInfo.Annotation.Semantic"

      public override val parent: GeneratedCodeInfo.Annotation.Companion
        get() = GeneratedCodeInfo.Annotation

      public override val descriptor: EnumDescriptorProto by lazy {
        GeneratedCodeInfo.Annotation.descriptor.enumType.first{ it.name == "Semantic" }
      }


      public override fun values(): Array<GeneratedCodeInfo.Annotation.Semantic> =
          GeneratedCodeInfo.Annotation.Semantic.values()
    }
  }
}
