package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.Empty
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.lazy

public object EmptyMetadata : FileSupport() {
  public override val name: String = "google/protobuf/empty.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/empty.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Empty)
}

public interface MutableEmpty : MutableMessage<Empty, MutableEmpty>, Empty

@InternalProtoApi
internal class EmptyImpl : AbstractMutableMessage<Empty, MutableEmpty>(), MutableEmpty {
  public override fun support(): MessageSupport<Empty, MutableEmpty> = Empty

  public override fun mergeWith(other: Empty?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEmpty = EmptyImpl().apply {
    mergeWith(this@EmptyImpl)
  }

  public override fun clear(): Unit {
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? =
      clearFieldInExtensions(fieldName)

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? =
      clearFieldInExtensions(fieldNumber)

  public override fun <T> getFieldInCurrent(fieldName: String): T = getFieldInExtensions(fieldName)

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = getFieldInExtensions(fieldNumber)

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    setFieldInExtensions(fieldName, value)
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    setFieldInExtensions(fieldNumber, value)
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean =
      hasFieldInExtensions(fieldName)

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean =
      hasFieldInExtensions(fieldNumber)

  public override fun equalsMessage(other: Empty): Boolean = true

  public override fun computeHashCode(): Int = this.javaClass.hashCode()

  public override fun writeFields(writer: Writer): Unit {
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean = false
}

public open class EmptySupport internal constructor() : MessageSupport<Empty, MutableEmpty>() {
  public override val name: String
    get() = ".google.protobuf.Empty"

  public override val parent: FileSupport
    get() = EmptyMetadata

  public override val descriptor: DescriptorProto by lazy {
    EmptyMetadata.descriptor.messageType.first{ it.name == "Empty" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEmpty = EmptyImpl()
}
