package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.collection.contentEquals
import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FieldMask
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.lazy

public object FieldMaskMetadata : FileSupport() {
  public override val name: String = "google/protobuf/field_mask.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/field_mask.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(FieldMask)
}

public interface MutableFieldMask : MutableMessage<FieldMask, MutableFieldMask>, FieldMask {
  public override val paths: MutableList<String>

  public fun clearPaths(): List<String>
}

@InternalProtoApi
internal class FieldMaskImpl : AbstractMutableMessage<FieldMask, MutableFieldMask>(),
    MutableFieldMask {
  public override val paths: MutableList<String> = mutableListOf()

  public override fun hasPaths(): Boolean = paths.isNotEmpty()

  public override fun clearPaths(): List<String> = paths.toList().also {
    paths.clear()
  }

  public override fun support(): MessageSupport<FieldMask, MutableFieldMask> = FieldMask

  public override fun mergeWith(other: FieldMask?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFieldMask = FieldMaskImpl().apply {
    mergeWith(this@FieldMaskImpl)
  }

  public override fun clear(): Unit {
    this.clearPaths()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "paths" -> this.clearPaths()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearPaths()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "paths" -> this.paths.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.paths.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "paths" -> {
        this.paths.clear()
        this.paths.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.paths.clear()
        this.paths.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "paths" -> this.hasPaths()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasPaths()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FieldMask): Boolean {
    if (!paths.contentEquals(other.paths)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.paths) {
      result = result * 37 + 1
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.paths.forEach { writer.tag(10).string(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.paths += reader.string()
      else -> return false
    }
    return true
  }
}

public open class FieldMaskSupport internal constructor() :
    MessageSupport<FieldMask, MutableFieldMask>() {
  public override val name: String
    get() = ".google.protobuf.FieldMask"

  public override val parent: FileSupport
    get() = FieldMaskMetadata

  public override val descriptor: DescriptorProto by lazy {
    FieldMaskMetadata.descriptor.messageType.first{ it.name == "FieldMask" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFieldMask = FieldMaskImpl()
}
