package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.SourceContext
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.lazy

public object SourceContextMetadata : FileSupport() {
  public override val name: String = "google/protobuf/source_context.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/source_context.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(SourceContext)
}

public interface MutableSourceContext : MutableMessage<SourceContext, MutableSourceContext>,
    SourceContext {
  public override var fileName: String

  public fun clearFileName(): String?
}

@InternalProtoApi
internal class SourceContextImpl : AbstractMutableMessage<SourceContext, MutableSourceContext>(),
    MutableSourceContext {
  private var _hasFileName: Boolean = false

  public override var fileName: String = ""
    get() = if(_hasFileName) field else ""
    set(`value`) {
      field = value
      _hasFileName = true
    }

  public override fun hasFileName(): Boolean = _hasFileName

  public override fun clearFileName(): String? {
    if (!hasFileName()) return null
    return fileName.also {
      fileName = ""
      _hasFileName = false
    }
  }

  public override fun support(): MessageSupport<SourceContext, MutableSourceContext> = SourceContext

  public override fun mergeWith(other: SourceContext?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableSourceContext = SourceContextImpl().apply {
    mergeWith(this@SourceContextImpl)
  }

  public override fun clear(): Unit {
    this.clearFileName()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "file_name", "fileName" -> this.clearFileName()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearFileName()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "file_name", "fileName" -> this.fileName.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.fileName.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "file_name", "fileName" -> this.fileName = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.fileName = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "file_name", "fileName" -> this.hasFileName()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasFileName()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: SourceContext): Boolean {
    if (fileName != other.fileName) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasFileName()) {
      result = result * 37 + 1
      result = result * 31 + this.fileName.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasFileName()) {
      writer.tag(10).string(this.fileName)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.fileName = reader.string()
      else -> return false
    }
    return true
  }
}

public open class SourceContextSupport internal constructor() :
    MessageSupport<SourceContext, MutableSourceContext>() {
  public override val name: String
    get() = ".google.protobuf.SourceContext"

  public override val parent: FileSupport
    get() = SourceContextMetadata

  public override val descriptor: DescriptorProto by lazy {
    SourceContextMetadata.descriptor.messageType.first{ it.name == "SourceContext" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableSourceContext = SourceContextImpl()
}
