package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.collection.contentEquals
import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.EnumDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.ListValue
import com.bybutter.sisyphus.protobuf.primitives.NullValue
import com.bybutter.sisyphus.protobuf.primitives.Struct
import com.bybutter.sisyphus.protobuf.primitives.Value
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.lazy

public abstract class NullValueSupport internal constructor() : EnumSupport<NullValue>() {
  public override val name: String
    get() = ".google.protobuf.NullValue"

  public override val parent: FileSupport
    get() = StructMetadata

  public override val descriptor: EnumDescriptorProto by lazy {
    StructMetadata.descriptor.enumType.first{ it.name == "NullValue" }
  }


  public override fun values(): Array<NullValue> = NullValue.values()
}

public object StructMetadata : FileSupport() {
  public override val name: String = "google/protobuf/struct.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/struct.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Struct, Value, ListValue,
      NullValue)
}

public interface MutableStruct : MutableMessage<Struct, MutableStruct>, Struct {
  public override val fields: MutableMap<String, Value>

  public fun clearFields(): Map<String, Value>
}

@InternalProtoApi
internal class StructImpl : AbstractMutableMessage<Struct, MutableStruct>(), MutableStruct {
  public override val fields: MutableMap<String, Value> = mutableMapOf()

  public override fun hasFields(): Boolean = fields.isNotEmpty()

  public override fun clearFields(): Map<String, Value> = fields.toMap().also {
    fields.clear()
  }

  public override fun support(): MessageSupport<Struct, MutableStruct> = Struct

  public override fun mergeWith(other: Struct?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableStruct = StructImpl().apply {
    mergeWith(this@StructImpl)
  }

  public override fun clear(): Unit {
    this.clearFields()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "fields" -> this.clearFields()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearFields()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "fields" -> this.fields.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.fields.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "fields" -> {
        this.fields.clear()
        this.fields.putAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.fields.clear()
        this.fields.putAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "fields" -> this.hasFields()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasFields()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Struct): Boolean {
    if (!fields.contentEquals(other.fields)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for ((key, value) in this.fields) {
      result = result * 37 + 1
      result = result * 31 + key.hashCode()
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.fields.forEach { (k, v) ->
        writer.tag(10).beginLd().tag(10).string(k).tag(18).message(v).endLd() }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> reader.mapEntry({ it.string() }, { Value.newMutable().apply { readFrom(reader) } }) {
          k, v -> this.fields[k] = v }
      else -> return false
    }
    return true
  }
}

public open class StructSupport internal constructor() : MessageSupport<Struct, MutableStruct>() {
  public override val name: String
    get() = ".google.protobuf.Struct"

  public override val parent: FileSupport
    get() = StructMetadata

  public override val descriptor: DescriptorProto by lazy {
    StructMetadata.descriptor.messageType.first{ it.name == "Struct" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableStruct = StructImpl()
}

public interface MutableValue : MutableMessage<Value, MutableValue>, Value {
  public override var nullValue: NullValue

  public override var numberValue: Double

  public override var stringValue: String

  public override var boolValue: Boolean

  public override var structValue: Struct?

  public override var listValue: ListValue?

  public override var kind: Value.Kind<*>?

  public fun clearNullValue(): NullValue?

  public fun clearNumberValue(): Double?

  public fun clearStringValue(): String?

  public fun clearBoolValue(): Boolean?

  public fun clearStructValue(): Struct?

  public fun clearListValue(): ListValue?
}

@InternalProtoApi
internal class ValueImpl : AbstractMutableMessage<Value, MutableValue>(), MutableValue {
  public override var nullValue: NullValue
    get() = (kind as? Value.Kind.NullValue)?.value ?: NullValue()
    set(`value`) {
      kind = Value.Kind.NullValue(value)
    }

  public override var numberValue: Double
    get() = (kind as? Value.Kind.NumberValue)?.value ?: 0.0
    set(`value`) {
      kind = Value.Kind.NumberValue(value)
    }

  public override var stringValue: String
    get() = (kind as? Value.Kind.StringValue)?.value ?: ""
    set(`value`) {
      kind = Value.Kind.StringValue(value)
    }

  public override var boolValue: Boolean
    get() = (kind as? Value.Kind.BoolValue)?.value ?: false
    set(`value`) {
      kind = Value.Kind.BoolValue(value)
    }

  public override var structValue: Struct?
    get() = (kind as? Value.Kind.StructValue)?.value
    set(`value`) {
      kind = value?.let { Value.Kind.StructValue(it) }
    }

  public override var listValue: ListValue?
    get() = (kind as? Value.Kind.ListValue)?.value
    set(`value`) {
      kind = value?.let { Value.Kind.ListValue(it) }
    }

  public override var kind: Value.Kind<*>? = null

  public override fun hasNullValue(): Boolean = kind is Value.Kind.NullValue

  public override fun clearNullValue(): NullValue? = (kind as? Value.Kind.NullValue)?.value?.also {
    kind = null
  }

  public override fun hasNumberValue(): Boolean = kind is Value.Kind.NumberValue

  public override fun clearNumberValue(): Double? = (kind as? Value.Kind.NumberValue)?.value?.also {
    kind = null
  }

  public override fun hasStringValue(): Boolean = kind is Value.Kind.StringValue

  public override fun clearStringValue(): String? = (kind as? Value.Kind.StringValue)?.value?.also {
    kind = null
  }

  public override fun hasBoolValue(): Boolean = kind is Value.Kind.BoolValue

  public override fun clearBoolValue(): Boolean? = (kind as? Value.Kind.BoolValue)?.value?.also {
    kind = null
  }

  public override fun hasStructValue(): Boolean = kind is Value.Kind.StructValue

  public override fun clearStructValue(): Struct? = (kind as? Value.Kind.StructValue)?.value?.also {
    kind = null
  }

  public override fun hasListValue(): Boolean = kind is Value.Kind.ListValue

  public override fun clearListValue(): ListValue? = (kind as? Value.Kind.ListValue)?.value?.also {
    kind = null
  }

  public override fun support(): MessageSupport<Value, MutableValue> = Value

  public override fun mergeWith(other: Value?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableValue = ValueImpl().apply {
    mergeWith(this@ValueImpl)
  }

  public override fun clear(): Unit {
    this.clearNullValue()
    this.clearNumberValue()
    this.clearStringValue()
    this.clearBoolValue()
    this.clearStructValue()
    this.clearListValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "null_value", "nullValue" -> this.clearNullValue()
    "number_value", "numberValue" -> this.clearNumberValue()
    "string_value", "stringValue" -> this.clearStringValue()
    "bool_value", "boolValue" -> this.clearBoolValue()
    "struct_value", "structValue" -> this.clearStructValue()
    "list_value", "listValue" -> this.clearListValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearNullValue()
    2 -> this.clearNumberValue()
    3 -> this.clearStringValue()
    4 -> this.clearBoolValue()
    5 -> this.clearStructValue()
    6 -> this.clearListValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "null_value", "nullValue" -> this.nullValue.uncheckedCast()
    "number_value", "numberValue" -> this.numberValue.uncheckedCast()
    "string_value", "stringValue" -> this.stringValue.uncheckedCast()
    "bool_value", "boolValue" -> this.boolValue.uncheckedCast()
    "struct_value", "structValue" -> this.structValue.uncheckedCast()
    "list_value", "listValue" -> this.listValue.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.nullValue.uncheckedCast()
    2 -> this.numberValue.uncheckedCast()
    3 -> this.stringValue.uncheckedCast()
    4 -> this.boolValue.uncheckedCast()
    5 -> this.structValue.uncheckedCast()
    6 -> this.listValue.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "null_value", "nullValue" -> this.nullValue = value.uncheckedCast()
      "number_value", "numberValue" -> this.numberValue = value.uncheckedCast()
      "string_value", "stringValue" -> this.stringValue = value.uncheckedCast()
      "bool_value", "boolValue" -> this.boolValue = value.uncheckedCast()
      "struct_value", "structValue" -> this.structValue = value.uncheckedCast()
      "list_value", "listValue" -> this.listValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.nullValue = value.uncheckedCast()
      2 -> this.numberValue = value.uncheckedCast()
      3 -> this.stringValue = value.uncheckedCast()
      4 -> this.boolValue = value.uncheckedCast()
      5 -> this.structValue = value.uncheckedCast()
      6 -> this.listValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "null_value", "nullValue" -> this.hasNullValue()
    "number_value", "numberValue" -> this.hasNumberValue()
    "string_value", "stringValue" -> this.hasStringValue()
    "bool_value", "boolValue" -> this.hasBoolValue()
    "struct_value", "structValue" -> this.hasStructValue()
    "list_value", "listValue" -> this.hasListValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasNullValue()
    2 -> this.hasNumberValue()
    3 -> this.hasStringValue()
    4 -> this.hasBoolValue()
    5 -> this.hasStructValue()
    6 -> this.hasListValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Value): Boolean {
    if (nullValue != other.nullValue) return false
    if (numberValue != other.numberValue) return false
    if (stringValue != other.stringValue) return false
    if (boolValue != other.boolValue) return false
    if (structValue != other.structValue) return false
    if (listValue != other.listValue) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasNullValue()) {
      result = result * 37 + 1
      result = result * 31 + this.nullValue.hashCode()
    }
    if (hasNumberValue()) {
      result = result * 37 + 2
      result = result * 31 + this.numberValue.hashCode()
    }
    if (hasStringValue()) {
      result = result * 37 + 3
      result = result * 31 + this.stringValue.hashCode()
    }
    if (hasBoolValue()) {
      result = result * 37 + 4
      result = result * 31 + this.boolValue.hashCode()
    }
    if (hasStructValue()) {
      result = result * 37 + 5
      result = result * 31 + this.structValue!!.hashCode()
    }
    if (hasListValue()) {
      result = result * 37 + 6
      result = result * 31 + this.listValue!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasNullValue()) {
      writer.tag(8).enum(this.nullValue)
    }
    if (hasNumberValue()) {
      writer.tag(17).double(this.numberValue)
    }
    if (hasStringValue()) {
      writer.tag(26).string(this.stringValue)
    }
    if (hasBoolValue()) {
      writer.tag(32).bool(this.boolValue)
    }
    if (hasStructValue()) {
      writer.tag(42).message(this.structValue)
    }
    if (hasListValue()) {
      writer.tag(50).message(this.listValue)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.nullValue = NullValue(reader.int32())
      2 -> this.numberValue = reader.double()
      3 -> this.stringValue = reader.string()
      4 -> this.boolValue = reader.bool()
      5 -> this.structValue = Struct.newMutable().apply { readFrom(reader) }
      6 -> this.listValue = ListValue.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class ValueSupport internal constructor() : MessageSupport<Value, MutableValue>() {
  public override val name: String
    get() = ".google.protobuf.Value"

  public override val parent: FileSupport
    get() = StructMetadata

  public override val descriptor: DescriptorProto by lazy {
    StructMetadata.descriptor.messageType.first{ it.name == "Value" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableValue = ValueImpl()
}

public interface MutableListValue : MutableMessage<ListValue, MutableListValue>, ListValue {
  public override val values: MutableList<Value>

  public fun clearValues(): List<Value>
}

@InternalProtoApi
internal class ListValueImpl : AbstractMutableMessage<ListValue, MutableListValue>(),
    MutableListValue {
  public override val values: MutableList<Value> = mutableListOf()

  public override fun hasValues(): Boolean = values.isNotEmpty()

  public override fun clearValues(): List<Value> = values.toList().also {
    values.clear()
  }

  public override fun support(): MessageSupport<ListValue, MutableListValue> = ListValue

  public override fun mergeWith(other: ListValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableListValue = ListValueImpl().apply {
    mergeWith(this@ListValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValues()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "values" -> this.clearValues()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValues()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "values" -> this.values.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.values.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "values" -> {
        this.values.clear()
        this.values.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> {
        this.values.clear()
        this.values.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "values" -> this.hasValues()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValues()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: ListValue): Boolean {
    if (!values.contentEquals(other.values)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    for (value in this.values) {
      result = result * 37 + 1
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    this.values.forEach { writer.tag(10).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.values += Value.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class ListValueSupport internal constructor() :
    MessageSupport<ListValue, MutableListValue>() {
  public override val name: String
    get() = ".google.protobuf.ListValue"

  public override val parent: FileSupport
    get() = StructMetadata

  public override val descriptor: DescriptorProto by lazy {
    StructMetadata.descriptor.messageType.first{ it.name == "ListValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableListValue = ListValueImpl()
}
