package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.Timestamp
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.lazy

public object TimestampMetadata : FileSupport() {
  public override val name: String = "google/protobuf/timestamp.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/timestamp.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Timestamp)
}

public interface MutableTimestamp : MutableMessage<Timestamp, MutableTimestamp>, Timestamp {
  public override var seconds: Long

  public override var nanos: Int

  public fun clearSeconds(): Long?

  public fun clearNanos(): Int?
}

@InternalProtoApi
internal class TimestampImpl : AbstractMutableMessage<Timestamp, MutableTimestamp>(),
    MutableTimestamp {
  private var _hasSeconds: Boolean = false

  public override var seconds: Long = 0L
    get() = if(_hasSeconds) field else 0L
    set(`value`) {
      field = value
      _hasSeconds = true
    }

  private var _hasNanos: Boolean = false

  public override var nanos: Int = 0
    get() = if(_hasNanos) field else 0
    set(`value`) {
      field = value
      _hasNanos = true
    }

  public override fun hasSeconds(): Boolean = _hasSeconds

  public override fun clearSeconds(): Long? {
    if (!hasSeconds()) return null
    return seconds.also {
      seconds = 0L
      _hasSeconds = false
    }
  }

  public override fun hasNanos(): Boolean = _hasNanos

  public override fun clearNanos(): Int? {
    if (!hasNanos()) return null
    return nanos.also {
      nanos = 0
      _hasNanos = false
    }
  }

  public override fun support(): MessageSupport<Timestamp, MutableTimestamp> = Timestamp

  public override fun mergeWith(other: Timestamp?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableTimestamp = TimestampImpl().apply {
    mergeWith(this@TimestampImpl)
  }

  public override fun clear(): Unit {
    this.clearSeconds()
    this.clearNanos()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "seconds" -> this.clearSeconds()
    "nanos" -> this.clearNanos()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearSeconds()
    2 -> this.clearNanos()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "seconds" -> this.seconds.uncheckedCast()
    "nanos" -> this.nanos.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.seconds.uncheckedCast()
    2 -> this.nanos.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "seconds" -> this.seconds = value.uncheckedCast()
      "nanos" -> this.nanos = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.seconds = value.uncheckedCast()
      2 -> this.nanos = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "seconds" -> this.hasSeconds()
    "nanos" -> this.hasNanos()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasSeconds()
    2 -> this.hasNanos()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Timestamp): Boolean {
    if (seconds != other.seconds) return false
    if (nanos != other.nanos) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasSeconds()) {
      result = result * 37 + 1
      result = result * 31 + this.seconds.hashCode()
    }
    if (hasNanos()) {
      result = result * 37 + 2
      result = result * 31 + this.nanos.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasSeconds()) {
      writer.tag(8).int64(this.seconds)
    }
    if (hasNanos()) {
      writer.tag(16).int32(this.nanos)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.seconds = reader.int64()
      2 -> this.nanos = reader.int32()
      else -> return false
    }
    return true
  }
}

public open class TimestampSupport internal constructor() :
    MessageSupport<Timestamp, MutableTimestamp>() {
  public override val name: String
    get() = ".google.protobuf.Timestamp"

  public override val parent: FileSupport
    get() = TimestampMetadata

  public override val descriptor: DescriptorProto by lazy {
    TimestampMetadata.descriptor.messageType.first{ it.name == "Timestamp" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableTimestamp = TimestampImpl()
}
