package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.collection.contentEquals
import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.EnumSupport
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.Message
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.Enum
import com.bybutter.sisyphus.protobuf.primitives.EnumDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.EnumValue
import com.bybutter.sisyphus.protobuf.primitives.Field
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.Option
import com.bybutter.sisyphus.protobuf.primitives.SourceContext
import com.bybutter.sisyphus.protobuf.primitives.Syntax
import com.bybutter.sisyphus.protobuf.primitives.Type
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.lazy

public abstract class SyntaxSupport internal constructor() : EnumSupport<Syntax>() {
  public override val name: String
    get() = ".google.protobuf.Syntax"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: EnumDescriptorProto by lazy {
    TypeMetadata.descriptor.enumType.first{ it.name == "Syntax" }
  }


  public override fun values(): Array<Syntax> = Syntax.values()
}

public object TypeMetadata : FileSupport() {
  public override val name: String = "google/protobuf/type.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/type.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Type, Field, Enum, EnumValue,
      Option, Syntax)
}

public interface MutableType : MutableMessage<Type, MutableType>, Type {
  public override var name: String

  public override val fields: MutableList<Field>

  public override val oneofs: MutableList<String>

  public override val options: MutableList<Option>

  public override var sourceContext: SourceContext?

  public override var syntax: Syntax

  public override var edition: String

  public fun clearName(): String?

  public fun clearFields(): List<Field>

  public fun clearOneofs(): List<String>

  public fun clearOptions(): List<Option>

  public fun clearSourceContext(): SourceContext?

  public fun clearSyntax(): Syntax?

  public fun clearEdition(): String?
}

@InternalProtoApi
internal class TypeImpl : AbstractMutableMessage<Type, MutableType>(), MutableType {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val fields: MutableList<Field> = mutableListOf()

  public override val oneofs: MutableList<String> = mutableListOf()

  public override val options: MutableList<Option> = mutableListOf()

  public override var sourceContext: SourceContext? = null
    set(`value`) {
      field = value
    }

  private var _hasSyntax: Boolean = false

  public override var syntax: Syntax = Syntax()
    get() = if(_hasSyntax) field else Syntax()
    set(`value`) {
      field = value
      _hasSyntax = true
    }

  private var _hasEdition: Boolean = false

  public override var edition: String = ""
    get() = if(_hasEdition) field else ""
    set(`value`) {
      field = value
      _hasEdition = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasFields(): Boolean = fields.isNotEmpty()

  public override fun clearFields(): List<Field> = fields.toList().also {
    fields.clear()
  }

  public override fun hasOneofs(): Boolean = oneofs.isNotEmpty()

  public override fun clearOneofs(): List<String> = oneofs.toList().also {
    oneofs.clear()
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun hasSourceContext(): Boolean = sourceContext != null

  public override fun clearSourceContext(): SourceContext? {
    if (!hasSourceContext()) return null
    return sourceContext.also {
      sourceContext = null
    }
  }

  public override fun hasSyntax(): Boolean = _hasSyntax

  public override fun clearSyntax(): Syntax? {
    if (!hasSyntax()) return null
    return syntax.also {
      syntax = Syntax()
      _hasSyntax = false
    }
  }

  public override fun hasEdition(): Boolean = _hasEdition

  public override fun clearEdition(): String? {
    if (!hasEdition()) return null
    return edition.also {
      edition = ""
      _hasEdition = false
    }
  }

  public override fun support(): MessageSupport<Type, MutableType> = Type

  public override fun mergeWith(other: Type?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableType = TypeImpl().apply {
    mergeWith(this@TypeImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearFields()
    this.clearOneofs()
    this.clearOptions()
    this.clearSourceContext()
    this.clearSyntax()
    this.clearEdition()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "fields" -> this.clearFields()
    "oneofs" -> this.clearOneofs()
    "options" -> this.clearOptions()
    "source_context", "sourceContext" -> this.clearSourceContext()
    "syntax" -> this.clearSyntax()
    "edition" -> this.clearEdition()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearFields()
    3 -> this.clearOneofs()
    4 -> this.clearOptions()
    5 -> this.clearSourceContext()
    6 -> this.clearSyntax()
    7 -> this.clearEdition()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "fields" -> this.fields.uncheckedCast()
    "oneofs" -> this.oneofs.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "source_context", "sourceContext" -> this.sourceContext.uncheckedCast()
    "syntax" -> this.syntax.uncheckedCast()
    "edition" -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.fields.uncheckedCast()
    3 -> this.oneofs.uncheckedCast()
    4 -> this.options.uncheckedCast()
    5 -> this.sourceContext.uncheckedCast()
    6 -> this.syntax.uncheckedCast()
    7 -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "fields" -> {
        this.fields.clear()
        this.fields.addAll(value.uncheckedCast())
      }
      "oneofs" -> {
        this.oneofs.clear()
        this.oneofs.addAll(value.uncheckedCast())
      }
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      "source_context", "sourceContext" -> this.sourceContext = value.uncheckedCast()
      "syntax" -> this.syntax = value.uncheckedCast()
      "edition" -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.fields.clear()
        this.fields.addAll(value.uncheckedCast())
      }
      3 -> {
        this.oneofs.clear()
        this.oneofs.addAll(value.uncheckedCast())
      }
      4 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      5 -> this.sourceContext = value.uncheckedCast()
      6 -> this.syntax = value.uncheckedCast()
      7 -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "fields" -> this.hasFields()
    "oneofs" -> this.hasOneofs()
    "options" -> this.hasOptions()
    "source_context", "sourceContext" -> this.hasSourceContext()
    "syntax" -> this.hasSyntax()
    "edition" -> this.hasEdition()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasFields()
    3 -> this.hasOneofs()
    4 -> this.hasOptions()
    5 -> this.hasSourceContext()
    6 -> this.hasSyntax()
    7 -> this.hasEdition()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Type): Boolean {
    if (name != other.name) return false
    if (!fields.contentEquals(other.fields)) return false
    if (!oneofs.contentEquals(other.oneofs)) return false
    if (!options.contentEquals(other.options)) return false
    if (sourceContext != other.sourceContext) return false
    if (syntax != other.syntax) return false
    if (edition != other.edition) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.fields) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    for (value in this.oneofs) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 4
      result = result * 31 + value.hashCode()
    }
    if (hasSourceContext()) {
      result = result * 37 + 5
      result = result * 31 + this.sourceContext!!.hashCode()
    }
    if (hasSyntax()) {
      result = result * 37 + 6
      result = result * 31 + this.syntax.hashCode()
    }
    if (hasEdition()) {
      result = result * 37 + 7
      result = result * 31 + this.edition.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.fields.forEach { writer.tag(18).message(it) }
    this.oneofs.forEach { writer.tag(26).string(it) }
    this.options.forEach { writer.tag(34).message(it) }
    if (hasSourceContext()) {
      writer.tag(42).message(this.sourceContext)
    }
    if (hasSyntax()) {
      writer.tag(48).enum(this.syntax)
    }
    if (hasEdition()) {
      writer.tag(58).string(this.edition)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.fields += Field.newMutable().apply { readFrom(reader) }
      3 -> this.oneofs += reader.string()
      4 -> this.options += Option.newMutable().apply { readFrom(reader) }
      5 -> this.sourceContext = SourceContext.newMutable().apply { readFrom(reader) }
      6 -> this.syntax = Syntax(reader.int32())
      7 -> this.edition = reader.string()
      else -> return false
    }
    return true
  }
}

public open class TypeSupport internal constructor() : MessageSupport<Type, MutableType>() {
  public override val name: String
    get() = ".google.protobuf.Type"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: DescriptorProto by lazy {
    TypeMetadata.descriptor.messageType.first{ it.name == "Type" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableType = TypeImpl()
}

public interface MutableField : MutableMessage<Field, MutableField>, Field {
  public override var kind: Field.Kind

  public override var cardinality: Field.Cardinality

  public override var number: Int

  public override var name: String

  public override var typeUrl: String

  public override var oneofIndex: Int

  public override var packed: Boolean

  public override val options: MutableList<Option>

  public override var jsonName: String

  public override var defaultValue: String

  public fun clearKind(): Field.Kind?

  public fun clearCardinality(): Field.Cardinality?

  public fun clearNumber(): Int?

  public fun clearName(): String?

  public fun clearTypeUrl(): String?

  public fun clearOneofIndex(): Int?

  public fun clearPacked(): Boolean?

  public fun clearOptions(): List<Option>

  public fun clearJsonName(): String?

  public fun clearDefaultValue(): String?
}

@InternalProtoApi
internal class FieldImpl : AbstractMutableMessage<Field, MutableField>(), MutableField {
  private var _hasKind: Boolean = false

  public override var kind: Field.Kind = Field.Kind()
    get() = if(_hasKind) field else Field.Kind()
    set(`value`) {
      field = value
      _hasKind = true
    }

  private var _hasCardinality: Boolean = false

  public override var cardinality: Field.Cardinality = Field.Cardinality()
    get() = if(_hasCardinality) field else Field.Cardinality()
    set(`value`) {
      field = value
      _hasCardinality = true
    }

  private var _hasNumber: Boolean = false

  public override var number: Int = 0
    get() = if(_hasNumber) field else 0
    set(`value`) {
      field = value
      _hasNumber = true
    }

  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasTypeUrl: Boolean = false

  public override var typeUrl: String = ""
    get() = if(_hasTypeUrl) field else ""
    set(`value`) {
      field = value
      _hasTypeUrl = true
    }

  private var _hasOneofIndex: Boolean = false

  public override var oneofIndex: Int = 0
    get() = if(_hasOneofIndex) field else 0
    set(`value`) {
      field = value
      _hasOneofIndex = true
    }

  private var _hasPacked: Boolean = false

  public override var packed: Boolean = false
    get() = if(_hasPacked) field else false
    set(`value`) {
      field = value
      _hasPacked = true
    }

  public override val options: MutableList<Option> = mutableListOf()

  private var _hasJsonName: Boolean = false

  public override var jsonName: String = ""
    get() = if(_hasJsonName) field else ""
    set(`value`) {
      field = value
      _hasJsonName = true
    }

  private var _hasDefaultValue: Boolean = false

  public override var defaultValue: String = ""
    get() = if(_hasDefaultValue) field else ""
    set(`value`) {
      field = value
      _hasDefaultValue = true
    }

  public override fun hasKind(): Boolean = _hasKind

  public override fun clearKind(): Field.Kind? {
    if (!hasKind()) return null
    return kind.also {
      kind = Field.Kind()
      _hasKind = false
    }
  }

  public override fun hasCardinality(): Boolean = _hasCardinality

  public override fun clearCardinality(): Field.Cardinality? {
    if (!hasCardinality()) return null
    return cardinality.also {
      cardinality = Field.Cardinality()
      _hasCardinality = false
    }
  }

  public override fun hasNumber(): Boolean = _hasNumber

  public override fun clearNumber(): Int? {
    if (!hasNumber()) return null
    return number.also {
      number = 0
      _hasNumber = false
    }
  }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasTypeUrl(): Boolean = _hasTypeUrl

  public override fun clearTypeUrl(): String? {
    if (!hasTypeUrl()) return null
    return typeUrl.also {
      typeUrl = ""
      _hasTypeUrl = false
    }
  }

  public override fun hasOneofIndex(): Boolean = _hasOneofIndex

  public override fun clearOneofIndex(): Int? {
    if (!hasOneofIndex()) return null
    return oneofIndex.also {
      oneofIndex = 0
      _hasOneofIndex = false
    }
  }

  public override fun hasPacked(): Boolean = _hasPacked

  public override fun clearPacked(): Boolean? {
    if (!hasPacked()) return null
    return packed.also {
      packed = false
      _hasPacked = false
    }
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun hasJsonName(): Boolean = _hasJsonName

  public override fun clearJsonName(): String? {
    if (!hasJsonName()) return null
    return jsonName.also {
      jsonName = ""
      _hasJsonName = false
    }
  }

  public override fun hasDefaultValue(): Boolean = _hasDefaultValue

  public override fun clearDefaultValue(): String? {
    if (!hasDefaultValue()) return null
    return defaultValue.also {
      defaultValue = ""
      _hasDefaultValue = false
    }
  }

  public override fun support(): MessageSupport<Field, MutableField> = Field

  public override fun mergeWith(other: Field?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableField = FieldImpl().apply {
    mergeWith(this@FieldImpl)
  }

  public override fun clear(): Unit {
    this.clearKind()
    this.clearCardinality()
    this.clearNumber()
    this.clearName()
    this.clearTypeUrl()
    this.clearOneofIndex()
    this.clearPacked()
    this.clearOptions()
    this.clearJsonName()
    this.clearDefaultValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "kind" -> this.clearKind()
    "cardinality" -> this.clearCardinality()
    "number" -> this.clearNumber()
    "name" -> this.clearName()
    "type_url", "typeUrl" -> this.clearTypeUrl()
    "oneof_index", "oneofIndex" -> this.clearOneofIndex()
    "packed" -> this.clearPacked()
    "options" -> this.clearOptions()
    "json_name", "jsonName" -> this.clearJsonName()
    "default_value", "defaultValue" -> this.clearDefaultValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearKind()
    2 -> this.clearCardinality()
    3 -> this.clearNumber()
    4 -> this.clearName()
    6 -> this.clearTypeUrl()
    7 -> this.clearOneofIndex()
    8 -> this.clearPacked()
    9 -> this.clearOptions()
    10 -> this.clearJsonName()
    11 -> this.clearDefaultValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "kind" -> this.kind.uncheckedCast()
    "cardinality" -> this.cardinality.uncheckedCast()
    "number" -> this.number.uncheckedCast()
    "name" -> this.name.uncheckedCast()
    "type_url", "typeUrl" -> this.typeUrl.uncheckedCast()
    "oneof_index", "oneofIndex" -> this.oneofIndex.uncheckedCast()
    "packed" -> this.packed.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "json_name", "jsonName" -> this.jsonName.uncheckedCast()
    "default_value", "defaultValue" -> this.defaultValue.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.kind.uncheckedCast()
    2 -> this.cardinality.uncheckedCast()
    3 -> this.number.uncheckedCast()
    4 -> this.name.uncheckedCast()
    6 -> this.typeUrl.uncheckedCast()
    7 -> this.oneofIndex.uncheckedCast()
    8 -> this.packed.uncheckedCast()
    9 -> this.options.uncheckedCast()
    10 -> this.jsonName.uncheckedCast()
    11 -> this.defaultValue.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "kind" -> this.kind = value.uncheckedCast()
      "cardinality" -> this.cardinality = value.uncheckedCast()
      "number" -> this.number = value.uncheckedCast()
      "name" -> this.name = value.uncheckedCast()
      "type_url", "typeUrl" -> this.typeUrl = value.uncheckedCast()
      "oneof_index", "oneofIndex" -> this.oneofIndex = value.uncheckedCast()
      "packed" -> this.packed = value.uncheckedCast()
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      "json_name", "jsonName" -> this.jsonName = value.uncheckedCast()
      "default_value", "defaultValue" -> this.defaultValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.kind = value.uncheckedCast()
      2 -> this.cardinality = value.uncheckedCast()
      3 -> this.number = value.uncheckedCast()
      4 -> this.name = value.uncheckedCast()
      6 -> this.typeUrl = value.uncheckedCast()
      7 -> this.oneofIndex = value.uncheckedCast()
      8 -> this.packed = value.uncheckedCast()
      9 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      10 -> this.jsonName = value.uncheckedCast()
      11 -> this.defaultValue = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "kind" -> this.hasKind()
    "cardinality" -> this.hasCardinality()
    "number" -> this.hasNumber()
    "name" -> this.hasName()
    "type_url", "typeUrl" -> this.hasTypeUrl()
    "oneof_index", "oneofIndex" -> this.hasOneofIndex()
    "packed" -> this.hasPacked()
    "options" -> this.hasOptions()
    "json_name", "jsonName" -> this.hasJsonName()
    "default_value", "defaultValue" -> this.hasDefaultValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasKind()
    2 -> this.hasCardinality()
    3 -> this.hasNumber()
    4 -> this.hasName()
    6 -> this.hasTypeUrl()
    7 -> this.hasOneofIndex()
    8 -> this.hasPacked()
    9 -> this.hasOptions()
    10 -> this.hasJsonName()
    11 -> this.hasDefaultValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Field): Boolean {
    if (kind != other.kind) return false
    if (cardinality != other.cardinality) return false
    if (number != other.number) return false
    if (name != other.name) return false
    if (typeUrl != other.typeUrl) return false
    if (oneofIndex != other.oneofIndex) return false
    if (packed != other.packed) return false
    if (!options.contentEquals(other.options)) return false
    if (jsonName != other.jsonName) return false
    if (defaultValue != other.defaultValue) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasKind()) {
      result = result * 37 + 1
      result = result * 31 + this.kind.hashCode()
    }
    if (hasCardinality()) {
      result = result * 37 + 2
      result = result * 31 + this.cardinality.hashCode()
    }
    if (hasNumber()) {
      result = result * 37 + 3
      result = result * 31 + this.number.hashCode()
    }
    if (hasName()) {
      result = result * 37 + 4
      result = result * 31 + this.name.hashCode()
    }
    if (hasTypeUrl()) {
      result = result * 37 + 6
      result = result * 31 + this.typeUrl.hashCode()
    }
    if (hasOneofIndex()) {
      result = result * 37 + 7
      result = result * 31 + this.oneofIndex.hashCode()
    }
    if (hasPacked()) {
      result = result * 37 + 8
      result = result * 31 + this.packed.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 9
      result = result * 31 + value.hashCode()
    }
    if (hasJsonName()) {
      result = result * 37 + 10
      result = result * 31 + this.jsonName.hashCode()
    }
    if (hasDefaultValue()) {
      result = result * 37 + 11
      result = result * 31 + this.defaultValue.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasKind()) {
      writer.tag(8).enum(this.kind)
    }
    if (hasCardinality()) {
      writer.tag(16).enum(this.cardinality)
    }
    if (hasNumber()) {
      writer.tag(24).int32(this.number)
    }
    if (hasName()) {
      writer.tag(34).string(this.name)
    }
    if (hasTypeUrl()) {
      writer.tag(50).string(this.typeUrl)
    }
    if (hasOneofIndex()) {
      writer.tag(56).int32(this.oneofIndex)
    }
    if (hasPacked()) {
      writer.tag(64).bool(this.packed)
    }
    this.options.forEach { writer.tag(74).message(it) }
    if (hasJsonName()) {
      writer.tag(82).string(this.jsonName)
    }
    if (hasDefaultValue()) {
      writer.tag(90).string(this.defaultValue)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.kind = Field.Kind(reader.int32())
      2 -> this.cardinality = Field.Cardinality(reader.int32())
      3 -> this.number = reader.int32()
      4 -> this.name = reader.string()
      6 -> this.typeUrl = reader.string()
      7 -> this.oneofIndex = reader.int32()
      8 -> this.packed = reader.bool()
      9 -> this.options += Option.newMutable().apply { readFrom(reader) }
      10 -> this.jsonName = reader.string()
      11 -> this.defaultValue = reader.string()
      else -> return false
    }
    return true
  }
}

public open class FieldSupport internal constructor() : MessageSupport<Field, MutableField>() {
  public override val name: String
    get() = ".google.protobuf.Field"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: DescriptorProto by lazy {
    TypeMetadata.descriptor.messageType.first{ it.name == "Field" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableField = FieldImpl()

  public override fun children(): Array<ProtoSupport<*>> = arrayOf(Field.Kind, Field.Cardinality)

  public abstract class KindSupport internal constructor() : EnumSupport<Field.Kind>() {
    public override val name: String
      get() = ".google.protobuf.Field.Kind"

    public override val parent: Field.Companion
      get() = Field

    public override val descriptor: EnumDescriptorProto by lazy {
      Field.descriptor.enumType.first{ it.name == "Kind" }
    }


    public override fun values(): Array<Field.Kind> = Field.Kind.values()
  }

  public abstract class CardinalitySupport internal constructor() : EnumSupport<Field.Cardinality>()
      {
    public override val name: String
      get() = ".google.protobuf.Field.Cardinality"

    public override val parent: Field.Companion
      get() = Field

    public override val descriptor: EnumDescriptorProto by lazy {
      Field.descriptor.enumType.first{ it.name == "Cardinality" }
    }


    public override fun values(): Array<Field.Cardinality> = Field.Cardinality.values()
  }
}

public interface MutableEnum : MutableMessage<Enum, MutableEnum>, Enum {
  public override var name: String

  public override val enumvalue: MutableList<EnumValue>

  public override val options: MutableList<Option>

  public override var sourceContext: SourceContext?

  public override var syntax: Syntax

  public override var edition: String

  public fun clearName(): String?

  public fun clearEnumvalue(): List<EnumValue>

  public fun clearOptions(): List<Option>

  public fun clearSourceContext(): SourceContext?

  public fun clearSyntax(): Syntax?

  public fun clearEdition(): String?
}

@InternalProtoApi
internal class EnumImpl : AbstractMutableMessage<Enum, MutableEnum>(), MutableEnum {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override val enumvalue: MutableList<EnumValue> = mutableListOf()

  public override val options: MutableList<Option> = mutableListOf()

  public override var sourceContext: SourceContext? = null
    set(`value`) {
      field = value
    }

  private var _hasSyntax: Boolean = false

  public override var syntax: Syntax = Syntax()
    get() = if(_hasSyntax) field else Syntax()
    set(`value`) {
      field = value
      _hasSyntax = true
    }

  private var _hasEdition: Boolean = false

  public override var edition: String = ""
    get() = if(_hasEdition) field else ""
    set(`value`) {
      field = value
      _hasEdition = true
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasEnumvalue(): Boolean = enumvalue.isNotEmpty()

  public override fun clearEnumvalue(): List<EnumValue> = enumvalue.toList().also {
    enumvalue.clear()
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun hasSourceContext(): Boolean = sourceContext != null

  public override fun clearSourceContext(): SourceContext? {
    if (!hasSourceContext()) return null
    return sourceContext.also {
      sourceContext = null
    }
  }

  public override fun hasSyntax(): Boolean = _hasSyntax

  public override fun clearSyntax(): Syntax? {
    if (!hasSyntax()) return null
    return syntax.also {
      syntax = Syntax()
      _hasSyntax = false
    }
  }

  public override fun hasEdition(): Boolean = _hasEdition

  public override fun clearEdition(): String? {
    if (!hasEdition()) return null
    return edition.also {
      edition = ""
      _hasEdition = false
    }
  }

  public override fun support(): MessageSupport<Enum, MutableEnum> = Enum

  public override fun mergeWith(other: Enum?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnum = EnumImpl().apply {
    mergeWith(this@EnumImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearEnumvalue()
    this.clearOptions()
    this.clearSourceContext()
    this.clearSyntax()
    this.clearEdition()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "enumvalue" -> this.clearEnumvalue()
    "options" -> this.clearOptions()
    "source_context", "sourceContext" -> this.clearSourceContext()
    "syntax" -> this.clearSyntax()
    "edition" -> this.clearEdition()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearEnumvalue()
    3 -> this.clearOptions()
    4 -> this.clearSourceContext()
    5 -> this.clearSyntax()
    6 -> this.clearEdition()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "enumvalue" -> this.enumvalue.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    "source_context", "sourceContext" -> this.sourceContext.uncheckedCast()
    "syntax" -> this.syntax.uncheckedCast()
    "edition" -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.enumvalue.uncheckedCast()
    3 -> this.options.uncheckedCast()
    4 -> this.sourceContext.uncheckedCast()
    5 -> this.syntax.uncheckedCast()
    6 -> this.edition.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "enumvalue" -> {
        this.enumvalue.clear()
        this.enumvalue.addAll(value.uncheckedCast())
      }
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      "source_context", "sourceContext" -> this.sourceContext = value.uncheckedCast()
      "syntax" -> this.syntax = value.uncheckedCast()
      "edition" -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> {
        this.enumvalue.clear()
        this.enumvalue.addAll(value.uncheckedCast())
      }
      3 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      4 -> this.sourceContext = value.uncheckedCast()
      5 -> this.syntax = value.uncheckedCast()
      6 -> this.edition = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "enumvalue" -> this.hasEnumvalue()
    "options" -> this.hasOptions()
    "source_context", "sourceContext" -> this.hasSourceContext()
    "syntax" -> this.hasSyntax()
    "edition" -> this.hasEdition()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasEnumvalue()
    3 -> this.hasOptions()
    4 -> this.hasSourceContext()
    5 -> this.hasSyntax()
    6 -> this.hasEdition()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Enum): Boolean {
    if (name != other.name) return false
    if (!enumvalue.contentEquals(other.enumvalue)) return false
    if (!options.contentEquals(other.options)) return false
    if (sourceContext != other.sourceContext) return false
    if (syntax != other.syntax) return false
    if (edition != other.edition) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    for (value in this.enumvalue) {
      result = result * 37 + 2
      result = result * 31 + value.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    if (hasSourceContext()) {
      result = result * 37 + 4
      result = result * 31 + this.sourceContext!!.hashCode()
    }
    if (hasSyntax()) {
      result = result * 37 + 5
      result = result * 31 + this.syntax.hashCode()
    }
    if (hasEdition()) {
      result = result * 37 + 6
      result = result * 31 + this.edition.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    this.enumvalue.forEach { writer.tag(18).message(it) }
    this.options.forEach { writer.tag(26).message(it) }
    if (hasSourceContext()) {
      writer.tag(34).message(this.sourceContext)
    }
    if (hasSyntax()) {
      writer.tag(40).enum(this.syntax)
    }
    if (hasEdition()) {
      writer.tag(50).string(this.edition)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.enumvalue += EnumValue.newMutable().apply { readFrom(reader) }
      3 -> this.options += Option.newMutable().apply { readFrom(reader) }
      4 -> this.sourceContext = SourceContext.newMutable().apply { readFrom(reader) }
      5 -> this.syntax = Syntax(reader.int32())
      6 -> this.edition = reader.string()
      else -> return false
    }
    return true
  }
}

public open class EnumSupport internal constructor() : MessageSupport<Enum, MutableEnum>() {
  public override val name: String
    get() = ".google.protobuf.Enum"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: DescriptorProto by lazy {
    TypeMetadata.descriptor.messageType.first{ it.name == "Enum" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnum = EnumImpl()
}

public interface MutableEnumValue : MutableMessage<EnumValue, MutableEnumValue>, EnumValue {
  public override var name: String

  public override var number: Int

  public override val options: MutableList<Option>

  public fun clearName(): String?

  public fun clearNumber(): Int?

  public fun clearOptions(): List<Option>
}

@InternalProtoApi
internal class EnumValueImpl : AbstractMutableMessage<EnumValue, MutableEnumValue>(),
    MutableEnumValue {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  private var _hasNumber: Boolean = false

  public override var number: Int = 0
    get() = if(_hasNumber) field else 0
    set(`value`) {
      field = value
      _hasNumber = true
    }

  public override val options: MutableList<Option> = mutableListOf()

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasNumber(): Boolean = _hasNumber

  public override fun clearNumber(): Int? {
    if (!hasNumber()) return null
    return number.also {
      number = 0
      _hasNumber = false
    }
  }

  public override fun hasOptions(): Boolean = options.isNotEmpty()

  public override fun clearOptions(): List<Option> = options.toList().also {
    options.clear()
  }

  public override fun support(): MessageSupport<EnumValue, MutableEnumValue> = EnumValue

  public override fun mergeWith(other: EnumValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableEnumValue = EnumValueImpl().apply {
    mergeWith(this@EnumValueImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearNumber()
    this.clearOptions()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "number" -> this.clearNumber()
    "options" -> this.clearOptions()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearNumber()
    3 -> this.clearOptions()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "number" -> this.number.uncheckedCast()
    "options" -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.number.uncheckedCast()
    3 -> this.options.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "number" -> this.number = value.uncheckedCast()
      "options" -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.number = value.uncheckedCast()
      3 -> {
        this.options.clear()
        this.options.addAll(value.uncheckedCast())
      }
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "number" -> this.hasNumber()
    "options" -> this.hasOptions()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasNumber()
    3 -> this.hasOptions()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: EnumValue): Boolean {
    if (name != other.name) return false
    if (number != other.number) return false
    if (!options.contentEquals(other.options)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasNumber()) {
      result = result * 37 + 2
      result = result * 31 + this.number.hashCode()
    }
    for (value in this.options) {
      result = result * 37 + 3
      result = result * 31 + value.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasNumber()) {
      writer.tag(16).int32(this.number)
    }
    this.options.forEach { writer.tag(26).message(it) }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.number = reader.int32()
      3 -> this.options += Option.newMutable().apply { readFrom(reader) }
      else -> return false
    }
    return true
  }
}

public open class EnumValueSupport internal constructor() :
    MessageSupport<EnumValue, MutableEnumValue>() {
  public override val name: String
    get() = ".google.protobuf.EnumValue"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: DescriptorProto by lazy {
    TypeMetadata.descriptor.messageType.first{ it.name == "EnumValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableEnumValue = EnumValueImpl()
}

public interface MutableOption : MutableMessage<Option, MutableOption>, Option {
  public override var name: String

  public override var `value`: Message<*, *>?

  public fun clearName(): String?

  public fun clearValue(): Message<*, *>?
}

@InternalProtoApi
internal class OptionImpl : AbstractMutableMessage<Option, MutableOption>(), MutableOption {
  private var _hasName: Boolean = false

  public override var name: String = ""
    get() = if(_hasName) field else ""
    set(`value`) {
      field = value
      _hasName = true
    }

  public override var `value`: Message<*, *>? = null
    set(`value`) {
      field = value
    }

  public override fun hasName(): Boolean = _hasName

  public override fun clearName(): String? {
    if (!hasName()) return null
    return name.also {
      name = ""
      _hasName = false
    }
  }

  public override fun hasValue(): Boolean = `value` != null

  public override fun clearValue(): Message<*, *>? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = null
    }
  }

  public override fun support(): MessageSupport<Option, MutableOption> = Option

  public override fun mergeWith(other: Option?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableOption = OptionImpl().apply {
    mergeWith(this@OptionImpl)
  }

  public override fun clear(): Unit {
    this.clearName()
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "name" -> this.clearName()
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearName()
    2 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "name" -> this.name.uncheckedCast()
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.name.uncheckedCast()
    2 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "name" -> this.name = value.uncheckedCast()
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.name = value.uncheckedCast()
      2 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "name" -> this.hasName()
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasName()
    2 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Option): Boolean {
    if (name != other.name) return false
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasName()) {
      result = result * 37 + 1
      result = result * 31 + this.name.hashCode()
    }
    if (hasValue()) {
      result = result * 37 + 2
      result = result * 31 + this.`value`!!.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasName()) {
      writer.tag(10).string(this.name)
    }
    if (hasValue()) {
      writer.tag(18).any(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.name = reader.string()
      2 -> this.`value` = reader.any()
      else -> return false
    }
    return true
  }
}

public open class OptionSupport internal constructor() : MessageSupport<Option, MutableOption>() {
  public override val name: String
    get() = ".google.protobuf.Option"

  public override val parent: FileSupport
    get() = TypeMetadata

  public override val descriptor: DescriptorProto by lazy {
    TypeMetadata.descriptor.messageType.first{ it.name == "Option" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableOption = OptionImpl()
}
