package com.bybutter.sisyphus.protobuf.primitives.`internal`

import com.bybutter.sisyphus.protobuf.AbstractMutableMessage
import com.bybutter.sisyphus.protobuf.FileSupport
import com.bybutter.sisyphus.protobuf.InternalProtoApi
import com.bybutter.sisyphus.protobuf.MessageSupport
import com.bybutter.sisyphus.protobuf.MutableMessage
import com.bybutter.sisyphus.protobuf.ProtoSupport
import com.bybutter.sisyphus.protobuf.coded.Reader
import com.bybutter.sisyphus.protobuf.coded.Writer
import com.bybutter.sisyphus.protobuf.primitives.BoolValue
import com.bybutter.sisyphus.protobuf.primitives.BytesValue
import com.bybutter.sisyphus.protobuf.primitives.DescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.DoubleValue
import com.bybutter.sisyphus.protobuf.primitives.FileDescriptorProto
import com.bybutter.sisyphus.protobuf.primitives.FloatValue
import com.bybutter.sisyphus.protobuf.primitives.Int32Value
import com.bybutter.sisyphus.protobuf.primitives.Int64Value
import com.bybutter.sisyphus.protobuf.primitives.StringValue
import com.bybutter.sisyphus.protobuf.primitives.UInt32Value
import com.bybutter.sisyphus.protobuf.primitives.UInt64Value
import com.bybutter.sisyphus.reflect.uncheckedCast
import kotlin.Any
import kotlin.Array
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Double
import kotlin.Float
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.UInt
import kotlin.ULong
import kotlin.Unit
import kotlin.lazy

public object WrappersMetadata : FileSupport() {
  public override val name: String = "google/protobuf/wrappers.proto"

  public override val descriptor: FileDescriptorProto by lazy {
    readDescriptor("google/protobuf/wrappers.pb")
  }


  public override fun children(): Array<ProtoSupport<*>> = arrayOf(DoubleValue, FloatValue,
      Int64Value, UInt64Value, Int32Value, UInt32Value, BoolValue, StringValue, BytesValue)
}

public interface MutableDoubleValue : MutableMessage<DoubleValue, MutableDoubleValue>, DoubleValue {
  public override var `value`: Double

  public fun clearValue(): Double?
}

@InternalProtoApi
internal class DoubleValueImpl : AbstractMutableMessage<DoubleValue, MutableDoubleValue>(),
    MutableDoubleValue {
  private var _hasValue: Boolean = false

  public override var `value`: Double = 0.0
    get() = if(_hasValue) field else 0.0
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): Double? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0.0
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<DoubleValue, MutableDoubleValue> = DoubleValue

  public override fun mergeWith(other: DoubleValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableDoubleValue = DoubleValueImpl().apply {
    mergeWith(this@DoubleValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: DoubleValue): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(9).double(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.double()
      else -> return false
    }
    return true
  }
}

public open class DoubleValueSupport internal constructor() :
    MessageSupport<DoubleValue, MutableDoubleValue>() {
  public override val name: String
    get() = ".google.protobuf.DoubleValue"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "DoubleValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableDoubleValue = DoubleValueImpl()
}

public interface MutableFloatValue : MutableMessage<FloatValue, MutableFloatValue>, FloatValue {
  public override var `value`: Float

  public fun clearValue(): Float?
}

@InternalProtoApi
internal class FloatValueImpl : AbstractMutableMessage<FloatValue, MutableFloatValue>(),
    MutableFloatValue {
  private var _hasValue: Boolean = false

  public override var `value`: Float = 0.0f
    get() = if(_hasValue) field else 0.0f
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): Float? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0.0f
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<FloatValue, MutableFloatValue> = FloatValue

  public override fun mergeWith(other: FloatValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableFloatValue = FloatValueImpl().apply {
    mergeWith(this@FloatValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: FloatValue): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(13).float(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.float()
      else -> return false
    }
    return true
  }
}

public open class FloatValueSupport internal constructor() :
    MessageSupport<FloatValue, MutableFloatValue>() {
  public override val name: String
    get() = ".google.protobuf.FloatValue"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "FloatValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableFloatValue = FloatValueImpl()
}

public interface MutableInt64Value : MutableMessage<Int64Value, MutableInt64Value>, Int64Value {
  public override var `value`: Long

  public fun clearValue(): Long?
}

@InternalProtoApi
internal class Int64ValueImpl : AbstractMutableMessage<Int64Value, MutableInt64Value>(),
    MutableInt64Value {
  private var _hasValue: Boolean = false

  public override var `value`: Long = 0L
    get() = if(_hasValue) field else 0L
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): Long? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0L
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<Int64Value, MutableInt64Value> = Int64Value

  public override fun mergeWith(other: Int64Value?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableInt64Value = Int64ValueImpl().apply {
    mergeWith(this@Int64ValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Int64Value): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(8).int64(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.int64()
      else -> return false
    }
    return true
  }
}

public open class Int64ValueSupport internal constructor() :
    MessageSupport<Int64Value, MutableInt64Value>() {
  public override val name: String
    get() = ".google.protobuf.Int64Value"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "Int64Value" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableInt64Value = Int64ValueImpl()
}

public interface MutableUInt64Value : MutableMessage<UInt64Value, MutableUInt64Value>, UInt64Value {
  public override var `value`: ULong

  public fun clearValue(): ULong?
}

@InternalProtoApi
internal class UInt64ValueImpl : AbstractMutableMessage<UInt64Value, MutableUInt64Value>(),
    MutableUInt64Value {
  private var _hasValue: Boolean = false

  public override var `value`: ULong = 0UL
    get() = if(_hasValue) field else 0UL
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): ULong? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0UL
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<UInt64Value, MutableUInt64Value> = UInt64Value

  public override fun mergeWith(other: UInt64Value?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableUInt64Value = UInt64ValueImpl().apply {
    mergeWith(this@UInt64ValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: UInt64Value): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(8).uint64(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.uint64()
      else -> return false
    }
    return true
  }
}

public open class UInt64ValueSupport internal constructor() :
    MessageSupport<UInt64Value, MutableUInt64Value>() {
  public override val name: String
    get() = ".google.protobuf.UInt64Value"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "UInt64Value" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableUInt64Value = UInt64ValueImpl()
}

public interface MutableInt32Value : MutableMessage<Int32Value, MutableInt32Value>, Int32Value {
  public override var `value`: Int

  public fun clearValue(): Int?
}

@InternalProtoApi
internal class Int32ValueImpl : AbstractMutableMessage<Int32Value, MutableInt32Value>(),
    MutableInt32Value {
  private var _hasValue: Boolean = false

  public override var `value`: Int = 0
    get() = if(_hasValue) field else 0
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): Int? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<Int32Value, MutableInt32Value> = Int32Value

  public override fun mergeWith(other: Int32Value?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableInt32Value = Int32ValueImpl().apply {
    mergeWith(this@Int32ValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: Int32Value): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(8).int32(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.int32()
      else -> return false
    }
    return true
  }
}

public open class Int32ValueSupport internal constructor() :
    MessageSupport<Int32Value, MutableInt32Value>() {
  public override val name: String
    get() = ".google.protobuf.Int32Value"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "Int32Value" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableInt32Value = Int32ValueImpl()
}

public interface MutableUInt32Value : MutableMessage<UInt32Value, MutableUInt32Value>, UInt32Value {
  public override var `value`: UInt

  public fun clearValue(): UInt?
}

@InternalProtoApi
internal class UInt32ValueImpl : AbstractMutableMessage<UInt32Value, MutableUInt32Value>(),
    MutableUInt32Value {
  private var _hasValue: Boolean = false

  public override var `value`: UInt = 0U
    get() = if(_hasValue) field else 0U
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): UInt? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = 0U
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<UInt32Value, MutableUInt32Value> = UInt32Value

  public override fun mergeWith(other: UInt32Value?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableUInt32Value = UInt32ValueImpl().apply {
    mergeWith(this@UInt32ValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: UInt32Value): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(8).uint32(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.uint32()
      else -> return false
    }
    return true
  }
}

public open class UInt32ValueSupport internal constructor() :
    MessageSupport<UInt32Value, MutableUInt32Value>() {
  public override val name: String
    get() = ".google.protobuf.UInt32Value"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "UInt32Value" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableUInt32Value = UInt32ValueImpl()
}

public interface MutableBoolValue : MutableMessage<BoolValue, MutableBoolValue>, BoolValue {
  public override var `value`: Boolean

  public fun clearValue(): Boolean?
}

@InternalProtoApi
internal class BoolValueImpl : AbstractMutableMessage<BoolValue, MutableBoolValue>(),
    MutableBoolValue {
  private var _hasValue: Boolean = false

  public override var `value`: Boolean = false
    get() = if(_hasValue) field else false
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): Boolean? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = false
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<BoolValue, MutableBoolValue> = BoolValue

  public override fun mergeWith(other: BoolValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableBoolValue = BoolValueImpl().apply {
    mergeWith(this@BoolValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: BoolValue): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(8).bool(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.bool()
      else -> return false
    }
    return true
  }
}

public open class BoolValueSupport internal constructor() :
    MessageSupport<BoolValue, MutableBoolValue>() {
  public override val name: String
    get() = ".google.protobuf.BoolValue"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "BoolValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableBoolValue = BoolValueImpl()
}

public interface MutableStringValue : MutableMessage<StringValue, MutableStringValue>, StringValue {
  public override var `value`: String

  public fun clearValue(): String?
}

@InternalProtoApi
internal class StringValueImpl : AbstractMutableMessage<StringValue, MutableStringValue>(),
    MutableStringValue {
  private var _hasValue: Boolean = false

  public override var `value`: String = ""
    get() = if(_hasValue) field else ""
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): String? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = ""
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<StringValue, MutableStringValue> = StringValue

  public override fun mergeWith(other: StringValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableStringValue = StringValueImpl().apply {
    mergeWith(this@StringValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: StringValue): Boolean {
    if (`value` != other.`value`) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(10).string(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.string()
      else -> return false
    }
    return true
  }
}

public open class StringValueSupport internal constructor() :
    MessageSupport<StringValue, MutableStringValue>() {
  public override val name: String
    get() = ".google.protobuf.StringValue"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "StringValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableStringValue = StringValueImpl()
}

public interface MutableBytesValue : MutableMessage<BytesValue, MutableBytesValue>, BytesValue {
  public override var `value`: ByteArray

  public fun clearValue(): ByteArray?
}

@InternalProtoApi
internal class BytesValueImpl : AbstractMutableMessage<BytesValue, MutableBytesValue>(),
    MutableBytesValue {
  private var _hasValue: Boolean = false

  public override var `value`: ByteArray = byteArrayOf()
    get() = if(_hasValue) field else byteArrayOf()
    set(`value`) {
      field = value
      _hasValue = true
    }

  public override fun hasValue(): Boolean = _hasValue

  public override fun clearValue(): ByteArray? {
    if (!hasValue()) return null
    return `value`.also {
      `value` = byteArrayOf()
      _hasValue = false
    }
  }

  public override fun support(): MessageSupport<BytesValue, MutableBytesValue> = BytesValue

  public override fun mergeWith(other: BytesValue?): Unit {
    other ?: return
    val proto = other.toProto()
    readFrom(Reader(proto.inputStream()), proto.size)
  }

  @InternalProtoApi
  public override fun cloneMutable(): MutableBytesValue = BytesValueImpl().apply {
    mergeWith(this@BytesValueImpl)
  }

  public override fun clear(): Unit {
    this.clearValue()
  }

  public override fun clearFieldInCurrent(fieldName: String): Any? = when(fieldName) {
    "value" -> this.clearValue()
    else -> clearFieldInExtensions(fieldName)
  }

  public override fun clearFieldInCurrent(fieldNumber: Int): Any? = when(fieldNumber) {
    1 -> this.clearValue()
    else -> clearFieldInExtensions(fieldNumber)
  }

  public override fun <T> getFieldInCurrent(fieldName: String): T = when(fieldName) {
    "value" -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldName)
  }

  public override fun <T> getFieldInCurrent(fieldNumber: Int): T = when(fieldNumber) {
    1 -> this.`value`.uncheckedCast()
    else -> getFieldInExtensions(fieldNumber)
  }

  public override fun <T> setFieldInCurrent(fieldName: String, `value`: T): Unit {
    when(fieldName) {
      "value" -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldName, value)
    }
  }

  public override fun <T> setFieldInCurrent(fieldNumber: Int, `value`: T): Unit {
    when(fieldNumber) {
      1 -> this.`value` = value.uncheckedCast()
      else -> setFieldInExtensions(fieldNumber, value)
    }
  }

  public override fun hasFieldInCurrent(fieldName: String): Boolean = when(fieldName) {
    "value" -> this.hasValue()
    else -> hasFieldInExtensions(fieldName)
  }

  public override fun hasFieldInCurrent(fieldNumber: Int): Boolean = when(fieldNumber) {
    1 -> this.hasValue()
    else -> hasFieldInExtensions(fieldNumber)
  }

  public override fun equalsMessage(other: BytesValue): Boolean {
    if (!`value`.contentEquals(other.`value`)) return false
    return true
  }

  public override fun computeHashCode(): Int {
    var result = this.javaClass.hashCode()
    if (hasValue()) {
      result = result * 37 + 1
      result = result * 31 + this.`value`.hashCode()
    }
    return result
  }

  public override fun writeFields(writer: Writer): Unit {
    if (hasValue()) {
      writer.tag(10).bytes(this.`value`)
    }
  }

  @InternalProtoApi
  public override fun readField(
    reader: Reader,
    `field`: Int,
    wire: Int,
  ): Boolean {
    when(field) {
      1 -> this.`value` = reader.bytes()
      else -> return false
    }
    return true
  }
}

public open class BytesValueSupport internal constructor() :
    MessageSupport<BytesValue, MutableBytesValue>() {
  public override val name: String
    get() = ".google.protobuf.BytesValue"

  public override val parent: FileSupport
    get() = WrappersMetadata

  public override val descriptor: DescriptorProto by lazy {
    WrappersMetadata.descriptor.messageType.first{ it.name == "BytesValue" }
  }


  @InternalProtoApi
  public override fun newMutable(): MutableBytesValue = BytesValueImpl()
}
