/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.upload;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.FinaliseResponse;
import com.bynder.sdk.model.PollStatus;
import com.bynder.sdk.model.SaveMediaResponse;
import com.bynder.sdk.model.UploadRequest;
import com.bynder.sdk.query.FinaliseUploadQuery;
import com.bynder.sdk.query.PollStatusQuery;
import com.bynder.sdk.query.RegisterChunkQuery;
import com.bynder.sdk.query.RequestUploadQuery;
import com.bynder.sdk.query.SaveMediaQuery;
import com.bynder.sdk.query.UploadQuery;
import com.bynder.sdk.service.AmazonService;
import com.bynder.sdk.service.exception.BynderUploadException;
import com.bynder.sdk.service.impl.AmazonServiceImpl;
import com.bynder.sdk.service.upload.FileConverterStatus;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$1;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$10;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$11;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$12;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$13;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$14;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$15;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$16;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$17;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$18;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$19;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$20;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$21;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$22;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$23;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$24;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$25;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$26;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$27;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$28;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$29;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$4;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$5;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$6;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$7;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$8;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$9;
import com.bynder.sdk.service.upload.UploadProcessData;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Map;
import retrofit2.Response;

public class FileUploader {
    private static final int MAX_CHUNK_SIZE = 0x500000;
    private static final int MAX_POLLING_ITERATIONS = 60;
    private static final int POLLING_IDLE_TIME = 2000;
    private final BynderApi bynderApi;
    private AmazonService amazonService;

    public FileUploader(BynderApi bynderApi) {
        this.bynderApi = bynderApi;
    }

    public Observable<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$1.lambdaFactory$(this, uploadQuery));
    }

    private void startUploadProcess(UploadQuery uploadQuery, ObservableEmitter<SaveMediaResponse> observableEmitter, UploadRequest uploadRequest, File file) {
        Observable<Integer> uploadPartsObs = this.uploadParts(file, uploadRequest);
        uploadPartsObs.subscribe(FileUploader$$Lambda$4.lambdaFactory$(this, uploadRequest, uploadQuery, observableEmitter, file), FileUploader$$Lambda$5.lambdaFactory$(observableEmitter));
    }

    private Observable<Integer> uploadParts(File file, UploadRequest uploadRequest) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$6.lambdaFactory$(this, file, uploadRequest));
    }

    private Observable<Boolean> processChunk(UploadProcessData uploadProcessData) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$7.lambdaFactory$(this, uploadProcessData));
    }

    private void registerUploadedChunk(UploadProcessData uploadProcessData, ObservableEmitter<Boolean> observableEmitter) throws IllegalAccessException {
        String filename = String.format("%s/p%s", uploadProcessData.getUploadRequest().getS3Filename(), Integer.toString(uploadProcessData.getChunkNumber()));
        Observable<Response<Void>> registerChunkObs = this.registerChunk(new RegisterChunkQuery(uploadProcessData.getUploadRequest().getS3File().getUploadId(), uploadProcessData.getChunkNumber(), uploadProcessData.getUploadRequest().getS3File().getTargetId(), filename));
        registerChunkObs.subscribe(FileUploader$$Lambda$8.lambdaFactory$(observableEmitter), FileUploader$$Lambda$9.lambdaFactory$(observableEmitter));
    }

    private void processFinaliseResponse(UploadQuery uploadQuery, ObservableEmitter<SaveMediaResponse> observableEmitter, File file, Response<FinaliseResponse> finaliseResponse) {
        String importId = ((FinaliseResponse)finaliseResponse.body()).getImportId();
        this.hasFinishedSuccessfully(importId).subscribe(FileUploader$$Lambda$10.lambdaFactory$(this, uploadQuery, observableEmitter, file, importId), FileUploader$$Lambda$11.lambdaFactory$(observableEmitter));
    }

    private Observable<Boolean> hasFinishedSuccessfully(String importId) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$12.lambdaFactory$(this, importId));
    }

    private void saveUploadedMedia(UploadQuery uploadQuery, ObservableEmitter<SaveMediaResponse> observableEmitter, File file, String importId) throws IllegalAccessException {
        Observable<Response<SaveMediaResponse>> saveMediaObs = uploadQuery.getMediaId() == null ? this.saveMedia(new SaveMediaQuery(importId).setBrandId(uploadQuery.getBrandId()).setName(file.getName()).setAudit(uploadQuery.isAudit())) : this.saveMedia(new SaveMediaQuery(importId).setMediaId(uploadQuery.getMediaId()).setAudit(uploadQuery.isAudit()));
        saveMediaObs.subscribe(FileUploader$$Lambda$13.lambdaFactory$(observableEmitter), FileUploader$$Lambda$14.lambdaFactory$(observableEmitter), FileUploader$$Lambda$15.lambdaFactory$(observableEmitter));
    }

    private Observable<Response<String>> getClosestS3Endpoint() {
        return this.bynderApi.getClosestS3Endpoint();
    }

    private Observable<Response<UploadRequest>> getUploadInformation(RequestUploadQuery requestUploadQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(requestUploadQuery);
        return this.bynderApi.getUploadInformation(params);
    }

    private Observable<Response<Void>> registerChunk(RegisterChunkQuery registerChunkQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(registerChunkQuery);
        return this.bynderApi.registerChunk(params);
    }

    private Observable<Response<FinaliseResponse>> finaliseUpload(FinaliseUploadQuery finaliseUploadQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(finaliseUploadQuery);
        return this.bynderApi.finaliseUpload(params);
    }

    private Observable<Response<PollStatus>> getPollStatus(PollStatusQuery pollStatusQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(pollStatusQuery);
        return this.bynderApi.getPollStatus(params);
    }

    private Observable<Response<SaveMediaResponse>> saveMedia(SaveMediaQuery saveMediaQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(saveMediaQuery);
        return this.bynderApi.saveMedia(params);
    }

    static /* synthetic */ void lambda$saveUploadedMedia$26(ObservableEmitter observableEmitter) throws Exception {
        observableEmitter.onComplete();
    }

    static /* synthetic */ void lambda$saveUploadedMedia$25(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$saveUploadedMedia$24(ObservableEmitter observableEmitter, Response saveMediaResponse) throws Exception {
        observableEmitter.onNext(saveMediaResponse.body());
    }

    static /* synthetic */ void lambda$hasFinishedSuccessfully$23(FileUploader this_, String importId, ObservableEmitter observableEmitter) throws Exception {
        try {
            FileConverterStatus fileConverterStatus = new FileConverterStatus(60);
            this_.getPollStatus(new PollStatusQuery(Arrays.asList(importId))).repeatUntil(FileUploader$$Lambda$16.lambdaFactory$(fileConverterStatus, observableEmitter)).subscribe(FileUploader$$Lambda$17.lambdaFactory$(importId, fileConverterStatus), FileUploader$$Lambda$18.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$22(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$21(String importId, FileConverterStatus fileConverterStatus, Response pollStatusResponse) throws Exception {
        PollStatus pollStatus = (PollStatus)pollStatusResponse.body();
        if (pollStatus != null) {
            if (pollStatus.getItemsDone().contains(importId)) {
                fileConverterStatus.setDone(true);
            }
            if (pollStatus.getItemsFailed().contains(importId)) {
                fileConverterStatus.setDone(false);
            }
        }
    }

    static /* synthetic */ boolean lambda$null$20(FileConverterStatus fileConverterStatus, ObservableEmitter observableEmitter) throws Exception {
        if (fileConverterStatus.isDone()) {
            observableEmitter.onNext((Object)fileConverterStatus.isSuccessful());
            observableEmitter.onComplete();
            return true;
        }
        if (!fileConverterStatus.nextAttempt()) {
            observableEmitter.onNext((Object)false);
            observableEmitter.onComplete();
            return true;
        }
        Thread.sleep(2000L);
        return false;
    }

    static /* synthetic */ void lambda$processFinaliseResponse$19(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$processFinaliseResponse$18(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter, File file, String importId, Boolean hasFinishedSuccessfully) throws Exception {
        if (hasFinishedSuccessfully.booleanValue()) {
            this_.saveUploadedMedia(uploadQuery, (ObservableEmitter<SaveMediaResponse>)observableEmitter, file, importId);
        } else {
            observableEmitter.onError((Throwable)new BynderUploadException("Converter did not finished. Upload not completed."));
        }
    }

    static /* synthetic */ void lambda$registerUploadedChunk$17(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$registerUploadedChunk$16(ObservableEmitter observableEmitter, Response voidResponse) throws Exception {
        observableEmitter.onNext((Object)true);
        observableEmitter.onComplete();
    }

    static /* synthetic */ void lambda$processChunk$15(FileUploader this_, UploadProcessData uploadProcessData, ObservableEmitter observableEmitter) throws Exception {
        try {
            Observable<Response<Void>> uploadPartToAmazonObs = this_.amazonService.uploadPartToAmazon(uploadProcessData.getFile().getName(), uploadProcessData.getUploadRequest(), uploadProcessData.getChunkNumber(), uploadProcessData.getBuffer(), uploadProcessData.getNumberOfChunks());
            uploadPartToAmazonObs.subscribe(FileUploader$$Lambda$19.lambdaFactory$(this_, uploadProcessData, observableEmitter), FileUploader$$Lambda$20.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$14(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$13(FileUploader this_, UploadProcessData uploadProcessData, ObservableEmitter observableEmitter, Response voidResponse) throws Exception {
        this_.registerUploadedChunk(uploadProcessData, (ObservableEmitter<Boolean>)observableEmitter);
    }

    static /* synthetic */ void lambda$uploadParts$12(FileUploader this_, File file, UploadRequest uploadRequest, ObservableEmitter observableEmitter) throws Exception {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            UploadProcessData uploadProcessData = new UploadProcessData(file, fileInputStream, uploadRequest, 0x500000);
            uploadProcessData.incrementChunk();
            this_.processChunk(uploadProcessData).repeatUntil(FileUploader$$Lambda$21.lambdaFactory$(uploadProcessData, observableEmitter)).subscribe(FileUploader$$Lambda$22.lambdaFactory$(), FileUploader$$Lambda$23.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$11(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$10(Boolean booleanResponse) throws Exception {
    }

    static /* synthetic */ boolean lambda$null$9(UploadProcessData uploadProcessData, ObservableEmitter observableEmitter) throws Exception {
        boolean isProcessed = uploadProcessData.isCompleted();
        if (isProcessed) {
            observableEmitter.onNext((Object)uploadProcessData.getNumberOfChunks());
            observableEmitter.onComplete();
        } else {
            uploadProcessData.incrementChunk();
        }
        return isProcessed;
    }

    static /* synthetic */ void lambda$startUploadProcess$8(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$startUploadProcess$7(FileUploader this_, UploadRequest uploadRequest, UploadQuery uploadQuery, ObservableEmitter observableEmitter, File file, Integer chunksResponse) throws Exception {
        Observable<Response<FinaliseResponse>> finaliseUploadedFileObs = this_.finaliseUpload(new FinaliseUploadQuery(uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), uploadRequest.getS3Filename(), chunksResponse));
        finaliseUploadedFileObs.subscribe(FileUploader$$Lambda$24.lambdaFactory$(this_, uploadQuery, observableEmitter, file), FileUploader$$Lambda$25.lambdaFactory$(observableEmitter));
    }

    static /* synthetic */ void lambda$null$6(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$5(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter, File file, Response finaliseResponse) throws Exception {
        this_.processFinaliseResponse(uploadQuery, (ObservableEmitter<SaveMediaResponse>)observableEmitter, file, (Response<FinaliseResponse>)finaliseResponse);
    }

    static /* synthetic */ void lambda$uploadFile$4(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter) throws Exception {
        try {
            Observable<Response<String>> s3EndpointObs = this_.getClosestS3Endpoint();
            s3EndpointObs.subscribe(FileUploader$$Lambda$26.lambdaFactory$(this_, uploadQuery, observableEmitter), FileUploader$$Lambda$27.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$3(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$2(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter, Response awsBucketResponse) throws Exception {
        this_.amazonService = new AmazonServiceImpl((String)awsBucketResponse.body());
        Observable<Response<UploadRequest>> uploadInformationObs = this_.getUploadInformation(new RequestUploadQuery(uploadQuery.getFilepath()));
        uploadInformationObs.subscribe(FileUploader$$Lambda$28.lambdaFactory$(this_, uploadQuery, observableEmitter), FileUploader$$Lambda$29.lambdaFactory$(observableEmitter));
    }

    static /* synthetic */ void lambda$null$1(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$0(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter, Response uploadRequestResponse) throws Exception {
        UploadRequest uploadRequest = (UploadRequest)uploadRequestResponse.body();
        File file = new File(uploadQuery.getFilepath());
        if (!file.exists()) {
            observableEmitter.onError((Throwable)new BynderUploadException(String.format("File: %s not found. Upload not completed.", file.getName())));
            return;
        }
        this_.startUploadProcess(uploadQuery, (ObservableEmitter<SaveMediaResponse>)observableEmitter, uploadRequest, file);
    }
}

