/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.bynder.sdk.model.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppProperties {
    private static final Logger LOG = LoggerFactory.getLogger(AppProperties.class);
    private final Properties appProperties = new Properties();

    public AppProperties() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("app.properties");
        try {
            this.appProperties.load(input);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }

    public String getProperty(String key) {
        return this.appProperties.getProperty(key);
    }

    public Settings getSettings() throws MalformedURLException {
        return new Settings(new URL(this.getProperty("BASE_URL")), this.getProperty("CONSUMER_KEY"), this.getProperty("CONSUMER_SECRET"), this.getProperty("ACCESS_TOKEN_KEY"), this.getProperty("ACCESS_TOKEN_SECRET"));
    }

    public Settings getSettingsForLogin() throws MalformedURLException {
        return new Settings(new URL(this.getProperty("BASE_URL")), this.getProperty("CONSUMER_KEY"), this.getProperty("CONSUMER_SECRET"), this.getProperty("REQUEST_TOKEN_KEY"), this.getProperty("REQUEST_TOKEN_SECRET"));
    }
}

