/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.impl;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Credentials;
import com.bynder.sdk.model.Settings;
import com.bynder.sdk.model.User;
import com.bynder.sdk.query.LoginQuery;
import com.bynder.sdk.service.AssetBankService;
import com.bynder.sdk.service.BynderService;
import com.bynder.sdk.service.impl.AssetBankServiceImpl;
import com.bynder.sdk.service.impl.BynderServiceImpl$$Lambda$1;
import com.bynder.sdk.service.impl.BynderServiceImpl$$Lambda$2;
import com.bynder.sdk.service.impl.BynderServiceImpl$$Lambda$3;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import retrofit2.Response;

public class BynderServiceImpl
implements BynderService {
    private final URL baseUrl;
    private Credentials credentials;
    private BynderApi bynderApi;
    private AssetBankService assetBankService;

    private BynderServiceImpl(URL baseUrl, Credentials credentials) {
        this.baseUrl = baseUrl;
        this.credentials = credentials;
        this.bynderApi = Utils.createApiService(BynderApi.class, baseUrl, credentials);
    }

    public static BynderService create(Settings settings) {
        Credentials credentials = new Credentials(settings.getConsumerKey(), settings.getConsumerSecret(), settings.getToken(), settings.getTokenSecret());
        return new BynderServiceImpl(settings.getBaseUrl(), credentials);
    }

    @Override
    public Observable<User> login(String username, String password) throws IllegalAccessException {
        return this.login(new LoginQuery(username, password));
    }

    @Override
    public Observable<String> getRequestToken() {
        Observable<Response<String>> requestTokenObservable = this.bynderApi.getRequestToken();
        return requestTokenObservable.map(BynderServiceImpl$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public URL getAuthoriseUrl(String callbackUrl) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder("/api/v4/oauth/authorise/?oauth_token=").append(this.credentials.getToken());
        if (StringUtils.isNotEmpty((String)callbackUrl)) {
            stringBuilder.append("&callback=").append(callbackUrl);
        }
        URL authoriseUrl = new URL(this.baseUrl, stringBuilder.toString());
        return authoriseUrl;
    }

    @Override
    public Observable<String> getAccessToken() {
        Observable<Response<String>> accessTokenObservable = this.bynderApi.getAccessToken();
        return accessTokenObservable.map(BynderServiceImpl$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    public void logout() {
        this.credentials.reset();
    }

    @Override
    public AssetBankService getAssetBankService() {
        if (this.assetBankService == null) {
            this.assetBankService = new AssetBankServiceImpl(this.bynderApi);
        }
        return this.assetBankService;
    }

    private void updateTokensFromResponse(String response) {
        Map<String, String> oauthTokens = Utils.buildMapFromResponse(response);
        this.credentials.set(oauthTokens.get("oauth_token"), oauthTokens.get("oauth_token_secret"));
        this.bynderApi = Utils.createApiService(BynderApi.class, this.baseUrl, this.credentials);
    }

    private Observable<User> login(LoginQuery loginQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(loginQuery);
        Observable<Response<User>> loginObservable = this.bynderApi.login(params);
        return loginObservable.map(BynderServiceImpl$$Lambda$3.lambdaFactory$(this));
    }

    static /* synthetic */ User lambda$login$36(BynderServiceImpl this_, Response response) throws Exception {
        User user = (User)response.body();
        this_.credentials.set(user.getTokenKey(), user.getTokenSecret());
        this_.bynderApi = Utils.createApiService(BynderApi.class, this_.baseUrl, this_.credentials);
        return user;
    }

    static /* synthetic */ String lambda$getAccessToken$35(BynderServiceImpl this_, Response response) throws Exception {
        String accessToken = (String)response.body();
        this_.updateTokensFromResponse(accessToken);
        return accessToken;
    }

    static /* synthetic */ String lambda$getRequestToken$34(BynderServiceImpl this_, Response response) throws Exception {
        String requestToken = (String)response.body();
        this_.updateTokensFromResponse(requestToken);
        return requestToken;
    }
}

