/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.impl;

import com.bynder.sdk.api.AmazonApi;
import com.bynder.sdk.model.UploadRequest;
import com.bynder.sdk.service.AmazonService;
import io.reactivex.Observable;
import java.util.LinkedHashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class AmazonServiceImpl
implements AmazonService {
    private final AmazonApi amazonApi;

    public AmazonServiceImpl(String awsBucket) {
        Retrofit retrofit = new Retrofit.Builder().addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(awsBucket).build();
        this.amazonApi = (AmazonApi)retrofit.create(AmazonApi.class);
    }

    @Override
    public Observable<Response<Void>> uploadPartToAmazon(String filename, UploadRequest uploadRequest, int chunkNumber, byte[] fileContent, int numberOfChunks) {
        String finalKey = String.format("%s/p%s", uploadRequest.getMultipartParams().getKey(), chunkNumber);
        LinkedHashMap<String, RequestBody> params = new LinkedHashMap<String, RequestBody>();
        MediaType contentType = MediaType.parse((String)"multipart/form-data");
        params.put("x-amz-credential", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getAwsAccessKeyId()));
        params.put("key", RequestBody.create((MediaType)contentType, (String)finalKey));
        params.put("Policy", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getPolicy()));
        params.put("X-Amz-Signature", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getSignature()));
        params.put("acl", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getAcl()));
        params.put("x-amz-algorithm", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getAlgorithm()));
        params.put("x-amz-date", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getDate()));
        params.put("success_action_status", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getSuccessActionStatus()));
        params.put("Content-Type", RequestBody.create((MediaType)contentType, (String)uploadRequest.getMultipartParams().getContentType()));
        params.put("name", RequestBody.create((MediaType)contentType, (String)filename));
        params.put("chunk", RequestBody.create((MediaType)contentType, (String)String.valueOf(chunkNumber)));
        params.put("chunks", RequestBody.create((MediaType)contentType, (String)String.valueOf(numberOfChunks)));
        params.put("Filename", RequestBody.create((MediaType)contentType, (String)finalKey));
        RequestBody requestFile = RequestBody.create((MediaType)contentType, (byte[])fileContent);
        params.put("file", requestFile);
        return this.amazonApi.uploadPartToAmazon(params);
    }
}

