/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.impl;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Collection;
import com.bynder.sdk.query.CollectionAddMediaQuery;
import com.bynder.sdk.query.CollectionCreateQuery;
import com.bynder.sdk.query.CollectionInfoQuery;
import com.bynder.sdk.query.CollectionQuery;
import com.bynder.sdk.query.CollectionRemoveMediaQuery;
import com.bynder.sdk.query.CollectionShareQuery;
import com.bynder.sdk.service.CollectionService;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class CollectionServiceImpl
implements CollectionService {
    private final BynderApi bynderApi;

    public CollectionServiceImpl(BynderApi bynderApi) {
        this.bynderApi = bynderApi;
    }

    @Override
    public Observable<Response<List<Collection>>> getCollections(CollectionQuery collectionQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionQuery);
        return this.bynderApi.getCollections(params);
    }

    @Override
    public Observable<Response<Collection>> getCollectionInfo(CollectionInfoQuery collectionInfoQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionInfoQuery);
        return this.bynderApi.getCollectionInfo(params);
    }

    @Override
    public Observable<Response<Void>> createCollection(CollectionCreateQuery collectionCreateQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionCreateQuery);
        return this.bynderApi.createCollection(params);
    }

    @Override
    public Observable<Response<Void>> deleteCollection(CollectionInfoQuery collectionInfoQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionInfoQuery);
        return this.bynderApi.deleteCollection(params);
    }

    @Override
    public Observable<Response<List<String>>> getCollectionMediaIds(CollectionInfoQuery collectionInfoQuery) {
        return this.bynderApi.getCollectionMediaIds(collectionInfoQuery.getCollectionId());
    }

    @Override
    public Observable<Response<Void>> addMediaToCollection(CollectionAddMediaQuery collectionAddMediaQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionAddMediaQuery);
        return this.bynderApi.addMediaToCollection(collectionAddMediaQuery.getCollectionId(), params);
    }

    @Override
    public Observable<Response<Void>> removeMediaFromCollection(CollectionRemoveMediaQuery collectionRemoveMediaQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionRemoveMediaQuery);
        return this.bynderApi.removeMediaFromCollection(collectionRemoveMediaQuery.getCollectionId(), params);
    }

    @Override
    public Observable<Response<Void>> shareCollection(CollectionShareQuery collectionShareQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(collectionShareQuery);
        return this.bynderApi.shareCollection(collectionShareQuery.getCollectionId(), params);
    }
}

