/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.impl;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.SaveMediaResponse;
import com.bynder.sdk.model.Smartfilter;
import com.bynder.sdk.model.Tag;
import com.bynder.sdk.model.Usage;
import com.bynder.sdk.query.MediaDeleteQuery;
import com.bynder.sdk.query.MediaDownloadQuery;
import com.bynder.sdk.query.MediaInfoQuery;
import com.bynder.sdk.query.MediaPropertiesQuery;
import com.bynder.sdk.query.MediaQuery;
import com.bynder.sdk.query.MetapropertyQuery;
import com.bynder.sdk.query.UploadQuery;
import com.bynder.sdk.query.UsageCreateQuery;
import com.bynder.sdk.query.UsageDeleteQuery;
import com.bynder.sdk.query.UsageQuery;
import com.bynder.sdk.service.AssetBankService;
import com.bynder.sdk.service.upload.FileUploader;
import com.bynder.sdk.service.upload.UploadProgress;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class AssetBankServiceImpl
implements AssetBankService {
    private final BynderApi bynderApi;
    private final FileUploader fileUploader;

    public AssetBankServiceImpl(BynderApi bynderApi) {
        this.bynderApi = bynderApi;
        this.fileUploader = new FileUploader(bynderApi);
    }

    @Override
    public Observable<Response<List<Brand>>> getBrands() {
        return this.bynderApi.getBrands();
    }

    @Override
    public Observable<Response<List<Tag>>> getTags() {
        return this.bynderApi.getTags();
    }

    @Override
    public Observable<Response<Map<String, Metaproperty>>> getMetaproperties(MetapropertyQuery metapropertyQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(metapropertyQuery);
        return this.bynderApi.getMetaproperties(params);
    }

    @Override
    public Observable<Response<List<Media>>> getMediaList(MediaQuery mediaQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(mediaQuery);
        return this.bynderApi.getMediaList(params);
    }

    @Override
    public Observable<Response<Media>> getMediaInfo(MediaInfoQuery mediaInfoQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(mediaInfoQuery);
        return this.bynderApi.getMediaInfo(params);
    }

    @Override
    public Observable<Response<Void>> setMediaProperties(MediaPropertiesQuery mediaPropertiesQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(mediaPropertiesQuery);
        return this.bynderApi.setMediaProperties(params);
    }

    @Override
    public Observable<Response<Void>> deleteMedia(MediaDeleteQuery mediaDeleteQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(mediaDeleteQuery);
        return this.bynderApi.deleteMedia(params);
    }

    @Override
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(MediaDownloadQuery mediaDownloadQuery) {
        if (mediaDownloadQuery.getMediaItemId() == null) {
            return this.bynderApi.getMediaDownloadUrl(mediaDownloadQuery.getMediaId());
        }
        return this.bynderApi.getMediaDownloadUrl(mediaDownloadQuery.getMediaId(), mediaDownloadQuery.getMediaItemId());
    }

    @Override
    public Observable<Response<Usage>> createUsage(UsageCreateQuery usageCreateQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(usageCreateQuery);
        return this.bynderApi.createUsage(params);
    }

    @Override
    public Observable<Response<List<Usage>>> getUsage(UsageQuery usageQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(usageQuery);
        return this.bynderApi.getUsage(params);
    }

    @Override
    public Observable<Response<Void>> deleteUsage(UsageDeleteQuery usageDeleteQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(usageDeleteQuery);
        return this.bynderApi.deleteUsage(params);
    }

    @Override
    public Observable<Response<List<Smartfilter>>> getSmartfilters() {
        return this.bynderApi.getSmartfilters();
    }

    @Override
    public Observable<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return this.fileUploader.uploadFile(uploadQuery);
    }

    @Override
    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery uploadQuery) {
        return this.fileUploader.uploadFileWithProgress(uploadQuery);
    }
}

