/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Arrays;

public class BooleanTypeAdapter
implements JsonDeserializer<Boolean> {
    public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()).contains(json.toString())) {
            return json.getAsBoolean();
        }
        try {
            int code = json.getAsInt();
            if (code == 0) {
                return false;
            }
            if (code == 1) {
                return true;
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

