/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.bynder.sdk.model.Media;
import com.bynder.sdk.util.BooleanTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediaTypeDeserializer
implements JsonDeserializer<Media> {
    private static final String KEY_PREFIX = "property_";

    public Media deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject jsonObject = json.getAsJsonObject();
        Map<String, List<String>> metaproperties = this.readMetapropertiesMap(jsonObject);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Boolean.class, (Object)new BooleanTypeAdapter());
        Gson gson = gsonBuilder.create();
        Media media = (Media)gson.fromJson((JsonElement)jsonObject, Media.class);
        media.setMetaproperties(metaproperties);
        return media;
    }

    private Map<String, List<String>> readMetapropertiesMap(JsonObject jsonObject) {
        HashMap<String, List<String>> metaproperties = new HashMap<String, List<String>>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (!((String)entry.getKey()).startsWith(KEY_PREFIX)) continue;
            String key = ((String)entry.getKey()).substring(KEY_PREFIX.length());
            metaproperties.put(key, Arrays.asList(((JsonElement)entry.getValue()).getAsString().split("\\s*,\\s*")));
        }
        return metaproperties;
    }
}

