/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.bynder.sdk.model.Credentials;
import com.bynder.sdk.model.HttpConnectionSettings;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.query.ApiField;
import com.bynder.sdk.query.ConversionType;
import com.bynder.sdk.query.MetapropertyField;
import com.bynder.sdk.util.BooleanTypeAdapter;
import com.bynder.sdk.util.MediaTypeDeserializer;
import com.bynder.sdk.util.StringConverterFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;
import se.akerfeldt.okhttp.signpost.SigningInterceptor;

public final class Utils {
    public static final String STR_AND = "&";
    public static final String STR_COMMA = ",";
    public static final String STR_EQUALS = "=";

    private Utils() {
    }

    public static Map<String, String> buildMapFromResponse(String response) {
        String[] keyValuePairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : keyValuePairs = response.split(STR_AND)) {
            String[] keyValue = pair.split(STR_EQUALS);
            if (keyValue.length != 2) {
                throw new InvalidParameterException();
            }
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    private static OkHttpOAuthConsumer createHttpOAuthConsumer(String consumerKey, String consumerSecret, String tokenKey, String tokenSecret) {
        OkHttpOAuthConsumer consumer = new OkHttpOAuthConsumer(consumerKey, consumerSecret);
        if (tokenKey != null && tokenSecret != null) {
            consumer.setTokenWithSecret(tokenKey, tokenSecret);
        }
        return consumer;
    }

    private static OkHttpClient createHttpClient(OkHttpOAuthConsumer consumer, HttpConnectionSettings httpConnectionSettings) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.interceptors().clear();
        httpClient.addInterceptor((Interceptor)new SigningInterceptor(consumer));
        if (httpConnectionSettings.isLoggingInterceptorEnabled()) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor((Interceptor)interceptor);
        }
        if (httpConnectionSettings.getCustomInterceptor() != null) {
            httpClient.addInterceptor(httpConnectionSettings.getCustomInterceptor());
        }
        httpClient.retryOnConnectionFailure(httpConnectionSettings.isRetryOnConnectionFailure());
        httpClient.readTimeout((long)httpConnectionSettings.getReadTimeoutSeconds(), TimeUnit.SECONDS);
        httpClient.connectTimeout((long)httpConnectionSettings.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
        if (httpConnectionSettings.getSslContext() != null && httpConnectionSettings.getTrustManager() != null) {
            httpClient.sslSocketFactory(httpConnectionSettings.getSslContext().getSocketFactory(), httpConnectionSettings.getTrustManager());
        }
        return httpClient.build();
    }

    public static <T> T createApiService(Class<T> apiInterface, URL baseUrl, Credentials credentials, HttpConnectionSettings httpConnectionSettings) {
        OkHttpOAuthConsumer oauthConsumer = Utils.createHttpOAuthConsumer(credentials.getConsumerKey(), credentials.getConsumerSecret(), credentials.getToken(), credentials.getTokenSecret());
        OkHttpClient httpClient = Utils.createHttpClient(oauthConsumer, httpConnectionSettings);
        Retrofit.Builder builder = new Retrofit.Builder();
        builder.baseUrl(baseUrl.toString());
        builder.addConverterFactory((Converter.Factory)new StringConverterFactory());
        builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Boolean.class, (Object)new BooleanTypeAdapter());
        gsonBuilder.registerTypeAdapter(Media.class, (Object)new MediaTypeDeserializer());
        builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gsonBuilder.create()));
        builder.client(httpClient);
        Retrofit retrofit = builder.build();
        return (T)retrofit.create(apiInterface);
    }

    public static Map<String, String> getApiParameters(Object query) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, String> params = new HashMap<String, String>();
        for (Field field : fields = query.getClass().getDeclaredFields()) {
            Utils.convertField(field, query, params);
        }
        return params;
    }

    private static void convertField(Field field, Object query, Map<String, String> params) throws IllegalAccessException {
        field.setAccessible(true);
        ApiField apiField = field.getAnnotation(ApiField.class);
        if (field.get(query) != null && apiField != null) {
            if (apiField.conversionType() == ConversionType.NONE) {
                params.put(apiField.name(), field.get(query).toString());
            } else if (apiField.conversionType() == ConversionType.METAPROPERTY_FIELD) {
                MetapropertyField metapropertyField = (MetapropertyField)field.get(query);
                params.put(String.format("%s.%s", apiField.name(), metapropertyField.getMetapropertyId()), StringUtils.join(metapropertyField.getOptionsIds(), (String)STR_COMMA));
            } else if (apiField.conversionType() == ConversionType.LIST_FIELD) {
                List listField = (List)field.get(query);
                params.put(apiField.name(), StringUtils.join((Collection)listField, (String)STR_COMMA));
            } else if (apiField.conversionType() == ConversionType.JSON_FIELD) {
                List listField = (List)field.get(query);
                Gson gson = new Gson();
                params.put(apiField.name(), gson.toJson((Object)listField));
            } else if (apiField.conversionType() == ConversionType.BOOLEAN_FIELD) {
                Boolean booleanField = (Boolean)field.get(query);
                params.put(apiField.name(), booleanField != false ? "1" : "0");
            }
        }
        field.setAccessible(false);
    }
}

