/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.api;

import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.Collection;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.FinaliseResponse;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.PollStatus;
import com.bynder.sdk.model.SaveMediaResponse;
import com.bynder.sdk.model.Smartfilter;
import com.bynder.sdk.model.Tag;
import com.bynder.sdk.model.UploadRequest;
import com.bynder.sdk.model.Usage;
import com.bynder.sdk.model.User;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;
import retrofit2.http.DELETE;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface BynderApi {
    @FormUrlEncoded
    @POST(value="/api/v4/users/login/")
    public Observable<Response<User>> login(@FieldMap Map<String, String> var1);

    @POST(value="/api/v4/oauth/request_token/")
    public Observable<Response<String>> getRequestToken();

    @POST(value="/api/v4/oauth/access_token/")
    public Observable<Response<String>> getAccessToken();

    @GET(value="/api/v4/account/derivatives/")
    public Observable<Response<List<Derivative>>> getDerivatives();

    @GET(value="/api/v4/brands/")
    public Observable<Response<List<Brand>>> getBrands();

    @GET(value="/api/v4/tags/")
    public Observable<Response<List<Tag>>> getTags();

    @GET(value="/api/v4/metaproperties/")
    public Observable<Response<Map<String, Metaproperty>>> getMetaproperties(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/")
    public Observable<Response<List<Media>>> getMediaList(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/")
    public Observable<Response<Media>> getMediaInfo(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/media/")
    public Observable<Response<Void>> setMediaProperties(@FieldMap Map<String, String> var1);

    @DELETE(value="/api/v4/media/")
    public Observable<Response<Void>> deleteMedia(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/{id}/download/")
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(@Path(value="id") String var1);

    @GET(value="/api/v4/media/{id}/download/{itemId}/")
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(@Path(value="id") String var1, @Path(value="itemId") String var2);

    @FormUrlEncoded
    @POST(value="/api/media/usage/")
    public Observable<Response<Usage>> createUsage(@FieldMap Map<String, String> var1);

    @GET(value="/api/media/usage/")
    public Observable<Response<List<Usage>>> getUsage(@QueryMap Map<String, String> var1);

    @DELETE(value="/api/media/usage/")
    public Observable<Response<Void>> deleteUsage(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/smartfilters/")
    public Observable<Response<List<Smartfilter>>> getSmartfilters();

    @GET(value="/api/v4/collections/")
    public Observable<Response<List<Collection>>> getCollections(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/collections/")
    public Observable<Response<Collection>> getCollectionInfo(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/")
    public Observable<Response<Void>> createCollection(@FieldMap Map<String, String> var1);

    @DELETE(value="/api/v4/collections/")
    public Observable<Response<Void>> deleteCollection(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/collections/{id}/media/")
    public Observable<Response<List<String>>> getCollectionMediaIds(@Path(value="id") String var1);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/{id}/media/")
    public Observable<Response<Void>> addMediaToCollection(@Path(value="id") String var1, @FieldMap Map<String, String> var2);

    @DELETE(value="/api/v4/collections/{id}/media/")
    public Observable<Response<Void>> removeMediaFromCollection(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/{id}/share/")
    public Observable<Response<Void>> shareCollection(@Path(value="id") String var1, @FieldMap Map<String, String> var2);

    @FormUrlEncoded
    @POST(value="/api/upload/init/")
    public Observable<Response<UploadRequest>> getUploadInformation(@FieldMap Map<String, String> var1);

    @GET(value="/api/upload/endpoint/")
    public Observable<Response<String>> getClosestS3Endpoint();

    @FormUrlEncoded
    @POST(value="/api/v4/upload/")
    public Observable<Response<Void>> registerChunk(@FieldMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/upload/")
    public Observable<Response<FinaliseResponse>> finaliseUpload(@FieldMap Map<String, String> var1);

    @GET(value="/api/v4/upload/poll/")
    public Observable<Response<PollStatus>> getPollStatus(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/media/save/")
    public Observable<Response<SaveMediaResponse>> saveMedia(@FieldMap Map<String, String> var1);
}

