/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.upload;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.FinaliseResponse;
import com.bynder.sdk.model.PollStatus;
import com.bynder.sdk.model.SaveMediaResponse;
import com.bynder.sdk.model.UploadRequest;
import com.bynder.sdk.query.FinaliseUploadQuery;
import com.bynder.sdk.query.PollStatusQuery;
import com.bynder.sdk.query.RegisterChunkQuery;
import com.bynder.sdk.query.RequestUploadQuery;
import com.bynder.sdk.query.SaveMediaQuery;
import com.bynder.sdk.query.UploadQuery;
import com.bynder.sdk.service.AmazonService;
import com.bynder.sdk.service.exception.BynderUploadException;
import com.bynder.sdk.service.impl.AmazonServiceImpl;
import com.bynder.sdk.service.upload.FileConverterStatus;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$1;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$10;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$11;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$12;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$13;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$14;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$15;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$16;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$17;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$18;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$19;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$20;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$21;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$22;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$23;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$24;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$25;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$26;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$27;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$28;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$29;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$30;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$31;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$32;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$33;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$34;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$35;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$36;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$4;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$5;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$6;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$7;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$8;
import com.bynder.sdk.service.upload.FileUploader$$Lambda$9;
import com.bynder.sdk.service.upload.UploadProcessData;
import com.bynder.sdk.service.upload.UploadProgress;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Map;
import retrofit2.Response;

public class FileUploader {
    private static final int MAX_CHUNK_SIZE = 0x500000;
    private static final int MAX_POLLING_ITERATIONS = 60;
    private static final int POLLING_IDLE_TIME = 2000;
    private final BynderApi bynderApi;
    private AmazonService amazonService;

    public FileUploader(BynderApi bynderApi) {
        this.bynderApi = bynderApi;
    }

    public Observable<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$1.lambdaFactory$(this, uploadQuery));
    }

    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery uploadQuery) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$4.lambdaFactory$(this, uploadQuery));
    }

    private Observable<UploadProgress> uploadParts(File file, UploadRequest uploadRequest) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$5.lambdaFactory$(this, file, uploadRequest));
    }

    private Observable<Integer> processChunk(UploadProcessData uploadProcessData) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$6.lambdaFactory$(this, uploadProcessData));
    }

    private void registerUploadedChunk(UploadProcessData uploadProcessData, ObservableEmitter<Integer> observableEmitter, Integer chunkSize) throws IllegalAccessException {
        String filename = String.format("%s/p%s", uploadProcessData.getUploadRequest().getS3Filename(), Integer.toString(uploadProcessData.getChunkNumber()));
        Observable<Response<Void>> registerChunkObs = this.registerChunk(new RegisterChunkQuery(uploadProcessData.getUploadRequest().getS3File().getUploadId(), uploadProcessData.getChunkNumber(), uploadProcessData.getUploadRequest().getS3File().getTargetId(), filename));
        registerChunkObs.subscribe(FileUploader$$Lambda$7.lambdaFactory$(observableEmitter, chunkSize), FileUploader$$Lambda$8.lambdaFactory$(observableEmitter));
    }

    private Observable<Boolean> checkUploadFinished(String importId) {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$9.lambdaFactory$(this, importId));
    }

    private Observable<SaveMediaResponse> saveUploadedMedia(UploadQuery uploadQuery, File file, String importId) throws IllegalAccessException {
        return Observable.create((ObservableOnSubscribe)FileUploader$$Lambda$10.lambdaFactory$(this, uploadQuery, importId, file));
    }

    private Observable<Response<String>> getClosestS3Endpoint() {
        return this.bynderApi.getClosestS3Endpoint();
    }

    private Observable<Response<UploadRequest>> getUploadInformation(RequestUploadQuery requestUploadQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(requestUploadQuery);
        return this.bynderApi.getUploadInformation(params);
    }

    private Observable<Response<Void>> registerChunk(RegisterChunkQuery registerChunkQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(registerChunkQuery);
        return this.bynderApi.registerChunk(params);
    }

    private Observable<Response<FinaliseResponse>> finaliseUpload(FinaliseUploadQuery finaliseUploadQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(finaliseUploadQuery);
        return this.bynderApi.finaliseUpload(params);
    }

    private Observable<Response<PollStatus>> getPollStatus(PollStatusQuery pollStatusQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(pollStatusQuery);
        return this.bynderApi.getPollStatus(params);
    }

    private Observable<Response<SaveMediaResponse>> saveMedia(SaveMediaQuery saveMediaQuery) throws IllegalAccessException {
        Map<String, String> params = Utils.getApiParameters(saveMediaQuery);
        return this.bynderApi.saveMedia(params);
    }

    static /* synthetic */ void lambda$saveUploadedMedia$33(FileUploader this_, UploadQuery uploadQuery, String importId, File file, ObservableEmitter emitter) throws Exception {
        Observable<Response<SaveMediaResponse>> saveMediaObs = uploadQuery.getMediaId() == null ? this_.saveMedia(new SaveMediaQuery(importId).setBrandId(uploadQuery.getBrandId()).setName(file.getName()).setAudit(uploadQuery.isAudit())) : this_.saveMedia(new SaveMediaQuery(importId).setMediaId(uploadQuery.getMediaId()).setAudit(uploadQuery.isAudit()));
        saveMediaObs.subscribe(FileUploader$$Lambda$11.lambdaFactory$(emitter), FileUploader$$Lambda$12.lambdaFactory$(emitter), FileUploader$$Lambda$13.lambdaFactory$(emitter));
    }

    static /* synthetic */ void lambda$null$32(ObservableEmitter emitter) throws Exception {
        emitter.onComplete();
    }

    static /* synthetic */ void lambda$null$31(ObservableEmitter emitter, Throwable throwable) throws Exception {
        emitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$30(ObservableEmitter emitter, Response saveMediaResponse) throws Exception {
        emitter.onNext(saveMediaResponse.body());
    }

    static /* synthetic */ void lambda$checkUploadFinished$29(FileUploader this_, String importId, ObservableEmitter observableEmitter) throws Exception {
        try {
            FileConverterStatus fileConverterStatus = new FileConverterStatus(60);
            this_.getPollStatus(new PollStatusQuery(Arrays.asList(importId))).repeatUntil(FileUploader$$Lambda$14.lambdaFactory$(fileConverterStatus, observableEmitter)).subscribe(FileUploader$$Lambda$15.lambdaFactory$(importId, fileConverterStatus), FileUploader$$Lambda$16.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$28(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$27(String importId, FileConverterStatus fileConverterStatus, Response pollStatusResponse) throws Exception {
        PollStatus pollStatus = (PollStatus)pollStatusResponse.body();
        if (pollStatus != null) {
            if (pollStatus.getItemsDone().contains(importId)) {
                fileConverterStatus.setDone(true);
            }
            if (pollStatus.getItemsFailed().contains(importId)) {
                fileConverterStatus.setDone(false);
            }
        }
    }

    static /* synthetic */ boolean lambda$null$26(FileConverterStatus fileConverterStatus, ObservableEmitter observableEmitter) throws Exception {
        if (fileConverterStatus.isDone()) {
            observableEmitter.onNext((Object)fileConverterStatus.isSuccessful());
            observableEmitter.onComplete();
            return true;
        }
        if (!fileConverterStatus.nextAttempt()) {
            observableEmitter.onNext((Object)false);
            observableEmitter.onComplete();
            return true;
        }
        Thread.sleep(2000L);
        return false;
    }

    static /* synthetic */ void lambda$registerUploadedChunk$25(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$registerUploadedChunk$24(ObservableEmitter observableEmitter, Integer chunkSize, Response voidResponse) throws Exception {
        observableEmitter.onNext((Object)chunkSize);
        observableEmitter.onComplete();
    }

    static /* synthetic */ void lambda$processChunk$23(FileUploader this_, UploadProcessData uploadProcessData, ObservableEmitter observableEmitter) throws Exception {
        try {
            byte[] chunk = uploadProcessData.getBuffer();
            Observable<Response<Void>> uploadPartToAmazonObs = this_.amazonService.uploadPartToAmazon(uploadProcessData.getFile().getName(), uploadProcessData.getUploadRequest(), uploadProcessData.getChunkNumber(), chunk, uploadProcessData.getNumberOfChunks());
            uploadPartToAmazonObs.subscribe(FileUploader$$Lambda$17.lambdaFactory$(this_, uploadProcessData, observableEmitter, chunk), FileUploader$$Lambda$18.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$22(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$21(FileUploader this_, UploadProcessData uploadProcessData, ObservableEmitter observableEmitter, byte[] chunk, Response voidResponse) throws Exception {
        this_.registerUploadedChunk(uploadProcessData, (ObservableEmitter<Integer>)observableEmitter, chunk.length);
        observableEmitter.onNext((Object)chunk.length);
    }

    static /* synthetic */ void lambda$uploadParts$20(FileUploader this_, File file, UploadRequest uploadRequest, ObservableEmitter observableEmitter) throws Exception {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            UploadProgress uploadProgress = new UploadProgress(file.length());
            UploadProcessData uploadProcessData = new UploadProcessData(file, fileInputStream, uploadRequest, 0x500000);
            uploadProcessData.incrementChunk();
            this_.processChunk(uploadProcessData).repeatUntil(FileUploader$$Lambda$19.lambdaFactory$(uploadProcessData, observableEmitter)).subscribe(FileUploader$$Lambda$20.lambdaFactory$(uploadProgress, observableEmitter), FileUploader$$Lambda$21.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$19(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$18(UploadProgress uploadProgress, ObservableEmitter observableEmitter, Integer chunkSize) throws Exception {
        uploadProgress.addProgress(chunkSize.intValue());
        observableEmitter.onNext((Object)uploadProgress);
    }

    static /* synthetic */ boolean lambda$null$17(UploadProcessData uploadProcessData, ObservableEmitter observableEmitter) throws Exception {
        boolean isProcessed = uploadProcessData.isCompleted();
        if (isProcessed) {
            observableEmitter.onComplete();
        } else {
            uploadProcessData.incrementChunk();
        }
        return isProcessed;
    }

    static /* synthetic */ void lambda$uploadFileWithProgress$16(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter) throws Exception {
        try {
            Observable<Response<String>> s3EndpointObs = this_.getClosestS3Endpoint();
            s3EndpointObs.subscribe(FileUploader$$Lambda$22.lambdaFactory$(this_, uploadQuery, observableEmitter), FileUploader$$Lambda$23.lambdaFactory$(observableEmitter));
        }
        catch (Exception e) {
            observableEmitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$15(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$14(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter observableEmitter, Response awsBucketResponse) throws Exception {
        this_.amazonService = new AmazonServiceImpl((String)awsBucketResponse.body());
        File file = new File(uploadQuery.getFilepath());
        Observable<Response<UploadRequest>> uploadInformationObs = this_.getUploadInformation(new RequestUploadQuery(file.getName()));
        uploadInformationObs.subscribe(FileUploader$$Lambda$24.lambdaFactory$(this_, file, observableEmitter, uploadQuery), FileUploader$$Lambda$25.lambdaFactory$(observableEmitter));
    }

    static /* synthetic */ void lambda$null$13(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$12(FileUploader this_, File file, ObservableEmitter observableEmitter, UploadQuery uploadQuery, Response uploadRequestResponse) throws Exception {
        UploadRequest uploadRequest = (UploadRequest)uploadRequestResponse.body();
        if (!file.exists()) {
            observableEmitter.onError((Throwable)new BynderUploadException(String.format("File: %s not found. Upload not completed.", file.getName())));
            return;
        }
        this_.uploadParts(file, uploadRequest).subscribe(FileUploader$$Lambda$26.lambdaFactory$(this_, observableEmitter, uploadRequest, uploadQuery, file), FileUploader$$Lambda$27.lambdaFactory$(observableEmitter));
    }

    static /* synthetic */ void lambda$null$11(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$10(FileUploader this_, ObservableEmitter observableEmitter, UploadRequest uploadRequest, UploadQuery uploadQuery, File file, UploadProgress uploadProgress) throws Exception {
        observableEmitter.onNext((Object)uploadProgress);
        if (uploadProgress.areChunksFinished()) {
            Observable<Response<FinaliseResponse>> finaliseUploadObs = this_.finaliseUpload(new FinaliseUploadQuery(uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), uploadRequest.getS3Filename(), uploadProgress.getUploadedChunks()));
            finaliseUploadObs.subscribe(FileUploader$$Lambda$28.lambdaFactory$(this_, uploadQuery, file, uploadProgress, observableEmitter), FileUploader$$Lambda$29.lambdaFactory$(observableEmitter));
        }
    }

    static /* synthetic */ void lambda$null$9(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$8(FileUploader this_, UploadQuery uploadQuery, File file, UploadProgress uploadProgress, ObservableEmitter observableEmitter, Response finaliseResponse) throws Exception {
        String importId = ((FinaliseResponse)finaliseResponse.body()).getImportId();
        this_.checkUploadFinished(importId).subscribe(FileUploader$$Lambda$30.lambdaFactory$(this_, uploadQuery, file, importId, uploadProgress, observableEmitter), FileUploader$$Lambda$31.lambdaFactory$(observableEmitter));
    }

    static /* synthetic */ void lambda$null$7(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$6(FileUploader this_, UploadQuery uploadQuery, File file, String importId, UploadProgress uploadProgress, ObservableEmitter observableEmitter, Boolean hasFinishedSuccessfully) throws Exception {
        if (hasFinishedSuccessfully.booleanValue()) {
            this_.saveUploadedMedia(uploadQuery, file, importId).subscribe(FileUploader$$Lambda$32.lambdaFactory$(uploadProgress, observableEmitter), FileUploader$$Lambda$33.lambdaFactory$(observableEmitter));
        } else {
            observableEmitter.onError((Throwable)new BynderUploadException("Converter did not finished. Upload not completed."));
        }
    }

    static /* synthetic */ void lambda$null$5(ObservableEmitter observableEmitter, Throwable throwable) throws Exception {
        observableEmitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$4(UploadProgress uploadProgress, ObservableEmitter observableEmitter, SaveMediaResponse saveMediaResponse) throws Exception {
        uploadProgress.setSaveMediaResponse(saveMediaResponse);
        uploadProgress.setFinished(true);
        observableEmitter.onNext((Object)uploadProgress);
        observableEmitter.onComplete();
    }

    static /* synthetic */ void lambda$uploadFile$3(FileUploader this_, UploadQuery uploadQuery, ObservableEmitter emitter) throws Exception {
        try {
            Observable<UploadProgress> uploadProgressObservable = this_.uploadFileWithProgress(uploadQuery);
            uploadProgressObservable.subscribe(FileUploader$$Lambda$34.lambdaFactory$(emitter), FileUploader$$Lambda$35.lambdaFactory$(emitter), FileUploader$$Lambda$36.lambdaFactory$(emitter));
        }
        catch (Exception e) {
            emitter.onError((Throwable)e);
        }
    }

    static /* synthetic */ void lambda$null$2(ObservableEmitter emitter) throws Exception {
        emitter.onComplete();
    }

    static /* synthetic */ void lambda$null$1(ObservableEmitter emitter, Throwable throwable) throws Exception {
        emitter.onError(throwable);
    }

    static /* synthetic */ void lambda$null$0(ObservableEmitter emitter, UploadProgress uploadProgress) throws Exception {
        if (uploadProgress.isFinished()) {
            emitter.onNext((Object)uploadProgress.getSaveMediaResponse());
        }
    }
}

