/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.upload;

import com.bynder.sdk.model.SaveMediaResponse;

public class UploadProgress {
    private final long totalBytes;
    private boolean finished;
    private SaveMediaResponse saveMediaResponse;
    private int uploadedChunks = 0;
    private long transmittedBytes;

    public UploadProgress(long totalBytes) {
        this.totalBytes = totalBytes;
        this.transmittedBytes = 0L;
        this.finished = false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public SaveMediaResponse getSaveMediaResponse() {
        return this.saveMediaResponse;
    }

    public void setSaveMediaResponse(SaveMediaResponse saveMediaResponse) {
        this.saveMediaResponse = saveMediaResponse;
    }

    void addProgress(long bytes) {
        this.transmittedBytes += bytes;
        ++this.uploadedChunks;
    }

    public boolean areChunksFinished() {
        return this.transmittedBytes == this.totalBytes;
    }

    public int getUploadedChunks() {
        return this.uploadedChunks;
    }

    public long getTransmittedBytes() {
        return this.transmittedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

