/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.query.decoder;

import com.bynder.sdk.query.decoder.ApiField;
import com.bynder.sdk.query.decoder.ParameterDecoder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class QueryDecoder {
    private static void convertField(Field field, Object query, Map<String, String> parameters) throws IllegalAccessException {
        field.setAccessible(true);
        ApiField apiField = field.getAnnotation(ApiField.class);
        Object fieldValue = field.get(query);
        if (apiField != null && fieldValue != null) {
            String name;
            String string = name = "".equals(apiField.name()) ? field.getName() : apiField.name();
            if (apiField.decoder().equals(Void.TYPE)) {
                parameters.put(name, fieldValue.toString());
            } else {
                ParameterDecoder parameterDecoder = null;
                try {
                    parameterDecoder = (ParameterDecoder)apiField.decoder().newInstance();
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                parameters.putAll(parameterDecoder.decode(name, fieldValue));
            }
        }
        field.setAccessible(false);
    }

    public Map<String, String> decode(Object query) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.addAll(Arrays.asList(query.getClass().getDeclaredFields()));
            if (query.getClass().getSuperclass().getDeclaredFields() != null) {
                fields.addAll(Arrays.asList(query.getClass().getSuperclass().getDeclaredFields()));
            }
            for (Field field : fields) {
                try {
                    QueryDecoder.convertField(field, query, parameters);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return parameters;
    }
}

