/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.query.upload;

import com.bynder.sdk.query.MetapropertyAttribute;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class UploadQuery {
    private final String filepath;
    private final String brandId;
    private String mediaId;
    private Boolean audit;
    private String tags;
    private List<MetapropertyAttribute> metaproperties;

    public UploadQuery(String filepath, String brandId) {
        this.filepath = filepath;
        this.brandId = brandId;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getFilename() {
        return Paths.get(this.filepath, new String[0]).getFileName().toString();
    }

    public String getBrandId() {
        return this.brandId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public UploadQuery setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public Boolean isAudit() {
        return this.audit;
    }

    public UploadQuery setAudit(Boolean audit) {
        this.audit = audit;
        return this;
    }

    public String getTags() {
        return this.tags;
    }

    public UploadQuery setTags(List<String> tags) {
        this.tags = String.join((CharSequence)",", tags);
        return this;
    }

    public List<MetapropertyAttribute> getMetaproperties() {
        return this.metaproperties;
    }

    public UploadQuery addMetaproperty(String metapropertyUuid, String optionName) {
        if (this.metaproperties == null) {
            this.metaproperties = new ArrayList<MetapropertyAttribute>();
        }
        this.metaproperties.add(new MetapropertyAttribute(metapropertyUuid, new String[]{optionName}));
        return this;
    }

    public UploadQuery addMetaproperty(String metapropertyUuid, String[] options) {
        if (this.metaproperties == null) {
            this.metaproperties = new ArrayList<MetapropertyAttribute>();
        }
        this.metaproperties.add(new MetapropertyAttribute(metapropertyUuid, options));
        return this;
    }
}

