/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.api;

import com.bynder.sdk.api.AmazonS3Api;
import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.api.OAuthApi;
import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.exception.BynderRuntimeException;
import com.bynder.sdk.model.oauth.Token;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.util.BooleanTypeAdapter;
import com.bynder.sdk.util.StringConverterFactory;
import com.bynder.sdk.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiFactory {
    private ApiFactory() {
    }

    public static BynderApi createBynderClient(Configuration configuration) {
        return (BynderApi)new Retrofit.Builder().baseUrl(configuration.getBaseUrl().toString()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)new StringConverterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().registerTypeAdapter(Boolean.class, (Object)new BooleanTypeAdapter()).create())).client(ApiFactory.createOkHttpClient(configuration)).build().create(BynderApi.class);
    }

    public static AmazonS3Api createAmazonS3Client(String bucket) {
        return (AmazonS3Api)new Retrofit.Builder().baseUrl(bucket).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build().create(AmazonS3Api.class);
    }

    public static OAuthApi createOAuthClient(String baseUrl) {
        return (OAuthApi)new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(OAuthApi.class);
    }

    private static OkHttpClient createOkHttpClient(Configuration configuration) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (configuration.getPermanentToken() == null) {
            ApiFactory.setOAuthInterceptor(httpClientBuilder, configuration);
        } else {
            ApiFactory.setPermanentTokenInterceptor(httpClientBuilder, configuration);
        }
        ApiFactory.setHttpConnectionSettings(httpClientBuilder, configuration);
        ApiFactory.addUserAgentHeader(httpClientBuilder);
        return httpClientBuilder.build();
    }

    private static void setOAuthInterceptor(OkHttpClient.Builder httpClientBuilder, Configuration configuration) {
        httpClientBuilder.addInterceptor(chain -> {
            if (configuration.getOAuthSettings().getToken() == null) {
                throw new BynderRuntimeException("Token is not defined in Configuration");
            }
            if (Utils.isDateExpiring(configuration.getOAuthSettings().getToken().getAccessTokenExpiration(), 15)) {
                configuration.getOAuthSettings().callback((Token)BynderClient.Builder.create(configuration).getOAuthService().refreshAccessToken().blockingSingle());
            }
            return chain.proceed(ApiFactory.addAuthHeader(chain.request(), configuration.getOAuthSettings().getToken().getAccessToken()));
        });
    }

    private static void setPermanentTokenInterceptor(OkHttpClient.Builder httpClientBuilder, Configuration configuration) {
        httpClientBuilder.addInterceptor(chain -> chain.proceed(ApiFactory.addAuthHeader(chain.request(), configuration.getPermanentToken())));
    }

    private static void setHttpConnectionSettings(OkHttpClient.Builder httpClientBuilder, Configuration configuration) {
        HttpConnectionSettings httpConnectionSettings = configuration.getHttpConnectionSettings();
        if (httpConnectionSettings.isLoggingInterceptorEnabled()) {
            httpClientBuilder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        if (httpConnectionSettings.getCustomInterceptor() != null) {
            httpClientBuilder.addInterceptor(httpConnectionSettings.getCustomInterceptor());
        }
        httpClientBuilder.retryOnConnectionFailure(httpConnectionSettings.isRetryOnConnectionFailure()).readTimeout((long)httpConnectionSettings.getReadTimeoutSeconds(), TimeUnit.SECONDS).connectTimeout((long)httpConnectionSettings.getConnectTimeoutSeconds(), TimeUnit.SECONDS).writeTimeout((long)httpConnectionSettings.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
        if (httpConnectionSettings.getSslContext() != null && httpConnectionSettings.getTrustManager() != null) {
            httpClientBuilder.sslSocketFactory(httpConnectionSettings.getSslContext().getSocketFactory(), httpConnectionSettings.getTrustManager());
        }
    }

    private static void addUserAgentHeader(OkHttpClient.Builder httpClientBuilder) {
        httpClientBuilder.addInterceptor(chain -> {
            String version;
            String name;
            try {
                Properties sdkInfo = Utils.loadConfig("bynder-sdk");
                name = sdkInfo.getProperty("name");
                version = sdkInfo.getProperty("version");
            }
            catch (IOException e) {
                name = "bynder-java-sdk";
                version = "unknown";
            }
            return chain.proceed(ApiFactory.addHeader(chain.request(), "User-Agent", String.format("%s/%s", name, version)));
        });
    }

    private static Request addHeader(Request request, String key, String value) {
        return request.newBuilder().header(key, value).build();
    }

    private static Request addAuthHeader(Request request, String token) {
        return ApiFactory.addHeader(request, "Authorization", String.format("%s %s", "Bearer", token));
    }
}

