/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.sample;

import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.OAuthSettings;
import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.MediaType;
import com.bynder.sdk.model.oauth.RefreshTokenCallback;
import com.bynder.sdk.model.oauth.Token;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.query.MediaQuery;
import com.bynder.sdk.query.OrderBy;
import com.bynder.sdk.query.upload.UploadQuery;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.Utils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class AppSample {
    private static final Logger LOG = LoggerFactory.getLogger(AppSample.class);

    public static void main(String[] args) throws URISyntaxException, IOException {
        Properties appProperties = Utils.loadConfig("app");
        BynderClient client = BynderClient.Builder.create(new Configuration.Builder(new URL(appProperties.getProperty("BASE_URL"))).setPermanentToken(appProperties.getProperty("PERMANENT_TOKEN")).build());
        AssetService assetService = client.getAssetService();
        List mediaList = (List)((Response)assetService.getMediaList(new MediaQuery().setType(MediaType.IMAGE).setOrderBy(OrderBy.NAME_DESC).setLimit(10).setPage(1)).blockingSingle()).body();
        for (Media media : mediaList) {
            LOG.info(media.getName());
        }
        String filePath = "your-absolute-filepath";
        String brandId = "your-brand-id";
        UploadQuery uploadQuery = new UploadQuery(filePath, brandId);
        SaveMediaResponse saveMediaResponse = (SaveMediaResponse)assetService.uploadFile(uploadQuery).blockingSingle();
        RefreshTokenCallback callback = new RefreshTokenCallback(){

            @Override
            public void execute(Token token) {
                LOG.info("Auto refresh triggered!");
                LOG.info(String.format("Refresh token used: %s", token.getRefreshToken()));
                LOG.info(String.format("New access token: %s", token.getAccessToken()));
                LOG.info(String.format("New access token expiration date: %s", token.getAccessTokenExpiration()));
            }
        };
        client = BynderClient.Builder.create(new Configuration.Builder(new URL(appProperties.getProperty("BASE_URL"))).setOAuthSettings(new OAuthSettings(appProperties.getProperty("CLIENT_ID"), appProperties.getProperty("CLIENT_SECRET"), new URI(appProperties.getProperty("REDIRECT_URI")), callback)).build());
        OAuthService oauthService = client.getOAuthService();
        List<String> scopes = Arrays.asList("offline", "asset:read");
        URL authorizationUrl = oauthService.getAuthorizationUrl("state example", scopes);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(authorizationUrl.toURI());
        System.out.println("Insert the code: ");
        Scanner scanner = new Scanner(System.in);
        String code = scanner.nextLine();
        scanner.close();
        oauthService.getAccessToken(code, scopes).blockingSingle();
        List derivatives = (List)((Response)client.getDerivatives().blockingSingle()).body();
        for (Derivative derivative : derivatives) {
            LOG.info(derivative.getPrefix());
        }
        assetService = client.getAssetService();
        List brands = (List)((Response)assetService.getBrands().blockingSingle()).body();
        for (Brand brand : brands) {
            LOG.info(brand.getName());
        }
        mediaList = (List)((Response)assetService.getMediaList(new MediaQuery().setType(MediaType.IMAGE).setOrderBy(OrderBy.NAME_DESC).setLimit(10).setPage(1)).blockingSingle()).body();
        for (Media media : mediaList) {
            LOG.info(media.getName());
        }
    }
}

