/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.oauth;

import com.bynder.sdk.api.OAuthApi;
import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.model.oauth.GrantType;
import com.bynder.sdk.model.oauth.ResponseType;
import com.bynder.sdk.model.oauth.Token;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.oauth.TokenQuery;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.Utils;
import io.reactivex.Observable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class OAuthServiceImpl
implements OAuthService {
    private final OAuthApi oauthClient;
    private final QueryDecoder queryDecoder;
    private Configuration configuration;

    OAuthServiceImpl(Configuration configuration, OAuthApi oauthClient, QueryDecoder queryDecoder) {
        this.configuration = configuration;
        this.oauthClient = oauthClient;
        this.queryDecoder = queryDecoder;
    }

    @Override
    public URL getAuthorizationUrl(String state, List<String> scopes) throws MalformedURLException, UnsupportedEncodingException, IllegalArgumentException {
        if (state == null || state.isEmpty()) {
            throw new IllegalArgumentException(state);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.configuration.getBaseUrl());
        stringBuilder.append("/v6/authentication/oauth2/auth");
        stringBuilder.append("?client_id=").append(Utils.encodeParameterValue(this.configuration.getOAuthSettings().getClientId()));
        stringBuilder.append("&redirect_uri=").append(Utils.encodeParameterValue(this.configuration.getOAuthSettings().getRedirectUri().toString()));
        stringBuilder.append("&response_type=").append(Utils.encodeParameterValue(ResponseType.CODE.toString()));
        stringBuilder.append("&scope=").append(Utils.encodeParameterValue(String.join((CharSequence)" ", scopes)));
        stringBuilder.append("&state=").append(Utils.encodeParameterValue(state));
        return new URL(stringBuilder.toString());
    }

    @Override
    public Observable<Token> getAccessToken(String code, List<String> scopes) {
        TokenQuery tokenQuery = new TokenQuery(this.configuration.getOAuthSettings().getClientId(), this.configuration.getOAuthSettings().getClientSecret(), this.configuration.getOAuthSettings().getRedirectUri(), GrantType.AUTHORIZATION_CODE, String.join((CharSequence)" ", scopes), code);
        Map<String, String> params = this.queryDecoder.decode(tokenQuery);
        Observable<Response<Token>> accessTokenObservable = this.oauthClient.getAccessToken(params);
        return accessTokenObservable.map(response -> {
            Token token = (Token)response.body();
            token.setAccessTokenExpiration();
            this.configuration.getOAuthSettings().setToken(token);
            return token;
        });
    }

    @Override
    public Observable<Token> refreshAccessToken() {
        TokenQuery tokenQuery = new TokenQuery(this.configuration.getOAuthSettings().getClientId(), this.configuration.getOAuthSettings().getClientSecret(), GrantType.REFRESH_TOKEN, this.configuration.getOAuthSettings().getToken().getRefreshToken());
        Map<String, String> params = this.queryDecoder.decode(tokenQuery);
        Observable<Response<Token>> refreshTokenObservable = this.oauthClient.getAccessToken(params);
        return refreshTokenObservable.map(response -> {
            Token token = (Token)response.body();
            token.setAccessTokenExpiration();
            this.configuration.getOAuthSettings().refreshToken(token);
            return token;
        });
    }
}

