/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service;

import com.bynder.sdk.api.ApiFactory;
import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.api.OAuthApi;
import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.collection.CollectionService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.service.workflow.WorkflowService;
import io.reactivex.Observable;
import java.util.List;
import retrofit2.Response;

public class BynderClientImpl
implements BynderClient {
    private final QueryDecoder queryDecoder;
    private final OAuthApi oauthClient;
    private final BynderApi bynderApi;
    private Configuration configuration;
    private OAuthService oauthService;
    private AssetService assetService;
    private CollectionService collectionService;
    private WorkflowService workflowService;

    BynderClientImpl(Configuration configuration, QueryDecoder decoder) {
        this.configuration = configuration;
        this.queryDecoder = decoder;
        this.oauthClient = ApiFactory.createOAuthClient(configuration.getBaseUrl().toString());
        this.bynderApi = ApiFactory.createBynderClient(configuration);
    }

    @Override
    public OAuthService getOAuthService() {
        if (this.oauthService == null) {
            this.oauthService = OAuthService.Builder.create(this.configuration, this.oauthClient, this.queryDecoder);
        }
        return this.oauthService;
    }

    @Override
    public AssetService getAssetService() {
        if (this.assetService == null) {
            this.assetService = AssetService.Builder.create(this.bynderApi, this.queryDecoder);
        }
        return this.assetService;
    }

    @Override
    public CollectionService getCollectionService() {
        if (this.collectionService == null) {
            this.collectionService = CollectionService.Builder.create(this.bynderApi, this.queryDecoder);
        }
        return this.collectionService;
    }

    @Override
    public Observable<Response<List<Derivative>>> getDerivatives() {
        return this.bynderApi.getDerivatives();
    }

    @Override
    public WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = WorkflowService.Builder.create(this.bynderApi, this.queryDecoder);
        }
        return this.workflowService;
    }
}

