/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.bynder.sdk.exception.HttpResponseException;
import com.bynder.sdk.util.Indexed;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import retrofit2.Response;

public class RXUtils {
    public static <T> Observable<Indexed<T>> mapWithIndex(Observable<T> observable, int startFrom) {
        return observable.zipWith((ObservableSource)Observable.range((int)startFrom, (int)(Integer.MAX_VALUE - startFrom)), Indexed::new);
    }

    public static <T> Observable<Indexed<T>> mapWithIndex(Observable<T> observable) {
        return RXUtils.mapWithIndex(observable, 0);
    }

    public static <T> Response<T> ensureSuccessResponse(Response<T> response) throws HttpResponseException {
        if (!response.isSuccessful()) {
            throw new HttpResponseException(response);
        }
        return response;
    }

    public static <T> T getResponseBody(Response<T> response) throws HttpResponseException {
        return (T)RXUtils.ensureSuccessResponse(response).body();
    }

    public static Observable<byte[]> readFileChunks(String path, int maxChunkSize) {
        return Observable.using(() -> new BufferedInputStream(new FileInputStream(path), maxChunkSize), is -> Observable.generate(emitter -> {
            byte[] buffer = new byte[maxChunkSize];
            int chunkSize = is.read(buffer);
            if (chunkSize == -1) {
                is.close();
                emitter.onComplete();
            } else if (chunkSize < maxChunkSize) {
                emitter.onNext((Object)Arrays.copyOf(buffer, chunkSize));
            } else {
                emitter.onNext((Object)buffer);
            }
        }), BufferedInputStream::close);
    }

    public static Single<byte[]> readFile(String path) {
        return RXUtils.readFileChunks(path, (int)new File(path).length()).singleOrError();
    }
}

