/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.api;

import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.Collection;
import com.bynder.sdk.model.DeletedMedia;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.Smartfilter;
import com.bynder.sdk.model.Tag;
import com.bynder.sdk.model.Usage;
import com.bynder.sdk.model.upload.FinaliseResponse;
import com.bynder.sdk.model.upload.PollStatus;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.model.upload.UploadAdditionalMediaResponse;
import com.bynder.sdk.model.upload.UploadRequest;
import com.bynder.sdk.model.workflow.Campaign;
import com.bynder.sdk.model.workflow.CampaignId;
import com.bynder.sdk.model.workflow.Job;
import com.bynder.sdk.model.workflow.JobActionResponse;
import com.bynder.sdk.model.workflow.JobMedia;
import com.bynder.sdk.model.workflow.JobPresetContainer;
import com.bynder.sdk.model.workflow.WorkflowGroup;
import com.bynder.sdk.model.workflow.WorkflowMetaproperty;
import com.bynder.sdk.model.workflow.WorkflowUser;
import com.bynder.sdk.query.workflow.CampaignDataQuery;
import com.bynder.sdk.query.workflow.JobCreateQuery;
import com.bynder.sdk.query.workflow.JobModifyQuery;
import com.bynder.sdk.query.workflow.WorkflowGroupDataQuery;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface BynderApi {
    @GET(value="/api/v4/account/derivatives/")
    public Observable<Response<List<Derivative>>> getDerivatives();

    @GET(value="/api/v4/brands/")
    public Observable<Response<List<Brand>>> getBrands();

    @GET(value="/api/v4/tags/")
    public Observable<Response<List<Tag>>> getTags();

    @GET(value="/api/v4/metaproperties/")
    public Observable<Response<Map<String, Metaproperty>>> getMetaproperties(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/")
    public Observable<Response<List<Media>>> getMediaList(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/")
    public Observable<Response<Media>> getMediaInfo(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/media/")
    public Observable<Response<Void>> modifyMedia(@FieldMap Map<String, String> var1);

    @DELETE(value="/api/v4/media/")
    public Observable<Response<Void>> deleteMedia(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/media/{id}/download/")
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(@Path(value="id") String var1);

    @GET(value="/api/v4/media/{id}/download/{itemId}/")
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(@Path(value="id") String var1, @Path(value="itemId") String var2);

    @FormUrlEncoded
    @POST(value="/api/media/usage/")
    public Observable<Response<Usage>> createUsage(@FieldMap Map<String, String> var1);

    @GET(value="/api/media/usage/")
    public Observable<Response<List<Usage>>> getUsage(@QueryMap Map<String, String> var1);

    @DELETE(value="/api/media/usage/")
    public Observable<Response<Void>> deleteUsage(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/smartfilters/")
    public Observable<Response<List<Smartfilter>>> getSmartfilters();

    @GET(value="/api/v4/collections/")
    public Observable<Response<List<Collection>>> getCollections(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/collections/")
    public Observable<Response<Collection>> getCollectionInfo(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/")
    public Observable<Response<Void>> createCollection(@FieldMap Map<String, String> var1);

    @DELETE(value="/api/v4/collections/")
    public Observable<Response<Void>> deleteCollection(@QueryMap Map<String, String> var1);

    @GET(value="/api/v4/collections/{id}/media/")
    public Observable<Response<List<String>>> getCollectionMediaIds(@Path(value="id") String var1);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/{id}/media/")
    public Observable<Response<Void>> addMediaToCollection(@Path(value="id") String var1, @FieldMap Map<String, String> var2);

    @DELETE(value="/api/v4/collections/{id}/media/")
    public Observable<Response<Void>> removeMediaFromCollection(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

    @FormUrlEncoded
    @POST(value="/api/v4/collections/{id}/share/")
    public Observable<Response<Void>> shareCollection(@Path(value="id") String var1, @FieldMap Map<String, String> var2);

    @FormUrlEncoded
    @POST(value="/api/upload/init/")
    public Observable<Response<UploadRequest>> getUploadInformation(@FieldMap Map<String, String> var1);

    @GET(value="/api/upload/endpoint/")
    public Observable<Response<String>> getClosestS3Endpoint();

    @FormUrlEncoded
    @POST(value="/api/v4/upload/")
    public Observable<Response<Void>> registerChunk(@FieldMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/upload/")
    public Observable<Response<FinaliseResponse>> finaliseUpload(@FieldMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/media/{id}/save/additional/")
    public Observable<Response<UploadAdditionalMediaResponse>> finaliseUploadAdditional(@Path(value="id") String var1, @FieldMap Map<String, String> var2);

    @GET(value="/api/v4/upload/poll/")
    public Observable<Response<PollStatus>> getPollStatus(@QueryMap Map<String, String> var1);

    @FormUrlEncoded
    @POST(value="/api/v4/media/save/")
    public Observable<Response<SaveMediaResponse>> saveMedia(@FieldMap Map<String, String> var1);

    @GET(value="/api/workflow/campaigns/")
    public Observable<Response<List<Campaign>>> getAllCampaigns();

    @GET(value="/api/workflow/campaigns/{id}/")
    public Observable<Response<Campaign>> getCampaign(@Path(value="id") String var1);

    @POST(value="/api/workflow/campaigns/")
    public Observable<Response<CampaignId>> createCampaign(@Body CampaignDataQuery var1);

    @PUT(value="/api/workflow/campaigns/{id}/")
    public Observable<Response<CampaignId>> modifyCampaign(@Path(value="id") String var1, @Body CampaignDataQuery var2);

    @DELETE(value="/api/workflow/campaigns/{id}/")
    public Observable<Response<Void>> deleteCampaign(@Path(value="id") String var1);

    @GET(value="/api/workflow/presets/job/{id}/")
    public Observable<Response<JobPresetContainer>> getJobPreset(@Path(value="id") String var1);

    @GET(value="/api/workflow/jobs/")
    public Observable<Response<List<Job>>> getJobs(@QueryMap Map<String, String> var1);

    @GET(value="/api/workflow/campaigns/{id}/jobs/")
    public Observable<Response<List<Job>>> getCampaignJobs(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/api/workflow/jobs/{id}/")
    public Observable<Response<Job>> getJob(@Path(value="id") String var1);

    @GET(value="/api/workflow/jobs/{id}/media/")
    public Observable<Response<List<JobMedia>>> getJobMedia(@Path(value="id") String var1);

    @POST(value="/api/workflow/jobs/")
    public Observable<Response<JobActionResponse>> createJob(@Body JobCreateQuery var1);

    @PUT(value="/api/workflow/jobs/{id}/")
    public Observable<Response<JobActionResponse>> modifyJob(@Path(value="id") String var1, @Body JobModifyQuery var2);

    @DELETE(value="/api/workflow/jobs/{id}/")
    public Observable<Response<Void>> deleteJob(@Path(value="id") String var1);

    @GET(value="api/workflow/metaproperties/")
    public Observable<Response<List<WorkflowMetaproperty>>> getAllWorkflowMetaproperties();

    @GET(value="api/workflow/metaproperties/{id}/")
    public Observable<Response<WorkflowMetaproperty>> getWorkflowMetaproperty(@Path(value="id") String var1);

    @GET(value="api/workflow/users/")
    public Observable<Response<List<WorkflowUser>>> getAllWorkflowUsers();

    @GET(value="api/workflow/groups/")
    public Observable<Response<List<WorkflowGroup>>> getAllWorkflowGroups();

    @GET(value="api/workflow/groups/{id}/")
    public Observable<Response<WorkflowGroup>> getWorkflowGroup(@Path(value="id") String var1);

    @POST(value="api/workflow/groups/")
    public Observable<Response<WorkflowGroup>> createWorkflowGroup(@Body WorkflowGroupDataQuery var1);

    @PUT(value="api/workflow/groups/{id}/")
    public Observable<Response<WorkflowGroup>> updateWorkflowGroup(@Path(value="id") String var1, @Body WorkflowGroupDataQuery var2);

    @DELETE(value="api/workflow/groups/{id}/")
    public Observable<Response<Void>> deleteWorkflowGroup(@Path(value="id") String var1);

    @GET(value="api/trash/media/")
    public Observable<Response<List<DeletedMedia>>> getRecentlyRemovedMediaList(@QueryMap Map<String, String> var1);
}

