/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.sample;

import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.configuration.OAuthSettings;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.MediaType;
import com.bynder.sdk.query.MediaDeleteQuery;
import com.bynder.sdk.query.MediaDownloadQuery;
import com.bynder.sdk.query.MediaInfoQuery;
import com.bynder.sdk.query.MediaModifyQuery;
import com.bynder.sdk.query.MediaQuery;
import com.bynder.sdk.query.OrderBy;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.Utils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class MediaSample {
    private static final Logger LOG = LoggerFactory.getLogger(MediaSample.class);

    public static void main(String[] args) throws URISyntaxException, IOException {
        MediaDownloadQuery mediaDownloadQuery;
        DownloadUrl mediaDownloadUrl;
        String mediaIdInfo;
        MediaInfoQuery mediaInfoQuery;
        Media foundMedia;
        MediaQuery mediaQuery;
        List mediaList;
        Properties appProperties = Utils.loadConfig("app");
        OAuthSettings oAuthSettings = new OAuthSettings(appProperties.getProperty("CLIENT_ID"), appProperties.getProperty("CLIENT_SECRET"), new URI(appProperties.getProperty("REDIRECT_URI")));
        BynderClient client = BynderClient.Builder.create(new Configuration.Builder(new URL(appProperties.getProperty("BASE_URL"))).setOAuthSettings(oAuthSettings).setHttpConnectionSettings(new HttpConnectionSettings()).build());
        List<String> scopes = Arrays.asList("offline", "asset:read", "asset:write", "asset.usage:read", "asset.usage:write", "collection:read", "collection:write", "meta.assetbank:read", "meta.assetbank:write", "meta.workflow:read");
        OAuthService oauthService = client.getOAuthService();
        URL authorizationUrl = oauthService.getAuthorizationUrl("state example", scopes);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(authorizationUrl.toURI());
        System.out.println("Insert the code: ");
        Scanner scanner = new Scanner(System.in);
        String code = scanner.nextLine();
        scanner.close();
        oauthService.getAccessToken(code, scopes).blockingSingle();
        AssetService assetService = client.getAssetService();
        List derivatives = (List)((Response)client.getDerivatives().blockingSingle()).body();
        if (derivatives != null && !derivatives.isEmpty()) {
            for (Derivative derivative : derivatives) {
                LOG.info("Derivative Prefix: " + derivative.getPrefix());
            }
        }
        if ((mediaList = (List)((Response)assetService.getMediaList(mediaQuery = new MediaQuery().setType(MediaType.IMAGE).setOrderBy(OrderBy.NAME_DESC).setLimit(10).setPage(1)).blockingSingle()).body()) != null && !mediaList.isEmpty()) {
            for (Media media : mediaList) {
                LOG.info("Media ID: " + media.getId());
                LOG.info("Media Name: " + media.getName());
            }
        }
        if ((foundMedia = (Media)((Response)assetService.getMediaInfo(mediaInfoQuery = new MediaInfoQuery(mediaIdInfo = appProperties.getProperty("MEDIA_ID_FOR_INFO"))).blockingSingle()).body()) != null) {
            LOG.info("get media info result: ");
            LOG.info("Media ID: " + foundMedia.getId());
            LOG.info("Media Name: " + foundMedia.getName());
            LOG.info("Media Brand ID: " + foundMedia.getBrandId());
        }
        if ((mediaDownloadUrl = (DownloadUrl)((Response)assetService.getMediaDownloadUrl(mediaDownloadQuery = new MediaDownloadQuery(mediaIdInfo)).blockingSingle()).body()) != null) {
            LOG.info("Media S3 File: " + mediaDownloadUrl.getS3File().getFile());
            LOG.info("Media S3 URI: " + mediaDownloadUrl.getS3File().toURI());
        }
        String mediaIdForRename = appProperties.getProperty("MEDIA_ID_FOR_RENAME");
        MediaModifyQuery modifyQuery = new MediaModifyQuery(mediaIdForRename).setName("New Name Updated").setDescription("Test Updated Description");
        assetService.modifyMedia(modifyQuery).blockingSingle();
        MediaInfoQuery mediaInfoQueryRename = new MediaInfoQuery(mediaIdForRename);
        Media updatedFoundMedia = (Media)((Response)assetService.getMediaInfo(mediaInfoQueryRename).blockingSingle()).body();
        if (updatedFoundMedia != null) {
            LOG.info("get updated media info result: ");
            LOG.info(updatedFoundMedia.getId());
            LOG.info(updatedFoundMedia.getName());
            LOG.info(updatedFoundMedia.getDescription());
        }
        String mediaToRemove = appProperties.getProperty("MEDIA_ID_FOR_REMOVAL");
        MediaDeleteQuery mediaDeleteQuery = new MediaDeleteQuery(mediaToRemove);
        LOG.info("Removing media id: " + mediaToRemove);
        assetService.deleteMedia(mediaDeleteQuery).blockingSingle();
        System.exit(0);
    }
}

