/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service;

import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.model.Derivative;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.service.BynderClientImpl;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.collection.CollectionService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.service.workflow.WorkflowService;
import io.reactivex.Observable;
import java.util.List;
import retrofit2.Response;

public interface BynderClient {
    public OAuthService getOAuthService();

    public AssetService getAssetService();

    public CollectionService getCollectionService();

    public Observable<Response<List<Derivative>>> getDerivatives();

    public WorkflowService getWorkflowService();

    public static class Builder {
        private Builder() {
        }

        public static BynderClient create(Configuration configuration) {
            return new BynderClientImpl(configuration, new QueryDecoder());
        }
    }
}

