/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.upload;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.exception.BynderUploadException;
import com.bynder.sdk.model.upload.FinaliseResponse;
import com.bynder.sdk.model.upload.PollStatus;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.model.upload.UploadAdditionalMediaResponse;
import com.bynder.sdk.model.upload.UploadProgress;
import com.bynder.sdk.model.upload.UploadRequest;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.upload.FinaliseUploadAdditionalQuery;
import com.bynder.sdk.query.upload.FinaliseUploadQuery;
import com.bynder.sdk.query.upload.PollStatusQuery;
import com.bynder.sdk.query.upload.RegisterChunkQuery;
import com.bynder.sdk.query.upload.RequestUploadQuery;
import com.bynder.sdk.query.upload.SaveMediaQuery;
import com.bynder.sdk.query.upload.UploadQuery;
import com.bynder.sdk.service.amazons3.AmazonS3Service;
import com.bynder.sdk.util.Indexed;
import com.bynder.sdk.util.RXUtils;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FileUploader {
    private static final int MAX_CHUNK_SIZE = 0x500000;
    private static final int MAX_POLLING_ITERATIONS = 60;
    private static final int POLLING_IDLE_TIME = 2000;
    private final BynderApi bynderApi;
    private final QueryDecoder queryDecoder;

    public FileUploader(BynderApi bynderApi, QueryDecoder queryDecoder) {
        this.bynderApi = bynderApi;
        this.queryDecoder = queryDecoder;
    }

    public Single<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return this.getClosestS3Endpoint().flatMap(awsBucket -> {
            String filename = uploadQuery.getFilename();
            AmazonS3Service amazonS3Service = AmazonS3Service.Builder.create(awsBucket);
            return this.getUploadInformation(new RequestUploadQuery(filename)).flatMap(uploadRequest -> this.uploadChunk(amazonS3Service, (UploadRequest)uploadRequest, uploadQuery, filename).count().flatMap(chunkCount -> this.finaliseUpload(new FinaliseUploadQuery(uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), uploadRequest.getS3Filename(), (Long)chunkCount))));
        }).flatMap(importId -> this.pollProcessing((String)importId).andThen(this.saveUploadedMedia((String)importId, uploadQuery)));
    }

    public Single<UploadAdditionalMediaResponse> uploadAdditionalFile(UploadQuery uploadQuery) {
        return this.getClosestS3Endpoint().flatMap(awsBucket -> {
            String filename = uploadQuery.getFilename();
            AmazonS3Service amazonS3Service = AmazonS3Service.Builder.create(awsBucket);
            return this.getUploadInformation(new RequestUploadQuery(filename)).flatMap(uploadRequest -> this.uploadChunk(amazonS3Service, (UploadRequest)uploadRequest, uploadQuery, filename).count().flatMap(chunkCount -> this.finaliseUploadAdditional(new FinaliseUploadAdditionalQuery(uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), uploadRequest.getS3Filename(), (Long)chunkCount), uploadQuery.getMediaId())));
        });
    }

    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery uploadQuery) {
        String filename = uploadQuery.getFilename();
        return this.getClosestS3Endpoint().flatMapObservable(awsBucket -> {
            AmazonS3Service amazonS3Service = AmazonS3Service.Builder.create(awsBucket);
            return this.getUploadInformation(new RequestUploadQuery(filename)).flatMapObservable(uploadRequest -> this.uploadChunk(amazonS3Service, (UploadRequest)uploadRequest, uploadQuery, filename));
        });
    }

    private Observable<UploadProgress> uploadChunk(AmazonS3Service amazonS3Service, UploadRequest uploadRequest, UploadQuery uploadQuery, String filename) throws IOException {
        long fileSize = Files.size(Paths.get(uploadQuery.getFilepath(), new String[0]));
        UploadProgress uploadProgress = new UploadProgress(fileSize);
        return RXUtils.mapWithIndex(RXUtils.readFileChunks(uploadQuery.getFilepath(), 0x500000), 1).flatMapSingle(chunk -> amazonS3Service.uploadPartToAmazon((Indexed<byte[]>)chunk, filename, (int)((fileSize - 1L) / 0x500000L + 1L), uploadRequest.getMultipartParams()).andThen((CompletableSource)this.registerChunk(new RegisterChunkQuery(chunk.getIndex(), uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), String.format("%s/p%s", uploadRequest.getS3Filename(), chunk.getIndex())))).toSingle(() -> uploadProgress.addProgress(((byte[])chunk.getValue()).length)));
    }

    private Completable pollProcessing(String importId) {
        return this.getPollStatus(new PollStatusQuery(importId.split(","))).delay(2000L, TimeUnit.MILLISECONDS).repeat().take(60L).takeUntil(pollStatus -> pollStatus.processingDone(importId) || pollStatus.processingFailed(importId)).lastElement().toSingle().flatMapCompletable(pollStatus -> {
            if (pollStatus.processingFailed(importId)) {
                return Completable.error((Throwable)new BynderUploadException("Processing media failed."));
            }
            return Completable.complete();
        });
    }

    private Single<SaveMediaResponse> saveUploadedMedia(String importId, UploadQuery uploadQuery) {
        SaveMediaQuery saveMediaQuery = new SaveMediaQuery(importId).setAudit(uploadQuery.isAudit()).setMetaproperties(uploadQuery.getMetaproperties());
        if (uploadQuery.getMediaId() == null) {
            return this.saveMedia(saveMediaQuery.setBrandId(uploadQuery.getBrandId()).setName(uploadQuery.getAssetName()).setTags(uploadQuery.getTags()));
        }
        return this.saveMedia(saveMediaQuery.setMediaId(uploadQuery.getMediaId()));
    }

    private Single<String> getClosestS3Endpoint() {
        return this.bynderApi.getClosestS3Endpoint().singleOrError().map(RXUtils::getResponseBody);
    }

    private Single<UploadRequest> getUploadInformation(RequestUploadQuery requestUploadQuery) {
        Map<String, String> params = this.queryDecoder.decode(requestUploadQuery);
        return this.bynderApi.getUploadInformation(params).singleOrError().map(RXUtils::getResponseBody);
    }

    private Completable registerChunk(RegisterChunkQuery registerChunkQuery) {
        Map<String, String> params = this.queryDecoder.decode(registerChunkQuery);
        return this.bynderApi.registerChunk(params).ignoreElements();
    }

    private Single<String> finaliseUpload(FinaliseUploadQuery finaliseUploadQuery) {
        Map<String, String> params = this.queryDecoder.decode(finaliseUploadQuery);
        return this.bynderApi.finaliseUpload(params).singleOrError().map(RXUtils::getResponseBody).map(FinaliseResponse::getImportId);
    }

    private Single<UploadAdditionalMediaResponse> finaliseUploadAdditional(FinaliseUploadAdditionalQuery finaliseUploadQuery, String mediaId) {
        Map<String, String> params = this.queryDecoder.decode(finaliseUploadQuery);
        return this.bynderApi.finaliseUploadAdditional(mediaId, params).singleOrError().map(RXUtils::getResponseBody);
    }

    private Single<PollStatus> getPollStatus(PollStatusQuery pollStatusQuery) {
        Map<String, String> params = this.queryDecoder.decode(pollStatusQuery);
        return this.bynderApi.getPollStatus(params).singleOrError().map(RXUtils::getResponseBody);
    }

    private Single<SaveMediaResponse> saveMedia(SaveMediaQuery saveMediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(saveMediaQuery);
        return this.bynderApi.saveMedia(params).singleOrError().map(RXUtils::getResponseBody);
    }
}

