/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.sample;

import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.configuration.OAuthSettings;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.MetapropertyOption;
import com.bynder.sdk.query.MetapropertyQuery;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.Utils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class MetapropertiesSample {
    private static final Logger LOG = LoggerFactory.getLogger(MetapropertiesSample.class);

    public static void main(String[] args) throws URISyntaxException, IOException {
        Properties appProperties = Utils.loadConfig("app");
        OAuthSettings oAuthSettings = new OAuthSettings(appProperties.getProperty("CLIENT_ID"), appProperties.getProperty("CLIENT_SECRET"), new URI(appProperties.getProperty("REDIRECT_URI")));
        BynderClient client = BynderClient.Builder.create(new Configuration.Builder(new URL(appProperties.getProperty("BASE_URL"))).setOAuthSettings(oAuthSettings).setHttpConnectionSettings(new HttpConnectionSettings()).build());
        List<String> scopes = Arrays.asList("offline", "asset:read", "asset:write", "asset.usage:read", "asset.usage:write", "collection:read", "collection:write", "meta.assetbank:read", "meta.assetbank:write", "meta.workflow:read");
        OAuthService oauthService = client.getOAuthService();
        URL authorizationUrl = oauthService.getAuthorizationUrl("state example", scopes);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(authorizationUrl.toURI());
        System.out.println("Insert the code: ");
        Scanner scanner = new Scanner(System.in);
        String code = scanner.nextLine();
        scanner.close();
        oauthService.getAccessToken(code, scopes).blockingSingle();
        AssetService assetService = client.getAssetService();
        MetapropertyQuery metapropertyQuery = new MetapropertyQuery();
        Map metapropertiesMap = (Map)((Response)assetService.getMetaproperties(metapropertyQuery).blockingSingle()).body();
        if (metapropertiesMap != null) {
            for (Map.Entry metapropertyEntry : metapropertiesMap.entrySet()) {
                LOG.info("current metaproperty");
                LOG.info("Key: " + (String)metapropertyEntry.getKey());
                Metaproperty currentMetaproperty = (Metaproperty)metapropertyEntry.getValue();
                LOG.info("ID: " + currentMetaproperty.getId());
                LOG.info("Name: " + currentMetaproperty.getName());
                LOG.info("Label: " + currentMetaproperty.getLabel());
                LOG.info("Type: " + currentMetaproperty.getType());
                List<MetapropertyOption> metapropertyOptionList = currentMetaproperty.getOptions();
                if (metapropertyOptionList == null || metapropertyOptionList.isEmpty()) continue;
                for (MetapropertyOption metapropertyOption : metapropertyOptionList) {
                    LOG.info("Metaproperty Option ID: " + metapropertyOption.getId());
                    LOG.info("Metaproperty Option Label: " + metapropertyOption.getLabel());
                    LOG.info("Metaproperty Name: " + metapropertyOption.getName());
                }
            }
        }
        System.exit(0);
    }
}

