/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.asset;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.DeletedMedia;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.Smartfilter;
import com.bynder.sdk.model.Tag;
import com.bynder.sdk.model.Usage;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.model.upload.UploadAdditionalMediaResponse;
import com.bynder.sdk.model.upload.UploadProgress;
import com.bynder.sdk.query.DeletedMediaQuery;
import com.bynder.sdk.query.MediaDeleteQuery;
import com.bynder.sdk.query.MediaDownloadQuery;
import com.bynder.sdk.query.MediaInfoQuery;
import com.bynder.sdk.query.MediaModifyQuery;
import com.bynder.sdk.query.MediaQuery;
import com.bynder.sdk.query.MetapropertyQuery;
import com.bynder.sdk.query.UsageCreateQuery;
import com.bynder.sdk.query.UsageDeleteQuery;
import com.bynder.sdk.query.UsageQuery;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.upload.UploadQuery;
import com.bynder.sdk.service.asset.AssetServiceImpl;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public interface AssetService {
    public Observable<Response<List<Brand>>> getBrands();

    public Observable<Response<List<Tag>>> getTags();

    public Observable<Response<Map<String, Metaproperty>>> getMetaproperties(MetapropertyQuery var1);

    public Observable<Response<List<Media>>> getMediaList(MediaQuery var1);

    public Observable<Response<Media>> getMediaInfo(MediaInfoQuery var1);

    public Observable<Response<Void>> modifyMedia(MediaModifyQuery var1);

    public Observable<Response<Void>> deleteMedia(MediaDeleteQuery var1);

    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(MediaDownloadQuery var1);

    public Observable<Response<Usage>> createUsage(UsageCreateQuery var1);

    public Observable<Response<List<Usage>>> getUsage(UsageQuery var1);

    public Observable<Response<Void>> deleteUsage(UsageDeleteQuery var1);

    public Observable<Response<List<Smartfilter>>> getSmartfilters();

    public Observable<SaveMediaResponse> uploadFile(UploadQuery var1);

    public Observable<UploadAdditionalMediaResponse> uploadAdditionalFile(UploadQuery var1);

    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery var1);

    public Observable<Response<List<DeletedMedia>>> getRecentlyRemovedMediaList(DeletedMediaQuery var1);

    public static class Builder {
        private Builder() {
        }

        public static AssetService create(BynderApi bynderApi, QueryDecoder queryDecoder) {
            return new AssetServiceImpl(bynderApi, queryDecoder);
        }
    }
}

