/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.asset;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Brand;
import com.bynder.sdk.model.DeletedMedia;
import com.bynder.sdk.model.DownloadUrl;
import com.bynder.sdk.model.Media;
import com.bynder.sdk.model.Metaproperty;
import com.bynder.sdk.model.Smartfilter;
import com.bynder.sdk.model.Tag;
import com.bynder.sdk.model.Usage;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.model.upload.UploadAdditionalMediaResponse;
import com.bynder.sdk.model.upload.UploadProgress;
import com.bynder.sdk.query.DeletedMediaQuery;
import com.bynder.sdk.query.MediaDeleteQuery;
import com.bynder.sdk.query.MediaDownloadQuery;
import com.bynder.sdk.query.MediaInfoQuery;
import com.bynder.sdk.query.MediaModifyQuery;
import com.bynder.sdk.query.MediaQuery;
import com.bynder.sdk.query.MetapropertyQuery;
import com.bynder.sdk.query.UsageCreateQuery;
import com.bynder.sdk.query.UsageDeleteQuery;
import com.bynder.sdk.query.UsageQuery;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.upload.UploadQuery;
import com.bynder.sdk.service.asset.AssetService;
import com.bynder.sdk.service.upload.FileUploader;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class AssetServiceImpl
implements AssetService {
    private final BynderApi bynderApi;
    private final QueryDecoder queryDecoder;
    private final FileUploader fileUploader;

    public AssetServiceImpl(BynderApi bynderApi, QueryDecoder queryDecoder) {
        this.bynderApi = bynderApi;
        this.queryDecoder = queryDecoder;
        this.fileUploader = new FileUploader(bynderApi, queryDecoder);
    }

    @Override
    public Observable<Response<List<Brand>>> getBrands() {
        return this.bynderApi.getBrands();
    }

    @Override
    public Observable<Response<List<Tag>>> getTags() {
        return this.bynderApi.getTags();
    }

    @Override
    public Observable<Response<Map<String, Metaproperty>>> getMetaproperties(MetapropertyQuery metapropertyQuery) {
        Map<String, String> params = this.queryDecoder.decode(metapropertyQuery);
        return this.bynderApi.getMetaproperties(params);
    }

    @Override
    public Observable<Response<List<Media>>> getMediaList(MediaQuery mediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(mediaQuery);
        return this.bynderApi.getMediaList(params);
    }

    @Override
    public Observable<Response<Media>> getMediaInfo(MediaInfoQuery mediaInfoQuery) {
        Map<String, String> params = this.queryDecoder.decode(mediaInfoQuery);
        return this.bynderApi.getMediaInfo(params);
    }

    @Override
    public Observable<Response<Void>> modifyMedia(MediaModifyQuery mediaModifyQuery) {
        Map<String, String> params = this.queryDecoder.decode(mediaModifyQuery);
        return this.bynderApi.modifyMedia(params);
    }

    @Override
    public Observable<Response<Void>> deleteMedia(MediaDeleteQuery mediaDeleteQuery) {
        Map<String, String> params = this.queryDecoder.decode(mediaDeleteQuery);
        return this.bynderApi.deleteMedia(params);
    }

    @Override
    public Observable<Response<DownloadUrl>> getMediaDownloadUrl(MediaDownloadQuery mediaDownloadQuery) {
        if (mediaDownloadQuery.getMediaItemId() == null) {
            return this.bynderApi.getMediaDownloadUrl(mediaDownloadQuery.getMediaId());
        }
        return this.bynderApi.getMediaDownloadUrl(mediaDownloadQuery.getMediaId(), mediaDownloadQuery.getMediaItemId());
    }

    @Override
    public Observable<Response<Usage>> createUsage(UsageCreateQuery usageCreateQuery) {
        Map<String, String> params = this.queryDecoder.decode(usageCreateQuery);
        return this.bynderApi.createUsage(params);
    }

    @Override
    public Observable<Response<List<Usage>>> getUsage(UsageQuery usageQuery) {
        Map<String, String> params = this.queryDecoder.decode(usageQuery);
        return this.bynderApi.getUsage(params);
    }

    @Override
    public Observable<Response<Void>> deleteUsage(UsageDeleteQuery usageDeleteQuery) {
        Map<String, String> params = this.queryDecoder.decode(usageDeleteQuery);
        return this.bynderApi.deleteUsage(params);
    }

    @Override
    public Observable<Response<List<Smartfilter>>> getSmartfilters() {
        return this.bynderApi.getSmartfilters();
    }

    @Override
    public Observable<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return this.fileUploader.uploadFile(uploadQuery).toObservable();
    }

    @Override
    public Observable<UploadAdditionalMediaResponse> uploadAdditionalFile(UploadQuery uploadQuery) {
        return this.fileUploader.uploadAdditionalFile(uploadQuery).toObservable();
    }

    @Override
    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery uploadQuery) {
        return this.fileUploader.uploadFileWithProgress(uploadQuery);
    }

    @Override
    public Observable<Response<List<DeletedMedia>>> getRecentlyRemovedMediaList(DeletedMediaQuery deletedMediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(deletedMediaQuery);
        return this.bynderApi.getRecentlyRemovedMediaList(params);
    }
}

