/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import com.bynder.sdk.model.Media;
import com.bynder.sdk.util.BooleanTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MediaTypeAdapter
implements JsonDeserializer<Media> {
    private static final String PROPERTY_PREFIX = "property_";
    private static final String CUSTOM_METAPROPERTY_FIELDNAME = "customMetaproperties";
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Boolean.class, (Object)new BooleanTypeAdapter()).create();

    public Media deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Media media = (Media)this.gson.fromJson((JsonElement)jsonObject, Media.class);
        LinkedHashMap<String, List<String>> metaproperties = new LinkedHashMap<String, List<String>>();
        for (Map.Entry elementJson : jsonObject.entrySet()) {
            if (!((String)elementJson.getKey()).startsWith(PROPERTY_PREFIX)) continue;
            String propertyName = ((String)elementJson.getKey()).substring(PROPERTY_PREFIX.length());
            List values = metaproperties.getOrDefault(metaproperties, new ArrayList());
            if (((JsonElement)elementJson.getValue()).isJsonArray()) {
                for (JsonElement element : ((JsonElement)elementJson.getValue()).getAsJsonArray()) {
                    values.add(element.getAsString());
                }
            } else {
                values.add(((JsonElement)elementJson.getValue()).getAsString());
            }
            metaproperties.put(propertyName, values);
        }
        this.setMetaproperties(media, metaproperties);
        return media;
    }

    private void setMetaproperties(Media media, Map<String, List<String>> metaproperties) {
        try {
            Field metapropertiesField = media.getClass().getDeclaredField(CUSTOM_METAPROPERTY_FIELDNAME);
            metapropertiesField.setAccessible(true);
            metapropertiesField.set(media, metaproperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }
}

