/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.sample;

import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.configuration.OAuthSettings;
import com.bynder.sdk.model.Collection;
import com.bynder.sdk.query.collection.CollectionAddMediaQuery;
import com.bynder.sdk.query.collection.CollectionCreateQuery;
import com.bynder.sdk.query.collection.CollectionInfoQuery;
import com.bynder.sdk.query.collection.CollectionQuery;
import com.bynder.sdk.query.collection.CollectionRecipientRight;
import com.bynder.sdk.query.collection.CollectionRemoveMediaQuery;
import com.bynder.sdk.query.collection.CollectionShareQuery;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.collection.CollectionService;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.Utils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class CollectionsSample {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionsSample.class);

    public static void main(String[] args) throws URISyntaxException, IOException {
        String collectionInfoId;
        CollectionInfoQuery collectionInfoQuery;
        Collection collectionInfo;
        Properties appProperties = Utils.loadConfig("app");
        OAuthSettings oAuthSettings = new OAuthSettings(appProperties.getProperty("CLIENT_ID"), appProperties.getProperty("CLIENT_SECRET"), new URI(appProperties.getProperty("REDIRECT_URI")));
        BynderClient client = BynderClient.Builder.create(new Configuration.Builder(new URL(appProperties.getProperty("BASE_URL"))).setOAuthSettings(oAuthSettings).setHttpConnectionSettings(new HttpConnectionSettings()).build());
        List<String> scopes = Arrays.asList("offline", "asset:read", "asset:write", "asset.usage:read", "asset.usage:write", "collection:read", "collection:write", "meta.assetbank:read", "meta.assetbank:write", "meta.workflow:read");
        OAuthService oauthService = client.getOAuthService();
        URL authorizationUrl = oauthService.getAuthorizationUrl("state example", scopes);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(authorizationUrl.toURI());
        System.out.println("Insert the code: ");
        Scanner scanner = new Scanner(System.in);
        String code = scanner.nextLine();
        scanner.close();
        oauthService.getAccessToken(code, scopes).blockingSingle();
        CollectionService collectionService = client.getCollectionService();
        CollectionQuery collectionQuery = new CollectionQuery().setLimit(20);
        List collections = (List)((Response)collectionService.getCollections(collectionQuery).blockingSingle()).body();
        if (collections != null && !collections.isEmpty()) {
            for (Collection collectionResult : collections) {
                LOG.info("Collection ID: " + collectionResult.getId());
                LOG.info("Collection Name: " + collectionResult.getName());
                LOG.info("Collection Description: " + collectionResult.getDescription());
                LOG.info("Collection Media Count: " + collectionResult.getMediaCount());
                LOG.info("Collection Date Created: " + collectionResult.getDateCreated());
            }
        }
        if ((collectionInfo = (Collection)((Response)collectionService.getCollectionInfo(collectionInfoQuery = new CollectionInfoQuery(collectionInfoId = appProperties.getProperty("GET_COLLECTION_INFO_ID"))).blockingSingle()).body()) != null) {
            LOG.info("Collection Info Name: " + collectionInfo.getName());
            LOG.info("Collection Info Description: " + collectionInfo.getDescription());
        }
        Random random = new Random();
        int randomInt = random.nextInt(100);
        String newCollectionName = "New Collection" + randomInt;
        LOG.info("new collection name: " + newCollectionName);
        CollectionCreateQuery createCollectionQuery = new CollectionCreateQuery(newCollectionName);
        collectionService.createCollection(createCollectionQuery).blockingSingle();
        List updatedCollections = (List)((Response)collectionService.getCollections(collectionQuery).blockingSingle()).body();
        if (updatedCollections != null && !updatedCollections.isEmpty()) {
            for (Collection collectionResult : updatedCollections) {
                LOG.info("Collection ID: " + collectionResult.getId());
                LOG.info("Collection Name: " + collectionResult.getName());
                LOG.info("Collection Description: " + collectionResult.getDescription());
                LOG.info("Collection Media Count: " + collectionResult.getMediaCount());
                LOG.info("Collection Date Created: " + collectionResult.getDateCreated());
            }
        }
        String shareCollectionId = appProperties.getProperty("SHARE_COLLECTION_ID");
        LOG.info("sharing collection id: " + shareCollectionId);
        String collectionShareRecipient = appProperties.getProperty("COLLECTION_SHARE_RECIPIENT");
        String[] shareCollectionRecipients = new String[]{collectionShareRecipient};
        CollectionShareQuery collectionShareQuery = new CollectionShareQuery(shareCollectionId, shareCollectionRecipients, CollectionRecipientRight.VIEW).setLoginRequired(false).setSendMail(true).setMessage("test");
        collectionService.shareCollection(collectionShareQuery).blockingSingle();
        String addMediaToCollectionId = appProperties.getProperty("ADD_MEDIA_TO_COLLECTION_COLLECTION_ID");
        String mediaIdToAdd = appProperties.getProperty("ADD_MEDIA_TO_COLLECTION_MEDIA_ID");
        String[] addMediaIds = new String[]{mediaIdToAdd};
        LOG.info("adding media ids: " + mediaIdToAdd);
        CollectionAddMediaQuery collectionAddMediaQuery = new CollectionAddMediaQuery(addMediaToCollectionId, addMediaIds);
        collectionService.addMediaToCollection(collectionAddMediaQuery).blockingSingle();
        CollectionInfoQuery addMediaCollectionInfoQuery = new CollectionInfoQuery(addMediaToCollectionId);
        List mediaIdsFromCollection = (List)((Response)collectionService.getCollectionMediaIds(addMediaCollectionInfoQuery).blockingSingle()).body();
        if (mediaIdsFromCollection != null && !mediaIdsFromCollection.isEmpty()) {
            for (String mediaId : mediaIdsFromCollection) {
                LOG.info("media id: " + mediaId);
            }
        }
        String removeFromCollectionId = appProperties.getProperty("REMOVE_FROM_COLLECTION_ID");
        String mediaIdToRemove = appProperties.getProperty("REMOVE_MEDIA_ID_FROM_COLLECTION");
        String[] removeMediaIds = new String[]{mediaIdToRemove};
        LOG.info("removing media ids: " + mediaIdToRemove);
        CollectionRemoveMediaQuery collectionRemoveMediaQuery = new CollectionRemoveMediaQuery(removeFromCollectionId, removeMediaIds);
        collectionService.removeMediaFromCollection(collectionRemoveMediaQuery);
        CollectionInfoQuery removeMediaCollectionInfoQuery = new CollectionInfoQuery(removeFromCollectionId);
        List mediaIdsFromCollectionAfterRemoval = (List)((Response)collectionService.getCollectionMediaIds(removeMediaCollectionInfoQuery).blockingSingle()).body();
        if (mediaIdsFromCollectionAfterRemoval != null && !mediaIdsFromCollectionAfterRemoval.isEmpty()) {
            for (String mediaId : mediaIdsFromCollectionAfterRemoval) {
                LOG.info("media id: " + mediaId);
            }
        }
        System.exit(0);
    }
}

