/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.workflow;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.workflow.Campaign;
import com.bynder.sdk.model.workflow.CampaignId;
import com.bynder.sdk.model.workflow.Job;
import com.bynder.sdk.model.workflow.JobActionResponse;
import com.bynder.sdk.model.workflow.JobMedia;
import com.bynder.sdk.model.workflow.JobPresetContainer;
import com.bynder.sdk.model.workflow.WorkflowGroup;
import com.bynder.sdk.model.workflow.WorkflowMetaproperty;
import com.bynder.sdk.model.workflow.WorkflowUser;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.workflow.CampaignDataQuery;
import com.bynder.sdk.query.workflow.CampaignQuery;
import com.bynder.sdk.query.workflow.JobCreateQuery;
import com.bynder.sdk.query.workflow.JobModifyQuery;
import com.bynder.sdk.query.workflow.JobPresetQuery;
import com.bynder.sdk.query.workflow.JobQuery;
import com.bynder.sdk.query.workflow.WorkflowGroupDataQuery;
import com.bynder.sdk.query.workflow.WorkflowGroupQuery;
import com.bynder.sdk.query.workflow.WorkflowMetapropertyQuery;
import com.bynder.sdk.service.workflow.WorkflowService;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class WorkflowServiceImpl
implements WorkflowService {
    private final BynderApi bynderApi;
    private final QueryDecoder queryDecoder;

    public WorkflowServiceImpl(BynderApi bynderApi, QueryDecoder queryDecoder) {
        this.bynderApi = bynderApi;
        this.queryDecoder = queryDecoder;
    }

    @Override
    public Observable<Response<List<Campaign>>> getAllCampaigns() {
        return this.bynderApi.getAllCampaigns();
    }

    @Override
    public Observable<Response<Campaign>> getCampaign(CampaignQuery campaignQuery) {
        return this.bynderApi.getCampaign(campaignQuery.getCampaignId());
    }

    @Override
    public Observable<Response<CampaignId>> createCampaign(CampaignDataQuery campaignDataQuery) {
        return this.bynderApi.createCampaign(campaignDataQuery);
    }

    @Override
    public Observable<Response<CampaignId>> modifyCampaign(CampaignQuery campaignQuery, CampaignDataQuery campaignDataQuery) {
        return this.bynderApi.modifyCampaign(campaignQuery.getCampaignId(), campaignDataQuery);
    }

    @Override
    public Observable<Response<Void>> deleteCampaign(CampaignQuery campaignQuery) {
        return this.bynderApi.deleteCampaign(campaignQuery.getCampaignId());
    }

    @Override
    public Observable<Response<JobPresetContainer>> getJobPreset(JobPresetQuery jobPresetQuery) {
        return this.bynderApi.getJobPreset(jobPresetQuery.getId());
    }

    @Override
    public Observable<Response<List<Job>>> getJobs(JobQuery jobQuery) {
        Map<String, String> params = this.queryDecoder.decode(jobQuery);
        return this.bynderApi.getJobs(params);
    }

    @Override
    public Observable<Response<List<Job>>> getCampaignJobs(JobQuery jobQuery) {
        Map<String, String> params = this.queryDecoder.decode(jobQuery);
        return this.bynderApi.getCampaignJobs(jobQuery.getId(), params);
    }

    @Override
    public Observable<Response<Job>> getJob(JobQuery jobQuery) {
        return this.bynderApi.getJob(jobQuery.getId());
    }

    @Override
    public Observable<Response<List<JobMedia>>> getJobMedia(JobQuery jobQuery) {
        return this.bynderApi.getJobMedia(jobQuery.getId());
    }

    @Override
    public Observable<Response<JobActionResponse>> createJob(JobCreateQuery jobCreateQuery) {
        return this.bynderApi.createJob(jobCreateQuery);
    }

    @Override
    public Observable<Response<JobActionResponse>> modifyJob(JobModifyQuery jobModifyQuery) {
        return this.bynderApi.modifyJob(jobModifyQuery.getId(), jobModifyQuery);
    }

    @Override
    public Observable<Response<Void>> deleteJob(JobQuery jobQuery) {
        return this.bynderApi.deleteJob(jobQuery.getId());
    }

    @Override
    public Observable<Response<List<WorkflowMetaproperty>>> getAllWorkflowMetaproperties() {
        return this.bynderApi.getAllWorkflowMetaproperties();
    }

    @Override
    public Observable<Response<WorkflowMetaproperty>> getWorkflowMetaproperty(WorkflowMetapropertyQuery workflowMetapropertyQuery) {
        return this.bynderApi.getWorkflowMetaproperty(workflowMetapropertyQuery.getMetapropertyId());
    }

    @Override
    public Observable<Response<List<WorkflowUser>>> getAllWorkflowUsers() {
        return this.bynderApi.getAllWorkflowUsers();
    }

    @Override
    public Observable<Response<List<WorkflowGroup>>> getAllWorkflowGroups() {
        return this.bynderApi.getAllWorkflowGroups();
    }

    @Override
    public Observable<Response<WorkflowGroup>> getWorkflowGroup(WorkflowGroupQuery workflowGroupQuery) {
        return this.bynderApi.getWorkflowGroup(workflowGroupQuery.getGroupId());
    }

    @Override
    public Observable<Response<WorkflowGroup>> createWorkflowGroup(WorkflowGroupDataQuery workflowGroupDataQuery) {
        return this.bynderApi.createWorkflowGroup(workflowGroupDataQuery);
    }

    @Override
    public Observable<Response<WorkflowGroup>> updateWorkflowGroup(WorkflowGroupQuery workflowGroupQuery, WorkflowGroupDataQuery workflowGroupDataQuery) {
        return this.bynderApi.updateWorkflowGroup(workflowGroupQuery.getGroupId(), workflowGroupDataQuery);
    }

    @Override
    public Observable<Response<Void>> deleteWorkflowGroup(WorkflowGroupQuery workflowGroupQuery) {
        return this.bynderApi.deleteWorkflowGroup(workflowGroupQuery.getGroupId());
    }
}

