/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.configuration;

import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;

public class HttpConnectionSettings {
    public static final int DEFAULT_TIMEOUT_SECONDS = 30;
    private final int readTimeoutSeconds;
    private final int connectTimeoutSeconds;
    private final boolean retryOnConnectionFailure;
    private final boolean loggingInterceptorEnabled;
    private SSLContext sslContext;
    private X509TrustManager trustManager;
    private Interceptor customInterceptor;

    public HttpConnectionSettings(SSLContext sslContext, X509TrustManager trustManager, Interceptor customInterceptor, int readTimeoutSeconds, int connectTimeoutSeconds, boolean retryOnConnectionFailure) {
        this(sslContext, trustManager, customInterceptor, readTimeoutSeconds, connectTimeoutSeconds, retryOnConnectionFailure, false);
    }

    public HttpConnectionSettings(SSLContext sslContext, X509TrustManager trustManager, Interceptor customInterceptor, int readTimeoutSeconds, int connectTimeoutSeconds, boolean retryOnConnectionFailure, boolean includeLoggingInterceptor) {
        this.sslContext = sslContext;
        this.trustManager = trustManager;
        this.customInterceptor = customInterceptor;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.loggingInterceptorEnabled = includeLoggingInterceptor;
    }

    public HttpConnectionSettings() {
        this.readTimeoutSeconds = 30;
        this.connectTimeoutSeconds = 30;
        this.retryOnConnectionFailure = true;
        this.loggingInterceptorEnabled = false;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public Interceptor getCustomInterceptor() {
        return this.customInterceptor;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public boolean isLoggingInterceptorEnabled() {
        return this.loggingInterceptorEnabled;
    }
}

