/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.model.upload;

import com.bynder.sdk.model.upload.UploadRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class UploadProcessData {
    private final File file;
    private final FileInputStream fileInputStream;
    private final UploadRequest uploadRequest;
    private final int maxChunkSize;
    private final int numberOfChunks;
    private int chunkNumber;

    public UploadProcessData(File file, FileInputStream fileInputStream, UploadRequest uploadRequest, int maxChunkSize) {
        this.file = file;
        this.fileInputStream = fileInputStream;
        this.uploadRequest = uploadRequest;
        this.maxChunkSize = maxChunkSize;
        this.numberOfChunks = (int)((file.length() + (long)maxChunkSize - 1L) / (long)maxChunkSize);
        this.chunkNumber = 0;
    }

    public File getFile() {
        return this.file;
    }

    public UploadRequest getUploadRequest() {
        return this.uploadRequest;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public int getNumberOfChunks() {
        return this.numberOfChunks;
    }

    public void incrementChunk() {
        ++this.chunkNumber;
    }

    public boolean isCompleted() {
        return this.chunkNumber == this.numberOfChunks;
    }

    public byte[] getBuffer() throws IOException {
        int length = Math.min(this.maxChunkSize, this.fileInputStream.available());
        byte[] buffer = new byte[length];
        this.fileInputStream.read(buffer);
        return buffer;
    }
}

