/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.amazons3;

import com.bynder.sdk.api.AmazonS3Api;
import com.bynder.sdk.api.ApiFactory;
import com.bynder.sdk.model.upload.MultipartParameters;
import com.bynder.sdk.model.upload.UploadRequest;
import com.bynder.sdk.service.amazons3.AmazonS3Service;
import io.reactivex.Observable;
import java.util.LinkedHashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Response;

public class AmazonS3ServiceImpl
implements AmazonS3Service {
    private static final MediaType FORM_DATA = MediaType.parse((String)"multipart/form-data");
    private final AmazonS3Api amazonS3Api;

    public AmazonS3ServiceImpl(String bucket) {
        this.amazonS3Api = ApiFactory.createAmazonS3Client(bucket);
    }

    @Override
    public Observable<Response<Void>> uploadPartToAmazon(String filename, UploadRequest uploadRequest, int chunkNumber, byte[] fileContent, int numberOfChunks) {
        LinkedHashMap<String, RequestBody> params = new LinkedHashMap<String, RequestBody>();
        MultipartParameters multipartParams = uploadRequest.getMultipartParams();
        RequestBody key = this.encodeField(String.format("%s/p%s", multipartParams.getKey(), chunkNumber));
        params.put("chunk", this.encodeField(String.valueOf(chunkNumber)));
        params.put("chunks", this.encodeField(String.valueOf(numberOfChunks)));
        params.put("file", this.encodeField(fileContent));
        params.put("Filename", key);
        params.put("key", key);
        params.put("name", this.encodeField(filename));
        params.put("acl", this.encodeField(multipartParams.getAcl()));
        params.put("Content-Type", this.encodeField(multipartParams.getContentType()));
        params.put("Policy", this.encodeField(multipartParams.getPolicy()));
        params.put("success_action_status", this.encodeField(multipartParams.getSuccessActionStatus()));
        params.put("x-amz-algorithm", this.encodeField(multipartParams.getAlgorithm()));
        params.put("x-amz-credential", this.encodeField(multipartParams.getAwsAccessKeyId()));
        params.put("x-amz-date", this.encodeField(multipartParams.getDate()));
        params.put("X-Amz-Signature", this.encodeField(multipartParams.getSignature()));
        return this.amazonS3Api.uploadPartToAmazon(params);
    }

    private RequestBody encodeField(byte[] field) {
        return RequestBody.create((byte[])field, (MediaType)FORM_DATA);
    }

    private RequestBody encodeField(String field) {
        return RequestBody.create((String)field, (MediaType)FORM_DATA);
    }
}

