/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.upload;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.exception.BynderUploadException;
import com.bynder.sdk.model.upload.FileConverterStatus;
import com.bynder.sdk.model.upload.FinaliseResponse;
import com.bynder.sdk.model.upload.PollStatus;
import com.bynder.sdk.model.upload.SaveMediaResponse;
import com.bynder.sdk.model.upload.UploadProcessData;
import com.bynder.sdk.model.upload.UploadProgress;
import com.bynder.sdk.model.upload.UploadRequest;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.query.upload.FinaliseUploadQuery;
import com.bynder.sdk.query.upload.PollStatusQuery;
import com.bynder.sdk.query.upload.RegisterChunkQuery;
import com.bynder.sdk.query.upload.RequestUploadQuery;
import com.bynder.sdk.query.upload.SaveMediaQuery;
import com.bynder.sdk.query.upload.UploadQuery;
import com.bynder.sdk.service.amazons3.AmazonS3Service;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import retrofit2.Response;

public class FileUploader {
    private static final int MAX_CHUNK_SIZE = 0x500000;
    private static final int MAX_POLLING_ITERATIONS = 60;
    private static final int POLLING_IDLE_TIME = 2000;
    private final BynderApi bynderApi;
    private final QueryDecoder queryDecoder;
    private AmazonS3Service amazonS3Service;

    public FileUploader(BynderApi bynderApi, QueryDecoder queryDecoder) {
        this.bynderApi = bynderApi;
        this.queryDecoder = queryDecoder;
    }

    public Observable<SaveMediaResponse> uploadFile(UploadQuery uploadQuery) {
        return Observable.create(emitter -> {
            try {
                Observable<UploadProgress> uploadProgressObservable = this.uploadFileWithProgress(uploadQuery);
                uploadProgressObservable.subscribe(uploadProgress -> {
                    if (uploadProgress.isFinished()) {
                        emitter.onNext((Object)uploadProgress.getSaveMediaResponse());
                    }
                }, throwable -> emitter.onError(throwable), () -> emitter.onComplete());
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        });
    }

    public Observable<UploadProgress> uploadFileWithProgress(UploadQuery uploadQuery) {
        return Observable.create(observableEmitter -> {
            try {
                Observable<Response<String>> s3EndpointObs = this.getClosestS3Endpoint();
                s3EndpointObs.subscribe(awsBucketResponse -> {
                    this.amazonS3Service = AmazonS3Service.Builder.create((String)awsBucketResponse.body());
                    File file = new File(uploadQuery.getFilepath());
                    Observable<Response<UploadRequest>> uploadInformationObs = this.getUploadInformation(new RequestUploadQuery(file.getName()));
                    uploadInformationObs.subscribe(uploadRequestResponse -> {
                        UploadRequest uploadRequest = (UploadRequest)uploadRequestResponse.body();
                        if (!file.exists()) {
                            observableEmitter.onError((Throwable)new BynderUploadException(String.format("File: %s not found. Upload not completed.", file.getName())));
                            return;
                        }
                        this.uploadParts(file, uploadRequest).subscribe(uploadProgress -> {
                            observableEmitter.onNext(uploadProgress);
                            if (uploadProgress.areChunksFinished()) {
                                Observable<Response<FinaliseResponse>> finaliseUploadObs = this.finaliseUpload(new FinaliseUploadQuery(uploadRequest.getS3File().getUploadId(), uploadRequest.getS3File().getTargetId(), uploadRequest.getS3Filename(), uploadProgress.getUploadedChunks()));
                                finaliseUploadObs.subscribe(finaliseResponse -> {
                                    String importId = ((FinaliseResponse)finaliseResponse.body()).getImportId();
                                    this.checkUploadFinished(importId).subscribe(hasFinishedSuccessfully -> {
                                        if (hasFinishedSuccessfully.booleanValue()) {
                                            this.saveUploadedMedia(uploadQuery, file, importId).subscribe(saveMediaResponse -> {
                                                uploadProgress.setSaveMediaResponse((SaveMediaResponse)saveMediaResponse);
                                                uploadProgress.setFinished(true);
                                                observableEmitter.onNext(uploadProgress);
                                                observableEmitter.onComplete();
                                            }, throwable -> observableEmitter.onError(throwable));
                                        } else {
                                            observableEmitter.onError((Throwable)new BynderUploadException("Converter did not finished. Upload not completed."));
                                        }
                                    }, throwable -> observableEmitter.onError(throwable));
                                }, throwable -> observableEmitter.onError(throwable));
                            }
                        }, throwable -> observableEmitter.onError(throwable));
                    }, throwable -> observableEmitter.onError(throwable));
                }, throwable -> observableEmitter.onError(throwable));
            }
            catch (Exception e) {
                observableEmitter.onError((Throwable)e);
            }
        });
    }

    private Observable<UploadProgress> uploadParts(File file, UploadRequest uploadRequest) {
        return Observable.create(observableEmitter -> {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                UploadProgress uploadProgress = new UploadProgress(file.length());
                UploadProcessData uploadProcessData = new UploadProcessData(file, fileInputStream, uploadRequest, 0x500000);
                uploadProcessData.incrementChunk();
                this.processChunk(uploadProcessData).repeatUntil(() -> {
                    boolean isProcessed = uploadProcessData.isCompleted();
                    if (isProcessed) {
                        observableEmitter.onComplete();
                    } else {
                        uploadProcessData.incrementChunk();
                    }
                    return isProcessed;
                }).subscribe(chunkSize -> {
                    uploadProgress.addProgress(chunkSize.intValue());
                    observableEmitter.onNext((Object)uploadProgress);
                }, throwable -> observableEmitter.onError(throwable));
            }
            catch (Exception e) {
                observableEmitter.onError((Throwable)e);
            }
        });
    }

    private Observable<Integer> processChunk(UploadProcessData uploadProcessData) {
        return Observable.create(observableEmitter -> {
            try {
                byte[] chunk = uploadProcessData.getBuffer();
                Observable<Response<Void>> uploadPartToAmazonObs = this.amazonS3Service.uploadPartToAmazon(uploadProcessData.getFile().getName(), uploadProcessData.getUploadRequest(), uploadProcessData.getChunkNumber(), chunk, uploadProcessData.getNumberOfChunks());
                uploadPartToAmazonObs.subscribe(voidResponse -> {
                    this.registerUploadedChunk(uploadProcessData, (ObservableEmitter<Integer>)observableEmitter, chunk.length);
                    observableEmitter.onNext((Object)chunk.length);
                }, throwable -> observableEmitter.onError(throwable));
            }
            catch (Exception e) {
                observableEmitter.onError((Throwable)e);
            }
        });
    }

    private void registerUploadedChunk(UploadProcessData uploadProcessData, ObservableEmitter<Integer> observableEmitter, Integer chunkSize) throws IllegalAccessException {
        String filename = String.format("%s/p%s", uploadProcessData.getUploadRequest().getS3Filename(), Integer.toString(uploadProcessData.getChunkNumber()));
        Observable<Response<Void>> registerChunkObs = this.registerChunk(new RegisterChunkQuery(uploadProcessData.getUploadRequest().getS3File().getUploadId(), uploadProcessData.getChunkNumber(), uploadProcessData.getUploadRequest().getS3File().getTargetId(), filename));
        registerChunkObs.subscribe(voidResponse -> {
            observableEmitter.onNext((Object)chunkSize);
            observableEmitter.onComplete();
        }, throwable -> observableEmitter.onError(throwable));
    }

    private Observable<Boolean> checkUploadFinished(String importId) {
        return Observable.create(observableEmitter -> {
            try {
                FileConverterStatus fileConverterStatus = new FileConverterStatus(60);
                this.getPollStatus(new PollStatusQuery(importId.split(","))).repeatUntil(() -> {
                    if (fileConverterStatus.isDone()) {
                        observableEmitter.onNext((Object)fileConverterStatus.isSuccessful());
                        observableEmitter.onComplete();
                        return true;
                    }
                    if (!fileConverterStatus.nextAttempt()) {
                        observableEmitter.onNext((Object)false);
                        observableEmitter.onComplete();
                        return true;
                    }
                    Thread.sleep(2000L);
                    return false;
                }).subscribe(pollStatusResponse -> {
                    PollStatus pollStatus = (PollStatus)pollStatusResponse.body();
                    if (pollStatus != null) {
                        if (pollStatus.getItemsDone().contains(importId)) {
                            fileConverterStatus.setDone(true);
                        }
                        if (pollStatus.getItemsFailed().contains(importId)) {
                            fileConverterStatus.setDone(false);
                        }
                    }
                }, throwable -> observableEmitter.onError(throwable));
            }
            catch (Exception e) {
                observableEmitter.onError((Throwable)e);
            }
        });
    }

    private Observable<SaveMediaResponse> saveUploadedMedia(UploadQuery uploadQuery, File file, String importId) throws IllegalAccessException {
        return Observable.create(emitter -> {
            Observable<Response<SaveMediaResponse>> saveMediaObs = uploadQuery.getMediaId() == null ? this.saveMedia(new SaveMediaQuery(importId).setBrandId(uploadQuery.getBrandId()).setName(file.getName()).setAudit(uploadQuery.isAudit()).setMetaproperties(uploadQuery.getMetaproperties())) : this.saveMedia(new SaveMediaQuery(importId).setMediaId(uploadQuery.getMediaId()).setAudit(uploadQuery.isAudit()).setMetaproperties(uploadQuery.getMetaproperties()));
            saveMediaObs.subscribe(saveMediaResponse -> emitter.onNext(saveMediaResponse.body()), throwable -> emitter.onError(throwable), () -> emitter.onComplete());
        });
    }

    private Observable<Response<String>> getClosestS3Endpoint() {
        return this.bynderApi.getClosestS3Endpoint();
    }

    private Observable<Response<UploadRequest>> getUploadInformation(RequestUploadQuery requestUploadQuery) {
        Map<String, String> params = this.queryDecoder.decode(requestUploadQuery);
        return this.bynderApi.getUploadInformation(params);
    }

    private Observable<Response<Void>> registerChunk(RegisterChunkQuery registerChunkQuery) {
        Map<String, String> params = this.queryDecoder.decode(registerChunkQuery);
        return this.bynderApi.registerChunk(params);
    }

    private Observable<Response<FinaliseResponse>> finaliseUpload(FinaliseUploadQuery finaliseUploadQuery) {
        Map<String, String> params = this.queryDecoder.decode(finaliseUploadQuery);
        return this.bynderApi.finaliseUpload(params);
    }

    private Observable<Response<PollStatus>> getPollStatus(PollStatusQuery pollStatusQuery) {
        Map<String, String> params = this.queryDecoder.decode(pollStatusQuery);
        return this.bynderApi.getPollStatus(params);
    }

    private Observable<Response<SaveMediaResponse>> saveMedia(SaveMediaQuery saveMediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(saveMediaQuery);
        return this.bynderApi.saveMedia(params);
    }
}

